/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceOraclev10g && ((TableSpaceOraclev10g)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)object;
        this.storageDesign = tableSpace.getStorageDesign();
        if (!tableSpace.isNullInstance()) {
            List list = tableSpace.getDataFiles();
            this.appendPrompt(buffer, tableSpace, "TABLESPACE");
            this.appendComment(oldbuffer, tableSpace);
            this.appendCreate(buffer, tableSpace);
            advancedComment = buffer.toString();
            this.appendDataFiles(buffer, tableSpace, list, prettyPrint);
            this.appendMinimumExtent(buffer, tableSpace, prettyPrint);
            this.appendBlockSize(buffer, tableSpace, prettyPrint);
            this.appendLogging(buffer, tableSpace, prettyPrint);
            this.appendForceLogging(buffer, tableSpace, prettyPrint);
            this.appendEncryption(buffer, tableSpace, prettyPrint);
            this.appendStatus(buffer, tableSpace, prettyPrint);
            this.appendContents(buffer, tableSpace, prettyPrint);
            this.appendDefaultStorage(buffer, tableSpace, prettyPrint);
            this.appendExtentManagement(buffer, tableSpace, prettyPrint);
            this.appendSegmentManagement(buffer, tableSpace, prettyPrint);
            this.appendFlashBackMode(buffer, tableSpace, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendFlashBackMode(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if (tableSpace.getFlashBack() != null) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FLASHBACK");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getFlashBack());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FLASHBACK");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendCreate(StringBuffer buffer, TableSpaceOraclev10g tableSpace) {
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "CREATE");
        if (!"".equals(tableSpace.getFileType())) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getFileType());
        }
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
    }

    private void appendSegmentManagement(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String segmentManagement;
        String extentManagement = tableSpace.getExtentManagement();
        if (extentManagement.equalsIgnoreCase("LOCAL") && !"".equals(segmentManagement = tableSpace.getSegmentManagement())) {
            buffer.append(NEWLINE);
            buffer.append("    ").append("SEGMENT SPACE MANAGEMENT ").append(segmentManagement);
        }
    }

    private void appendBlockSize(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        int blockSize = tableSpace.getBlockSize();
        if (blockSize > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "BLOCKSIZE");
            this.appendStringWithSpace(buffer, blockSize);
        }
    }

    private void appendDataFiles(StringBuffer buffer, TableSpaceOraclev10g tableSpace, List dataFiles, boolean prettyPrint) {
        if (dataFiles.isEmpty()) {
            DiskGroupOraclev10g diskGroup = tableSpace.getDiskGroup();
            if (diskGroup != null) {
                SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                buffer.append('\'').append('+');
                buffer.append(diskGroup.getFormatedName(this.storageDesign, false));
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, '\'');
            } else {
                buffer.append(NEWLINE);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "--  WARNING: Tablespace has no data files defined");
                DDLFileMaker.incrementWarnings();
            }
        }
        Iterator setIt = dataFiles.iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            String filename = dataFile.getFileName().trim();
            if (!filename.equals("")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, this.addQuotes(filename, true));
            }
            if (dataFile.getSize() > 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
                this.appendStringWithSpace(buffer, dataFile.getSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            }
            if (dataFile.getReuse().equalsIgnoreCase("YES") && !filename.equals("")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendMinimumExtent(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        int minExtent;
        if ("DICTIONARY".equalsIgnoreCase(tableSpace.getExtentManagement()) && (minExtent = tableSpace.getMinExtLen()) > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MINIMUM");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "EXTENT");
            this.appendStringWithSpace(buffer, minExtent);
        }
    }

    private void appendLogging(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getLogging());
        }
    }

    private void appendForceLogging(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(tableSpace.getForceLogging())) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FORCE");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "LOGGING");
        }
    }

    private void appendEncryption(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if ("YES".equals(tableSpace.getEncrypt()) && this.storageDesign instanceof StorageDesignOraclev11g) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ENCRYPTION");
            String encryptionAlgorithm = tableSpace.getEncryptionAlgorithm();
            if (encryptionAlgorithm.length() > 0) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "USING");
                SSBTableSpaceOraclev10g.appendString(buffer, '\'');
                SSBTableSpaceOraclev10g.appendString(buffer, encryptionAlgorithm);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, '\'');
            }
        }
    }

    private void appendStatus(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String status = tableSpace.getStatus();
        SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, status);
    }

    private void appendContents(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if (tableSpace.getContents().equals("TEMPORARY") && tableSpace.getExtentManagement().equals("DICTIONARY")) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
        }
    }

    private void appendDefaultStorage(StringBuffer oldbuffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        this.appendCompressClause(buffer, tableSpace);
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            this.appendInMemoryClause(buffer, tableSpace, prettyPrint);
        }
        if ("LOCAL".equalsIgnoreCase(tableSpace.getExtentManagement())) {
            if (tableSpace.getEncrypt().equals("YES") && this.storageDesign instanceof StorageDesignOraclev11g) {
                if (buffer.length() > 0) {
                    SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ENCRYPT");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, '(');
            boolean props = false;
            long initExtent = tableSpace.getDSInitialExtent();
            long nextExtent = tableSpace.getDSNextExtent();
            int minExtents = tableSpace.getDSMinExtents();
            String maxtExtents = tableSpace.getDSMaxExtents();
            int pctIncrease = tableSpace.getDSPctIncrease();
            if (initExtent > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                this.appendStringWithSpace(buffer, initExtent);
                props = true;
            }
            if (nextExtent > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, nextExtent);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                if (minExtents > 1) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, minExtents);
                    props = true;
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "1");
                    props = true;
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, maxtExtents);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                this.appendStringWithSpace(buffer, pctIncrease);
                props = true;
            }
            if (tableSpace.getEncrypt().equals("YES") && this.storageDesign instanceof StorageDesignOraclev11g) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ENCRYPT");
                props = true;
            }
            if (props) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
        if (buffer.length() > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(oldbuffer, "DEFAULT");
            this.appendString(oldbuffer, buffer);
        }
    }

    private void appendCompressClause(StringBuffer buffer, TableSpaceOraclev10g tablespace) {
        String compression = tablespace.getDSCompression();
        if (compression.equalsIgnoreCase("NOCOMPRESS")) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        } else if (compression.equalsIgnoreCase("COMPRESS")) {
            String compressionType = tablespace.getCompressionType();
            if (this.storageDesign instanceof StorageDesignOraclev12c) {
                if (compressionType.isEmpty()) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                } else {
                    if (compressionType.equals("BASIC") || compressionType.equals("ADVANCED")) {
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ROW");
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "STORE");
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else {
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "STORE");
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FOR");
                    }
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, compressionType);
                }
            } else {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                if (this.storageDesign instanceof StorageDesignOraclev11g && !compressionType.isEmpty() && !compressionType.equals("BASIC")) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FOR");
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, compressionType);
                }
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
    }

    private void appendInMemoryClause(StringBuffer buffer, TableSpaceOraclev10g tablespace, boolean prettyPrint) {
        String inMemory = tablespace.getInMemory();
        if (inMemory.equals("YES")) {
            String inMemoryDuplicate;
            String inMemoryDistribute;
            String inMemoryPriority;
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "INMEMORY");
            String inMemoryCompression = tablespace.getInMemoryCompression();
            if (!inMemoryCompression.isEmpty()) {
                if (!inMemoryCompression.equals("NO MEMCOMPRESS")) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MEMCOMPRESS");
                }
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, inMemoryCompression);
            }
            if (!(inMemoryPriority = tablespace.getInMemoryPriority()).isEmpty()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "PRIORITY");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, inMemoryPriority);
            }
            if (!(inMemoryDistribute = tablespace.getInMemoryDistribute()).isEmpty()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DISTRIBUTE");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, inMemoryDistribute);
            }
            if (!(inMemoryDuplicate = tablespace.getInMemoryDuplicate()).isEmpty()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, inMemoryDuplicate);
            }
        } else if (inMemory.equals("NO")) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NO");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "INMEMORY");
        }
    }

    private void appendExtentManagement(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String extentManagement = tableSpace.getExtentManagement();
        SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "EXTENT");
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MANAGEMENT");
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, extentManagement);
        if (extentManagement.equalsIgnoreCase("LOCAL")) {
            if (tableSpace.getEMLocalSubtype().equalsIgnoreCase("AUTOALLOCATE")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "AUTOALLOCATE");
            } else if (tableSpace.getEMLocalSubtype().equalsIgnoreCase("UNIFORM")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "UNIFORM");
                if (tableSpace.getEMUniformSize() > 0) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
                    this.appendStringWithSpace(buffer, tableSpace.getEMUniformSize());
                }
            }
        }
    }
}

