/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKOraclev10g
extends AbstractSSBOracle {
    StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        FKProxyOraclev10g fkproxy;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        FKIndexAssociation fk = null;
        if (object instanceof FKIndexAssociation) {
            fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignOracle)rd.getStorageDesign(rd.getSelectedRDBMSSite());
            fkproxy = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                this.appendViewFKs(oldbuffer, fk, prettyPrint);
                return;
            }
        } else {
            fkproxy = (FKProxyOraclev10g)object;
            this.storageDesign = (StorageDesignOracle)fkproxy.getStorageDesign();
        }
        if (fkproxy.getIndex().getElements().length > 0) {
            TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fkproxy.getTable().getObjectID());
            PartitionListOracle partitionList = tableProxy.getPartitionList();
            if (partitionList instanceof PartitionListOraclev11g && partitionList.getPartitionType().equals("REFERENCE") && fkproxy == ((PartitionListOraclev11g)partitionList).getRefConstraint()) {
                return;
            }
            this.appendComment(oldbuffer, fkproxy);
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            String fkName = fkproxy.getName();
            if (fkName.length() > tableProxy.getMaxNameLength()) {
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBFKOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: FK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendPrompt(buffer, tableProxy, "FOREIGN KEY ON");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!fkName.startsWith("SYS_")) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
            advancedComment = buffer.toString();
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendString(buffer, fkproxy.getColumns(this.storageDesign));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy);
            boolean referencesView = fkproxy.getFKTable() instanceof TableView;
            if (referencesView) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            } else {
                this.appendOnDelete(buffer, fkproxy);
                this.appendConstraintState(buffer, fkproxy);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterTable();
            String relyValue = null;
            if (referencesView) {
                if (fkproxy.getRely().equals("YES")) {
                    relyValue = "RELY";
                } else {
                    KeyObject fkIndex = (KeyObject)fkproxy.getObject();
                    if (fkIndex != null) {
                        fk = fkIndex.getFKAssociation();
                    }
                    if (fk != null && fk.isRely()) {
                        relyValue = "RELY";
                    }
                }
            } else if (fkproxy.getValidate().equals("NO")) {
                if (fkproxy.getRely().equals("YES")) {
                    relyValue = "RELY";
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    relyValue = "NORELY";
                }
            }
            if (relyValue != null) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
                advancedComment = buffer.toString();
                SSBFKOraclev10g.appendStringWithSpace(buffer, relyValue);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
            }
            this.appendExceptionTable(oldbuffer, fkproxy, prettyPrint);
            this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        } else {
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - Foreign Key ");
            oldbuffer.append(this.storageDesign.getFormatedName(fkproxy));
            oldbuffer.append(" has no columns");
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendExceptionTable(StringBuffer oldbuffer, FKProxyOraclev10g fk, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (fk.getExceptionsTable() != null && "YES".equalsIgnoreCase(fk.getEnable())) {
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(fk.getTableProxy()));
            advancedComment = buffer.toString();
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterTable();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof FKProxyOraclev10g) {
            if (!((FKProxyOraclev10g)object).getStorageDesign().isOpen()) {
                return ((FKProxyOraclev10g)object).getObject().isMarkedGenerate();
            }
            return ((FKProxyOraclev10g)object).isMarkedGenerate();
        }
        if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return false;
    }

    private void appendReferences(StringBuffer buffer, FKProxyOraclev10g fk) {
        SSBFKOraclev10g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getFKTable();
        if (refTable != null) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = null;
            refTableObject = refTable instanceof TableView ? this.storageDesign.getTableViewProxySet().getProxy(refTable.getObjectID()) : this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendNewLine(buffer, true, 0);
                SSBFKOraclev10g.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyOraclev10g fk) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "DELETE");
            SSBFKOraclev10g.appendStringWithSpace(buffer, onDelete);
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOraclev10g fk) {
        if (this.storageDesign.isOpen()) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "NOT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(fk.getValidate())) {
                        SSBFKOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            if (fk.getExceptionsTable() != null) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            }
        }
    }

    protected void appendViewFKs(StringBuffer oldbuffer, FKIndexAssociation fk, boolean prettyPrint) {
        if (fk.getLocalFKIndex().getElements().length > 0) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            TableViewProxyOracle tableProxy = (TableViewProxyOracle)this.storageDesign.getTableViewProxySet().getProxy(fk.getTable().getObjectID());
            this.appendComment(oldbuffer, fk);
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            String fkName = fk.getName();
            if (fkName.length() > tableProxy.getMaxNameLength()) {
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBFKOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: FK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendPrompt(buffer, tableProxy, "FOREIGN KEY ON");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "VIEW");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!fkName.startsWith("SYS_")) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
            advancedComment = buffer.toString();
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendString(buffer, this.getFKColumns(fk));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendFKReferences(buffer, fk);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterView();
            if (fk.isRely()) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "VIEW");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                advancedComment = buffer.toString();
                SSBFKOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterView();
            }
            this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        } else {
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - Foreign Key ");
            oldbuffer.append(this.storageDesign.getFormatedName(fk));
            oldbuffer.append(" has no columns");
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    public String getFKColumns(FKIndexAssociation fk) {
        StringBuffer result = new StringBuffer();
        ContainedObject[] columns = fk.getLocalFKIndex().getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                result.append(",\n");
            }
            result.append("     ").append(this.storageDesign.getFormatedName(columns[i]));
        }
        return result.toString();
    }

    private void appendFKReferences(StringBuffer buffer, FKIndexAssociation fk) {
        SSBFKOraclev10g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getRemoteTable();
        if (refTable != null) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = null;
            refTableObject = refTable instanceof TableView ? this.storageDesign.getTableViewProxySet().getProxy(refTable.getObjectID()) : this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ContainedObject[] columns = fk.getLocalFKIndex().getElements();
                for (int i = 0; i < columns.length; ++i) {
                    FKElement column = (FKElement)columns[i];
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendNewLine(buffer, true, 0);
                SSBFKOraclev10g.appendString(buffer, this.getFKReferenceColumns(fk));
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    public String getFKReferenceColumns(FKIndexAssociation fk) {
        StringBuffer result = new StringBuffer();
        KeyObject remoteIndex = fk.getRemoteIndex();
        ContainedObject[] columns = remoteIndex.getElements();
        for (int i = 0; i < columns.length; ++i) {
            ModelIDObject columnObject;
            if (i > 0) {
                result.append(",\n");
            }
            if ((columnObject = this.storageDesign.getColumnProxySet().getProxy(columns[i].getObjectID())) == null) {
                columnObject = columns[i];
            }
            String name = this.storageDesign.getFormatedName(columnObject);
            result.append("     ").append(name);
        }
        return result.toString();
    }
}

