/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStoredProcedureDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StoredProcedureDB2 proc = (StoredProcedureDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(proc);
        this.appendComment(buffer, proc);
        this.appendCreate(buffer, proc);
        this.appendBody(buffer, proc, prettyPrint);
        SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        if (proc.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, proc, prettyPrint);
        }
        DDLFileMaker.incrementCreateProc();
        this.appendExecutePrivileges(buffer, proc, prettyPrint);
    }

    private void appendCommentOn(StringBuffer buffer, StoredProcedureDB2 proc, boolean prettyPrint) {
        SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "PROCEDURE");
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getLongNameDDL()));
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "IS");
        SSBStoredProcedureDB2v70.appendString(buffer, '\'');
        SSBStoredProcedureDB2v70.appendString(buffer, proc.getCommentInRDBMS());
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, '\'');
        SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreate(StringBuffer buffer, StoredProcedureDB2 proc) {
        this.appendCreate(buffer);
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "PROCEDURE");
        if (proc.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBStoredProcedureDB2v70.appendString(buffer, this.storageDesign.getFormatedName(proc.getOwner().getName()));
            SSBStoredProcedureDB2v70.appendString(buffer, ".");
        }
        SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getName()));
    }

    private void appendBody(StringBuffer buffer, StoredProcedureDB2 proc, boolean prettyPrint) {
        SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 1);
        if (!proc.getBody().trim().equalsIgnoreCase("")) {
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, proc.getBody());
        } else {
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    private void appendExecutePrivileges(StringBuffer buffer, StoredProcedureDB2 proc, boolean prettyPrint) {
        if (!proc.getUsers().equalsIgnoreCase("")) {
            SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "GRANT");
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "EXECUTE");
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "ON");
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "PROCEDURE");
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getName()));
            SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "TO");
            SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, proc.getUsers());
            if ("YES".equalsIgnoreCase(proc.getGrantOption())) {
                SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBStoredProcedureDB2v70.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBStoredProcedureDB2v70.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StoredProcedureDB2 && ((StoredProcedureDB2)object).isMarkedGenerate();
    }
}

