/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.util.exceptions.DDLExceptionList;

public class DDLAdvancedGenerator {
    private DDLExceptionList ddlExceptionList = null;
    private static final int STRING_LENGTH = 70;

    public void addAdvanceHeader(StringBuffer buffer) {
        this.appendDescription(buffer);
        buffer.append("REM Package definition");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("CREATE OR REPLACE PACKAGE adv_scripting AS");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("TYPE masked_errors IS TABLE OF NUMBER INDEX BY BINARY_INTEGER;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" skip_errors masked_errors;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" start_step NUMBER;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" stop_step NUMBER;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" log_options NUMBER;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("/*");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" log_options := 1 - log executed steps only + status + errors");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("log_options := 2 - option 1 + comments ");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("log_options := 3 - option 1 + executed statement ");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" */");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" PROCEDURE EXEC_STATEMENT (");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  current_step NUMBER,");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  sql_statement VARCHAR2,");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  comments VARCHAR2);");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" PROCEDURE INIT_STEPS(");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  start_step_in NUMBER,");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  stop_step_in NUMBER,");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  log_option_in NUMBER);");
        buffer.append(this.newline());
        buffer.append("  PROCEDURE STOP_EXECUTION(tablename IN VARCHAR2);");
        buffer.append(this.newline());
        buffer.append("  FUNCTION GET_START_STEP RETURN NUMBER;");
        buffer.append(this.newline());
        buffer.append("  FUNCTION GET_STOP_STEP RETURN NUMBER;");
        buffer.append(this.newline());
        buffer.append("END adv_scripting;");
        buffer.append(this.newline());
        buffer.append("/");
        buffer.append(this.newline());
        buffer.append("REM Package body definition");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("CREATE OR REPLACE PACKAGE BODY adv_scripting AS");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("    FUNCTION GET_START_STEP RETURN NUMBER");
        buffer.append(this.newline());
        buffer.append(" IS");
        buffer.append(this.newline());
        buffer.append(" BEGIN");
        buffer.append(this.newline());
        buffer.append("  RETURN start_step;");
        buffer.append(this.newline());
        buffer.append(" END;");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("    FUNCTION GET_STOP_STEP RETURN NUMBER");
        buffer.append(this.newline());
        buffer.append(" IS");
        buffer.append(this.newline());
        buffer.append(" BEGIN");
        buffer.append(this.newline());
        buffer.append("  RETURN stop_step;");
        buffer.append(this.newline());
        buffer.append(" END;");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("    PROCEDURE STOP_EXECUTION(tablename IN VARCHAR2)");
        buffer.append(this.newline());
        buffer.append(" IS");
        buffer.append(this.newline());
        buffer.append("  msg varchar2(2000) := 'Script execution is interrupted because manual maintenance for table ';");
        buffer.append(this.newline());
        buffer.append("  BEGIN");
        buffer.append(this.newline());
        buffer.append("   DBMS_OUTPUT.PUT_LINE(msg||tablename||' is required');");
        buffer.append(this.newline());
        buffer.append("   raise_application_error(-20222,msg||tablename||' is required');");
        buffer.append(this.newline());
        buffer.append("  END;");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("PROCEDURE EXEC_STATEMENT (");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" current_step NUMBER,");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" sql_statement VARCHAR2,");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" comments VARCHAR2) IS");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" err_num NUMBER;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" err_msg VARCHAR2(250);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" out_msg VARCHAR2(1000);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" raise_again boolean;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" error_fl boolean;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" st_time VARCHAR2(25);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" end_time VARCHAR2(25);");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  BEGIN");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" if current_step >= start_step and (stop_step=0 OR current_step <= stop_step) then");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  raise_again := false;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("  err_num:=0;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("  error_fl:=false;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  begin");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("st_time:= to_char(sysdate,'yyyymmdd hh24:mi:ss');");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("   execute immediate (sql_statement);");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("end_time:= to_char(sysdate,'yyyymmdd hh24:mi:ss');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("  EXCEPTION");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("     WHEN OTHERS THEN");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("  err_num := SQLCODE;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("  err_msg := SUBSTR(SQLERRM, 1, 250);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("end_time:= to_char(sysdate,'yyyymmdd hh24:mi:ss');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("error_fl:=true;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" if err_num=0  then");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  out_msg:=' Ok ';");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("elsif skip_errors.EXISTS(err_num) then");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" out_msg:= ' Masked error '|| err_num;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("else ");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" raise_again := true;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" out_msg:=' Error ' ||err_num;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" end if;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE('Step '||current_step||out_msg||'  time: '||st_time||' - '||end_time);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if log_options = 2 then");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  DBMS_OUTPUT.PUT_LINE( comments);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("elsif log_options = 3 then ");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE( substr(sql_statement,1,250) );");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("end if;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if err_num<>0 then");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  DBMS_OUTPUT.PUT_LINE('');");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("  DBMS_OUTPUT.PUT_LINE(err_msg);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("end if;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE('');");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE('');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if raise_again then");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append(" RAISE;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("end if;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("end; ");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if not error_fl then");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("out_msg:=' Ok ';");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE('Step '||current_step||out_msg||'  time: '||st_time||' - '||end_time);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if log_options = 2 then");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE( comments);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("elsif log_options = 3 then ");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" DBMS_OUTPUT.PUT_LINE( substr(sql_statement,1,250) );");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("end if;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("DBMS_OUTPUT.PUT_LINE('');");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("DBMS_OUTPUT.PUT_LINE('');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("end if;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("end if;");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("END;");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("PROCEDURE INIT_STEPS(");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("start_step_in NUMBER,");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("stop_step_in NUMBER,");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("log_option_in NUMBER) IS");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("BEGIN");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" start_step := start_step_in;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" stop_step := stop_step_in;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append(" log_options := log_option_in;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("END;");
        buffer.append(this.newline());
        buffer.append("BEGIN ");
        buffer.append(this.newline());
        buffer.append(" start_step :=0;");
        buffer.append(this.newline());
        buffer.append(" stop_step :=0;");
        buffer.append(this.newline());
        buffer.append("-- dynamic settings - depends on log options set in Oracle SQL Developer Modeler");
        buffer.append(this.newline());
        buffer.append("log_options := 2;");
        buffer.append(this.newline());
        buffer.append("-- dynamic settings - depends on list of errors to skip set in Oracle SQL Developer Modeler");
        this.appendDDLExceptionList(buffer);
        buffer.append(this.newline());
        buffer.append("END adv_scripting;");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("/");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("-- static part");
        buffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 1) {
            buffer.append(this.newline());
            buffer.append("define start_in = 0;");
            buffer.append(this.newline());
            buffer.append("define stop_in = 0;");
            buffer.append(this.newline());
            buffer.append("define log_option_in = 1;");
            buffer.append(this.newline());
            buffer.append(this.newline());
            buffer.append("accept start_in NUMBER PROMPT 'Enter start step>'");
            buffer.append(this.newline());
            buffer.append(this.newline());
            buffer.append("accept stop_in NUMBER PROMPT 'Enter stop step>'");
            buffer.append(this.newline());
            buffer.append(this.newline());
            buffer.append("accept log_file PROMPT 'Enter log file>'");
            buffer.append(this.newline());
            buffer.append(this.newline());
            buffer.append("PROMPT Enter log option :");
            buffer.append(this.newline());
            buffer.append("PROMPT log option := 1 - logs executed steps only + status + errors");
            buffer.append(this.newline());
            buffer.append("PROMPT log option := 2 - option 1 + comments");
            buffer.append(this.newline());
            buffer.append("PROMPT log option := 3 - option 1 + executed statement");
            buffer.append(this.newline());
            buffer.append("accept log_option_in NUMBER PROMPT 'Enter log option - 1,2 or 3>'");
            buffer.append(this.newline());
        } else {
            buffer.append(this.newline());
            buffer.append("define start_in = &1;");
            buffer.append(this.newline());
            buffer.append("define stop_in = &2;");
            buffer.append(this.newline());
            buffer.append("define log_file = &3;");
            buffer.append(this.newline());
            buffer.append("define log_option_in = &4;");
            buffer.append(this.newline());
        }
        buffer.append(this.newline());
        buffer.append("SET SERVEROUTPUT ON");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("SET SERVEROUTPUT ON FORMAT WRAP");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("set termout off");
        buffer.append(this.newline());
        buffer.append("set verify off");
        buffer.append(this.newline());
        buffer.append("set feedback off");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("begin");
        buffer.append(this.newline());
        buffer.append(" DBMS_OUTPUT.ENABLE(500000);");
        buffer.append(this.newline());
        buffer.append("end;");
        buffer.append(this.newline());
        buffer.append("/");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("execute adv_scripting.INIT_STEPS(&start_in,&stop_in,&log_option_in)");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("spool &log_file");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("WHENEVER SQLERROR EXIT 22 COMMIT");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append(this.newline());
    }

    private void appendDDLExceptionList(StringBuffer buffer) {
        if (this.getDDLExceptionList() != null) {
            for (DDLException ddlException : this.getDDLExceptionList().getDDLExceptions()) {
                if (!ddlException.isSelected()) continue;
                buffer.append(this.newline());
                buffer.append("--");
                String description = ddlException.getDescription();
                if (description.length() > 70) {
                    description = description.substring(0, 70);
                }
                buffer.append(description);
                buffer.append(this.newline());
                buffer.append("skip_errors(").append(ddlException.getNumber()).append(")");
                buffer.append(":=").append(ddlException.getNumber()).append(";");
            }
        }
    }

    public DDLExceptionList getDDLExceptionList() {
        return this.ddlExceptionList;
    }

    public void setDDLExceptionList(DDLExceptionList ddlExceptionList) {
        this.ddlExceptionList = ddlExceptionList;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public void addStatementFinisher(StringBuffer buffer) {
        buffer.append("spool off");
        buffer.append(this.newline());
        buffer.append("set termout on");
        buffer.append(this.newline());
        buffer.append("set verify on");
        buffer.append(this.newline());
        buffer.append("set feedback on");
        buffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 2) {
            buffer.append("exit ;");
            buffer.append(this.newline());
        }
    }

    public void unloadStatement(StringBuffer buffer) {
        buffer.append("CREATE OR REPLACE AND COMPILE JAVA SOURCE NAMED \"ODM_JAVA_SP\" AS");
        buffer.append(this.newline());
        buffer.append("import java.io.BufferedOutputStream;");
        buffer.append(this.newline());
        buffer.append("import java.io.BufferedWriter;");
        buffer.append(this.newline());
        buffer.append("import java.io.File;");
        buffer.append(this.newline());
        buffer.append("import java.io.FileOutputStream;");
        buffer.append(this.newline());
        buffer.append("import java.io.IOException;");
        buffer.append(this.newline());
        buffer.append("import java.io.InputStream;");
        buffer.append(this.newline());
        buffer.append("import java.io.OutputStream;");
        buffer.append(this.newline());
        buffer.append("import java.io.OutputStreamWriter;");
        buffer.append(this.newline());
        buffer.append("import java.io.Reader;");
        buffer.append(this.newline());
        buffer.append("import java.io.Writer;");
        buffer.append(this.newline());
        buffer.append("import java.sql.Connection;");
        buffer.append(this.newline());
        buffer.append("import java.sql.ResultSet;");
        buffer.append(this.newline());
        buffer.append("import java.sql.ResultSetMetaData;");
        buffer.append(this.newline());
        buffer.append("import java.sql.SQLException;");
        buffer.append(this.newline());
        buffer.append("import java.sql.Statement;");
        buffer.append(this.newline());
        buffer.append("import java.sql.Types;");
        buffer.append(this.newline());
        buffer.append("import oracle.jdbc.*;");
        buffer.append(this.newline());
        buffer.append("import oracle.sql.BFILE;");
        buffer.append(this.newline());
        buffer.append("import oracle.sql.OPAQUE;");
        buffer.append(this.newline());
        buffer.append("import oracle.xdb.XMLType;");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("public class ODM_JAVA_SP {");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("public static void save_to_file_01(String query, String fileName, int writeMode)");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("throws SQLException, IOException");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("{");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("File file = openFile(fileName, writeMode);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("Writer fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)), 32768);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("Connection conn = null;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("Statement stmt = null;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("ResultSet rset = null;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("try {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("int extraFileCount = 0;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("OracleDriver ora = new OracleDriver();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("conn = ora.defaultConnection();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("stmt = conn.createStatement();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("rset = stmt.executeQuery(query);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("ResultSetMetaData rsmd = rset.getMetaData();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("int colCount = rsmd.getColumnCount();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("while ( rset.next() ) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("for ( int i = 1; i <= colCount; i++ ) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("int sqlType = rsmd.getColumnType(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if ((sqlType == Types.CHAR) || (sqlType == Types.VARCHAR)) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("String charString = rset.getString(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (charString != null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("charString = \"\\\"\" + charString.replaceAll(\"\\\"\", \"\\\"\\\"\") + \"\\\"\";");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(charString);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("} else if (sqlType == Types.CLOB) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("Reader reader = rset.getCharacterStream(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (reader != null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("String clobFilePath = getExtraFilePath(fileName, ++extraFileCount, \"txt\");");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("File clobFile = openFile(clobFilePath, writeMode);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("Writer writer = new BufferedWriter(");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("new OutputStreamWriter(new FileOutputStream(clobFile)), 32768);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("int character = reader.read();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("while (character >= 0) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("writer.write(character);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("character = reader.read();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("reader.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("writer.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(getFileName(clobFilePath));");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("} else if ((sqlType == Types.BLOB) ||");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("           (sqlType == OracleTypes.OPAQUE)) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("String ext = \"bin\";");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("InputStream inputStream = null;");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (sqlType == OracleTypes.OPAQUE) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("ext = \"xml\";");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("OPAQUE opaque = ((OracleResultSet) rset).getOPAQUE(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (opaque != null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("XMLType xmlType = XMLType.createXML(opaque);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("inputStream = xmlType.getInputStream();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("} else {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("inputStream = rset.getBinaryStream(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (inputStream != null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("String blobFilePath = getExtraFilePath(fileName, ++extraFileCount, ext);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("File blobFile = openFile(blobFilePath, writeMode);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("OutputStream outputStream = new BufferedOutputStream(");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("     new FileOutputStream(blobFile), 32768);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("int dataByte = inputStream.read();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("while (dataByte >= 0) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("outputStream.write(dataByte);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("dataByte = inputStream.read();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("inputStream.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("outputStream.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(getFileName(blobFilePath));");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("} else if (sqlType == OracleTypes.BFILE) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("BFILE bfile = ((OracleResultSet) rset).getBFILE(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (bfile != null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(\"'\" + bfile.getDirAlias() + \"', '\"+ bfile.getName() + \"'\");");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("} else {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("String charString = rset.getString(i);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (charString != null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(charString);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(\"|\");");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("fout.write(\"|@*|\\r\\n\");");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("finally {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    fout.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    if(rset!=null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("        rset.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    }");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    if(stmt!=null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("        stmt.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    }");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    if(conn!=null) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("        conn.commit();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("        conn.close();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("    }");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("private static String getExtraFilePath(String baseFilePath, int extraFileNum, String extension)");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("{");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("int lastDot = baseFilePath.lastIndexOf('.');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if (lastDot >= 0) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("baseFilePath = baseFilePath.substring(0, lastDot);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("return baseFilePath + '.' + extraFileNum + '.' + extension;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("private static String getFileName(String filePath)");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("{");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("int lastIndex = filePath.lastIndexOf('/');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if (lastIndex >= 0) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("filePath = filePath.substring(lastIndex + 1);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("lastIndex = filePath.lastIndexOf('\\\\');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if (lastIndex >= 0) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("filePath = filePath.substring(lastIndex + 1);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("lastIndex = filePath.lastIndexOf(':');");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if (lastIndex >= 0) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("filePath = filePath.substring(lastIndex + 1);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("return filePath;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline());
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("private static File openFile(String fileName, int writeMode)");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("{");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("File file = new File(fileName);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("if (writeMode != 1) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("if (file.exists()) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("throw new RuntimeException(\"File \" + fileName + \" already exists\");");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("try {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("file.createNewFile();");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("} catch (IOException e) {");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        buffer.append("throw new RuntimeException(\"File \" + fileName + \" cannot be created \" + e);");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        buffer.append("return file;");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("}");
        buffer.append(this.newline());
        buffer.append("}");
        buffer.append(this.newline());
        buffer.append("/");
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("create or replace procedure cwd_query_to_file( query in varchar2,file_name in varchar2, write_mode in number )");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("as");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("language java");
        buffer.append(this.newline()).append(this.newTab());
        buffer.append("name 'ODM_JAVA_SP.save_to_file_01( java.lang.String,java.lang.String,int)';");
        buffer.append(this.newline());
        buffer.append("/");
        buffer.append(this.newline());
        buffer.append(this.newline());
    }

    private void appendDescription(StringBuffer buffer) {
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("--  ODM advanced script with support for");
        buffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 1) {
            buffer.append("--  interactive (SQL/Plus or SQLDeveloper)");
        } else {
            buffer.append("--  command line (SQL/Plus only)");
        }
        buffer.append(this.newline());
        buffer.append("--  settings of input parameters for:");
        buffer.append(this.newline());
        buffer.append("--  start step, stop step, log file and log level (1,2 or 3)");
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        buffer.append("--  In order to have this script successfully executed,");
        buffer.append(this.newline());
        buffer.append("--  the following grants should be given to the user");
        buffer.append(this.newline());
        buffer.append("--  that executes the script (SCOTT in the examples below):");
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        buffer.append("-- grant connect, resource to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant unlimited tablespace to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant create any table to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant create any trigger to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant drop any table to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant create view to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant create sequence to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant create snapshot to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant QUERY REWRITE TO SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant create any directory to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- grant drop any directory to SCOTT;");
        buffer.append(this.newline());
        buffer.append("-- begin");
        buffer.append(this.newline());
        buffer.append("--  Dbms_Java.grant_Permission('SCOTT', 'java.io.FilePermission',");
        buffer.append(this.newline());
        buffer.append("--  '<<ALL FILES>>', 'read ,write, execute, delete');");
        buffer.append(this.newline());
        buffer.append("-- end;");
        buffer.append(this.newline());
        buffer.append("-- /");
        buffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 2) {
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            buffer.append("-- The script can be executed as follows (all parameters are required):");
            buffer.append(this.newline());
            buffer.append("--");
            buffer.append(this.newline());
            buffer.append("-- sqlplus user/passw@name @script_name start_step stop_st log_file log_level");
            buffer.append(this.newline());
            buffer.append("--");
            buffer.append(this.newline());
            buffer.append("-- Examples:");
            buffer.append(this.newline());
            buffer.append("--");
            buffer.append(this.newline());
            buffer.append("-- sqlplus scott/tiger@orcl @e:\\adv_script.sql 0 0 e:\\adv_script.log 2");
            buffer.append(this.newline());
            buffer.append("--");
            buffer.append(this.newline());
            buffer.append("-- the execution will start from the begining of the script");
            buffer.append(this.newline());
            buffer.append("-- and there is no restriction on step on which execution will stop");
            buffer.append(this.newline());
            buffer.append("--");
            buffer.append(this.newline());
            buffer.append("-- sqlplus scott/tiger@orcl @e:\\adv_script.sql 50 200 e:\\adv_script.log 1");
            buffer.append(this.newline());
            buffer.append("--");
            buffer.append(this.newline());
            buffer.append("-- all steps between 50 and 200 (including) will be executed");
            buffer.append(this.newline());
        }
        buffer.append("--");
        buffer.append(this.newline());
    }
}

