/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;

public class SetChangeEvent
extends EventObject {
    private final Set _addedObjects;
    private final Set _removedObjects;

    public SetChangeEvent(Object source, Set addedObjects, Set removedObjects) {
        super(source);
        this._addedObjects = addedObjects;
        this._removedObjects = removedObjects;
    }

    public Set getAddedObjects() {
        if (this._addedObjects == null) {
            return null;
        }
        return Collections.unmodifiableSet(this._addedObjects);
    }

    public Set getRemovedObjects() {
        if (this._removedObjects == null) {
            return null;
        }
        return Collections.unmodifiableSet(this._removedObjects);
    }

    public int getAddedCount() {
        return this._addedObjects != null ? this._addedObjects.size() : 0;
    }

    public int getRemovedCount() {
        return this._removedObjects != null ? this._removedObjects.size() : 0;
    }

    @Override
    public String toString() {
        String outString = super.toString();
        if (this._addedObjects != null && !this._addedObjects.isEmpty()) {
            outString = outString + "\nadded:" + this._addedObjects;
        }
        if (this._removedObjects != null && !this._removedObjects.isEmpty()) {
            outString = outString + "\nremoved:" + this._removedObjects;
        }
        return outString;
    }
}

