/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.BufferDomRelatedChange;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import org.w3c.dom.Node;

class SimpleMapNodeToLocatorChange
extends BufferDomRelatedChange {
    private final NodeRef _nodeRef;
    private final Locator _newLoc;
    private final Locator _oldLoc;

    public SimpleMapNodeToLocatorChange(NodeRef ref, Locator newLoc, Locator oldLoc) {
        this._nodeRef = ref;
        this._newLoc = newLoc;
        this._oldLoc = oldLoc;
    }

    @Override
    protected void preUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        this._map(model, plugin, this._oldLoc);
    }

    @Override
    protected void postRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        this._map(model, plugin, this._newLoc);
    }

    private void _map(DomModel model, BufferDomModel plugin, Locator newLocator) {
        Node node = TextSyncUtils.getNode(model, this._nodeRef);
        LocatorManager manager = plugin.getLocatorManager();
        Locator before = plugin.getLocator(node);
        if (before != null) {
            before.attach(manager, false);
        }
        newLocator = Locator.getCopy(newLocator);
        plugin.mapNodeToLocator(node, newLocator);
        if (newLocator != null) {
            newLocator.attach(manager, true);
        }
    }
}

