/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Proj;

public class ShapeUtil {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final float[] closeCoords = new float[6];
    static float[] pointCoord = new float[6];
    static AffineTransform _shiftLeft180 = null;
    static Area _rightHemisphere180 = null;
    static Area _leftHemisphere180 = null;
    private static AffineTransform _shift0 = null;
    private static Area _rightHemisphere0 = null;
    private static Area _leftHemisphere0 = null;

    public static double lengthOf(Shape shp) {
        PathIterator pi = shp.getPathIterator(null);
        double sx = Double.NEGATIVE_INFINITY;
        double sy = Double.NEGATIVE_INFINITY;
        double ex = Double.POSITIVE_INFINITY;
        double ey = Double.POSITIVE_INFINITY;
        double mx = Double.POSITIVE_INFINITY;
        double my = Double.POSITIVE_INFINITY;
        double len = 0.0;
        double[] seg = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = mx = seg[0];
                    sy = my = seg[1];
                    ex = Double.POSITIVE_INFINITY;
                    ey = Double.POSITIVE_INFINITY;
                    break;
                }
                case 1: {
                    if (ex != Double.POSITIVE_INFINITY && ey != Double.POSITIVE_INFINITY) {
                        sx = ex;
                        sy = ey;
                    }
                    ex = seg[0];
                    ey = seg[1];
                    len += Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
                    break;
                }
                case 4: {
                    sx = ex;
                    sy = ey;
                    ex = mx;
                    ey = my;
                    len += Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
                    break;
                }
                case 2: 
                case 3: {
                    log.warning("[ShapeUtil] lengthOf: invalid segment type.");
                }
            }
            pi.next();
        }
        return len;
    }

    public static double[] getEndPoints(Shape shp) {
        if (shp == null) {
            return null;
        }
        PathIterator pi = shp.getPathIterator(null);
        boolean foundFirst = false;
        double[] seg = new double[6];
        double x1 = 0.0;
        double y1 = 0.0;
        double xk = 0.0;
        double yk = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: 
                case 1: {
                    if (!foundFirst) {
                        x1 = seg[0];
                        y1 = seg[1];
                        foundFirst = true;
                    }
                    xk = seg[0];
                    yk = seg[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    if (!foundFirst) {
                        x1 = seg[0];
                        y1 = seg[1];
                        foundFirst = true;
                    }
                    xk = seg[4];
                    yk = seg[5];
                    break;
                }
                case 2: {
                    if (!foundFirst) {
                        x1 = seg[0];
                        y1 = seg[1];
                        foundFirst = true;
                    }
                    xk = seg[2];
                    yk = seg[3];
                }
            }
            pi.next();
        }
        seg[0] = x1;
        seg[1] = y1;
        seg[2] = xk;
        seg[3] = yk;
        return seg;
    }

    public static double estLengthOf(Shape shp) {
        PathIterator pi = shp.getPathIterator(null);
        double sx = Double.NEGATIVE_INFINITY;
        double sy = Double.NEGATIVE_INFINITY;
        double ex = Double.POSITIVE_INFINITY;
        double ey = Double.POSITIVE_INFINITY;
        double mx = Double.POSITIVE_INFINITY;
        double my = Double.POSITIVE_INFINITY;
        double len = 0.0;
        double[] seg = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = mx = seg[0];
                    sy = my = seg[1];
                    ex = Double.POSITIVE_INFINITY;
                    ey = Double.POSITIVE_INFINITY;
                    break;
                }
                case 1: {
                    if (ex != Double.POSITIVE_INFINITY && ey != Double.POSITIVE_INFINITY) {
                        sx = ex;
                        sy = ey;
                    }
                    ex = seg[0];
                    ey = seg[1];
                    len += Math.max(Math.abs(ex - sx), Math.abs(ey - sy));
                    break;
                }
                case 4: {
                    sx = ex;
                    sy = ey;
                    ex = mx;
                    ey = my;
                    len += Math.max(Math.abs(ex - sx), Math.abs(ey - sy));
                    break;
                }
                case 2: 
                case 3: {
                    log.severe("[ShapeUtil] lengthOf: invalid segment type.");
                }
            }
            pi.next();
        }
        return len * 1.2;
    }

    public static boolean lrPoint(Shape linear, double percent, float[] pt) {
        if (percent < 0.0 || percent > 1.0) {
            return false;
        }
        double len = ShapeUtil.lengthOf(linear);
        if (len == 0.0) {
            return false;
        }
        len *= percent;
        PathIterator pi = linear.getPathIterator(null);
        double sx = Double.NEGATIVE_INFINITY;
        double sy = Double.NEGATIVE_INFINITY;
        double ex = Double.POSITIVE_INFINITY;
        double ey = Double.POSITIVE_INFINITY;
        double mx = Double.POSITIVE_INFINITY;
        double my = Double.POSITIVE_INFINITY;
        double segLen = 0.0;
        double[] seg = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = mx = seg[0];
                    sy = my = seg[1];
                    break;
                }
                case 1: {
                    ex = seg[0];
                    ey = seg[1];
                    segLen = Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
                    len -= segLen;
                    if (len < 0.0) {
                        double r = (segLen - Math.abs(len)) / segLen;
                        pt[0] = (float)(sx + (ex - sx) * r);
                        pt[1] = (float)(sy + (ey - sy) * r);
                        return true;
                    }
                    sx = ex;
                    sy = ey;
                    break;
                }
                case 4: {
                    ex = mx;
                    ey = my;
                    segLen = Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
                    len -= segLen;
                    if (!(len < 0.0)) break;
                    double r = (segLen - Math.abs(len)) / segLen;
                    pt[0] = (float)(sx + (ex - sx) * r);
                    pt[1] = (float)(sy + (ey - sy) * r);
                    return true;
                }
                case 2: 
                case 3: {
                    log.severe("[ShapeUtil] lrPoint: invalid segment type.");
                }
            }
            pi.next();
        }
        if (len == 0.0 && percent == 1.0) {
            pt[0] = (float)sx;
            pt[1] = (float)sy;
            return true;
        }
        return false;
    }

    public static int lrSegmentPoints(Shape linear, double percent, double[] pt) {
        if (percent < 0.0 || percent > 1.0) {
            return 0;
        }
        double len = ShapeUtil.lengthOf(linear);
        len *= percent;
        PathIterator pi = linear.getPathIterator(null);
        double sx = Double.NEGATIVE_INFINITY;
        double sy = Double.NEGATIVE_INFINITY;
        double ex = Double.POSITIVE_INFINITY;
        double ey = Double.POSITIVE_INFINITY;
        double mx = Double.POSITIVE_INFINITY;
        double my = Double.POSITIVE_INFINITY;
        double px = Double.NEGATIVE_INFINITY;
        double py = Double.NEGATIVE_INFINITY;
        double segLen = 0.0;
        double[] seg = new double[6];
        int segpos = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = mx = seg[0];
                    sy = my = seg[1];
                    break;
                }
                case 1: {
                    ++segpos;
                    ex = seg[0];
                    ey = seg[1];
                    segLen = Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
                    len -= segLen;
                    if (len < 0.0) {
                        pt[0] = sx;
                        pt[1] = sy;
                        pt[2] = ex;
                        pt[3] = ey;
                        return segpos;
                    }
                    px = sx;
                    py = sy;
                    sx = ex;
                    sy = ey;
                    break;
                }
                case 4: {
                    ++segpos;
                    ex = mx;
                    ey = my;
                    px = sx;
                    py = sy;
                    segLen = Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
                    len -= segLen;
                    if (!(len < 0.0)) break;
                    pt[0] = sx;
                    pt[1] = sy;
                    pt[2] = ex;
                    pt[3] = ey;
                    return segpos;
                }
                case 2: 
                case 3: {
                    log.severe("[ShapeUtil] lrSegment: invalid segment type.");
                }
            }
            pi.next();
        }
        if (len == 0.0 && percent == 1.0) {
            pt[0] = px;
            pt[1] = py;
            pt[2] = ex;
            pt[3] = ey;
            return segpos;
        }
        return 0;
    }

    public static double[] lrSegmentPoints(Shape linear) {
        if (linear == null) {
            return null;
        }
        PathIterator pi = linear.getPathIterator(null);
        double sx = Double.NEGATIVE_INFINITY;
        double sy = Double.NEGATIVE_INFINITY;
        double ex = Double.POSITIVE_INFINITY;
        double ey = Double.POSITIVE_INFINITY;
        double mx = Double.POSITIVE_INFINITY;
        double my = Double.POSITIVE_INFINITY;
        double[] seg = new double[6];
        ArrayList<Double> points = new ArrayList<Double>();
        int segpos = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = mx = seg[0];
                    sy = my = seg[1];
                    break;
                }
                case 1: {
                    ++segpos;
                    ex = seg[0];
                    ey = seg[1];
                    points.add(sx);
                    points.add(sy);
                    points.add(ex);
                    points.add(ey);
                    sx = ex;
                    sy = ey;
                    break;
                }
                case 4: {
                    ++segpos;
                    ex = mx;
                    ey = my;
                    points.add(sx);
                    points.add(sy);
                    points.add(ex);
                    points.add(ey);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            pi.next();
        }
        if (points.size() == 0) {
            return null;
        }
        double[] pts = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            pts[i] = (Double)points.get(i);
        }
        return pts;
    }

    public static final int numLineSegments(Shape shp, float[] coords) {
        int count = 0;
        PathIterator pi = shp.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (type == 1 || type == 4) {
                ++count;
            }
            pi.next();
        }
        return count;
    }

    public static final int numCloseSegments(Shape shp) {
        int count = 0;
        PathIterator pi = shp.getPathIterator(null);
        while (!pi.isDone()) {
            if (pi.currentSegment(closeCoords) == 4) {
                ++count;
            }
            pi.next();
        }
        return count;
    }

    public static double projection(double cx, double cy, double Ax, double Ay, double Bx, double By, Point2D out) {
        if (Ax == Bx && Ay == By) {
            return Double.NaN;
        }
        double r = ((cx - Ax) * (Bx - Ax) + (cy - Ay) * (By - Ay)) / ((Bx - Ax) * (Bx - Ax) + (By - Ay) * (By - Ay));
        double x = Ax + r * (Bx - Ax);
        double y = Ay + r * (By - Ay);
        out.setLocation(x, y);
        return r;
    }

    public static final int numPoints(Shape shp) {
        int count = 0;
        boolean lastOneIsMoveTo = false;
        PathIterator pi = shp.getPathIterator(null);
        while (!pi.isDone()) {
            switch (pi.currentSegment(pointCoord)) {
                case 0: {
                    if (lastOneIsMoveTo) {
                        ++count;
                    }
                    lastOneIsMoveTo = true;
                    break;
                }
                default: {
                    lastOneIsMoveTo = false;
                }
            }
            pi.next();
        }
        if (lastOneIsMoveTo) {
            ++count;
        }
        return count;
    }

    public static final boolean clipLineSegment(double[] line, Rectangle2D clip, double[] out) {
        double x0 = line[0];
        double y0 = line[1];
        double x1 = line[2];
        double y1 = line[3];
        int c0 = clip.outcode(x0, y0);
        int c12 = clip.outcode(x1, y1);
        while (true) {
            double y;
            double x;
            int c;
            if ((c0 | c12) == 0) {
                out[0] = x0;
                out[1] = y0;
                out[2] = x1;
                out[3] = y1;
                return true;
            }
            if ((c0 & c12) != 0) {
                return false;
            }
            int n = c = c0 != 0 ? c0 : c12;
            if ((c & 8) != 0) {
                x = x0 + (x1 - x0) * (clip.getMaxY() - y0) / (y1 - y0);
                y = clip.getMaxY();
            } else if ((c & 2) != 0) {
                x = x0 + (x1 - x0) * (clip.getMinY() - y0) / (y1 - y0);
                y = clip.getMinY();
            } else if ((c & 4) != 0) {
                x = clip.getMaxX();
                y = y0 + (y1 - y0) * (clip.getMaxX() - x0) / (x1 - x0);
            } else {
                x = clip.getMinX();
                y = y0 + (y1 - y0) * (clip.getMinX() - x0) / (x1 - x0);
            }
            if (c == c0) {
                x0 = x;
                y0 = y;
                c0 = clip.outcode(x0, y0);
                continue;
            }
            x1 = x;
            y1 = y;
            c12 = clip.outcode(x1, y1);
        }
    }

    private static final boolean contains(Rectangle2D win, double x, double y) {
        return x <= win.getMaxX() && y <= win.getMaxY() && x >= win.getMinX() && y >= win.getMinY();
    }

    public static Shape clipLineString(Rectangle2D window, Shape old, Rectangle shapeMBR) {
        if (old == null) {
            return old;
        }
        if (shapeMBR == null) {
            shapeMBR = old.getBounds();
        }
        if (window.contains(shapeMBR)) {
            return old;
        }
        PathIterator pi = old.getPathIterator(null);
        if (pi.isDone()) {
            return old;
        }
        float sx = 0.0f;
        float sy = 0.0f;
        float ex = 0.0f;
        float ey = 0.0f;
        float mx = 0.0f;
        float my = 0.0f;
        float[] seg = new float[6];
        double[] in = new double[4];
        double[] out = new double[4];
        GeneralPath newShp = new GeneralPath(pi.getWindingRule());
        int segType = 0;
        int lineToCnt = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    lineToCnt = 0;
                    sx = seg[0];
                    sy = seg[1];
                    mx = sx;
                    my = sy;
                    if (!ShapeUtil.contains(window, seg[0], seg[1])) break;
                    newShp.moveTo(seg[0], seg[1]);
                    break;
                }
                case 1: {
                    ++lineToCnt;
                    ex = seg[0];
                    ey = seg[1];
                    in[0] = sx;
                    in[1] = sy;
                    in[2] = ex;
                    in[3] = ey;
                    if (ShapeUtil.clipLineSegment(in, window, out)) {
                        if (out[0] != (double)sx || out[1] != (double)sy) {
                            newShp.moveTo((float)out[0], (float)out[1]);
                        }
                        newShp.lineTo((float)out[2], (float)out[3]);
                    }
                    sx = ex;
                    sy = ey;
                    break;
                }
                case 4: {
                    if (lineToCnt <= 0) break;
                    lineToCnt = 0;
                    sx = ex;
                    sy = ey;
                    ex = mx;
                    ey = my;
                    if (!ShapeUtil.clipLineSegment(in, window, out)) break;
                    if (out[0] != (double)sx || out[1] != (double)sy) {
                        newShp.moveTo((float)out[0], (float)out[1]);
                    }
                    newShp.lineTo((float)out[2], (float)out[3]);
                    break;
                }
                default: {
                    log.finer("clipLineString: quadratic or cubic curve not supported.");
                    return old;
                }
            }
            pi.next();
        }
        return newShp;
    }

    public static Shape clipLineString(Rectangle2D window, Shape old) {
        return ShapeUtil.clipLineString(window, old, null);
    }

    private static Shape clipPolygon2(Rectangle2D window, Shape s) {
        Area a = new Area(s);
        Area b = new Area(window);
        a.intersect(b);
        PathIterator pi = a.getPathIterator(null);
        GeneralPath res = new GeneralPath();
        res.append(pi, false);
        return res;
    }

    public static Shape clipPolygon(Rectangle2D window, Shape s) {
        return ShapeUtil.clipPolygon2(window, s);
    }

    public static double drawHashMarkOnSegment(double sx, double sy, double ex, double ey, double startOffset, double gap, double markLen, Graphics2D g2) {
        double accumLen;
        double dx = ex - sx;
        double dy = ey - sy;
        double hdx = -dy;
        double hdy = dx;
        double segLen = Math.sqrt((ex - sx) * (ex - sx) + (ey - sy) * (ey - sy));
        double hr = markLen / segLen;
        for (accumLen = startOffset; accumLen <= segLen; accumLen += gap) {
            double r = accumLen / segLen;
            double hsx = sx + dx * r;
            double hsy = sy + dy * r;
            double hex = hsx + hdx * hr;
            double hey = hsy + hdy * hr;
            g2.drawLine((int)hsx, (int)hsy, (int)hex, (int)hey);
            hex = hsx - hdx * hr;
            hey = hsy - hdy * hr;
            g2.drawLine((int)hsx, (int)hsy, (int)hex, (int)hey);
        }
        return accumLen - segLen;
    }

    public static void drawHashmarksOnShape(Graphics2D g2, Color hashColor, Shape shp, double gap, double markLen) {
        double startOffset = 0.0;
        PathIterator pi = shp.getPathIterator(null);
        double sx = Double.NEGATIVE_INFINITY;
        double sy = Double.NEGATIVE_INFINITY;
        double ex = Double.POSITIVE_INFINITY;
        double ey = Double.POSITIVE_INFINITY;
        double mx = Double.POSITIVE_INFINITY;
        double my = Double.POSITIVE_INFINITY;
        double len = 0.0;
        double[] seg = new double[6];
        g2.setColor(hashColor);
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = mx = seg[0];
                    sy = my = seg[1];
                    ex = Double.POSITIVE_INFINITY;
                    ey = Double.POSITIVE_INFINITY;
                    startOffset = 0.0;
                    break;
                }
                case 1: {
                    if (ex != Double.POSITIVE_INFINITY && ey != Double.POSITIVE_INFINITY) {
                        sx = ex;
                        sy = ey;
                    }
                    ex = seg[0];
                    ey = seg[1];
                    startOffset = ShapeUtil.drawHashMarkOnSegment(sx, sy, ex, ey, startOffset, gap, markLen, g2);
                    break;
                }
                case 4: {
                    sx = ex;
                    sy = ey;
                    ex = mx;
                    ey = my;
                    startOffset = ShapeUtil.drawHashMarkOnSegment(sx, sy, ex, ey, startOffset, gap, markLen, g2);
                    break;
                }
                case 2: 
                case 3: {
                    System.err.println("ShapeUtil::lengthOf: invalid segment type.");
                }
            }
            pi.next();
        }
    }

    public static final void dumpShape(Shape shp) {
        float[] coord = new float[6];
        PathIterator pi = shp.getPathIterator(null);
        System.out.println("Winding=" + pi.getWindingRule());
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    System.out.print("\nM" + coord[0] + "," + coord[1] + " ");
                    break;
                }
                case 1: {
                    System.out.print("L" + coord[0] + "," + coord[1] + " ");
                    break;
                }
                case 2: {
                    System.out.print("Q" + coord[0] + "," + coord[1] + "," + coord[2] + "," + coord[3] + " ");
                    break;
                }
                case 3: {
                    System.out.print("U" + coord[0] + "," + coord[1] + "," + coord[2] + "," + coord[3] + "," + coord[4] + "," + coord[5] + " ");
                    break;
                }
                case 4: {
                    System.out.print("C ");
                }
            }
            pi.next();
        }
    }

    public static void store(Shape shape, ObjectOutputStream out) throws IOException {
        float[] coord = new float[6];
        PathIterator pi = shape.getPathIterator(null);
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    out.writeByte(77);
                    out.writeFloat(coord[0]);
                    out.writeFloat(coord[1]);
                    break;
                }
                case 1: {
                    out.writeByte(76);
                    out.writeFloat(coord[0]);
                    out.writeFloat(coord[1]);
                    break;
                }
                case 2: {
                    out.writeByte(81);
                    out.writeFloat(coord[0]);
                    out.writeFloat(coord[1]);
                    out.writeFloat(coord[2]);
                    out.writeFloat(coord[3]);
                    break;
                }
                case 3: {
                    out.writeByte(85);
                    out.writeFloat(coord[0]);
                    out.writeFloat(coord[1]);
                    out.writeFloat(coord[2]);
                    out.writeFloat(coord[3]);
                    out.writeFloat(coord[4]);
                    out.writeFloat(coord[5]);
                    break;
                }
                case 4: {
                    out.writeByte(67);
                }
            }
            pi.next();
        }
        out.writeByte(88);
    }

    public static Shape load(ObjectInputStream in) throws IOException, ClassNotFoundException {
        float[] coord = new float[6];
        GeneralPath gp = new GeneralPath();
        boolean done = false;
        while (!done) {
            byte c = in.readByte();
            switch (c) {
                case 77: {
                    coord[0] = in.readFloat();
                    coord[1] = in.readFloat();
                    gp.moveTo(coord[0], coord[1]);
                    break;
                }
                case 76: {
                    coord[0] = in.readFloat();
                    coord[1] = in.readFloat();
                    gp.lineTo(coord[0], coord[1]);
                    break;
                }
                case 81: {
                    coord[0] = in.readFloat();
                    coord[1] = in.readFloat();
                    coord[2] = in.readFloat();
                    coord[3] = in.readFloat();
                    gp.quadTo(coord[0], coord[1], coord[2], coord[3]);
                    break;
                }
                case 85: {
                    coord[0] = in.readFloat();
                    coord[1] = in.readFloat();
                    coord[2] = in.readFloat();
                    coord[3] = in.readFloat();
                    coord[4] = in.readFloat();
                    coord[5] = in.readFloat();
                    gp.curveTo(coord[0], coord[1], coord[2], coord[3], coord[4], coord[5]);
                    break;
                }
                case 67: {
                    gp.closePath();
                    break;
                }
                case 88: {
                    done = true;
                }
            }
        }
        return gp;
    }

    public static Shape createShape(float[] points) {
        GeneralPath gp = new GeneralPath();
        boolean done = false;
        int length = points.length;
        if (length < 4) {
            return null;
        }
        gp.moveTo(points[0], points[1]);
        for (int i = 2; i < length; i += 2) {
            gp.lineTo(points[i], points[i + 1]);
        }
        gp.closePath();
        return gp;
    }

    public static String toSVGPathData(Shape shp) {
        int charCnt = 0;
        StringBuffer path = new StringBuffer(2048);
        float[] coord = new float[6];
        int prevPI = 4;
        PathIterator pi = shp.getPathIterator(null);
        while (!pi.isDone()) {
            int clen = path.length();
            int currentPI = pi.currentSegment(coord);
            switch (currentPI) {
                case 0: {
                    path.append("M" + coord[0] + "," + coord[1]);
                    break;
                }
                case 1: {
                    if (prevPI == 1) {
                        path.append(" ").append(coord[0]).append(",").append(coord[1]);
                        break;
                    }
                    path.append("L").append(coord[0]).append(",").append(coord[1]);
                    break;
                }
                case 2: {
                    path.append("Q" + coord[0] + "," + coord[1] + " " + coord[2] + "," + coord[3]);
                    break;
                }
                case 3: {
                    path.append("C" + coord[0] + "," + coord[1] + " " + coord[2] + "," + coord[3] + " " + coord[4] + "," + coord[5]);
                    break;
                }
                case 4: {
                    path.append("Z");
                }
            }
            prevPI = currentPI;
            if ((charCnt += path.length() - clen) >= 255) {
                path.append("\n");
                charCnt = 0;
            }
            pi.next();
        }
        return path.toString();
    }

    public static Shape splitAt180(Shape in, boolean area) {
        if (area) {
            Area left = new Area(in);
            Area right = new Area(in);
            if (_rightHemisphere180 == null) {
                _rightHemisphere180 = new Area(new Rectangle2D.Double(180.0, -91.0, 180.0, 182.0));
            }
            if (_leftHemisphere180 == null) {
                _leftHemisphere180 = new Area(new Rectangle2D.Double(0.0, -91.0, 180.0, 182.0));
            }
            left.subtract(_rightHemisphere180);
            right.subtract(_leftHemisphere180);
            if (_shiftLeft180 == null) {
                _shiftLeft180 = new AffineTransform();
                _shiftLeft180.translate(-360.0, 0.0);
            }
            GeneralPath gp = new GeneralPath();
            gp.append(left.getPathIterator(null), false);
            gp.append(right.getPathIterator(_shiftLeft180), false);
            return gp;
        }
        return ShapeUtil.splitLinestringAt180(in);
    }

    static Shape splitLinestringAt180(Shape in) {
        PathIterator pi = in.getPathIterator(null);
        if (pi.isDone()) {
            return in;
        }
        float sx = 0.0f;
        float sy = 0.0f;
        float ex = 0.0f;
        float ey = 0.0f;
        float[] seg = new float[6];
        GeneralPath newShp = new GeneralPath(pi.getWindingRule());
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = seg[0];
                    sy = seg[1];
                    newShp.moveTo(sx, sy);
                    break;
                }
                case 1: {
                    boolean crossing;
                    ex = seg[0];
                    ey = seg[1];
                    float min = sx <= ex ? sx : ex;
                    float max = sx <= ex ? ex : sx;
                    boolean bl = crossing = min < 0.0f && max > 0.0f && max - min > 180.0f;
                    if (crossing) {
                        double yi;
                        double x1 = sx < 0.0f ? (double)(sx + 360.0f) : (double)sx;
                        double x2 = ex < 0.0f ? (double)(ex + 360.0f) : (double)ex;
                        double m = (double)(sy - ey) / (x1 - x2);
                        double d = yi = sy == ey ? (double)sy : (double)ey + (180.0 - x2) * m;
                        if (sx > 0.0f) {
                            newShp.lineTo(180.0f, (float)yi);
                            newShp.moveTo(-180.0f, (float)yi);
                        } else {
                            newShp.lineTo(-180.0f, (float)yi);
                            newShp.moveTo(180.0f, (float)yi);
                        }
                    }
                    newShp.lineTo(ex, ey);
                    sx = ex;
                    sy = ey;
                    break;
                }
                default: {
                    log.severe("splitLinestringAt180: invalid segment type.");
                }
            }
            pi.next();
        }
        return newShp;
    }

    public static Shape splitAt0(Shape in, boolean area) {
        if (area) {
            Area left = new Area(in);
            Area right = new Area(in);
            double X = 0.0;
            double w = 180.0;
            double sxr = X;
            double sxl = X - w;
            if (_rightHemisphere0 == null) {
                _rightHemisphere0 = new Area(new Rectangle2D.Double(sxr, -91.0, w, 182.0));
            }
            if (_leftHemisphere0 == null) {
                _leftHemisphere0 = new Area(new Rectangle2D.Double(sxl, -91.0, w, 182.0));
            }
            left.subtract(_rightHemisphere0);
            right.subtract(_leftHemisphere0);
            if (_shift0 == null) {
                _shift0 = new AffineTransform();
                _shift0.translate(360.0, 0.0);
            }
            GeneralPath gp = new GeneralPath();
            gp.append(left.getPathIterator(_shift0), false);
            GeneralPath rightP = ShapeUtil.ceilingTo0(right.getPathIterator(null));
            gp.append(rightP, false);
            return gp;
        }
        return ShapeUtil.splitLinestringAt0(in);
    }

    static Shape splitLinestringAt0(Shape in) {
        PathIterator pi = in.getPathIterator(null);
        if (pi.isDone()) {
            return in;
        }
        float sx = 0.0f;
        float sy = 0.0f;
        float ex = 0.0f;
        float ey = 0.0f;
        float mx = -9999.0f;
        float my = 0.0f;
        float[] seg = new float[6];
        GeneralPath newShp = new GeneralPath(pi.getWindingRule());
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = seg[0];
                    sy = seg[1];
                    if (sx < 0.0f) {
                        newShp.moveTo(sx + 360.0f, sy);
                        break;
                    }
                    if (sx > 0.0f) {
                        newShp.moveTo(sx, sy);
                        break;
                    }
                    mx = 0.0f;
                    my = sy;
                    break;
                }
                case 1: {
                    boolean crossing;
                    ex = seg[0];
                    ey = seg[1];
                    if (mx == 0.0f) {
                        if (ex < 0.0f) {
                            newShp.moveTo(360.0f, my);
                        } else {
                            newShp.moveTo(mx, my);
                        }
                    }
                    mx = -9999.0f;
                    float min = sx <= ex ? sx : ex;
                    float max = sx <= ex ? ex : sx;
                    boolean bl = crossing = min < 0.0f && max > 0.0f && max - min < 180.0f;
                    if (crossing) {
                        double yi;
                        double m = (sy - ey) / (sx - ex);
                        double d = yi = sy == ey ? (double)sy : (double)ey + (double)(0.0f - ex) * m;
                        if (sx < 0.0f) {
                            newShp.lineTo(360.0f, (float)yi);
                            newShp.moveTo(0.0f, (float)yi);
                        } else {
                            newShp.lineTo(0.0f, (float)yi);
                            newShp.moveTo(360.0f, (float)yi);
                        }
                    }
                    if (ex < 0.0f) {
                        newShp.lineTo(ex + 360.0f, ey);
                    } else {
                        newShp.lineTo(ex, ey);
                    }
                    sx = ex;
                    sy = ey;
                    break;
                }
                default: {
                    log.severe("splitLinestringAt0: invalid segment type.");
                }
            }
            pi.next();
        }
        return newShp;
    }

    public static Shape positiveTransform(Shape in) {
        PathIterator pi = in.getPathIterator(null);
        if (pi.isDone()) {
            return in;
        }
        float x = 0.0f;
        float y = 0.0f;
        float[] seg = new float[6];
        GeneralPath newShp = new GeneralPath(pi.getWindingRule());
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    x = seg[0];
                    y = seg[1];
                    if (x < 0.0f) {
                        x += 360.0f;
                    }
                    newShp.moveTo(x, y);
                    break;
                }
                case 1: {
                    x = seg[0];
                    y = seg[1];
                    if (x < 0.0f) {
                        x += 360.0f;
                    }
                    newShp.lineTo(x, y);
                    break;
                }
                case 4: {
                    newShp.closePath();
                    break;
                }
                default: {
                    log.severe("positiveTransform: invalid segment type.");
                }
            }
            pi.next();
        }
        return newShp;
    }

    public static GeneralPath ceilingTo0(PathIterator pi) {
        GeneralPath newShp = new GeneralPath(pi.getWindingRule());
        if (pi.isDone()) {
            return newShp;
        }
        float x = 0.0f;
        float y = 0.0f;
        float[] seg = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    x = seg[0];
                    y = seg[1];
                    if (x < 0.0f) {
                        x = 0.0f;
                    }
                    newShp.moveTo(x, y);
                    break;
                }
                case 1: {
                    x = seg[0];
                    y = seg[1];
                    if (x < 0.0f) {
                        x = 0.0f;
                    }
                    newShp.lineTo(x, y);
                    break;
                }
                case 4: {
                    newShp.closePath();
                    break;
                }
                default: {
                    log.severe("ceilingTo0: invalid segment type.");
                }
            }
            pi.next();
        }
        return newShp;
    }

    public static Shape proj(Shape in, Proj proj) {
        PathIterator pi = in.getPathIterator(null);
        if (pi.isDone()) {
            return in;
        }
        GeneralPath newShp = new GeneralPath(pi.getWindingRule());
        if (pi.isDone()) {
            return newShp;
        }
        float x = 0.0f;
        float y = 0.0f;
        float[] seg = new float[6];
        Proj.P2 pres = new Proj.P2();
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    x = seg[0];
                    y = seg[1];
                    proj.forward(x, y, pres);
                    newShp.moveTo((float)pres.x, (float)pres.y);
                    break;
                }
                case 1: {
                    x = seg[0];
                    y = seg[1];
                    proj.forward(x, y, pres);
                    newShp.lineTo((float)pres.x, (float)pres.y);
                    break;
                }
                case 4: {
                    newShp.closePath();
                    break;
                }
                default: {
                    log.severe("Proj: invalid segment type.");
                }
            }
            pi.next();
        }
        return newShp;
    }

    public static final boolean intersectsShapeSegments(Rectangle2D rect, Shape shp, Rectangle2D shpMBR) {
        if (rect == null || shp == null) {
            return false;
        }
        if (shpMBR == null) {
            shpMBR = shp.getBounds2D();
        }
        if (rect.contains(shpMBR.getMinX(), shpMBR.getMinY()) && rect.contains(shpMBR.getMaxX(), shpMBR.getMaxY())) {
            return true;
        }
        if (!rect.intersects(shpMBR) && !rect.intersectsLine(shpMBR.getMinX(), shpMBR.getMinY(), shpMBR.getMaxX(), shpMBR.getMaxY())) {
            return false;
        }
        PathIterator pi = shp.getPathIterator(null);
        if (pi.isDone()) {
            return false;
        }
        float[] seg = new float[6];
        float sx = 0.0f;
        float sy = 0.0f;
        float ex = 0.0f;
        float ey = 0.0f;
        float mx = 0.0f;
        float my = 0.0f;
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    sx = seg[0];
                    sy = seg[1];
                    mx = sx;
                    my = sy;
                    break;
                }
                case 1: {
                    ex = seg[0];
                    ey = seg[1];
                    if (rect.intersectsLine(sx, sy, ex, ey)) {
                        return true;
                    }
                    sx = ex;
                    sy = ey;
                    break;
                }
                case 4: {
                    sx = ex;
                    sy = ey;
                    ex = mx;
                    ey = my;
                    if (!rect.intersectsLine(sx, sy, ex, ey)) break;
                    return true;
                }
                default: {
                    log.finest("intersectsShapeSegments: invalid segment type.");
                    return true;
                }
            }
            pi.next();
        }
        return false;
    }

    public static final boolean intersects(Shape shp1, Shape shp2) {
        float[] seg1 = new float[6];
        float[] seg2 = new float[6];
        PathIterator pi1 = shp1.getPathIterator(null);
        float sx1 = 0.0f;
        float sy1 = 0.0f;
        float sx2 = 0.0f;
        float sy2 = 0.0f;
        float ex1 = 0.0f;
        float ey1 = 0.0f;
        float ex2 = 0.0f;
        float ey2 = 0.0f;
        while (!pi1.isDone()) {
            switch (pi1.currentSegment(seg1)) {
                case 0: {
                    sx1 = seg1[0];
                    sy1 = seg1[1];
                    break;
                }
                case 1: {
                    ex1 = seg1[0];
                    ey1 = seg1[1];
                    PathIterator pi2 = shp2.getPathIterator(null);
                    while (!pi2.isDone()) {
                        switch (pi2.currentSegment(seg2)) {
                            case 0: {
                                sx2 = seg2[0];
                                sy2 = seg2[1];
                                break;
                            }
                            case 1: {
                                ex2 = seg2[0];
                                ey2 = seg2[1];
                                if (ShapeUtil.linesIntersect(sx1, sy1, ex1, ey1, sx2, sy2, ex2, ey2)) {
                                    return true;
                                }
                                sx2 = ex2;
                                sy2 = ey2;
                                break;
                            }
                        }
                        pi2.next();
                    }
                    sx1 = ex1;
                    sy1 = ey1;
                    break;
                }
            }
            pi1.next();
        }
        return false;
    }

    public static ArrayList getIntersectionPoints(double minX, double minY, double maxX, double maxY, double llx, double lly, double lx, double ly) {
        return ShapeUtil.getIntersectionPoints(minX, minY, maxX, maxY, llx, lly, lx, ly, true);
    }

    public static ArrayList getIntersectionPoints(double minX, double minY, double maxX, double maxY, double llx, double lly, double lx, double ly, boolean forLineString) {
        if (llx == lx && lly == ly) {
            return null;
        }
        if (llx >= minX && llx <= maxX && lly >= minY && lly <= maxY && lx >= minX && lx <= maxX && ly >= minY && ly <= maxY) {
            return null;
        }
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(2);
        if (llx == lx) {
            if (lx < minX || lx > maxX || ly > maxY && lly > maxY || ly < minY && lly < minY) {
                return null;
            }
            if (ly > maxY) {
                if (lly < minY) {
                    points.add(new Point2D.Double(lx, minY));
                    points.add(new Point2D.Double(lx, maxY));
                } else {
                    points.add(new Point2D.Double(lx, maxY));
                }
            } else if (ly < minY) {
                if (lly > maxY) {
                    points.add(new Point2D.Double(lx, maxY));
                    points.add(new Point2D.Double(lx, minY));
                } else {
                    points.add(new Point2D.Double(lx, minY));
                }
            } else if (lly < minY) {
                points.add(new Point2D.Double(lx, minY));
            } else if (lly > maxY) {
                points.add(new Point2D.Double(lx, maxY));
            }
        } else if (lly == ly) {
            if (ly < minY || ly > maxY || lx > maxX && llx > maxX || lx < minX && llx < minX) {
                return null;
            }
            if (lx > maxX) {
                if (llx < minX) {
                    points.add(new Point2D.Double(minX, ly));
                    points.add(new Point2D.Double(maxX, ly));
                } else {
                    points.add(new Point2D.Double(maxX, ly));
                }
            } else if (lx < minX) {
                if (llx > maxX) {
                    points.add(new Point2D.Double(maxX, ly));
                    points.add(new Point2D.Double(minX, ly));
                } else {
                    points.add(new Point2D.Double(minX, ly));
                }
            } else if (llx < minX) {
                points.add(new Point2D.Double(minX, ly));
            } else if (llx > maxX) {
                points.add(new Point2D.Double(maxX, ly));
            }
        } else {
            double tmpY2;
            double k = (lly - ly) * 1.0 / (llx - lx);
            double b = (ly * llx - lly * lx) * 1.0 / (llx - lx);
            double tmpY1 = k * maxX + b;
            Point2D.Double point1 = null;
            Point2D.Double point2 = null;
            Point2D.Double point = null;
            if (tmpY1 <= maxY && tmpY1 >= minY && (tmpY1 >= lly && tmpY1 <= ly || tmpY1 <= lly && tmpY1 >= ly)) {
                point = new Point2D.Double(maxX, tmpY1);
                if (llx > maxX) {
                    point1 = point;
                } else {
                    point2 = point;
                }
            }
            if ((tmpY2 = k * minX + b) <= maxY && tmpY2 >= minY && (tmpY2 >= lly && tmpY2 <= ly || tmpY2 <= lly && tmpY2 >= ly)) {
                point = new Point2D.Double(minX, tmpY2);
                if (llx < minX) {
                    point1 = point;
                } else {
                    point2 = point;
                }
            }
            if (point1 == null || point2 == null) {
                double tmpX2;
                double tmpX1 = (maxY - b) / k;
                if (tmpX1 <= maxX && tmpX1 >= minX && (tmpX1 >= llx && tmpX1 <= lx || tmpX1 <= llx && tmpX1 >= lx)) {
                    if (lly > maxY) {
                        if (point1 == null) {
                            point1 = new Point2D.Double(tmpX1, maxY);
                        }
                    } else if (point2 == null) {
                        point2 = new Point2D.Double(tmpX1, maxY);
                    }
                }
                if ((tmpX2 = (minY - b) / k) <= maxX && tmpX2 >= minX && (tmpX2 >= llx && tmpX2 <= lx || tmpX2 <= llx && tmpX2 >= lx)) {
                    if (lly < minY) {
                        if (point1 == null) {
                            point1 = new Point2D.Double(tmpX2, minY);
                        }
                    } else if (point2 == null) {
                        point2 = new Point2D.Double(tmpX2, minY);
                    }
                }
            }
            if (point1 != null) {
                points.add(point1);
            }
            if (point2 != null) {
                points.add(point2);
            }
            if (points.size() == 0 && !forLineString) {
                if (llx > maxX && lx > maxX || llx < minX && lx < minX || lly > maxY && ly > maxY || lly < minY && ly < minY) {
                    return points;
                }
                if (tmpY1 < minY && tmpY2 < minY) {
                    if (llx < minX && lly > minY || lx < minX && ly > minY) {
                        points.add(new Point2D.Double(0.0, 0.0));
                    } else if (llx > maxX && lly > minY || lx > maxX && ly > minY) {
                        points.add(new Point2D.Double(maxX, 0.0));
                    }
                } else if (tmpY1 > maxY && tmpY2 > maxY) {
                    if (llx < minX && lly < maxY || lx < minX && ly < maxY) {
                        points.add(new Point2D.Double(0.0, maxY));
                    } else if (llx > maxX && lly < maxY || lx > maxX && ly < maxY) {
                        points.add(new Point2D.Double(maxX, maxY));
                    }
                }
            }
        }
        return points;
    }

    private static boolean linesIntersect(float sx1, float sy1, float ex1, float ey1, float sx2, float sy2, float ex2, float ey2) {
        float r1 = (sy1 - sy2) * (ex2 - sx2) - (sx1 - sx2) * (ey2 - sy2);
        float denom = (ex1 - sx1) * (ey2 - sy2) - (ey1 - sy1) * (ex2 - sx2);
        if (denom == 0.0f) {
            return false;
        }
        float r = r1 / denom;
        float s1 = (sy1 - sy2) * (ex1 - sx1) - (sx1 - sx2) * (ey1 - sy1);
        float s = s1 / denom;
        return r >= 0.0f && r <= 1.0f && s >= 0.0f && s <= 1.0f;
    }

    public static void extractLinesAndRings(Shape shp, GeneralPath gpLines, GeneralPath gpRings) {
        int nClose;
        if (shp == null || gpLines == null || gpRings == null) {
            return;
        }
        gpLines.reset();
        gpRings.reset();
        PathIterator pi = shp.getPathIterator(null);
        Path2D gp = null;
        float[] seg = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    if (gp != null) {
                        nClose = ShapeUtil.numCloseSegments(gp);
                        if (nClose == 0) {
                            gpLines.append(gp, false);
                        } else {
                            ShapeUtil.addToShape(gpRings, gp);
                        }
                    }
                    gp = new GeneralPath();
                    ((Path2D.Float)gp).moveTo(seg[0], seg[1]);
                    break;
                }
                case 1: {
                    ((Path2D.Float)gp).lineTo(seg[0], seg[1]);
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
                case 3: {
                    ((Path2D.Float)gp).curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                    break;
                }
                case 2: {
                    ((Path2D.Float)gp).quadTo(seg[0], seg[1], seg[2], seg[3]);
                }
            }
            pi.next();
        }
        if (gp != null) {
            nClose = ShapeUtil.numCloseSegments(gp);
            if (nClose == 0) {
                gpLines.append(gp, false);
            } else {
                ShapeUtil.addToShape(gpRings, gp);
            }
        }
    }

    public static void addToShape(GeneralPath source, Shape toadd) {
        if (source == null || toadd == null) {
            return;
        }
        PathIterator pi = toadd.getPathIterator(null);
        float[] seg = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    source.moveTo(seg[0], seg[1]);
                    break;
                }
                case 1: {
                    source.lineTo(seg[0], seg[1]);
                    break;
                }
                case 4: {
                    source.closePath();
                    break;
                }
                case 3: {
                    source.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                    break;
                }
                case 2: {
                    source.quadTo(seg[0], seg[1], seg[2], seg[3]);
                }
            }
            pi.next();
        }
    }

    static Rectangle2D curveMBR(float[] seg, int numCtlPoints) {
        float xMin = Float.POSITIVE_INFINITY;
        float yMin = Float.POSITIVE_INFINITY;
        float xMax = Float.NEGATIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < numCtlPoints; ++i) {
            float x = seg[i * 2];
            float y = seg[i * 2 + 1];
            if (xMin > x) {
                xMin = x;
            }
            if (yMin > y) {
                yMin = y;
            }
            if (xMax < x) {
                xMax = x;
            }
            if (!(yMax < y)) continue;
            yMax = y;
        }
        return new Rectangle2D.Float(xMin, yMin, xMax - xMin, yMax - yMin);
    }
}

