/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtil {
    private static Map keyStores = new HashMap();

    public static void addKeyStore(String serverHostName, String file, String password) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fis = new FileInputStream(new File(file));
        ks.load(fis, password.toCharArray());
        fis.close();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, tmf.getTrustManagers(), null);
        SSLSocketFactory sslFactory = ctx.getSocketFactory();
        KeyStoreEntry ent = new KeyStoreEntry();
        ent.keyStore = ks;
        ent.socketFactory = sslFactory;
        ent.password = password;
        keyStores.put(serverHostName.toUpperCase(), ent);
    }

    public static KeyStore getKeyStore(String serverName) {
        KeyStoreEntry ent = (KeyStoreEntry)keyStores.get(serverName.toUpperCase());
        return ent == null ? null : ent.keyStore;
    }

    public static void removeKeyStore(String serverHostName) {
        if (serverHostName == null) {
            return;
        }
        keyStores.remove(serverHostName.toUpperCase());
    }

    public static SSLSocketFactory getSSLSocketFactory(String serverHostName) {
        String serverHostNameU = serverHostName.toUpperCase();
        KeyStoreEntry ent = (KeyStoreEntry)keyStores.get(serverHostNameU);
        if (ent == null) {
            for (String registeredHostName : keyStores.keySet()) {
                if (!serverHostNameU.endsWith(registeredHostName)) continue;
                ent = (KeyStoreEntry)keyStores.get(registeredHostName);
                break;
            }
        }
        return ent == null ? null : ent.socketFactory;
    }

    public static void destory() {
        for (KeyStoreEntry keyStoreEntry : keyStores.entrySet()) {
            keyStoreEntry.destory();
        }
        keyStores.clear();
    }

    public static final class KeyStoreEntry {
        public KeyStore keyStore;
        public SSLSocketFactory socketFactory;
        public String password;

        public void destory() {
            this.socketFactory = null;
            this.keyStore = null;
        }
    }
}

