/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class TopologyThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent topologySensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "Topology", "Producer", "Time spent preparing data");
    private static final int YIELD_COUNT = 20;
    protected Theme owner;
    protected TopologyThemeDefinition def;
    LocalThemeDataProducer features;
    int visSRID = 0;
    String dbVersion = null;
    double viewResX = Double.MIN_VALUE;
    double viewResY = Double.MIN_VALUE;
    double swxl = Double.MIN_VALUE;
    double swxh = Double.MAX_VALUE;
    double swyl = Double.MIN_VALUE;
    double swyh = Double.MAX_VALUE;
    boolean applyRotation = false;
    double mapRotation = 0.0;
    double tolerance = 1.0E-14;
    private long maxFeaturesToBePrepared = -1L;

    public TopologyThemeProducer(Theme t) {
        this.owner = t;
        this.def = (TopologyThemeDefinition)t.getDefinition();
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void abort() {
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenT = 0L;
        try {
            tokenT = topologySensor.start();
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            }
            catch (Exception e) {
                throw new DataException("Cannot obtain a connection to database.", e);
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                            Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                            Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                        } else {
                            Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                        }
                    }
                }
                catch (Exception e) {
                    String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                        err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                    } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                        err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                    }
                    log.log(Level.SEVERE, err, e);
                    throw new DataException(err);
                }
            }
            this.visSRID = vc.getMasterSRID();
            int cnt = 0;
            ArrayList featureSet = new ArrayList(128);
            ArrayList markerSet = new ArrayList(128);
            SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
            SRS srs = sc.get(this.def.getSrid());
            boolean isGeodetic = false;
            String unit = null;
            if (srs != null) {
                isGeodetic = srs.isGeodetic();
                unit = srs.getUnit();
            } else if (this.def.getSrid() > 0) {
                log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
            }
            double xl = queryWin.getMinX();
            double yl = queryWin.getMinY();
            double xh = queryWin.getMaxX();
            double yh = queryWin.getMaxY();
            boolean transformSRid = false;
            double xi = xl;
            double xf = xh;
            double yi = yl;
            double yf = yh;
            double masterScale = vc.getCurrentScale();
            this.getTheme().setShowLabels(true);
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                if (this.def.isPredefined()) {
                    this.def.createCacheGeomGroup(vc.getMasterSRID());
                    this.def.createCacheEdgeGroup(vc.getMasterSRID());
                    this.def.createCacheNodeGroup(vc.getMasterSRID());
                }
                if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                    double[] inmbr = new double[]{xl, yl, xh, yh};
                    double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), this.def.getSrid(), conn);
                    if (outmbr == null) {
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                        int e = 0;
                        return e;
                    }
                    xl = outmbr[0];
                    yl = outmbr[1];
                    xh = outmbr[2];
                    yh = outmbr[3];
                    transformSRid = true;
                } else {
                    transformSRid = true;
                }
            }
            if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
                log.finer("[Master scale] " + masterScale + " [Scale factor for theme " + this.getTheme().getName() + "] " + factor);
                double scale = masterScale * factor;
                if (this.getTheme().getScaleType() == "RATIO") {
                    double centery;
                    double centerx;
                    if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                        srs = sc.get(vc.getMasterSRID());
                        centerx = (xi + xf) / 2.0;
                        centery = (yi + yf) / 2.0;
                        factor = 1.0;
                    } else {
                        centerx = (xl + xh) / 2.0;
                        centery = (yl + yh) / 2.0;
                    }
                    if (vc.isTileRequest() && srs.isGeodetic()) {
                        centerx = 0.0;
                        centery = 0.0;
                    }
                    if (srs != null) {
                        scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                        log.finer("Ratio scale to compare: " + scale);
                    } else {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                        int n = 0;
                        return n;
                    }
                }
                if (!this.getTheme().withinRenderScaleLimits(scale)) {
                    log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                    int e = 0;
                    return e;
                }
                if (!this.getTheme().withinLabelScaleLimits(scale)) {
                    log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                    this.getTheme().setShowLabels(false);
                }
            }
            boolean workaround = false;
            boolean bl = workaround = isGeodetic && xh - xl >= 2.0 && xh - xl < 120.0;
            if (workaround) {
                xl = Math.floor(xl);
                log.finest("ptvpxfmfxed: xl=" + xl);
            }
            log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
            this.swxl = xl;
            this.swxh = xh;
            this.swyl = yl;
            this.swyh = yh;
            this.applyRotation = false;
            this.mapRotation = 0.0;
            if (MapMaker.isSpecial(xl, yl, xh, yh) && vc.getRotation() != 0.0) {
                log.warning("Rotation is currently ignored for full extent.");
            } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(xl, yl, xh, yh)) {
                if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                    log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                } else {
                    double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                    if (rmbr != null) {
                        xl = Math.min(rmbr[0], xl);
                        yl = Math.min(rmbr[1], yl);
                        xh = Math.max(rmbr[2], xh);
                        yh = Math.max(rmbr[3], yh);
                        log.finest("Rotation angle: " + vc.getRotation());
                        log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                        this.applyRotation = true;
                        this.mapRotation = vc.getRotation();
                        this.swxl = xl;
                        this.swxh = xh;
                        this.swyl = yl;
                        this.swyh = yh;
                    } else {
                        log.info("Rotated MBR is null. Rotation ignored.");
                    }
                }
            }
            if (transformSRid) {
                this.swxl = xi;
                this.swxh = xf;
                this.swyl = yi;
                this.swyh = yf;
            }
            Proj proj = vc.getProjection();
            this.viewResX = vc.getDeviceWindow().getWidth();
            this.viewResY = vc.getDeviceWindow().getHeight();
            this.dbVersion = Util.getDBVersion(conn);
            log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
            long t1 = 0L;
            long t2 = 0L;
            if (this.def.getQuery() != null) {
                try {
                    t1 = System.currentTimeMillis();
                    cnt = !this.def.isPredefined() ? this.processJDBCQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc) : this.processPredefinedQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
                    t2 = System.currentTimeMillis();
                    log.info("Processing time [" + this.def.name + "]: " + (t2 - t1) + " ms" + " for " + featureSet.size() + " features");
                }
                catch (Exception e) {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    throw new DataException(e);
                }
            }
            if (this.def.getDebugTheme()) {
                t1 = System.currentTimeMillis();
                try {
                    if (this.def.getFaceStyle() != null) {
                        cnt = this.processFaceQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
                    }
                    if (this.def.getEdgeStyle() != null && (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared)) {
                        cnt = this.processEdgeQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
                    }
                    if (this.def.getNodeStyle() != null && (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared)) {
                        cnt = this.processNodeQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
                    }
                    t2 = System.currentTimeMillis();
                    log.info("Processing time (querying and loading) [" + this.def.name + "]: " + (t2 - t1) + " ms" + " for " + featureSet.size() + " features");
                }
                catch (Exception e) {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    throw new DataException(e);
                }
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            try {
                if (conn != null) {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            if (featureSet.size() <= 0) {
                int n = 0;
                return n;
            }
            this.setStyledFeatures(featureSet);
            featureSet = null;
            int n = this.features.size();
            return n;
        }
        finally {
            topologySensor.stop(tokenT);
        }
    }

    private String rewriteTopologyEdgeQuery(Connection conn, boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String mQuery = this.def.getQuery();
        if (mQuery == null) {
            return null;
        }
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            featureTable = this.def.getTopoView();
            topoColumn = this.def.getTopoViewColumn();
        }
        String edgeKeyColumn = "";
        if (this.def.isPredefined()) {
            edgeKeyColumn = tbSchema + topologyName + "_edge$." + this.def.getKeyColumn() + " mv_key, ";
        }
        String geomAttr = "geometry";
        if (transformSRID) {
            geomAttr = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String finalQuery = "select * from (select " + edgeKeyColumn + geomAttr + ", mv_result.* from " + tbSchema + topologyName + "_edge$ inner join (";
        String querystr = null;
        querystr = "(" + mQuery + ") tpf_feat";
        finalQuery = finalQuery + "select edge_id, start_node_id, end_node_id, tpf_feat." + topoColumn + ".tg_id mv_tgid, " + tbSchema + topologyName + "_edge$.rowid edge_rowid, tpf_feat.* from " + querystr + " inner join " + tbSchema + topologyName + "_relation$ tpf_rel on " + "(tpf_feat." + topoColumn + ".tg_layer_id = " + "tpf_rel.tg_layer_id and " + "tpf_feat." + topoColumn + ".tg_id = " + "tpf_rel.tg_id and " + "tpf_feat." + topoColumn + ".tg_layer_id = " + this.def.getTopoLayerID() + ") inner join " + tbSchema + topologyName + "_edge$ on abs(topo_id) = edge_id " + " and topo_type = 2 order by tpf_feat." + topoColumn + ".tg_id) mv_result on " + tbSchema + topologyName + "_edge$.rowid = mv_result.edge_rowid";
        String filter = null;
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter("geometry", this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        finalQuery = filter != null ? finalQuery + " and " + filter + ") order by mv_tgid" : finalQuery + ") order by mv_tgid";
        return finalQuery;
    }

    private String rewriteTopologyEdgeQueryV2(Connection conn, boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic, String indexTable) {
        String mQuery = this.def.getQuery();
        if (mQuery == null) {
            return null;
        }
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        String topoName = tbSchema + topologyName;
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            featureTable = this.def.getTopoView();
            topoColumn = this.def.getTopoViewColumn();
        }
        String edgeKeyColumn = "";
        if (this.def.isPredefined()) {
            edgeKeyColumn = tbSchema + topologyName + "_edge$." + this.def.getKeyColumn() + " mv_key,\n";
        }
        String geomAttr = "geometry";
        if (transformSRID) {
            geomAttr = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String filter = null;
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter("geometry", this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        String relation_exp = "            " + topoName + "_relation$ tpf_rel,\n";
        String nltpfrel = "                 use_nl (tpf_rel,topo_idx)\n";
        String tpftgid = "tpf_rel.tg_id\n";
        String andtpfhier = "";
        String indexStr = "index(tpf_rel " + topoName + "_rel_idx$)";
        int layerId = this.def.getTopoLayerID();
        if (this.def.getTopoLayerLevel() > 0) {
            int i;
            int[] hierLayers = this.def.getLayersHierarchy();
            layerId = hierLayers[0];
            nltpfrel = "                 use_nl (tpf_rel,tpf_rel1)\n";
            for (i = 1; i < this.def.getTopoLayerLevel(); ++i) {
                nltpfrel = nltpfrel + "                 use_nl (tpf_rel" + i + ",tpf_rel" + (i + 1) + ")\n";
            }
            nltpfrel = nltpfrel + "                 use_nl (tpf_rel" + this.def.getTopoLayerLevel() + ",topo_idx)\n";
            andtpfhier = "             and tpf_rel1.topo_id = tpf_rel.tg_layer_id\n             and tpf_rel1.topo_type = tpf_rel.tg_id\n             and tpf_rel1.tg_layer_id = " + hierLayers[1] + "\n";
            for (i = 2; i <= this.def.getTopoLayerLevel(); ++i) {
                andtpfhier = andtpfhier + "             and tpf_rel" + i + ".topo_id = tpf_rel" + (i - 1) + ".tg_layer_id\n" + "             and tpf_rel" + i + ".topo_type = tpf_rel" + (i - 1) + ".tg_id\n" + "             and tpf_rel" + i + ".tg_layer_id = " + hierLayers[i] + "\n";
            }
            for (i = 1; i <= this.def.getTopoLayerLevel(); ++i) {
                relation_exp = relation_exp + "            " + topoName + "_relation$ tpf_rel" + i + ",\n";
                indexStr = indexStr + " index(tpf_rel" + i + " " + topoName + "_rel_idx$)";
            }
            indexStr = indexStr + "\n";
            tpftgid = "tpf_rel" + this.def.getTopoLayerLevel() + ".tg_id\n";
        } else {
            indexStr = indexStr + "\n";
        }
        String finalQuery = "select /*+ ordered use_nl (tpf_feat, other_query) */\n        other_query.*,tpf_feat." + topoColumn + ".tg_id,tpf_feat.*\n" + "from (\n" + "      select /*+ ordered " + indexStr + "              use_nl (" + topoName + "_edge$,tpf_rel)\n" + nltpfrel + " */\n" + "        " + edgeKeyColumn + "        " + geomAttr + ",\n" + "         edge_id,\n" + "         start_node_id,\n" + "         end_node_id,\n" + "         topo_idx.sdo_rowid\n" + "       from " + topoName + "_edge$,\n" + relation_exp + "            " + indexTable + " topo_idx\n" + "       where\n" + "             topo_idx.sdo_tg_id = " + tpftgid + "             and tpf_rel.topo_type = 2\n" + "             and tpf_rel.topo_id = edge_id\n" + "             and tpf_rel.tg_layer_id = " + layerId + "\n" + andtpfhier;
        if (filter != null) {
            finalQuery = finalQuery + "             and " + filter + "\n";
        }
        finalQuery = finalQuery + "       ) other_query,\n       (" + mQuery + ") tpf_feat\n" + "where other_query.sdo_rowid = tpf_feat.rowid\n" + "      order by tpf_feat." + topoColumn + ".tg_id";
        return finalQuery;
    }

    private String rewriteTopologyPointQuery(Connection conn, boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String mQuery = this.def.getQuery();
        if (mQuery == null) {
            return null;
        }
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            featureTable = this.def.getTopoView();
            topoColumn = this.def.getTopoViewColumn();
        }
        String nodeKeyColumn = "";
        if (this.def.isPredefined()) {
            nodeKeyColumn = tbSchema + topologyName + "_node$." + this.def.getKeyColumn() + " mv_key, ";
        }
        String geomAttr = "geometry";
        if (transformSRID) {
            geomAttr = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String finalQuery = "select * from (select " + nodeKeyColumn + geomAttr + ", mv_result.* from " + tbSchema + topologyName + "_node$ inner join (";
        String querystr = null;
        querystr = "(" + mQuery + ") tpf_feat";
        finalQuery = finalQuery + "select node_id, 0 mv_void1, 0 mv_void2, tpf_feat." + topoColumn + ".tg_id mv_tgid, " + tbSchema + topologyName + "_node$.rowid node_rowid, tpf_feat.* from " + querystr + " inner join " + tbSchema + topologyName + "_relation$ tpf_rel on " + "(tpf_feat." + topoColumn + ".tg_layer_id = " + "tpf_rel.tg_layer_id and " + "tpf_feat." + topoColumn + ".tg_id = " + "tpf_rel.tg_id and " + "tpf_feat." + topoColumn + ".tg_layer_id = " + this.def.getTopoLayerID() + ") inner join " + tbSchema + topologyName + "_node$ on topo_id = node_id " + " and topo_type = 1 order by tpf_feat." + topoColumn + ".tg_id) mv_result on " + tbSchema + topologyName + "_node$.rowid = mv_result.node_rowid";
        String filter = null;
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter("geometry", this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        finalQuery = filter != null ? finalQuery + " and " + filter + ") order by mv_tgid" : finalQuery + ") order by mv_tgid";
        return finalQuery;
    }

    private String rewriteTopologyPointQueryV2(Connection conn, boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic, String indexTable) {
        String mQuery = this.def.getQuery();
        if (mQuery == null) {
            return null;
        }
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        String topoName = tbSchema + topologyName;
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            featureTable = this.def.getTopoView();
            topoColumn = this.def.getTopoViewColumn();
        }
        String nodeKeyColumn = "";
        if (this.def.isPredefined()) {
            nodeKeyColumn = tbSchema + topologyName + "_node$." + this.def.getKeyColumn() + " mv_key,\n";
        }
        String geomAttr = "geometry";
        if (transformSRID) {
            geomAttr = "sdo_cs.transform(geometry," + this.visSRID + ") geometry";
        }
        String filter = null;
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter("geometry", this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        String relation_exp = "            " + topoName + "_relation$ tpf_rel,\n";
        String nltpfrel = "                 use_nl (tpf_rel,topo_idx)\n";
        String tpftgid = "tpf_rel.tg_id\n";
        String andtpfhier = "";
        String indexStr = "index(tpf_rel " + topoName + "_rel_idx$)";
        int layerId = this.def.getTopoLayerID();
        if (this.def.getTopoLayerLevel() > 0) {
            int i;
            int[] hierLayers = this.def.getLayersHierarchy();
            layerId = hierLayers[0];
            nltpfrel = "                 use_nl (tpf_rel,tpf_rel1)\n";
            for (i = 1; i < this.def.getTopoLayerLevel(); ++i) {
                nltpfrel = nltpfrel + "                 use_nl (tpf_rel" + i + ",tpf_rel" + (i + 1) + ")\n";
            }
            nltpfrel = nltpfrel + "                 use_nl (tpf_rel" + this.def.getTopoLayerLevel() + ",topo_idx)\n";
            andtpfhier = "             and tpf_rel1.topo_id = tpf_rel.tg_layer_id\n             and tpf_rel1.topo_type = tpf_rel.tg_id\n             and tpf_rel1.tg_layer_id = " + hierLayers[1] + "\n";
            for (i = 2; i <= this.def.getTopoLayerLevel(); ++i) {
                andtpfhier = andtpfhier + "             and tpf_rel" + i + ".topo_id = tpf_rel" + (i - 1) + ".tg_layer_id\n" + "             and tpf_rel" + i + ".topo_type = tpf_rel" + (i - 1) + ".tg_id\n" + "             and tpf_rel" + i + ".tg_layer_id = " + hierLayers[i] + "\n";
            }
            for (i = 1; i <= this.def.getTopoLayerLevel(); ++i) {
                relation_exp = relation_exp + "            " + topoName + "_relation$ tpf_rel" + i + ",\n";
                indexStr = indexStr + " index(tpf_rel" + i + " " + topoName + "_rel_idx$)";
            }
            indexStr = indexStr + "\n";
            tpftgid = "tpf_rel" + this.def.getTopoLayerLevel() + ".tg_id\n";
        } else {
            indexStr = indexStr + "\n";
        }
        String finalQuery = "select /*+ ordered use_nl (tpf_feat, other_query) */\n        other_query.*,tpf_feat." + topoColumn + ".tg_id,tpf_feat.*\n" + "from (\n" + "      select /*+ ordered " + indexStr + "              use_nl (" + topoName + "_node$,tpf_rel)\n" + nltpfrel + " */\n" + "        " + nodeKeyColumn + "        " + geomAttr + ",\n" + "         node_id,\n" + "         0 mv_void1,\n" + "         0 mv_void2,\n" + "         topo_idx.sdo_rowid\n" + "       from " + topoName + "_node$,\n" + relation_exp + "            " + indexTable + " topo_idx\n" + "       where\n" + "             topo_idx.sdo_tg_id = " + tpftgid + "             and tpf_rel.topo_type = 1\n" + "             and tpf_rel.topo_id = node_id\n" + "             and tpf_rel.tg_layer_id = " + layerId + "\n" + andtpfhier;
        if (filter != null) {
            finalQuery = finalQuery + "             and " + filter + "\n";
        }
        finalQuery = finalQuery + "       ) other_query,\n       (" + mQuery + ") tpf_feat\n" + "where other_query.sdo_rowid = tpf_feat.rowid\n" + "      order by tpf_feat." + topoColumn + ".tg_id";
        return finalQuery;
    }

    private String rewriteTopologyFaceQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String mQuery = this.def.getQuery();
        if (mQuery == null) {
            return null;
        }
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String faceColumn = "mbr_geometry";
        String edgeSpatialColumn = "geometry";
        String filter = null;
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            featureTable = this.def.getTopoView();
            topoColumn = this.def.getTopoViewColumn();
        }
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter(faceColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        String keyColumn = "";
        if (this.def.isPredefined()) {
            keyColumn = tbSchema + topologyName + "_edge$." + this.def.getKeyColumn() + " mv_rowid,";
        }
        String geocolumn = edgeSpatialColumn;
        if (transformSRID) {
            geocolumn = "sdo_cs.transform(" + edgeSpatialColumn + "," + this.visSRID + ") " + edgeSpatialColumn;
        }
        String finalQuery = "select * from (select " + keyColumn + geocolumn + ",final_result.* from " + tbSchema + topologyName + "_edge$ inner join (" + "select  mv_result.* from " + tbSchema + topologyName + "_face$ inner join (" + "select mv_face_geom.*,mv_face_feat.* from (";
        String edge_rowid = tbSchema + topologyName + "_edge$.rowid edge_rowid, ";
        String face_rowid = tbSchema + topologyName + "_face$.rowid face_rowid, ";
        String leftfaceQuery = "select edge_id, start_node_id, end_node_id, next_left_edge_id nextedge, prev_left_edge_id prevedge, left_face_id left_face, right_face_id right_face, " + edge_rowid + face_rowid + "face_id from " + tbSchema + topologyName + "_edge$ " + "inner join " + tbSchema + topologyName + "_face$ on " + "left_face_id = face_id where (abs(next_left_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        String rightfaceQuery = "select edge_id, start_node_id,end_node_id, next_right_edge_id nextedge, prev_right_edge_id prevedge, left_face_id left_face, right_face_id right_face, " + edge_rowid + face_rowid + "face_id from " + tbSchema + topologyName + "_edge$ " + "inner join " + tbSchema + topologyName + "_face$ on " + "right_face_id = face_id where (abs(next_right_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        finalQuery = finalQuery + leftfaceQuery + " union all " + rightfaceQuery + ") mv_face_geom inner join (";
        String relation_exp = this.getRelationExpression();
        String topo_faces = "select tpf_feat." + topoColumn + ".tg_id tg_id, " + "topo_id, tpf_feat.* from " + "(" + mQuery + ") tpf_feat inner join " + relation_exp + " tpf_rel on (" + "tpf_feat." + topoColumn + ".tg_layer_id = " + "tpf_rel.tg_layer_id and " + "tpf_feat." + topoColumn + ".tg_id = " + "tpf_rel.tg_id and tpf_rel.topo_type = 3) inner join " + tbSchema + topologyName + "_face$ on topo_id = face_id";
        finalQuery = finalQuery + topo_faces + ") mv_face_feat on " + "mv_face_geom.face_id = mv_face_feat.topo_id " + "order by mv_face_feat." + topoColumn + ".tg_id,face_id" + " ) mv_result on " + tbSchema + topologyName + "_face$.rowid = " + "mv_result.face_rowid";
        if (filter != null) {
            finalQuery = finalQuery + " and " + filter;
        }
        finalQuery = finalQuery + " order by mv_result.tg_id,mv_result.face_id ) final_result on " + tbSchema + topologyName + "_edge$.rowid = " + "final_result.edge_rowid ) " + "order by tg_id,face_id";
        return finalQuery;
    }

    private String rewriteTopologyFaceQueryV2(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic, String indexTable) {
        String mQuery = this.def.getQuery();
        if (mQuery == null) {
            return null;
        }
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String faceColumn = "mbr_geometry";
        String edgeSpatialColumn = "geometry";
        String filter = null;
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        String topoName = tbSchema + topologyName;
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            featureTable = this.def.getTopoView();
            topoColumn = this.def.getTopoViewColumn();
        }
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter(faceColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        String keyColumn = "";
        if (this.def.isPredefined()) {
            keyColumn = topoName + "_edge$." + this.def.getKeyColumn() + " mv_rowid,\n";
        }
        String geocolumn = edgeSpatialColumn;
        if (transformSRID) {
            geocolumn = "sdo_cs.transform(" + edgeSpatialColumn + "," + this.visSRID + ") " + edgeSpatialColumn;
        }
        String relation_exp = "            " + topoName + "_relation$ tpf_rel,\n";
        String nltpfrel = "                 use_nl (tpf_rel,topo_idx)\n";
        String tpftgid = "tpf_rel.tg_id\n";
        String andtpfhier = "";
        String indexStr = "index(tpf_rel " + topoName + "_rel_idx$)";
        int layerId = this.def.getTopoLayerID();
        if (this.def.getTopoLayerLevel() > 0) {
            int i;
            int[] hierLayers = this.def.getLayersHierarchy();
            layerId = hierLayers[0];
            nltpfrel = "                 use_nl (tpf_rel,tpf_rel1)\n";
            for (i = 1; i < this.def.getTopoLayerLevel(); ++i) {
                nltpfrel = nltpfrel + "                 use_nl (tpf_rel" + i + ",tpf_rel" + (i + 1) + ")\n";
            }
            nltpfrel = nltpfrel + "                 use_nl (tpf_rel" + this.def.getTopoLayerLevel() + ",topo_idx)\n";
            andtpfhier = "             and tpf_rel1.topo_id = tpf_rel.tg_layer_id\n             and tpf_rel1.topo_type = tpf_rel.tg_id\n             and tpf_rel1.tg_layer_id = " + hierLayers[1] + "\n";
            for (i = 2; i <= this.def.getTopoLayerLevel(); ++i) {
                andtpfhier = andtpfhier + "             and tpf_rel" + i + ".topo_id = tpf_rel" + (i - 1) + ".tg_layer_id\n" + "             and tpf_rel" + i + ".topo_type = tpf_rel" + (i - 1) + ".tg_id\n" + "             and tpf_rel" + i + ".tg_layer_id = " + hierLayers[i] + "\n";
            }
            for (i = 1; i <= this.def.getTopoLayerLevel(); ++i) {
                relation_exp = relation_exp + "            " + topoName + "_relation$ tpf_rel" + i + ",\n";
                indexStr = indexStr + " index(tpf_rel" + i + " " + topoName + "_rel_idx$)";
            }
            indexStr = indexStr + "\n";
            tpftgid = "tpf_rel" + this.def.getTopoLayerLevel() + ".tg_id\n";
        } else {
            indexStr = indexStr + "\n";
        }
        String finalQuery = "select /*+ ordered use_nl (tpf_feat, other_query) */\n      other_query.*,tpf_feat." + topoColumn + ".tg_id,tpf_feat.* \n" + "from (select /*+ ordered " + indexStr + "                 use_nl (" + topoName + "_face$,tpf_rel)\n" + nltpfrel + "                 use_nl (" + topoName + "_face$," + topoName + "_edge$) */\n" + "        " + keyColumn + "        " + geocolumn + ",\n" + "        " + topoName + "_edge$.edge_id,\n" + "        " + topoName + "_edge$.start_node_id,\n" + "        " + topoName + "_edge$.end_node_id,\n" + "        " + topoName + "_edge$.next_left_edge_id tpl_nextedge,\n" + "        " + topoName + "_edge$.prev_left_edge_id tpl_prevedge,\n" + "        " + topoName + "_edge$.left_face_id tpl_leftface,\n" + "        " + topoName + "_edge$.right_face_id tpl_rightface,\n" + "        " + topoName + "_edge$.rowid tpl_edge_rowid,\n" + "        " + topoName + "_face$.rowid tpf_face_rowid,\n" + "        " + topoName + "_face$.face_id,\n" + "         topo_idx.sdo_rowid,\n" + "        " + topoName + "_face$.face_id topo_id\n" + "       from " + topoName + "_face$,\n" + "            " + topoName + "_edge$,\n" + relation_exp + "            " + indexTable + " topo_idx\n" + "       where left_face_id = face_id\n" + "             and (abs(next_left_edge_id) != edge_id OR start_node_id = end_node_id)\n" + "             and (left_face_id != right_face_id)\n";
        if (filter != null) {
            finalQuery = finalQuery + "             and " + filter + "\n";
        }
        finalQuery = finalQuery + "             and topo_idx.sdo_tg_id = " + tpftgid + "             and tpf_rel.topo_type = 3\n" + "             and tpf_rel.topo_id = face_id\n" + "             and tpf_rel.tg_layer_id = " + layerId + "\n" + andtpfhier + "        union all\n" + "        select /*+ ordered " + indexStr + "                 use_nl (" + topoName + "_face$,tpf_rel)\n" + nltpfrel + "                 use_nl (" + topoName + "_face$," + topoName + "_edge$) */\n" + "        " + keyColumn + "        " + geocolumn + ",\n" + "        " + topoName + "_edge$.edge_id,\n" + "        " + topoName + "_edge$.start_node_id,\n" + "        " + topoName + "_edge$.end_node_id,\n" + "        " + topoName + "_edge$.next_right_edge_id tpl_nextedge,\n" + "        " + topoName + "_edge$.prev_right_edge_id tpl_prevedge,\n" + "        " + topoName + "_edge$.left_face_id tpl_leftface,\n" + "        " + topoName + "_edge$.right_face_id tpl_rightface,\n" + "        " + topoName + "_edge$.rowid tpl_edge_rowid,\n" + "        " + topoName + "_face$.rowid tpf_face_rowid,\n" + "        " + topoName + "_face$.face_id,\n" + "         topo_idx.sdo_rowid,\n" + "        " + topoName + "_face$.face_id topo_id\n" + "       from " + topoName + "_face$,\n" + "            " + topoName + "_edge$,\n" + relation_exp + "            " + indexTable + " topo_idx\n" + "       where right_face_id = face_id\n" + "             and (abs(next_right_edge_id) != edge_id OR start_node_id = end_node_id)\n" + "             and (left_face_id != right_face_id)\n";
        if (filter != null) {
            finalQuery = finalQuery + "             and " + filter + "\n";
        }
        finalQuery = finalQuery + "             and topo_idx.sdo_tg_id = " + tpftgid + "             and tpf_rel.topo_type = 3\n" + "             and tpf_rel.topo_id = face_id\n" + "             and tpf_rel.tg_layer_id = " + layerId + "\n" + andtpfhier + "       ) other_query, \n" + "       (" + mQuery + ") tpf_feat\n" + "where other_query.sdo_rowid = tpf_feat.rowid\n" + "      order by tpf_feat." + topoColumn + ".tg_id, other_query.face_id";
        return finalQuery;
    }

    private String getRelationExpression() {
        String topologyName = this.def.getTopologyName();
        String featureTable = this.def.getFeatureTable();
        String topoColumn = this.def.getTopoGeometryColumn();
        String tbSchema = "";
        if (!this.def.getTopologyOwner().equalsIgnoreCase(this.def.getConnectionUser())) {
            tbSchema = this.def.getTopologyOwner() + ".";
        }
        String rel_exp = tbSchema + topologyName + "_relation$";
        int layerID = this.def.getTopoLayerID();
        int child_layerID = this.def.getChildLayerID();
        int layerLevel = this.def.getTopoLayerLevel();
        if (this.def.getTopoLayerLevel() > 0) {
            int i;
            int[] hierLayers = this.def.getLayersHierarchy();
            rel_exp = "";
            for (i = layerLevel; i > 0; --i) {
                rel_exp = rel_exp + "( select mv_table" + (i + 1) + i + ".tg_layer_id, " + "mv_table" + (i + 1) + i + ".tg_id, " + "mv_table" + i + (i + 1) + ".topo_id," + "mv_table" + i + (i + 1) + ".topo_type from " + tbSchema + topologyName + "_relation$ mv_table" + (i + 1) + i + " inner join ";
            }
            rel_exp = rel_exp + tbSchema + topologyName + "_relation$ ";
            for (i = 1; i <= layerLevel; ++i) {
                if (i != 1) {
                    rel_exp = rel_exp + ") ";
                }
                rel_exp = rel_exp + " mv_table" + i + (i + 1) + " on ";
                rel_exp = rel_exp + "(mv_table" + (i + 1) + i + ".topo_id = mv_table" + i + (i + 1) + ".tg_layer_id and mv_table" + (i + 1) + i + ".topo_type = " + "mv_table" + i + (i + 1) + ".tg_id and mv_table" + (i + 1) + i + ".tg_layer_id = " + hierLayers[i - 1] + ")";
            }
            rel_exp = rel_exp + " )";
        }
        return rel_exp;
    }

    private String rewriteFaceQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String edgeSpatialColumn = "geometry";
        String faceSpatialColumn = "mbr_geometry";
        String topologyName = this.def.getTopologyName();
        String leftfaceQuery = "select geometry, edge_id, start_node_id, end_node_id, next_left_edge_id nextedge, prev_left_edge_id prevedge, left_face_id left_face, right_face_id right_face, face_id from " + topologyName + "_edge$ " + "inner join " + topologyName + "_face$ on " + "left_face_id = face_id where (abs(next_left_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        String rightfaceQuery = "select geometry, edge_id,start_node_id,end_node_id, next_right_edge_id nextedge, prev_right_edge_id prevedge, left_face_id left_face, right_face_id right_face, face_id from " + topologyName + "_edge$ " + "inner join " + topologyName + "_face$ on " + "right_face_id = face_id where (abs(next_right_edge_id) != edge_id " + "or start_node_id = end_node_id) and face_id > 0 " + "and (left_face_id != right_face_id) ";
        String leftquery = leftfaceQuery;
        String rightquery = rightfaceQuery;
        if (transformSRID) {
            String tochange = edgeSpatialColumn;
            String changeto = "sdo_cs.transform(" + edgeSpatialColumn + "," + this.visSRID + ") " + edgeSpatialColumn;
            leftquery = leftfaceQuery.replaceFirst(tochange, changeto);
            rightquery = rightfaceQuery.replaceFirst(tochange, changeto);
        }
        if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            return leftquery + " union all " + rightquery + " order by face_id";
        }
        String filter = this.getFilter(faceSpatialColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return leftquery + " AND " + filter + " union all " + rightquery + " AND " + filter + " order by face_id";
    }

    private String rewriteFaceQueryV2(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String edgeSpatialColumn = "geometry";
        String faceSpatialColumn = "mbr_geometry";
        String topologyName = this.def.getTopologyName();
        String filter = null;
        if (!this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            filter = this.getFilter(faceSpatialColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        if (transformSRID) {
            edgeSpatialColumn = "sdo_cs.transform(" + edgeSpatialColumn + "," + this.visSRID + ") " + edgeSpatialColumn;
        }
        String finalQuery = "select /*+ ordered \n        use_nl (" + topologyName + "_face$," + topologyName + "_edge$)*/\n" + "   " + edgeSpatialColumn + ",\n" + "   edge_id, start_node_id, end_node_id,\n" + "   next_left_edge_id nextedge, prev_left_edge_id prevedge,\n" + "   left_face_id left_face, right_face_id right_face, face_id\n" + "from " + topologyName + "_face$," + topologyName + "_edge$\n" + "where\n" + "   left_face_id = face_id\n" + "   and (abs(next_left_edge_id) != edge_id or start_node_id = end_node_id)\n" + "   and face_id > 0\n" + "   and (left_face_id != right_face_id)\n";
        if (filter != null) {
            finalQuery = finalQuery + "   and " + filter + "\n";
        }
        finalQuery = finalQuery + "union all\nselect /*+ ordered \n        use_nl (" + topologyName + "_face$," + topologyName + "_edge$)*/\n" + "   " + edgeSpatialColumn + ",\n" + "   edge_id, start_node_id, end_node_id,\n" + "   next_right_edge_id nextedge, prev_right_edge_id prevedge,\n" + "   left_face_id left_face, right_face_id right_face, face_id\n" + "from " + topologyName + "_face$," + topologyName + "_edge$\n" + "where\n" + "    right_face_id = face_id\n" + "    and (abs(next_right_edge_id) != edge_id or start_node_id = end_node_id)\n" + "    and face_id > 0\n" + "    and (left_face_id != right_face_id)\n";
        if (filter != null) {
            finalQuery = finalQuery + "   and " + filter + "\n";
        }
        finalQuery = finalQuery + "order by face_id";
        return finalQuery;
    }

    private String rewriteEdgeQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String edgeQuery;
        String edgeSpatialColumn = this.def.getEdgeGeometryColumn();
        String topologyName = this.def.getTopologyName();
        if (edgeSpatialColumn == null) {
            return null;
        }
        String querystr = edgeQuery = "select " + edgeSpatialColumn + ", edge_id from " + topologyName + "_edge$";
        if (transformSRID) {
            String tochange = edgeSpatialColumn;
            String changeto = "sdo_cs.transform(" + edgeSpatialColumn + "," + this.visSRID + ") " + edgeSpatialColumn;
            querystr = edgeQuery.replaceFirst(tochange, changeto);
        }
        if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            return querystr;
        }
        String filter = this.getFilter(edgeSpatialColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return querystr + " WHERE " + filter;
    }

    private String rewriteNodeQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String nodeQuery;
        String nodeSpatialColumn = this.def.getNodeGeometryColumn();
        String topologyName = this.def.getTopologyName();
        if (nodeSpatialColumn == null) {
            return null;
        }
        String querystr = nodeQuery = "select " + nodeSpatialColumn + ", node_id from " + topologyName + "_node$";
        if (transformSRID) {
            String tochange = nodeSpatialColumn;
            String changeto = "sdo_cs.transform(" + nodeSpatialColumn + "," + this.visSRID + ") " + nodeSpatialColumn;
            querystr = nodeQuery.replaceFirst(tochange, changeto);
        } else {
            querystr = nodeQuery;
        }
        if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            return querystr;
        }
        String filter = this.getFilter(nodeSpatialColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return querystr + " WHERE " + filter;
    }

    final String getFilter(String spatialColumn, int srid, double xl, double yl, double xh, double yh, boolean is9i, boolean geodetic) {
        StringBuffer sb = new StringBuffer(256);
        String params = "";
        if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (this.dbVersion.indexOf(" 10.2") > 0 || this.dbVersion.indexOf(" 10.1.0.3") > 0 || this.dbVersion.indexOf(" 10.1.0.4") > 0 || Util.is11gOrAfter(this.dbVersion))) {
            double resx = (xh - xl) / this.viewResX;
            double resy = (yh - yl) / this.viewResY;
            double res = Math.min(resx, resy) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
            if (geodetic) {
                double earthRadius = 6378137.0;
                res *= Math.PI * earthRadius / 180.0;
            }
            params = ",'min_resolution=" + res + "'";
        }
        String topoColumn = this.def.getTopoGeometryColumn();
        if (is9i && geodetic) {
            sb.append("SDO_FILTER(" + spatialColumn + ", ");
            sb.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            sb.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + "))" + ", " + srid + " ) " + params + ") = 'TRUE'");
            return sb.toString();
        }
        sb.append("SDO_FILTER(" + spatialColumn + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + ")) " + params + ") = 'TRUE'");
        return sb.toString();
    }

    private Vector getAttributes(ResultSetMetaData meta, ResultSet rs, int geomCol, int labelCol, int totalCol) throws SQLException, IOException {
        int nAttrs = labelCol <= 0 ? totalCol - 1 : totalCol - 2;
        Vector<Field> v = new Vector<Field>(nAttrs);
        boolean j = false;
        for (int i = 1; i < totalCol + 1; ++i) {
            if (i <= geomCol || i == labelCol) continue;
            Field a = null;
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            a = Util.getFieldFromResultSet(sqlType, rs, i);
            a.setName(name);
            v.add(a);
        }
        return v;
    }

    private void fillAttributes(StyledFeatureI sf, Vector v) throws SQLException {
        Field[] iAttrs = this.def.getIdentifiableColumns();
        if (iAttrs == null) {
            sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
        } else {
            Field[] myIAttrs = new Field[iAttrs.length];
            block0: for (int i = 0; i < iAttrs.length; ++i) {
                Field a = iAttrs[i];
                String name = a.getName();
                for (int c = 0; c < v.size(); ++c) {
                    Field ca = (Field)v.get(c);
                    if (!name.equalsIgnoreCase(ca.getName())) continue;
                    myIAttrs[i] = ca;
                    v.remove(c);
                    continue block0;
                }
            }
            sf.setIdentifiableAttributes(myIAttrs);
            if (v.size() > 0) {
                sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
            }
        }
    }

    private void loadAttributeData(ResultSet rs, StyledFeatureI sf, int totalCol, ResultSetMetaData meta, int offset) throws SQLException, IOException {
        Vector<Field> v = new Vector<Field>(totalCol - offset);
        for (int i = offset + 1; i < totalCol + 1; ++i) {
            Field a = null;
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            a = Util.getFieldFromResultSet(sqlType, rs, i);
            a.setName(name);
            v.add(a);
        }
        Field[] iAttrs = this.def.getIdentifiableColumns();
        if (iAttrs == null) {
            sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
        } else {
            Field[] myIAttrs = new Field[iAttrs.length];
            block1: for (int i = 0; i < iAttrs.length; ++i) {
                Field a = iAttrs[i];
                String name = a.getName();
                for (int c = 0; c < v.size(); ++c) {
                    Field ca = (Field)v.get(c);
                    if (!name.equalsIgnoreCase(ca.getName())) continue;
                    myIAttrs[i] = ca;
                    v.remove(c);
                    continue block1;
                }
            }
            sf.setIdentifiableAttributes(myIAttrs);
            if (v.size() > 0) {
                sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
            }
        }
    }

    private int processJDBCQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        if (this.def.getTopoLayerType().equals("POLYGON")) {
            cnt = this.processTopologyFaceQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
        } else if (this.def.getTopoLayerType().equals("LINE")) {
            cnt = this.processTopologyEdgeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
        } else if (this.def.getTopoLayerType().equals("POINT")) {
            cnt = this.processTopologyNodeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
        } else if (this.def.getTopoLayerType().equals("COLLECTION")) {
            cnt = this.processTopologyFaceQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
            if (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared) {
                cnt = this.processTopologyEdgeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
            }
            if (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared) {
                cnt = this.processTopologyNodeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
            }
        } else {
            log.warning("Topology type " + this.def.getTopoLayerType() + " is not supported.");
        }
        return cnt;
    }

    public int processPredefinedQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        if (this.def.getTopoLayerType().equals("POLYGON")) {
            cnt = this.processPredefinedTopologyFaceQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
        } else if (this.def.getTopoLayerType().equals("LINE")) {
            cnt = this.processPredefinedTopologyEdgeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
        } else if (this.def.getTopoLayerType().equals("POINT")) {
            cnt = this.processPredefinedTopologyNodeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
        } else if (this.def.getTopoLayerType().equals("COLLECTION")) {
            cnt = this.processPredefinedTopologyFaceQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, numfeat, vc);
            if (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared) {
                cnt = this.processPredefinedTopologyEdgeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
            }
            if (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared) {
                cnt = this.processPredefinedTopologyNodeQueryV2(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
            }
        } else {
            log.warning("Topology type " + this.def.getTopoLayerType() + " is not supported.");
        }
        return cnt;
    }

    private int processFaceQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String faceq = this.rewriteFaceQueryV2(transformSRid, xl, yl, xh, yh, isGeodetic);
        log.finest("Face query [" + this.def.name + "]:\n" + faceq);
        try {
            stmt = conn.prepareStatement(faceq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Face query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            int last_face_id = 0;
            Vector<JSDOGeometry> face_polys = new Vector<JSDOGeometry>(10);
            Hashtable<String, TopoEdge> topo_edges = new Hashtable<String, TopoEdge>();
            Hashtable<String, Integer> edge_nextedge = new Hashtable<String, Integer>();
            Hashtable<String, TopoNode> topo_nodes = new Hashtable<String, TopoNode>();
            while (rs.next()) {
                JSDOGeometry geom;
                int face_id = rs.getInt(9);
                if (face_id != last_face_id && last_face_id != 0) {
                    this.generateFacePolygonsFromEdges(last_face_id, face_polys, topo_edges, topo_nodes, edge_nextedge);
                    StyledFeatureI sf = this.createStyledFeatureFromFace(face_polys, last_face_id);
                    if (sf != null) {
                        sf.setID(String.valueOf(last_face_id));
                        featureSet.add(sf);
                        if (++cnt % 20 == 0) {
                            Thread.currentThread();
                            Thread.yield();
                        }
                    }
                    face_polys.clear();
                    edge_nextedge.clear();
                    topo_nodes.clear();
                    topo_edges.clear();
                    if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) break;
                }
                if ((geom = this.loadGeometry(rs, proj, true, vc, false)) == null) continue;
                int edge_id = rs.getInt(2);
                int start_node_id = rs.getInt(3);
                int end_node_id = rs.getInt(4);
                int next_edge_id = rs.getInt(5);
                int prev_edge_id = rs.getInt(6);
                int left_face_id = rs.getInt(7);
                int right_face_id = rs.getInt(8);
                if (start_node_id == end_node_id && (edge_id == Math.abs(next_edge_id) || edge_id == Math.abs(prev_edge_id) || Math.abs(next_edge_id) == Math.abs(prev_edge_id))) {
                    double[] coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face_polys.add(geom);
                } else {
                    edge_nextedge.put(String.valueOf(edge_id), new Integer(next_edge_id));
                    TopoEdge tp_edge = new TopoEdge(edge_id, face_id);
                    tp_edge.setNodes(start_node_id, end_node_id);
                    tp_edge.setFaces(left_face_id, right_face_id);
                    tp_edge.setGeometry(geom);
                    topo_edges.put(String.valueOf(edge_id), tp_edge);
                    TopoNode nd_start = (TopoNode)topo_nodes.get(String.valueOf(start_node_id));
                    if (nd_start == null) {
                        nd_start = new TopoNode(start_node_id);
                        topo_nodes.put(String.valueOf(start_node_id), nd_start);
                    }
                    nd_start.addEdge(edge_id);
                    TopoNode nd_end = (TopoNode)topo_nodes.get(String.valueOf(end_node_id));
                    if (nd_end == null) {
                        nd_end = new TopoNode(end_node_id);
                        topo_nodes.put(String.valueOf(end_node_id), nd_end);
                    }
                    nd_end.addEdge(edge_id);
                }
                last_face_id = face_id;
            }
            if (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared) {
                this.generateFacePolygonsFromEdges(last_face_id, face_polys, topo_edges, topo_nodes, edge_nextedge);
                StyledFeatureI sf = this.createStyledFeatureFromFace(face_polys, last_face_id);
                if (sf != null) {
                    sf.setID(String.valueOf(last_face_id));
                    featureSet.add(sf);
                    if (++cnt % 20 == 0) {
                        Thread.currentThread();
                        Thread.yield();
                    }
                }
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), faceq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processEdgeQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String edgeq = this.rewriteEdgeQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
        log.finest("Edge query [" + this.def.name + "]:\n" + edgeq);
        try {
            stmt = conn.prepareStatement(edgeq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Edge query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            while (rs.next()) {
                double[] coords;
                Point2D pt;
                if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                    break;
                }
                JSDOGeometry geom = this.loadGeometry(rs, proj, true, vc, false);
                if (geom == null) continue;
                int geom_id = rs.getInt(2);
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setID(String.valueOf(geom_id));
                sf.setGeometry(geom);
                sf.setFeatureStyleName(this.def.getEdgeStyle());
                sf.setDataSource(this.def.getDataSourceName());
                if (this.def.getEdgeLabelStyle() != null) {
                    sf.setLabel(String.valueOf(geom_id));
                    sf.setLabelStyleName(this.def.getEdgeLabelStyle());
                }
                featureSet.add(sf);
                if (++cnt % 20 == 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
                if (this.def.getEdgeMarkerStyle() == null || (pt = Util.getLinePoint(coords = geom.getOrdinatesArray(), 0.5)) == null) continue;
                double[] newPt = new double[]{pt.getX(), pt.getY()};
                double[] segpoints = Util.getLineSegment(coords, 0.5);
                double dx = 0.0;
                double dy = 0.0;
                dx = segpoints[2] - segpoints[0];
                dy = segpoints[3] - segpoints[1];
                JSDOGeometry ptgeom = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])newPt, (int)2, (int)this.def.getSrid()));
                StyledFeatureI sfpt = this.getNewStyledFeatureInstance();
                sfpt.setGeometry(ptgeom);
                sfpt.setDataSource(this.def.getDataSourceName());
                sfpt.setFeatureStyleName(this.def.getEdgeMarkerStyle());
                sfpt.setMarkerStyleSize(this.def.getEdgeMarkerSize());
                sfpt.setMarkerStyleOrientation(dx, dy, 0.0);
                featureSet.add(sfpt);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), edgeq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processNodeQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String nodeq = this.rewriteNodeQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
        log.finest("Node query [" + this.def.name + "]:\n" + nodeq);
        try {
            stmt = conn.prepareStatement(nodeq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Face query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            while (rs.next()) {
                if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                    break;
                }
                JSDOGeometry geom = this.loadGeometry(rs, proj, false, vc, false);
                if (geom == null) continue;
                int geom_id = rs.getInt(2);
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setID(String.valueOf(geom_id));
                sf.setGeometry(geom);
                sf.setFeatureStyleName(this.def.getNodeStyle());
                sf.setDataSource(this.def.getDataSourceName());
                if (this.def.getNodeLabelStyle() != null) {
                    sf.setLabel(String.valueOf(geom_id));
                    sf.setLabelStyleName(this.def.getNodeLabelStyle());
                }
                featureSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), nodeq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processTopologyFaceQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        String topoColumn = this.def.getTopoGeometryColumn();
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            topoColumn = this.def.getTopoViewColumn();
        }
        String labelColumnName = this.def.getLabelColumn();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String faceq = this.rewriteTopologyFaceQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
        if (faceq == null) {
            log.warning("Topology face query is null.");
            return cnt;
        }
        log.finest("Topology Face query [" + this.def.name + "]:\n" + faceq);
        try {
            Vector geometries;
            int c;
            stmt = conn.prepareStatement(faceq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.finer("Topology Face query executed.");
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int totalColCount = meta.getColumnCount();
            int[] colIdx = null;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                colIdx = new int[infoColumns.length];
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                if (infoColumns != null) {
                    for (int c2 = 0; c2 < infoColumns.length; ++c2) {
                        if (!meta.getColumnName(i + 1).equalsIgnoreCase(infoColumns[c2].getName())) continue;
                        colIdx[c2] = i + 1;
                        break;
                    }
                }
                if (topoColumn != null && topoColumn.length() > 0 && !topoColumn.equals("null") && meta.getColumnName(i + 1).equalsIgnoreCase(topoColumn)) {
                    geomCol = i + 1;
                    log.finest("Found  Topo Column=" + topoColumn + " at column " + geomCol);
                }
                if (this.def.getLabelColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                labelCol = i + 1;
                log.finest("Found Label Column=" + this.def.getLabelColumn() + " at column " + labelCol);
            }
            if (colIdx != null) {
                for (c = 0; c < colIdx.length; ++c) {
                    if (colIdx[c] <= 0) continue;
                    if (labelCol == colIdx[c]) {
                        colIdx[c] = -1;
                        continue;
                    }
                    if (geomCol > 0 && colIdx[c] > geomCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    if (labelCol > 0 && colIdx[c] > labelCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    int n = c;
                    colIdx[n] = colIdx[n] - 1;
                }
            }
            if (geomCol == 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                c = cnt;
                return c;
            }
            if (totalColCount > 14 || labelCol == 0 && totalColCount > 13) {
                hasAttributes = true;
            }
            int last_face_id = 0;
            int face_id = 0;
            long feat_id = 0L;
            long last_feat_id = 0L;
            String feat_label = null;
            Vector attrs = null;
            TopoFace face = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                double[] coords;
                face_id = rs.getInt(11);
                feat_id = rs.getLong(12);
                if (face_id != last_face_id && last_face_id != 0) {
                    topofeat.addFace(face);
                    face = new TopoFace(face_id);
                } else if (face == null) {
                    face = new TopoFace(face_id);
                }
                if (feat_id != last_feat_id && last_feat_id != 0L) {
                    geometries = topofeat.getFeaturePolygons();
                    cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
                    topofeat = new TopoFeature(feat_id, 3);
                    attrs = null;
                    feat_label = null;
                } else if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 3);
                }
                JSDOGeometry geom = this.loadGeometry(rs, proj, true, vc, false);
                if (geom == null) continue;
                int edge_id = rs.getInt(2);
                int start_node_id = rs.getInt(3);
                int end_node_id = rs.getInt(4);
                int next_edge_id = rs.getInt(5);
                int prev_edge_id = rs.getInt(6);
                int left_face_id = rs.getInt(7);
                int right_face_id = rs.getInt(8);
                if (labelCol > 0 && feat_label == null) {
                    feat_label = rs.getString(labelCol);
                }
                if (hasAttributes && attrs == null) {
                    attrs = this.getAttributes(meta, rs, geomCol, labelCol, totalColCount);
                }
                if (start_node_id == end_node_id && (edge_id == Math.abs(next_edge_id) || edge_id == Math.abs(prev_edge_id) || Math.abs(next_edge_id) == Math.abs(prev_edge_id))) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFacePolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else if (start_node_id == end_node_id && edge_id != Math.abs(next_edge_id) && edge_id != Math.abs(prev_edge_id) && Math.abs(next_edge_id) != Math.abs(prev_edge_id)) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFaceOffsetPolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else {
                    face.addEdge(edge_id, start_node_id, end_node_id, left_face_id, right_face_id, geom);
                    face.addNextEdge(edge_id, next_edge_id);
                }
                last_face_id = face_id;
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                topofeat.addFace(face);
                geometries = topofeat.getFeaturePolygons();
                cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), faceq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processTopologyFaceQueryV2(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        String topoColumn = this.def.getTopoGeometryColumn();
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            topoColumn = this.def.getTopoViewColumn();
        }
        String labelColumnName = this.def.getLabelColumn();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String indexTable = this.def.getIndexTableName(conn);
        String faceq = this.rewriteTopologyFaceQueryV2(transformSRid, xl, yl, xh, yh, isGeodetic, indexTable);
        if (faceq == null) {
            log.warning("Topology face query is null.");
            return cnt;
        }
        log.finest("Topology Face query [" + this.def.name + "]:\n" + faceq);
        try {
            Vector geometries;
            int c;
            stmt = conn.prepareStatement(faceq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Topology Face query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int totalColCount = meta.getColumnCount();
            int[] colIdx = null;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                colIdx = new int[infoColumns.length];
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                if (infoColumns != null) {
                    for (int c2 = 0; c2 < infoColumns.length; ++c2) {
                        if (!meta.getColumnName(i + 1).equalsIgnoreCase(infoColumns[c2].getName())) continue;
                        colIdx[c2] = i + 1;
                        break;
                    }
                }
                if (topoColumn != null && topoColumn.length() > 0 && !topoColumn.equals("null") && meta.getColumnName(i + 1).equalsIgnoreCase(topoColumn)) {
                    geomCol = i + 1;
                    log.finest("Found  Topo Column=" + topoColumn + " at column " + geomCol);
                }
                if (this.def.getLabelColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                labelCol = i + 1;
                log.finest("Found Label Column=" + this.def.getLabelColumn() + " at column " + labelCol);
            }
            if (colIdx != null) {
                for (c = 0; c < colIdx.length; ++c) {
                    if (colIdx[c] <= 0) continue;
                    if (labelCol == colIdx[c]) {
                        colIdx[c] = -1;
                        continue;
                    }
                    if (geomCol > 0 && colIdx[c] > geomCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    if (labelCol > 0 && colIdx[c] > labelCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    int n = c;
                    colIdx[n] = colIdx[n] - 1;
                }
            }
            if (geomCol == 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                c = cnt;
                return c;
            }
            if (totalColCount > 16 || labelCol == 0 && totalColCount > 15) {
                hasAttributes = true;
            }
            int last_face_id = 0;
            int face_id = 0;
            long feat_id = 0L;
            long last_feat_id = 0L;
            String feat_label = null;
            Vector attrs = null;
            TopoFace face = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                double[] coords;
                face_id = rs.getInt(11);
                feat_id = rs.getLong(14);
                if (face_id != last_face_id && last_face_id != 0) {
                    topofeat.addFace(face);
                    face = new TopoFace(face_id);
                } else if (face == null) {
                    face = new TopoFace(face_id);
                }
                if (feat_id != last_feat_id && last_feat_id != 0L) {
                    geometries = topofeat.getFeaturePolygons();
                    cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
                    if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                        topofeat = null;
                        break;
                    }
                    topofeat = new TopoFeature(feat_id, 3);
                    attrs = null;
                    feat_label = null;
                } else if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 3);
                }
                JSDOGeometry geom = this.loadGeometry(rs, proj, true, vc, false);
                if (geom == null) continue;
                int edge_id = rs.getInt(2);
                int start_node_id = rs.getInt(3);
                int end_node_id = rs.getInt(4);
                int next_edge_id = rs.getInt(5);
                int prev_edge_id = rs.getInt(6);
                int left_face_id = rs.getInt(7);
                int right_face_id = rs.getInt(8);
                if (labelCol > 0 && feat_label == null) {
                    feat_label = rs.getString(labelCol);
                }
                if (hasAttributes && attrs == null) {
                    attrs = this.getAttributes(meta, rs, geomCol, labelCol, totalColCount);
                }
                if (start_node_id == end_node_id && (edge_id == Math.abs(next_edge_id) || edge_id == Math.abs(prev_edge_id) || Math.abs(next_edge_id) == Math.abs(prev_edge_id))) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFacePolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else if (start_node_id == end_node_id && edge_id != Math.abs(next_edge_id) && edge_id != Math.abs(prev_edge_id) && Math.abs(next_edge_id) != Math.abs(prev_edge_id)) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFaceOffsetPolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else {
                    face.addEdge(edge_id, start_node_id, end_node_id, left_face_id, right_face_id, geom);
                    face.addNextEdge(edge_id, next_edge_id);
                }
                last_face_id = face_id;
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                topofeat.addFace(face);
                geometries = topofeat.getFeaturePolygons();
                cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), faceq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processTopologyEdgeQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            topoColumn = this.def.getTopoViewColumn();
        }
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        topoq = this.rewriteTopologyEdgeQuery(conn, transformSRid, xl, yl, xh, yh, isGeodetic);
        if (topoq == null) {
            log.warning("Topology Edge query is null.");
            return cnt;
        }
        log.finest("[Topology Edge query]:  " + topoq);
        try {
            int c;
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.finer("Topology Edge query executed.");
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int totalColCount = meta.getColumnCount();
            int[] colIdx = null;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                colIdx = new int[infoColumns.length];
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                if (infoColumns != null) {
                    for (int c2 = 0; c2 < infoColumns.length; ++c2) {
                        if (!meta.getColumnName(i + 1).equalsIgnoreCase(infoColumns[c2].getName())) continue;
                        colIdx[c2] = i + 1;
                        break;
                    }
                }
                if (topoColumn != null && topoColumn.length() > 0 && !topoColumn.equals("null") && meta.getColumnName(i + 1).equalsIgnoreCase(topoColumn)) {
                    geomCol = i + 1;
                    log.finest("Found  Topo Column=" + topoColumn);
                }
                if (this.def.getLabelColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                labelCol = i + 1;
            }
            if (colIdx != null) {
                for (c = 0; c < colIdx.length; ++c) {
                    if (colIdx[c] <= 0) continue;
                    if (labelCol == colIdx[c]) {
                        colIdx[c] = -1;
                        continue;
                    }
                    if (geomCol > 0 && colIdx[c] > geomCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    if (labelCol > 0 && colIdx[c] > labelCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    int n = c;
                    colIdx[n] = colIdx[n] - 1;
                }
            }
            if (geomCol == 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                c = cnt;
                return c;
            }
            if (totalColCount > 8 || labelCol == 0 && totalColCount > 7) {
                hasAttributes = true;
            }
            long last_feat_id = 0L;
            String feat_label = null;
            Vector attrs = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                JSDOGeometry geom;
                int edge_id = rs.getInt(2);
                int start_node = rs.getInt(3);
                int end_node = rs.getInt(4);
                long feat_id = rs.getLong(5);
                if (last_feat_id != 0L && feat_id != last_feat_id) {
                    Vector geometries = topofeat.getFeatureLines();
                    cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
                    topofeat = null;
                    feat_label = null;
                    attrs = null;
                }
                if ((geom = this.loadGeometry(rs, proj, true, vc, false)) == null) continue;
                if (labelCol > 0 && feat_label == null) {
                    feat_label = rs.getString(labelCol);
                }
                if (hasAttributes && attrs == null) {
                    attrs = this.getAttributes(meta, rs, geomCol, labelCol, totalColCount);
                }
                if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 2);
                }
                TopoEdge edge = new TopoEdge(edge_id);
                edge.setNodes(start_node, end_node);
                edge.setGeometry(geom);
                topofeat.addEdge(edge);
                TopoNode nd_start = topofeat.getNode(start_node);
                if (nd_start == null) {
                    nd_start = new TopoNode(start_node);
                    topofeat.addNode(nd_start);
                }
                nd_start.addEdge(edge_id);
                TopoNode nd_end = topofeat.getNode(end_node);
                if (nd_end == null) {
                    nd_end = new TopoNode(end_node);
                    topofeat.addNode(nd_end);
                }
                if (start_node != end_node) {
                    nd_end.addEdge(edge_id);
                }
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                Vector geometries = topofeat.getFeatureLines();
                cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processTopologyEdgeQueryV2(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            topoColumn = this.def.getTopoViewColumn();
        }
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        String indexTable = this.def.getIndexTableName(conn);
        topoq = this.rewriteTopologyEdgeQueryV2(conn, transformSRid, xl, yl, xh, yh, isGeodetic, indexTable);
        if (topoq == null) {
            log.warning("Topology Edge query is null.");
            return cnt;
        }
        log.finest("Topology Edge query [" + this.def.name + "]:\n" + topoq);
        try {
            int c;
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Topology Edge query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int totalColCount = meta.getColumnCount();
            int[] colIdx = null;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                colIdx = new int[infoColumns.length];
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                if (infoColumns != null) {
                    for (int c2 = 0; c2 < infoColumns.length; ++c2) {
                        if (!meta.getColumnName(i + 1).equalsIgnoreCase(infoColumns[c2].getName())) continue;
                        colIdx[c2] = i + 1;
                        break;
                    }
                }
                if (topoColumn != null && topoColumn.length() > 0 && !topoColumn.equals("null") && meta.getColumnName(i + 1).equalsIgnoreCase(topoColumn)) {
                    geomCol = i + 1;
                    log.finest("Found  Topo Column=" + topoColumn);
                }
                if (this.def.getLabelColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                labelCol = i + 1;
            }
            if (colIdx != null) {
                for (c = 0; c < colIdx.length; ++c) {
                    if (colIdx[c] <= 0) continue;
                    if (labelCol == colIdx[c]) {
                        colIdx[c] = -1;
                        continue;
                    }
                    if (geomCol > 0 && colIdx[c] > geomCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    if (labelCol > 0 && colIdx[c] > labelCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    int n = c;
                    colIdx[n] = colIdx[n] - 1;
                }
            }
            if (geomCol == 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                c = cnt;
                return c;
            }
            if (totalColCount > 8 || labelCol == 0 && totalColCount > 7) {
                hasAttributes = true;
            }
            long last_feat_id = 0L;
            String feat_label = null;
            Vector attrs = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                JSDOGeometry geom;
                int edge_id = rs.getInt(2);
                int start_node = rs.getInt(3);
                int end_node = rs.getInt(4);
                long feat_id = rs.getLong(6);
                if (last_feat_id != 0L && feat_id != last_feat_id) {
                    Vector geometries = topofeat.getFeatureLines();
                    cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
                    if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                        topofeat = null;
                        break;
                    }
                    topofeat = null;
                    feat_label = null;
                    attrs = null;
                }
                if ((geom = this.loadGeometry(rs, proj, true, vc, false)) == null) continue;
                if (labelCol > 0 && feat_label == null) {
                    feat_label = rs.getString(labelCol);
                }
                if (hasAttributes && attrs == null) {
                    attrs = this.getAttributes(meta, rs, geomCol, labelCol, totalColCount);
                }
                if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 2);
                }
                TopoEdge edge = new TopoEdge(edge_id);
                edge.setNodes(start_node, end_node);
                edge.setGeometry(geom);
                topofeat.addEdge(edge);
                TopoNode nd_start = topofeat.getNode(start_node);
                if (nd_start == null) {
                    nd_start = new TopoNode(start_node);
                    topofeat.addNode(nd_start);
                }
                nd_start.addEdge(edge_id);
                TopoNode nd_end = topofeat.getNode(end_node);
                if (nd_end == null) {
                    nd_end = new TopoNode(end_node);
                    topofeat.addNode(nd_end);
                }
                if (start_node != end_node) {
                    nd_end.addEdge(edge_id);
                }
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                Vector geometries = topofeat.getFeatureLines();
                cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, this.def.getLabelStyle(), attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processTopologyNodeQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            topoColumn = this.def.getTopoViewColumn();
        }
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        topoq = this.rewriteTopologyPointQuery(conn, transformSRid, xl, yl, xh, yh, isGeodetic);
        if (topoq == null) {
            log.warning("Topology point query is null.");
            return cnt;
        }
        log.info("[Topology point query]:  " + topoq);
        try {
            int c;
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.finer("Topology Node query executed.");
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int totalColCount = meta.getColumnCount();
            int[] colIdx = null;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                colIdx = new int[infoColumns.length];
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                if (infoColumns != null) {
                    for (int c2 = 0; c2 < infoColumns.length; ++c2) {
                        if (!meta.getColumnName(i + 1).equalsIgnoreCase(infoColumns[c2].getName())) continue;
                        colIdx[c2] = i + 1;
                        break;
                    }
                }
                if (topoColumn != null && topoColumn.length() > 0 && !topoColumn.equals("null") && meta.getColumnName(i + 1).equalsIgnoreCase(topoColumn)) {
                    geomCol = i + 1;
                    log.finest("Found  Topo Column=" + topoColumn);
                }
                if (this.def.getLabelColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                labelCol = i + 1;
            }
            if (colIdx != null) {
                for (c = 0; c < colIdx.length; ++c) {
                    if (colIdx[c] <= 0) continue;
                    if (labelCol == colIdx[c]) {
                        colIdx[c] = -1;
                        continue;
                    }
                    if (geomCol > 0 && colIdx[c] > geomCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    if (labelCol > 0 && colIdx[c] > labelCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    int n = c;
                    colIdx[n] = colIdx[n] - 1;
                }
            }
            if (geomCol == 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                c = cnt;
                return c;
            }
            if (totalColCount > 8 || labelCol == 0 && totalColCount > 7) {
                hasAttributes = true;
            }
            while (rs.next()) {
                JSDOGeometry geom = this.loadGeometry(rs, proj, true, vc, false);
                if (geom == null) continue;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geom);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    sf.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    sf.setFeatureStyleName(this.def.getRenderStyle());
                }
                if (labelCol > 0) {
                    sf.setLabel(rs.getString(labelCol));
                }
                sf.setLabelStyleName(this.def.getLabelStyle());
                if (hasAttributes) {
                    Vector v = this.getAttributes(meta, rs, geomCol, labelCol, totalColCount);
                    this.fillAttributes(sf, v);
                }
                sf.setDataSource(this.def.getDataSourceName());
                sf.setRenderingRules(this.def.getRenderingRules());
                featureSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processTopologyNodeQueryV2(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        if (this.def.getTopoView() != null && this.def.getTopoViewColumn() != null) {
            topoColumn = this.def.getTopoViewColumn();
        }
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        String indexTable = this.def.getIndexTableName(conn);
        topoq = this.rewriteTopologyPointQueryV2(conn, transformSRid, xl, yl, xh, yh, isGeodetic, indexTable);
        if (topoq == null) {
            log.warning("Topology point query is null.");
            return cnt;
        }
        log.finest("Topology point query [" + this.def.name + "]:\n" + topoq);
        try {
            int c;
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Topology point query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            ResultSetMetaData meta = rs.getMetaData();
            boolean hasAttributes = false;
            int geomCol = 0;
            int labelCol = 0;
            int totalColCount = meta.getColumnCount();
            int[] colIdx = null;
            Field[] infoColumns = this.def.getIdentifiableColumns();
            if (infoColumns != null) {
                colIdx = new int[infoColumns.length];
            }
            boolean k = false;
            for (int i = 0; i < totalColCount; ++i) {
                if (infoColumns != null) {
                    for (int c2 = 0; c2 < infoColumns.length; ++c2) {
                        if (!meta.getColumnName(i + 1).equalsIgnoreCase(infoColumns[c2].getName())) continue;
                        colIdx[c2] = i + 1;
                        break;
                    }
                }
                if (topoColumn != null && topoColumn.length() > 0 && !topoColumn.equals("null") && meta.getColumnName(i + 1).equalsIgnoreCase(topoColumn)) {
                    geomCol = i + 1;
                    log.finest("Found  Topo Column=" + topoColumn);
                }
                if (this.def.getLabelColumn() == null || !meta.getColumnName(i + 1).equalsIgnoreCase(this.def.getLabelColumn())) continue;
                labelCol = i + 1;
            }
            if (colIdx != null) {
                for (c = 0; c < colIdx.length; ++c) {
                    if (colIdx[c] <= 0) continue;
                    if (labelCol == colIdx[c]) {
                        colIdx[c] = -1;
                        continue;
                    }
                    if (geomCol > 0 && colIdx[c] > geomCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    if (labelCol > 0 && colIdx[c] > labelCol) {
                        int n = c;
                        colIdx[n] = colIdx[n] - 1;
                    }
                    int n = c;
                    colIdx[n] = colIdx[n] - 1;
                }
            }
            if (geomCol == 0) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01045") + " [" + this.def.getName() + "].");
                c = cnt;
                return c;
            }
            if (totalColCount > 8 || labelCol == 0 && totalColCount > 7) {
                hasAttributes = true;
            }
            while (rs.next()) {
                if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                    break;
                }
                JSDOGeometry geom = this.loadGeometry(rs, proj, true, vc, false);
                if (geom == null) continue;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geom);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    sf.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    sf.setFeatureStyleName(this.def.getRenderStyle());
                }
                if (labelCol > 0) {
                    sf.setLabel(rs.getString(labelCol));
                }
                sf.setLabelStyleName(this.def.getLabelStyle());
                if (hasAttributes) {
                    Vector v = this.getAttributes(meta, rs, geomCol, labelCol, totalColCount);
                    this.fillAttributes(sf, v);
                }
                sf.setDataSource(this.def.getDataSourceName());
                sf.setRenderingRules(this.def.getRenderingRules());
                featureSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processPredefinedTopologyFaceQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        String topoColumn = this.def.getTopoGeometryColumn();
        String labelColumnName = this.def.getLabelColumn();
        ResultSet rs = null;
        Statement stmt = null;
        String faceq = this.rewriteTopologyFaceQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
        if (faceq == null) {
            log.warning("Predefined Topology face query is null.");
            return cnt;
        }
        log.info("[Predefined Topology Face query]:  " + faceq);
        try {
            Vector geometries;
            String key = null;
            String cacheKey = null;
            String cacheGroupName = null;
            cacheGroupName = this.def.getCacheEdgeGroup();
            if (transformSRid) {
                cacheGroupName = this.def.getCacheEdgeGroupName(this.visSRID);
            }
            stmt = conn.prepareStatement(faceq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.finer("Topology Face query executed.");
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            int last_face_id = 0;
            int face_id = 0;
            long last_feat_id = 0L;
            long feat_id = 0L;
            String feat_label = null;
            String feat_label_style = null;
            String feat_style = null;
            Vector attrs = null;
            TopoFace face = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                double[] coords;
                face_id = rs.getInt(12);
                feat_id = rs.getLong(13);
                if (face_id != last_face_id && last_face_id != 0) {
                    topofeat.addFace(face);
                    face = new TopoFace(face_id);
                } else if (face == null) {
                    face = new TopoFace(face_id);
                }
                if (feat_id != last_feat_id && last_feat_id != 0L) {
                    geometries = topofeat.getFeaturePolygons();
                    cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, feat_label_style, attrs, featureSet, cnt);
                    topofeat = new TopoFeature(feat_id, 3);
                    attrs = null;
                    feat_label = null;
                    feat_label_style = null;
                    feat_style = null;
                } else if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 3);
                }
                JSDOGeometry geom = null;
                cacheKey = key = rs.getString(1);
                if (transformSRid) {
                    cacheKey = key + this.visSRID;
                }
                if ((geom = this.loadPredefinedGeometry(rs, proj, cacheKey, cacheGroupName, true, vc, false)) == null) continue;
                int edge_id = rs.getInt(3);
                int start_node_id = rs.getInt(4);
                int end_node_id = rs.getInt(5);
                int next_edge_id = rs.getInt(6);
                int prev_edge_id = rs.getInt(7);
                int left_face_id = rs.getInt(8);
                int right_face_id = rs.getInt(9);
                if (feat_style == null) {
                    feat_style = rs.getString(15);
                }
                if (rs.getFloat(19) > 0.0f && feat_label == null) {
                    feat_label = rs.getString(17);
                    feat_label_style = rs.getString(18);
                }
                if (colCnt > 19 && attrs == null) {
                    attrs = this.getAttributes(meta, rs, 18, 19, colCnt);
                }
                if (start_node_id == end_node_id && (edge_id == Math.abs(next_edge_id) || edge_id == Math.abs(prev_edge_id) || Math.abs(next_edge_id) == Math.abs(prev_edge_id))) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFacePolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else if (start_node_id == end_node_id && edge_id != Math.abs(next_edge_id) && edge_id != Math.abs(prev_edge_id) && Math.abs(next_edge_id) != Math.abs(prev_edge_id)) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFaceOffsetPolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else {
                    face.addEdge(edge_id, start_node_id, end_node_id, left_face_id, right_face_id, geom);
                    face.addNextEdge(edge_id, next_edge_id);
                }
                last_face_id = face_id;
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                topofeat.addFace(face);
                geometries = topofeat.getFeaturePolygons();
                cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, feat_label_style, attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), faceq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processPredefinedTopologyFaceQueryV2(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        String topoColumn = this.def.getTopoGeometryColumn();
        String labelColumnName = this.def.getLabelColumn();
        ResultSet rs = null;
        Statement stmt = null;
        String indexTable = this.def.getIndexTableName(conn);
        String faceq = this.rewriteTopologyFaceQueryV2(transformSRid, xl, yl, xh, yh, isGeodetic, indexTable);
        if (faceq == null) {
            log.warning("Predefined Topology face query is null.");
            return cnt;
        }
        log.finest("Predefined Topology Face query [" + this.def.name + "]: \n" + faceq);
        try {
            Vector geometries;
            String key = null;
            String cacheKey = null;
            String cacheGroupName = null;
            cacheGroupName = this.def.getCacheEdgeGroup();
            if (transformSRid) {
                cacheGroupName = this.def.getCacheEdgeGroupName(this.visSRID);
            }
            stmt = conn.prepareStatement(faceq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Predefined Topology Face query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            int last_face_id = 0;
            int face_id = 0;
            long last_feat_id = 0L;
            long feat_id = 0L;
            String feat_label = null;
            String feat_label_style = null;
            String feat_style = null;
            Vector attrs = null;
            TopoFace face = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                double[] coords;
                face_id = rs.getInt(12);
                feat_id = rs.getLong(15);
                if (face_id != last_face_id && last_face_id != 0) {
                    topofeat.addFace(face);
                    face = new TopoFace(face_id);
                } else if (face == null) {
                    face = new TopoFace(face_id);
                }
                if (feat_id != last_feat_id && last_feat_id != 0L) {
                    geometries = topofeat.getFeaturePolygons();
                    cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, feat_label_style, attrs, featureSet, cnt);
                    if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                        topofeat = null;
                        break;
                    }
                    topofeat = new TopoFeature(feat_id, 3);
                    attrs = null;
                    feat_label = null;
                    feat_label_style = null;
                    feat_style = null;
                } else if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 3);
                }
                JSDOGeometry geom = null;
                cacheKey = key = rs.getString(1);
                if (transformSRid) {
                    cacheKey = key + this.visSRID;
                }
                if ((geom = this.loadPredefinedGeometry(rs, proj, cacheKey, cacheGroupName, true, vc, false)) == null) continue;
                int edge_id = rs.getInt(3);
                int start_node_id = rs.getInt(4);
                int end_node_id = rs.getInt(5);
                int next_edge_id = rs.getInt(6);
                int prev_edge_id = rs.getInt(7);
                int left_face_id = rs.getInt(8);
                int right_face_id = rs.getInt(9);
                if (feat_style == null) {
                    feat_style = rs.getString(17);
                }
                if (rs.getFloat(20) > 0.0f && feat_label == null) {
                    feat_label = rs.getString(18);
                    feat_label_style = rs.getString(19);
                }
                if (colCnt > 20 && attrs == null) {
                    attrs = this.getAttributes(meta, rs, 19, 20, colCnt);
                }
                if (start_node_id == end_node_id && (edge_id == Math.abs(next_edge_id) || edge_id == Math.abs(prev_edge_id) || Math.abs(next_edge_id) == Math.abs(prev_edge_id))) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFacePolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else if (start_node_id == end_node_id && edge_id != Math.abs(next_edge_id) && edge_id != Math.abs(prev_edge_id) && Math.abs(next_edge_id) != Math.abs(prev_edge_id)) {
                    coords = geom.getOrdinatesArray();
                    geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)this.def.getSrid()));
                    face.addFaceOffsetPolygon(edge_id, prev_edge_id, next_edge_id, geom);
                } else {
                    face.addEdge(edge_id, start_node_id, end_node_id, left_face_id, right_face_id, geom);
                    face.addNextEdge(edge_id, next_edge_id);
                }
                last_face_id = face_id;
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                topofeat.addFace(face);
                geometries = topofeat.getFeaturePolygons();
                cnt = this.createStyledFeatures(geometries, this.def.getRenderStyle(), feat_label, feat_label_style, attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), faceq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private void printResultsetColumns(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            System.out.println("Result set columns:");
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCnt = rsmeta.getColumnCount();
            for (int i = 1; i <= colCnt; ++i) {
                String colname = rsmeta.getColumnName(i);
                System.out.println("" + i + " : " + colname);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int processPredefinedTopologyEdgeQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        Statement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        topoq = this.rewriteTopologyEdgeQuery(conn, transformSRid, xl, yl, xh, yh, isGeodetic);
        if (topoq == null) {
            log.warning("Predefine Topology Edge query is null.");
            return cnt;
        }
        log.info("[Predefined Topology Edge query]:  " + topoq);
        try {
            String key = null;
            String cacheKey = null;
            String cacheGroupName = null;
            cacheGroupName = this.def.getCacheEdgeGroup();
            if (transformSRid) {
                cacheGroupName = this.def.getCacheEdgeGroupName(this.visSRID);
            }
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            long last_feat_id = 0L;
            String feat_label = null;
            String feat_label_style = null;
            String feat_style = null;
            Vector attrs = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                long feat_id = rs.getLong(6);
                if (feat_id != last_feat_id && last_feat_id != 0L) {
                    Vector geometries = topofeat.getFeatureLines();
                    cnt = this.createStyledFeatures(geometries, feat_style, feat_label, feat_label_style, attrs, featureSet, cnt);
                    topofeat = null;
                    attrs = null;
                    feat_label = null;
                    feat_label_style = null;
                    feat_style = null;
                }
                JSDOGeometry geom = null;
                cacheKey = key = rs.getString(1);
                if (transformSRid) {
                    cacheKey = key + this.visSRID;
                }
                if ((geom = this.loadPredefinedGeometry(rs, proj, cacheKey, cacheGroupName, true, vc, false)) == null) continue;
                if (feat_style == null) {
                    feat_style = rs.getString(9);
                }
                if (rs.getFloat(12) > 0.0f && feat_label == null) {
                    feat_label = rs.getString(10);
                    feat_label_style = rs.getString(11);
                }
                if (colCnt > 12 && attrs == null) {
                    attrs = this.getAttributes(meta, rs, 12, 13, colCnt);
                }
                int edge_id = rs.getInt(3);
                int start_node = rs.getInt(4);
                int end_node = rs.getInt(5);
                if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 2);
                }
                TopoEdge edge = new TopoEdge(edge_id);
                edge.setNodes(start_node, end_node);
                edge.setGeometry(geom);
                topofeat.addEdge(edge);
                TopoNode nd_start = topofeat.getNode(start_node);
                if (nd_start == null) {
                    nd_start = new TopoNode(start_node);
                    topofeat.addNode(nd_start);
                }
                nd_start.addEdge(edge_id);
                TopoNode nd_end = topofeat.getNode(end_node);
                if (nd_end == null) {
                    nd_end = new TopoNode(end_node);
                    topofeat.addNode(nd_end);
                }
                if (start_node != end_node) {
                    nd_end.addEdge(edge_id);
                }
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                Vector geometries = topofeat.getFeatureLines();
                cnt = this.createStyledFeatures(geometries, feat_style, feat_label, feat_label_style, attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processPredefinedTopologyEdgeQueryV2(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        Statement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        String indexTable = this.def.getIndexTableName(conn);
        topoq = this.rewriteTopologyEdgeQueryV2(conn, transformSRid, xl, yl, xh, yh, isGeodetic, indexTable);
        if (topoq == null) {
            log.warning("Predefine Topology Edge query is null.");
            return cnt;
        }
        log.finest("Predefined Topology Edge query [" + this.def.name + "]:\n" + topoq);
        try {
            String key = null;
            String cacheKey = null;
            String cacheGroupName = null;
            cacheGroupName = this.def.getCacheEdgeGroup();
            if (transformSRid) {
                cacheGroupName = this.def.getCacheEdgeGroupName(this.visSRID);
            }
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Predefined Topology Edge query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            long last_feat_id = 0L;
            String feat_label = null;
            String feat_label_style = null;
            String feat_style = null;
            Vector attrs = null;
            TopoFeature topofeat = null;
            while (rs.next()) {
                long feat_id = rs.getLong(7);
                if (feat_id != last_feat_id && last_feat_id != 0L) {
                    Vector geometries = topofeat.getFeatureLines();
                    cnt = this.createStyledFeatures(geometries, feat_style, feat_label, feat_label_style, attrs, featureSet, cnt);
                    if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                        topofeat = null;
                        break;
                    }
                    topofeat = null;
                    attrs = null;
                    feat_label = null;
                    feat_label_style = null;
                    feat_style = null;
                }
                JSDOGeometry geom = null;
                cacheKey = key = rs.getString(1);
                if (transformSRid) {
                    cacheKey = key + this.visSRID;
                }
                if ((geom = this.loadPredefinedGeometry(rs, proj, cacheKey, cacheGroupName, true, vc, false)) == null) continue;
                if (feat_style == null) {
                    feat_style = rs.getString(9);
                }
                if (rs.getFloat(12) > 0.0f && feat_label == null) {
                    feat_label = rs.getString(10);
                    feat_label_style = rs.getString(11);
                }
                if (colCnt > 12 && attrs == null) {
                    attrs = this.getAttributes(meta, rs, 11, 12, colCnt);
                }
                int edge_id = rs.getInt(3);
                int start_node = rs.getInt(4);
                int end_node = rs.getInt(5);
                if (topofeat == null) {
                    topofeat = new TopoFeature(feat_id, 2);
                }
                TopoEdge edge = new TopoEdge(edge_id);
                edge.setNodes(start_node, end_node);
                edge.setGeometry(geom);
                topofeat.addEdge(edge);
                TopoNode nd_start = topofeat.getNode(start_node);
                if (nd_start == null) {
                    nd_start = new TopoNode(start_node);
                    topofeat.addNode(nd_start);
                }
                nd_start.addEdge(edge_id);
                TopoNode nd_end = topofeat.getNode(end_node);
                if (nd_end == null) {
                    nd_end = new TopoNode(end_node);
                    topofeat.addNode(nd_end);
                }
                if (start_node != end_node) {
                    nd_end.addEdge(edge_id);
                }
                last_feat_id = feat_id;
            }
            if (topofeat != null) {
                Vector geometries = topofeat.getFeatureLines();
                cnt = this.createStyledFeatures(geometries, feat_style, feat_label, feat_label_style, attrs, featureSet, cnt);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processPredefinedTopologyNodeQuery(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        Statement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        topoq = this.rewriteTopologyPointQuery(conn, transformSRid, xl, yl, xh, yh, isGeodetic);
        if (topoq == null) {
            log.warning("Predefined Topology Point query is null.");
            return cnt;
        }
        log.info("[Predefined Topology Point query]:  " + topoq);
        try {
            String key = null;
            String cacheKey = null;
            String cacheGroupName = null;
            cacheGroupName = this.def.getCacheNodeGroup();
            if (transformSRid) {
                cacheGroupName = this.def.getCacheNodeGroupName(this.visSRID);
            }
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            while (rs.next()) {
                JSDOGeometry geom = null;
                cacheKey = key = rs.getString(1);
                if (transformSRid) {
                    cacheKey = key + this.visSRID;
                }
                if ((geom = this.loadPredefinedGeometry(rs, proj, cacheKey, cacheGroupName, true, vc, false)) == null) continue;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geom);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    sf.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    sf.setFeatureStyleName(rs.getString(9));
                }
                if (rs.getFloat(12) > 0.0f) {
                    sf.setLabel(rs.getString(10));
                    sf.setLabelStyleName(rs.getString(11));
                }
                if (colCnt > 12) {
                    this.loadAttributeData(rs, sf, colCnt, meta, 12);
                }
                sf.setDataSource(this.def.getDataSourceName());
                sf.setRenderingRules(this.def.getRenderingRules());
                featureSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int processPredefinedTopologyNodeQueryV2(Connection conn, boolean transformSRid, double xl, double yl, double xh, double yh, ArrayList featureSet, Proj proj, boolean isGeodetic, int numfeat, VisContext vc) throws DataException {
        int cnt = numfeat;
        long t1 = 0L;
        long t2 = 0L;
        ResultSet rs = null;
        Statement stmt = null;
        String topoColumn = this.def.getTopoGeometryColumn();
        String labelColumnName = this.def.getLabelColumn();
        String topoq = null;
        String indexTable = this.def.getIndexTableName(conn);
        topoq = this.rewriteTopologyPointQueryV2(conn, transformSRid, xl, yl, xh, yh, isGeodetic, indexTable);
        if (topoq == null) {
            log.warning("Predefined Topology Point query is null.");
            return cnt;
        }
        log.finest("Predefined Topology Point query [" + this.def.name + "]:\n" + topoq);
        try {
            String key = null;
            String cacheKey = null;
            String cacheGroupName = null;
            cacheGroupName = this.def.getCacheNodeGroup();
            if (transformSRid) {
                cacheGroupName = this.def.getCacheNodeGroupName(this.visSRID);
            }
            stmt = conn.prepareStatement(topoq);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t1 = System.currentTimeMillis();
            rs = stmt.executeQuery();
            t2 = System.currentTimeMillis();
            log.info("Predefined Topology Point query executed [" + this.def.name + "]: " + (t2 - t1) + " ms");
            ResultSetMetaData meta = rs.getMetaData();
            int colCnt = meta.getColumnCount();
            while (rs.next()) {
                if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                    break;
                }
                JSDOGeometry geom = null;
                cacheKey = key = rs.getString(1);
                if (transformSRid) {
                    cacheKey = key + this.visSRID;
                }
                if ((geom = this.loadPredefinedGeometry(rs, proj, cacheKey, cacheGroupName, true, vc, false)) == null) continue;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geom);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    sf.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    sf.setFeatureStyleName(rs.getString(9));
                }
                if (rs.getFloat(12) > 0.0f) {
                    sf.setLabel(rs.getString(10));
                    sf.setLabelStyleName(rs.getString(11));
                }
                if (colCnt > 12) {
                    this.loadAttributeData(rs, sf, colCnt, meta, 12);
                }
                sf.setDataSource(this.def.getDataSourceName());
                sf.setRenderingRules(this.def.getRenderingRules());
                featureSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + (cnt - numfeat) + " features: " + (t3 - t2) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), topoq, "features loaded = " + (cnt - numfeat));
        return cnt;
    }

    private int createStyledFeatures(Vector geometries, String feat_style, String feat_label, String feat_label_style, Vector attrs, ArrayList featureSet, int numfeat) throws Exception {
        int cnt = numfeat;
        if (geometries != null && geometries.size() > 0) {
            for (int m = 0; m < geometries.size(); ++m) {
                JSDOGeometry geo = (JSDOGeometry)geometries.get(m);
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geo);
                if (feat_label != null) {
                    sf.setLabel(feat_label);
                    sf.setLabelStyleName(feat_label_style);
                }
                if (attrs != null) {
                    try {
                        this.fillAttributes(sf, attrs);
                    }
                    catch (Exception e) {
                        throw new Exception(e.getMessage());
                    }
                }
                sf.setFeatureStyleName(feat_style);
                sf.setDataSource(this.def.getDataSourceName());
                sf.setRenderingRules(this.def.getRenderingRules());
                featureSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        return cnt;
    }

    private StyledFeatureI createStyledFeatureFromFace(Vector face_polys, int face_id) {
        StyledFeatureI sf = null;
        JSDOGeometry geom = this.getFaceGeometry(face_polys);
        if (geom != null) {
            sf = this.getNewStyledFeatureInstance();
            sf.setGeometry(geom);
            sf.setFeatureStyleName(this.def.getFaceStyle());
            sf.setDataSource(this.def.getDataSourceName());
            if (this.def.getFaceLabelStyle() != null) {
                sf.setLabel(String.valueOf(face_id));
                sf.setLabelStyleName(this.def.getFaceLabelStyle());
            }
        }
        return sf;
    }

    private JSDOGeometry getFaceGeometry(Vector face_polys) {
        JSDOGeometry geom = null;
        if (face_polys != null && face_polys.size() > 0) {
            JSDOGeometry geo = null;
            double[][] facecoords = new double[face_polys.size()][];
            if (face_polys.size() == 1) {
                geo = (JSDOGeometry)face_polys.get(0);
                facecoords[0] = geo.getOrdinatesArray();
            } else {
                double maxarea = 0.0;
                int exterior = -1;
                for (int k = 0; k < face_polys.size(); ++k) {
                    geo = (JSDOGeometry)face_polys.get(k);
                    double[] mbr = geo.getMBR();
                    double area = (mbr[2] - mbr[0]) * (mbr[3] - mbr[1]);
                    if (!(area > maxarea)) continue;
                    exterior = k;
                    maxarea = area;
                }
                geo = (JSDOGeometry)face_polys.get(exterior);
                facecoords[0] = geo.getOrdinatesArray();
                if (this.isClockwise(facecoords[0])) {
                    int size = facecoords[0].length;
                    for (int i = 0; i < (size - 2) / 2; i += 2) {
                        double temp_x = facecoords[0][i];
                        double temp_y = facecoords[0][i + 1];
                        facecoords[0][i] = facecoords[0][size - 2 - i];
                        facecoords[0][i + 1] = facecoords[0][size - 1 - i];
                        facecoords[0][size - 2 - i] = temp_x;
                        facecoords[0][size - 1 - i] = temp_y;
                    }
                }
                int pos = 1;
                for (int k = 0; k < face_polys.size(); ++k) {
                    if (k == exterior) continue;
                    geo = (JSDOGeometry)face_polys.get(k);
                    facecoords[pos] = geo.getOrdinatesArray();
                    if (!this.isClockwise(facecoords[pos])) {
                        int size = facecoords[pos].length;
                        for (int i = 0; i < (size - 2) / 2; i += 2) {
                            double temp_x = facecoords[pos][i];
                            double temp_y = facecoords[pos][i + 1];
                            facecoords[pos][i] = facecoords[pos][size - 2 - i];
                            facecoords[pos][i + 1] = facecoords[pos][size - 1 - i];
                            facecoords[pos][size - 2 - i] = temp_x;
                            facecoords[pos][size - 1 - i] = temp_y;
                        }
                    }
                    ++pos;
                }
            }
            if (facecoords != null) {
                geom = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((Object[])facecoords, (int)2, (int)this.def.getSrid()));
            }
        }
        return geom;
    }

    private JSDOGeometry getFaceExteriorGeometry(Vector face_polys) {
        JSDOGeometry geom = null;
        int exterior = -1;
        if (face_polys != null && face_polys.size() > 0) {
            if (face_polys.size() == 1) {
                exterior = 0;
            } else {
                double maxarea = 0.0;
                for (int k = 0; k < face_polys.size(); ++k) {
                    JSDOGeometry geo = (JSDOGeometry)face_polys.get(k);
                    double[] mbr = geo.getMBR();
                    double area = (mbr[2] - mbr[0]) * (mbr[3] - mbr[1]);
                    if (!(area > maxarea)) continue;
                    exterior = k;
                    maxarea = area;
                }
            }
        }
        if (exterior > -1 && exterior < face_polys.size()) {
            geom = (JSDOGeometry)face_polys.get(exterior);
        }
        return geom;
    }

    private void generateFacePolygonsFromEdges(int face_id, Vector face_polys, Hashtable topo_edges, Hashtable topo_nodes, Hashtable edge_nextedge) {
        int tot_edges = topo_edges.size();
        if (tot_edges > 0) {
            Vector<String> used_edges = new Vector<String>(10);
            Object[] values = topo_edges.values().toArray();
            for (int v = 0; v < values.length; ++v) {
                int k;
                TopoEdge tp_edge = (TopoEdge)values[v];
                String edgeid = String.valueOf(tp_edge.getID());
                if (used_edges.contains(edgeid)) continue;
                int start_node = tp_edge.getStartNodeID();
                int end_node = tp_edge.getEndNodeID();
                int last_ref_node = 0;
                last_ref_node = tp_edge.getLeftFaceID() == face_id ? 2 : 1;
                int nextedge = Integer.parseInt(edge_nextedge.get(edgeid).toString());
                String lastEdgeId = edgeid;
                JSDOGeometry geom = tp_edge.getGeometry();
                used_edges.add(edgeid);
                int startedge = Integer.parseInt(edgeid);
                double[] coords = null;
                coords = geom.getOrdinatesArray();
                double[] finalcoords = new double[coords.length];
                if (tp_edge.getLeftFaceID() == face_id && !geom.LoadedAndReoriented() || tp_edge.getRightFaceID() == face_id && geom.LoadedAndReoriented()) {
                    for (k = 0; k < coords.length; ++k) {
                        finalcoords[k] = coords[k];
                    }
                } else {
                    for (k = 0; k < coords.length; k += 2) {
                        finalcoords[k] = coords[coords.length - 1 - k - 1];
                        finalcoords[k + 1] = coords[coords.length - 1 - k];
                    }
                }
                boolean close_polygon = true;
                boolean valid_polygon = false;
                int loop = 0;
                while (close_polygon) {
                    int k2;
                    if (loop > tot_edges) {
                        log.warning("Unable to close polygon for face " + face_id);
                        break;
                    }
                    ++loop;
                    String nextedgeStr = String.valueOf(Math.abs(nextedge));
                    TopoEdge tp_next_edge = (TopoEdge)topo_edges.get(nextedgeStr);
                    JSDOGeometry nextgeom = null;
                    if (tp_next_edge == null) {
                        int j;
                        Vector nd_edges;
                        TopoNode nd;
                        int geomsize = finalcoords.length;
                        if (Math.abs(finalcoords[0] - finalcoords[geomsize - 2]) <= this.tolerance && Math.abs(finalcoords[1] - finalcoords[geomsize - 1]) <= this.tolerance) {
                            valid_polygon = true;
                            close_polygon = false;
                            continue;
                        }
                        if (last_ref_node == 1) {
                            nd = (TopoNode)topo_nodes.get(String.valueOf(start_node));
                            nd_edges = nd.getEdges();
                            for (j = 0; j < nd_edges.size(); ++j) {
                                String edid = (String)nd_edges.get(j);
                                if (edid.equals(lastEdgeId)) continue;
                                tp_next_edge = (TopoEdge)topo_edges.get(edid);
                                nextedgeStr = edid;
                                nextedge = tp_next_edge.getID();
                                if (tp_next_edge.getStartNodeID() == start_node) break;
                                nextedge = tp_next_edge.getID() * -1;
                                break;
                            }
                        } else {
                            nd = (TopoNode)topo_nodes.get(String.valueOf(end_node));
                            nd_edges = nd.getEdges();
                            for (j = 0; j < nd_edges.size(); ++j) {
                                String edid = (String)nd_edges.get(j);
                                if (edid.equals(lastEdgeId)) continue;
                                tp_next_edge = (TopoEdge)topo_edges.get(edid);
                                nextedgeStr = edid;
                                nextedge = tp_next_edge.getID();
                                if (tp_next_edge.getStartNodeID() == end_node) break;
                                nextedge = tp_next_edge.getID() * -1;
                                break;
                            }
                        }
                        if (tp_next_edge == null) {
                            valid_polygon = false;
                            log.warning("Next edge (" + nextedgeStr + ") is null. Face (" + face_id + ") polygon discarded.");
                            break;
                        }
                    }
                    int size = finalcoords.length;
                    if (startedge == Math.abs(nextedge)) {
                        if (Math.abs(finalcoords[0] - finalcoords[size - 2]) <= this.tolerance && Math.abs(finalcoords[1] - finalcoords[size - 1]) <= this.tolerance) {
                            valid_polygon = true;
                        } else {
                            log.warning("Polygon start and end points are not the same for face " + face_id + " : face discarded.");
                        }
                        close_polygon = false;
                        continue;
                    }
                    nextgeom = tp_next_edge.getGeometry();
                    double[] nextcoords = nextgeom.getOrdinatesArray();
                    int nextsize = nextcoords.length;
                    double[] temp = new double[finalcoords.length];
                    System.arraycopy(finalcoords, 0, temp, 0, finalcoords.length);
                    finalcoords = null;
                    finalcoords = new double[temp.length + nextcoords.length - 2];
                    System.arraycopy(temp, 0, finalcoords, 0, temp.length);
                    if (nextedge > 0) {
                        if (!nextgeom.LoadedAndReoriented()) {
                            for (k2 = 2; k2 < nextcoords.length; ++k2) {
                                finalcoords[temp.length + k2 - 2] = nextcoords[k2];
                            }
                        } else {
                            for (k2 = 2; k2 < nextcoords.length; k2 += 2) {
                                finalcoords[temp.length + k2 - 2] = nextcoords[nextcoords.length - 1 - k2 - 1];
                                finalcoords[temp.length + k2 - 1] = nextcoords[nextcoords.length - 1 - k2];
                            }
                        }
                        last_ref_node = 2;
                    } else {
                        if (nextgeom.LoadedAndReoriented()) {
                            for (k2 = 2; k2 < nextcoords.length; ++k2) {
                                finalcoords[temp.length + k2 - 2] = nextcoords[k2];
                            }
                        } else {
                            for (k2 = 2; k2 < nextcoords.length; k2 += 2) {
                                finalcoords[temp.length + k2 - 2] = nextcoords[nextcoords.length - 1 - k2 - 1];
                                finalcoords[temp.length + k2 - 1] = nextcoords[nextcoords.length - 1 - k2];
                            }
                        }
                        last_ref_node = 1;
                    }
                    used_edges.add(nextedgeStr);
                    tp_edge = tp_next_edge;
                    start_node = tp_edge.getStartNodeID();
                    end_node = tp_edge.getEndNodeID();
                    lastEdgeId = nextedgeStr;
                    nextedge = Integer.parseInt(edge_nextedge.get(nextedgeStr).toString());
                }
                if (!valid_polygon) continue;
                JSDOGeometry newpoly = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])finalcoords, (int)2, (int)this.def.getSrid()));
                face_polys.add(newpoly);
            }
        }
    }

    private JSDOGeometry loadGeometry(ResultSet rs, Proj proj, boolean checkReorient, VisContext vc, boolean checkShift) {
        JSDOGeometry geom = null;
        try {
            if (this.getTheme().getDecorator().isFastUnpickle()) {
                byte[] bytes = ((OracleResultSet)rs).getBytes(1);
                geom = checkReorient && this.getTheme().getDecorator().isReorientLines() ? JSDOGeometry.loadAndReorient(bytes) : JSDOGeometry.loadFromDB(bytes);
            } else {
                geom = JDBCUtil.loadGeometry(rs, 1, false);
            }
            if (geom == null) {
                return null;
            }
            if (this.applyRotation) {
                JGeometry geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, this.mapRotation);
                if (geomRot == null) {
                    return null;
                }
                geom = JSDOGeometry.recast(geomRot);
                if (geom == null) {
                    return null;
                }
            }
            if (checkShift && (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) {
                log.finer("SRS.shif method returned null geometry.");
                return null;
            }
            if (proj != null) {
                Proj.P2 p = proj.getOpposite();
                if (geom.pointInPolygon(p.x, p.y)) {
                    return null;
                }
                if ((geom = SRS.proj(geom, proj, 0)) == null) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return geom;
    }

    private JSDOGeometry loadPredefinedGeometry(ResultSet rs, Proj proj, String cacheKey, String cacheGroupName, boolean checkReorient, VisContext vc, boolean checkShift) {
        JSDOGeometry geom = null;
        try {
            if (this.def.getCachingMode() != 3 && this.getTheme().getDecorator().getWorkspaceName() == null) {
                CacheGroup cg = CacheMgr2.getGroup(this.def.cacheSubRegionName, cacheGroupName);
                if (cg != null) {
                    geom = (JSDOGeometry)cg.get(cacheKey);
                    if (geom == null && (geom = JDBCUtil.loadGeometry(rs, 2, false)) != null) {
                        cg.put(cacheKey, geom, geom.getSize());
                    }
                } else {
                    geom = JDBCUtil.loadGeometry(rs, 2, false);
                }
            } else {
                geom = JDBCUtil.loadGeometry(rs, 2, false);
            }
            if (geom == null) {
                return null;
            }
            if (this.applyRotation) {
                JGeometry geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, this.mapRotation);
                if (geomRot == null) {
                    return null;
                }
                geom = JSDOGeometry.recast(geomRot);
                if (geom == null) {
                    return null;
                }
            }
            if (checkShift && (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) {
                log.finer("SRS.shif method returned null geometry.");
                return null;
            }
            if (proj != null) {
                Proj.P2 p = proj.getOpposite();
                if (geom.pointInPolygon(p.x, p.y)) {
                    return null;
                }
                if ((geom = SRS.proj(geom, proj, 0)) == null) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return null;
        }
        return geom;
    }

    public void setStyledFeatures(ArrayList sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features != null) {
            return this.features.getStyledFeatures();
        }
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(window);
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(idx);
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(window, name);
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.features != null) {
            this.features.postPreparation(vc);
        }
    }

    @Override
    public int size() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    private boolean isFullExtent(boolean passThrough, double xl, double yl, double xh, double yh) {
        return passThrough || Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private boolean isClockwise(double[] coords) {
        double area = this.getPolygonArea(coords);
        return !(area < 0.0);
    }

    private double getPolygonArea(double[] coords) {
        if (coords == null) {
            return 0.0;
        }
        double r1 = 0.0;
        double r2 = 0.0;
        double area = 0.0;
        double prev_x = coords[0];
        double prev_y = coords[1];
        for (int k = 2; k < coords.length - 1; k += 2) {
            double next_x = coords[k];
            double next_y = coords[k + 1];
            r1 += prev_x * next_y;
            r2 += prev_y * next_x;
            prev_x = next_x;
            prev_y = next_y;
        }
        area = (r2 - r1) / 2.0;
        return area;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }

    private class TopoFeatureGeometry {
        Vector faceIds = new Vector(10);
        Vector polygons = new Vector(10);

        public boolean addPolygon(JSDOGeometry geom, Vector face_ids) {
            if (geom == null || face_ids.size() == 0) {
                return false;
            }
            for (int i = 0; i < face_ids.size(); ++i) {
                if (this.faceIds.contains(face_ids.get(i))) continue;
                this.faceIds.add(face_ids.get(i));
            }
            this.polygons.add(geom);
            return true;
        }

        public Vector getPolygons() {
            return this.polygons;
        }

        public boolean faceIn(String face_id) {
            return this.faceIds.contains(face_id);
        }

        public JSDOGeometry getGeometry() {
            if (this.polygons.size() == 0) {
                return null;
            }
            return TopologyThemeProducer.this.getFaceGeometry(this.polygons);
        }

        public JSDOGeometry getExternalGeometry() {
            if (this.polygons.size() == 0) {
                return null;
            }
            return TopologyThemeProducer.this.getFaceExteriorGeometry(this.polygons);
        }
    }

    private class TopoFeature {
        long featID = 0L;
        int featType = 0;
        Hashtable edgeFaces = new Hashtable(10);
        Hashtable commonEdges = new Hashtable();
        Hashtable edges = new Hashtable();
        Hashtable polyFaces = new Hashtable();
        Vector edgeIDs = new Vector(10);
        Hashtable nodes = new Hashtable(10);
        Hashtable containedFaces = new Hashtable(10);

        public TopoFeature(long id, int type) {
            this.featID = id;
            this.featType = type;
        }

        public void addCommonEdge(TopoEdge edge) {
            this.commonEdges.put(String.valueOf(edge.getID()), edge);
            this.edges.remove(String.valueOf(edge.getID()));
        }

        public void addEdge(TopoEdge edge) {
            this.edges.put(String.valueOf(edge.getID()), edge);
        }

        public void addNode(TopoNode node) {
            this.nodes.put(String.valueOf(node.getID()), node);
        }

        public TopoNode getNode(int nodeid) {
            return (TopoNode)this.nodes.get(String.valueOf(nodeid));
        }

        public void addFace(TopoFace face) {
            if (this.edgeFaces.get(String.valueOf(face.getID())) != null) {
                return;
            }
            if (this.polyFaces.get(String.valueOf(face.getID())) != null) {
                return;
            }
            int polysize = face.getPolygons().size();
            if (polysize > 0) {
                int removed = 0;
                Vector polyedges = face.getFacePolygonsEdges();
                block0: for (int i = 0; i < face.getPolygons().size(); ++i) {
                    TopoEdge tpe = (TopoEdge)polyedges.get(i);
                    Enumeration e = this.polyFaces.elements();
                    while (e.hasMoreElements()) {
                        TopoEdge fctpe;
                        int j;
                        TopoFace fc = (TopoFace)e.nextElement();
                        if (fc.getPolygons().size() == 0) continue;
                        boolean polyremoved = false;
                        Vector fcedges = fc.getFacePolygonsEdges();
                        for (j = 0; j < fc.getPolygons().size(); ++j) {
                            fctpe = (TopoEdge)fcedges.get(j);
                            if (tpe.getID() != fctpe.getID() || Math.abs(tpe.getPreviousEdge()) != Math.abs(tpe.getNextEdge()) || Math.abs(fctpe.getPreviousEdge()) != Math.abs(fctpe.getNextEdge())) continue;
                            face.removeFacePolygon(i);
                            --i;
                            fc.removeFacePolygon(j);
                            ++removed;
                            polyremoved = true;
                            break;
                        }
                        if (polyremoved) continue block0;
                        fcedges = fc.getFaceOffsetPolygonsEdges();
                        for (j = 0; j < fc.getOffsetPolygons().size(); ++j) {
                            fctpe = (TopoEdge)fcedges.get(j);
                            if (tpe.getID() != fctpe.getID()) continue;
                            face.removeFacePolygon(i);
                            --i;
                            ++removed;
                            polyremoved = true;
                            break;
                        }
                        if (!polyremoved) continue;
                        continue block0;
                    }
                }
                if (polysize != removed) {
                    this.polyFaces.put(String.valueOf(face.getID()), face);
                }
            }
            if (face.getNumberOfEdges() > 0) {
                int size = face.getNumberOfEdges();
                int remedges = 0;
                Object[] values = face.getEdges().values().toArray();
                for (int i = 0; i < size; ++i) {
                    int edge_id = ((TopoEdge)values[i]).getID();
                    TopoEdge edge = (TopoEdge)this.edges.get(String.valueOf(edge_id));
                    if (edge != null) {
                        TopoCommonEdge deledge = new TopoCommonEdge(edge_id);
                        deledge.setFaceId(edge.getFaceId());
                        deledge.setNodes(0, 0);
                        deledge.setFaces(edge.getLeftFaceID(), edge.getRightFaceID());
                        deledge.setFirstFaceID(edge.getFaceId());
                        deledge.setSecondFaceID(face.getID());
                        this.addCommonEdge(deledge);
                        this.edges.remove(String.valueOf(edge_id));
                        this.edgeIDs.remove(String.valueOf(edge_id));
                        ++remedges;
                        continue;
                    }
                    edge = (TopoEdge)values[i];
                    int start_node = edge.getStartNodeID();
                    int end_node = edge.getEndNodeID();
                    int left_face = edge.getLeftFaceID();
                    int right_face = edge.getRightFaceID();
                    edge = new TopoEdge(edge_id, face.getID());
                    edge.setNodes(start_node, end_node);
                    edge.setFaces(left_face, right_face);
                    this.edges.put(String.valueOf(edge_id), edge);
                    this.edgeIDs.add(String.valueOf(edge_id));
                }
                if (size > 0 && remedges != size) {
                    this.edgeFaces.put(String.valueOf(face.getID()), face);
                } else if (size > 0 && remedges == size) {
                    this.containedFaces.put(String.valueOf(face.getID()), face);
                }
            }
        }

        public Vector getFeaturePolygons() {
            if (this.edges.size() == 0 && this.polyFaces.size() == 0) {
                return null;
            }
            Vector<TopoFeatureGeometry> result = new Vector<TopoFeatureGeometry>(10);
            int tot_edges = this.edgeIDs.size();
            if (tot_edges > 0) {
                Vector<String> used_edges = new Vector<String>(10);
                Vector<String> used_faces = new Vector<String>(10);
                for (int el = 0; el < tot_edges; ++el) {
                    String edgeid = (String)this.edgeIDs.get(el);
                    if (used_edges.contains(edgeid)) continue;
                    TopoEdge topoedge = (TopoEdge)this.edges.get(edgeid);
                    String faceid = String.valueOf(topoedge.getFaceId());
                    TopoFace topoface = (TopoFace)this.edgeFaces.get(faceid);
                    int start_node = topoedge.getStartNodeID();
                    int end_node = topoedge.getEndNodeID();
                    int last_ref_node = 0;
                    last_ref_node = topoedge.getLeftFaceID() == Integer.parseInt(faceid) ? 2 : 1;
                    int nextedge = topoface.getNextEdgeID(Integer.parseInt(edgeid));
                    String lastEdgeId = edgeid;
                    JSDOGeometry geom = topoface.getEdgeGeometry(Integer.parseInt(edgeid));
                    used_edges.add(edgeid);
                    int startedge = Integer.parseInt(edgeid);
                    double[] coords = null;
                    coords = geom.getOrdinatesArray();
                    double[] finalcoords = new double[coords.length];
                    for (int k = 0; k < coords.length; ++k) {
                        finalcoords[k] = coords[k];
                    }
                    boolean close_polygon = true;
                    boolean valid_polygon = false;
                    boolean first_nextedge = true;
                    used_faces.add(faceid);
                    int last_face_id = topoface.getID();
                    int current_face_id = topoface.getID();
                    while (close_polygon) {
                        int k;
                        JSDOGeometry nextgeom;
                        TopoCommonEdge commonEdge = (TopoCommonEdge)this.commonEdges.get(String.valueOf(Math.abs(nextedge)));
                        boolean maybeinloop = false;
                        int tries = 0;
                        while (commonEdge != null) {
                            if (tries > 2 * this.commonEdges.size()) {
                                maybeinloop = true;
                                break;
                            }
                            int facetouse = 0;
                            facetouse = commonEdge.getFirstFaceID() == topoface.getID() ? commonEdge.getSecondFaceID() : commonEdge.getFirstFaceID();
                            topoface = (TopoFace)this.edgeFaces.get(String.valueOf(facetouse));
                            if (topoface == null) {
                                topoface = (TopoFace)this.containedFaces.get(String.valueOf(facetouse));
                                int nxedge = topoface.getNextEdgeID(commonEdge.getID());
                                commonEdge = (TopoCommonEdge)this.commonEdges.get(String.valueOf(Math.abs(nxedge)));
                                facetouse = commonEdge.getFirstFaceID() == topoface.getID() ? commonEdge.getSecondFaceID() : commonEdge.getFirstFaceID();
                                topoface = (TopoFace)this.edgeFaces.get(String.valueOf(facetouse));
                            }
                            current_face_id = facetouse;
                            nextedge = topoface.getNextEdgeID(commonEdge.getID());
                            lastEdgeId = String.valueOf(commonEdge.getID());
                            commonEdge = (TopoCommonEdge)this.commonEdges.get(String.valueOf(Math.abs(nextedge)));
                            ++tries;
                        }
                        if (maybeinloop) {
                            log.warning("Unable to close polygon for feature " + this.featID + " starting with edge " + startedge);
                            close_polygon = false;
                            continue;
                        }
                        String nextedgeStr = String.valueOf(Math.abs(nextedge));
                        TopoEdge tp_next_edge = (TopoEdge)topoface.getEdges().get(nextedgeStr);
                        if (tp_next_edge == null) {
                            int geomsize = finalcoords.length;
                            if (Math.abs(finalcoords[0] - finalcoords[geomsize - 2]) <= TopologyThemeProducer.this.tolerance && Math.abs(finalcoords[1] - finalcoords[geomsize - 1]) <= TopologyThemeProducer.this.tolerance) {
                                valid_polygon = true;
                                close_polygon = false;
                                continue;
                            }
                            int node_to_use = start_node;
                            if (last_ref_node != 1) {
                                node_to_use = end_node;
                            }
                            TopoNode nd = (TopoNode)topoface.getNodes().get(String.valueOf(node_to_use));
                            Vector nd_edges = nd.getEdges();
                            for (int j = 0; j < nd_edges.size(); ++j) {
                                String edid = (String)nd_edges.get(j);
                                if (edid.equals(lastEdgeId)) continue;
                                TopoCommonEdge comEdge = (TopoCommonEdge)this.commonEdges.get(edid);
                                if (comEdge == null) {
                                    tp_next_edge = (TopoEdge)topoface.getEdges().get(edid);
                                    nextedgeStr = edid;
                                    nextedge = tp_next_edge.getID();
                                    if (tp_next_edge.getLeftFaceID() == topoface.getID()) break;
                                    nextedge = tp_next_edge.getID() * -1;
                                    break;
                                }
                                int fctouse = 0;
                                fctouse = comEdge.getFirstFaceID() == topoface.getID() ? comEdge.getSecondFaceID() : comEdge.getFirstFaceID();
                                topoface = (TopoFace)this.edgeFaces.get(String.valueOf(fctouse));
                                current_face_id = fctouse;
                                nextedge = topoface.getNextEdgeID(comEdge.getID());
                                nextedgeStr = String.valueOf(Math.abs(nextedge));
                                tp_next_edge = (TopoEdge)topoface.getEdges().get(String.valueOf(Math.abs(nextedge)));
                                break;
                            }
                            if (tp_next_edge == null) {
                                log.warning("Unable to close polygon for feature " + this.featID + " starting with edge " + startedge);
                                close_polygon = false;
                                continue;
                            }
                        }
                        int size = finalcoords.length;
                        if (startedge == Math.abs(nextedge)) {
                            if (Math.abs(finalcoords[0] - finalcoords[size - 2]) <= TopologyThemeProducer.this.tolerance && Math.abs(finalcoords[1] - finalcoords[size - 1]) <= TopologyThemeProducer.this.tolerance) {
                                valid_polygon = true;
                            } else {
                                log.warning("Unable to close polygon for feature " + this.featID + " starting with edge " + startedge + " : feature polygon discarded.");
                            }
                            close_polygon = false;
                            continue;
                        }
                        if (current_face_id != last_face_id) {
                            if (!used_faces.contains(String.valueOf(topoface.getID()))) {
                                used_faces.add(String.valueOf(topoface.getID()));
                            }
                            last_face_id = current_face_id;
                        }
                        if ((nextgeom = tp_next_edge.getGeometry()) == null) {
                            log.warning("Next edge (" + nextedge + ") is not on face edge list. Face polygon discarded.");
                            valid_polygon = false;
                            break;
                        }
                        double[] nextcoords = nextgeom.getOrdinatesArray();
                        int nextsize = nextcoords.length;
                        if (first_nextedge) {
                            if (nextedge > 0 && !nextgeom.LoadedAndReoriented() && Math.abs(finalcoords[0] - nextcoords[0]) <= TopologyThemeProducer.this.tolerance && Math.abs(finalcoords[1] - nextcoords[1]) <= TopologyThemeProducer.this.tolerance || nextedge > 0 && nextgeom.LoadedAndReoriented() && Math.abs(finalcoords[0] - nextcoords[nextsize - 2]) <= TopologyThemeProducer.this.tolerance && Math.abs(finalcoords[1] - nextcoords[nextsize - 1]) <= TopologyThemeProducer.this.tolerance || nextedge < 0 && !nextgeom.LoadedAndReoriented() && Math.abs(finalcoords[0] - nextcoords[nextsize - 2]) <= TopologyThemeProducer.this.tolerance && Math.abs(finalcoords[1] - nextcoords[nextsize - 1]) <= TopologyThemeProducer.this.tolerance || nextedge < 0 && nextgeom.LoadedAndReoriented() && Math.abs(finalcoords[0] - nextcoords[0]) <= TopologyThemeProducer.this.tolerance && Math.abs(finalcoords[1] - nextcoords[1]) <= TopologyThemeProducer.this.tolerance) {
                                int finalsize = finalcoords.length;
                                for (int i = 0; i < (finalsize - 2) / 2; i += 2) {
                                    double temp_x = finalcoords[i];
                                    double temp_y = finalcoords[i + 1];
                                    finalcoords[i] = finalcoords[finalsize - 2 - i];
                                    finalcoords[i + 1] = finalcoords[finalsize - 1 - i];
                                    finalcoords[finalsize - 2 - i] = temp_x;
                                    finalcoords[finalsize - 1 - i] = temp_y;
                                }
                            }
                            first_nextedge = false;
                        }
                        double[] temp = new double[finalcoords.length];
                        System.arraycopy(finalcoords, 0, temp, 0, finalcoords.length);
                        finalcoords = null;
                        finalcoords = new double[temp.length + nextcoords.length - 2];
                        System.arraycopy(temp, 0, finalcoords, 0, temp.length);
                        if (nextedge > 0) {
                            if (!nextgeom.LoadedAndReoriented()) {
                                for (k = 2; k < nextcoords.length; ++k) {
                                    finalcoords[temp.length + k - 2] = nextcoords[k];
                                }
                            } else {
                                for (k = 2; k < nextcoords.length; k += 2) {
                                    finalcoords[temp.length + k - 2] = nextcoords[nextcoords.length - 1 - k - 1];
                                    finalcoords[temp.length + k - 1] = nextcoords[nextcoords.length - 1 - k];
                                }
                            }
                            last_ref_node = 2;
                        } else {
                            if (nextgeom.LoadedAndReoriented()) {
                                for (k = 2; k < nextcoords.length; ++k) {
                                    finalcoords[temp.length + k - 2] = nextcoords[k];
                                }
                            } else {
                                for (k = 2; k < nextcoords.length; k += 2) {
                                    finalcoords[temp.length + k - 2] = nextcoords[nextcoords.length - 1 - k - 1];
                                    finalcoords[temp.length + k - 1] = nextcoords[nextcoords.length - 1 - k];
                                }
                            }
                            last_ref_node = 1;
                        }
                        used_edges.add(nextedgeStr);
                        start_node = tp_next_edge.getStartNodeID();
                        end_node = tp_next_edge.getEndNodeID();
                        lastEdgeId = nextedgeStr;
                        nextedge = topoface.getNextEdgeID(Integer.parseInt(nextedgeStr));
                    }
                    if (valid_polygon) {
                        JSDOGeometry newpoly = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])finalcoords, (int)2, (int)TopologyThemeProducer.this.def.getSrid()));
                        boolean exist = false;
                        TopoFeatureGeometry tpgeom = null;
                        block10: for (int m = 0; m < result.size(); ++m) {
                            tpgeom = (TopoFeatureGeometry)result.get(m);
                            for (int n = 0; n < used_faces.size(); ++n) {
                                if (!tpgeom.faceIn((String)used_faces.get(n))) continue;
                                tpgeom.addPolygon(newpoly, used_faces);
                                exist = true;
                                continue block10;
                            }
                        }
                        if (!exist) {
                            tpgeom = new TopoFeatureGeometry();
                            tpgeom.addPolygon(newpoly, used_faces);
                            result.add(tpgeom);
                        }
                    }
                    used_faces.clear();
                }
            }
            Enumeration e = this.polyFaces.elements();
            while (e.hasMoreElements()) {
                TopoFace face = (TopoFace)e.nextElement();
                Vector fpolys = face.getPolygons();
                if (fpolys == null || fpolys.size() == 0) continue;
                Vector<String> faces = new Vector<String>();
                faces.add(String.valueOf(face.getID()));
                boolean exist = false;
                TopoFeatureGeometry tpgeom = null;
                for (int m = 0; m < result.size(); ++m) {
                    tpgeom = (TopoFeatureGeometry)result.get(m);
                    if (!tpgeom.faceIn(String.valueOf(face.getID()))) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    tpgeom = new TopoFeatureGeometry();
                    result.add(tpgeom);
                }
                for (int i = 0; i < fpolys.size(); ++i) {
                    JSDOGeometry geo = (JSDOGeometry)fpolys.get(i);
                    tpgeom.addPolygon(geo, faces);
                }
            }
            Vector<JSDOGeometry> result_final = new Vector<JSDOGeometry>(10);
            for (int i = 0; i < result.size(); ++i) {
                TopoFeatureGeometry tpgeom = (TopoFeatureGeometry)result.get(i);
                JSDOGeometry geo = null;
                geo = TopologyThemeProducer.this.def.getTopoLayerLevel() > 0 ? tpgeom.getExternalGeometry() : tpgeom.getGeometry();
                if (geo == null) continue;
                result_final.add(geo);
            }
            return result_final;
        }

        public Vector getFeatureLines() {
            if (this.featType != 2) {
                return null;
            }
            Vector<JSDOGeometry> result = new Vector<JSDOGeometry>(10);
            Vector<String> usededges = new Vector<String>(10);
            if (this.edges.size() == 0 || this.nodes.size() == 0) {
                return null;
            }
            for (int pass = 0; pass < 2 && (pass != 1 || this.edges.size() != usededges.size()); ++pass) {
                Enumeration e = this.edges.elements();
                while (e.hasMoreElements()) {
                    int k;
                    TopoEdge edge = (TopoEdge)e.nextElement();
                    int edgeid = edge.getID();
                    if (edge.getGeometry() == null) {
                        log.warning("Feature edge with null geometry.");
                        usededges.add(String.valueOf(edgeid));
                        continue;
                    }
                    if (usededges.contains(String.valueOf(edgeid))) continue;
                    int startnode = edge.getStartNodeID();
                    int endnode = edge.getEndNodeID();
                    TopoNode start = this.getNode(startnode);
                    TopoNode end = this.getNode(endnode);
                    if (pass == 0 && start.getNumberOfEdges() > 1 && end.getNumberOfEdges() > 1) continue;
                    if (startnode == 0 || endnode == 0 || start.getNumberOfEdges() == 1 && end.getNumberOfEdges() == 1) {
                        result.add(edge.getGeometry());
                        usededges.add(String.valueOf(edgeid));
                        continue;
                    }
                    usededges.add(String.valueOf(edgeid));
                    int currentedge = edgeid;
                    int currentnode = 0;
                    int nextnode = 0;
                    if (pass == 0) {
                        if (start.getNumberOfEdges() == 1) {
                            currentnode = startnode;
                            nextnode = endnode;
                        } else {
                            currentnode = endnode;
                            nextnode = startnode;
                        }
                    } else {
                        currentnode = startnode;
                        nextnode = endnode;
                    }
                    JSDOGeometry geom = edge.getGeometry();
                    double[] coords = geom.getOrdinatesArray();
                    double[] finalcoords = new double[coords.length];
                    if (!geom.LoadedAndReoriented() && currentnode == startnode || geom.LoadedAndReoriented() && currentnode == endnode) {
                        for (k = 0; k < coords.length; ++k) {
                            finalcoords[k] = coords[k];
                        }
                    } else {
                        for (k = 0; k < coords.length; k += 2) {
                            finalcoords[k] = coords[coords.length - 1 - k - 1];
                            finalcoords[k + 1] = coords[coords.length - 1 - k];
                        }
                    }
                    Vector<String> usednodes = new Vector<String>(10);
                    usednodes.add(String.valueOf(currentnode));
                    TopoNode nextnd = (TopoNode)this.nodes.get(String.valueOf(nextnode));
                    block4: while (nextnd.getNumberOfEdges() > 1 && edge != null && !usednodes.contains(String.valueOf(nextnode))) {
                        Vector ndedges = nextnd.getEdges();
                        int nextedgeid = 0;
                        edge = null;
                        for (int j = 0; j < ndedges.size(); ++j) {
                            int k2;
                            int id = Integer.parseInt(ndedges.get(j).toString());
                            if (id == currentedge || usededges.contains(String.valueOf(id))) continue;
                            edge = (TopoEdge)this.edges.get(String.valueOf(id));
                            nextedgeid = edge.getID();
                            startnode = edge.getStartNodeID();
                            endnode = edge.getEndNodeID();
                            JSDOGeometry nextgeom = edge.getGeometry();
                            double[] nextcoords = nextgeom.getOrdinatesArray();
                            double[] temp = new double[finalcoords.length];
                            System.arraycopy(finalcoords, 0, temp, 0, finalcoords.length);
                            finalcoords = null;
                            finalcoords = new double[temp.length + nextcoords.length - 2];
                            System.arraycopy(temp, 0, finalcoords, 0, temp.length);
                            if (!nextgeom.LoadedAndReoriented() && nextnode == startnode || nextgeom.LoadedAndReoriented() && nextnode == endnode) {
                                for (k2 = 2; k2 < nextcoords.length; ++k2) {
                                    finalcoords[temp.length + k2 - 2] = nextcoords[k2];
                                }
                            } else {
                                for (k2 = 2; k2 < nextcoords.length; k2 += 2) {
                                    finalcoords[temp.length + k2 - 2] = nextcoords[nextcoords.length - 1 - k2 - 1];
                                    finalcoords[temp.length + k2 - 1] = nextcoords[nextcoords.length - 1 - k2];
                                }
                            }
                            usededges.add(String.valueOf(nextedgeid));
                            usednodes.add(String.valueOf(nextnode));
                            nextnode = nextnode == startnode ? endnode : startnode;
                            nextnd = (TopoNode)this.nodes.get(String.valueOf(nextnode));
                            currentedge = nextedgeid;
                            continue block4;
                        }
                    }
                    if (finalcoords == null) continue;
                    if (TopologyThemeProducer.this.getTheme().getDecorator().isReorientLines() && finalcoords[0] > finalcoords[finalcoords.length - 2]) {
                        int size = finalcoords.length;
                        for (int i = 0; i < (size - 2) / 2; i += 2) {
                            double temp_x = finalcoords[i];
                            double temp_y = finalcoords[i + 1];
                            finalcoords[i] = finalcoords[size - 2 - i];
                            finalcoords[i + 1] = finalcoords[size - 1 - i];
                            finalcoords[size - 2 - i] = temp_x;
                            finalcoords[size - 1 - i] = temp_y;
                        }
                    }
                    JSDOGeometry newline = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])finalcoords, (int)2, (int)TopologyThemeProducer.this.def.getSrid()));
                    result.add(newline);
                }
            }
            return result;
        }
    }

    private class TopoFace {
        int faceID = 0;
        Vector facePolygons = new Vector(10);
        Vector facePolygonsEdges = new Vector(10);
        Vector faceoffsetPolygons = new Vector(10);
        Vector faceoffsetPolygonsEdges = new Vector(10);
        Hashtable edgeNextEdge = new Hashtable();
        Hashtable topoEdges = new Hashtable();
        Hashtable topoNodes = new Hashtable();

        public TopoFace(int id) {
            this.faceID = id;
        }

        public int getID() {
            return this.faceID;
        }

        public void addFacePolygon(int edgeId, int prevEdge, int nextEdge, JSDOGeometry geom) {
            TopoEdge tp_edge = new TopoEdge(edgeId, this.faceID);
            tp_edge.setSequenceEdges(prevEdge, nextEdge);
            this.facePolygonsEdges.add(tp_edge);
            this.facePolygons.add(geom);
        }

        public void addFaceOffsetPolygon(int edgeId, int prevEdge, int nextEdge, JSDOGeometry geom) {
            TopoEdge tp_edge = new TopoEdge(edgeId, this.faceID);
            tp_edge.setSequenceEdges(prevEdge, nextEdge);
            this.faceoffsetPolygonsEdges.add(tp_edge);
            this.faceoffsetPolygons.add(geom);
        }

        public void removeFacePolygon(int index) {
            if (index < 0 || index > this.facePolygons.size() - 1) {
                return;
            }
            this.facePolygonsEdges.remove(index);
            this.facePolygons.remove(index);
        }

        public Vector getFacePolygonsEdges() {
            return this.facePolygonsEdges;
        }

        public Vector getFaceOffsetPolygonsEdges() {
            return this.faceoffsetPolygonsEdges;
        }

        public int getNumberOfFacePolygons() {
            return this.facePolygons.size();
        }

        public int getNumberOfFaceOffsetPolygons() {
            return this.faceoffsetPolygons.size();
        }

        public boolean addEdge(int edgeid, int startNode, int endNode, int leftFace, int rightFace, JSDOGeometry geom) {
            TopoEdge tp_edge = new TopoEdge(edgeid, this.faceID);
            tp_edge.setNodes(startNode, endNode);
            tp_edge.setFaces(leftFace, rightFace);
            tp_edge.setGeometry(geom);
            this.topoEdges.put(String.valueOf(edgeid), tp_edge);
            TopoNode nd_start = (TopoNode)this.topoNodes.get(String.valueOf(startNode));
            if (nd_start == null) {
                nd_start = new TopoNode(startNode);
                this.topoNodes.put(String.valueOf(startNode), nd_start);
            }
            nd_start.addEdge(edgeid);
            TopoNode nd_end = (TopoNode)this.topoNodes.get(String.valueOf(endNode));
            if (nd_end == null) {
                nd_end = new TopoNode(endNode);
                this.topoNodes.put(String.valueOf(endNode), nd_end);
            }
            nd_end.addEdge(edgeid);
            return true;
        }

        public void addNextEdge(int edgeid, int nextedgeid) {
            this.edgeNextEdge.put(String.valueOf(edgeid), new Integer(nextedgeid));
        }

        public Hashtable getEdges() {
            return this.topoEdges;
        }

        public Hashtable getNodes() {
            return this.topoNodes;
        }

        public Vector getPolygons() {
            return this.facePolygons;
        }

        public Vector getOffsetPolygons() {
            return this.faceoffsetPolygons;
        }

        public int getNumberOfEdges() {
            return this.topoEdges.size();
        }

        public JSDOGeometry getEdgeGeometry(int edgeid) {
            TopoEdge edge = (TopoEdge)this.topoEdges.get(String.valueOf(edgeid));
            if (edge == null) {
                return null;
            }
            return edge.getGeometry();
        }

        public int getNextEdgeID(int edgeid) {
            Integer nextid = (Integer)this.edgeNextEdge.get(String.valueOf(edgeid));
            return nextid;
        }
    }

    private class TopoCommonEdge
    extends TopoEdge {
        int firstFaceID;
        int scndFaceID;

        public TopoCommonEdge(int id) {
            this.firstFaceID = 0;
            this.scndFaceID = 0;
            this.edgeID = id;
        }

        public int getFirstFaceID() {
            return this.firstFaceID;
        }

        public int getSecondFaceID() {
            return this.scndFaceID;
        }

        public void setFirstFaceID(int id) {
            this.firstFaceID = id;
        }

        public void setSecondFaceID(int id) {
            this.scndFaceID = id;
        }
    }

    private class TopoEdge {
        int edgeID = 0;
        int faceID = 0;
        int leftFaceID = 0;
        int rightFaceID = 0;
        int startNodeID = 0;
        int endNodeID = 0;
        int nextEdgeId = 0;
        int prevEdgeId = 0;
        JSDOGeometry geom = null;

        public TopoEdge() {
        }

        public TopoEdge(int id) {
            this.edgeID = id;
        }

        public TopoEdge(int id, int faceId) {
            this.edgeID = id;
            this.faceID = faceId;
        }

        public void setFaceId(int faceId) {
            this.faceID = faceId;
        }

        public int getFaceId() {
            return this.faceID;
        }

        public void setNodes(int startNode, int endNode) {
            this.startNodeID = startNode;
            this.endNodeID = endNode;
        }

        public void setFaces(int leftFace, int rigthFace) {
            this.leftFaceID = leftFace;
            this.rightFaceID = rigthFace;
        }

        public void setSequenceEdges(int prevedge, int nextedge) {
            this.prevEdgeId = prevedge;
            this.nextEdgeId = nextedge;
        }

        public int getPreviousEdge() {
            return this.prevEdgeId;
        }

        public int getNextEdge() {
            return this.nextEdgeId;
        }

        public int getID() {
            return this.edgeID;
        }

        public int getLeftFaceID() {
            return this.leftFaceID;
        }

        public int getRightFaceID() {
            return this.rightFaceID;
        }

        public void setLeftFaceID(int id) {
            this.leftFaceID = id;
        }

        public void setRightFaceID(int id) {
            this.rightFaceID = id;
        }

        public int getStartNodeID() {
            return this.startNodeID;
        }

        public int getEndNodeID() {
            return this.endNodeID;
        }

        public void setGeometry(JSDOGeometry geo) {
            this.geom = geo;
        }

        public JSDOGeometry getGeometry() {
            return this.geom;
        }
    }

    private class TopoNode {
        int nodeID = 0;
        Vector edgesID = new Vector(3);
        JSDOGeometry geom = null;

        public TopoNode(int id) {
            this.nodeID = id;
        }

        public int getID() {
            return this.nodeID;
        }

        public Vector getEdges() {
            return this.edgesID;
        }

        public void addEdge(int id) {
            this.edgesID.add(String.valueOf(id));
        }

        public int getNumberOfEdges() {
            return this.edgesID.size();
        }

        public void setGeometry(JSDOGeometry geo) {
            this.geom = geo;
        }

        public JSDOGeometry getGeometry() {
            return this.geom;
        }
    }
}

