/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.PieSliceInfo;
import oracle.mapviewer.share.stylex.VariablePieChartStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VariablePieChartStyle
extends BucketStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public VariablePieChartStyle() {
        this.bean = new VariablePieChartStyleModel();
    }

    public VariablePieChartStyle(StyleModel model) {
        this.setModel(model);
    }

    public VariablePieChartStyle(Document doc) throws StyleException {
        this.bean = new VariablePieChartStyleModel();
        try {
            Color color;
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            Node elemVPC = XMLDOMParser.getSubElement(elem, "VariablePieChartStyle");
            String startSize = XMLDOMParser.getAttribute(elemVPC, "startradius");
            String incSize = XMLDOMParser.getAttribute(elemVPC, "increment");
            SizeDefinition2D sizes = SizeDefinition2D.parse(startSize, incSize);
            if (sizes == null) {
                throw new StyleException("Invalid sizes in VariablePieChart style definition.");
            }
            ((VariablePieChartStyleModel)this.bean).setSizes(sizes);
            String strokeColor = XMLDOMParser.getAttribute(elemVPC, "stroke");
            if (strokeColor != null && strokeColor.trim().length() > 0 && (color = StyleUtils.getColor(strokeColor.trim())) != null) {
                String stroke_opacity = XMLDOMParser.getAttribute(elemVPC, "stroke-opacity");
                if (stroke_opacity != null) {
                    try {
                        int value = Integer.parseInt(stroke_opacity);
                        if (value < 0 || value > 255) {
                            log.warning("Stroke opacity value out of range [0,255].");
                        } else {
                            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), value);
                        }
                    }
                    catch (Exception ex) {
                        log.warning("Invalid stroke opacity value: " + stroke_opacity);
                    }
                }
                ((VariablePieChartStyleModel)this.bean).setStrokeColor(color);
            }
            ArrayList nl = XMLDOMParser.getSubElements(elemVPC, "PieSlice");
            ((VariablePieChartStyleModel)this.bean).setNumSlices(nl.size());
            PieSliceInfo[] psi = new PieSliceInfo[nl.size()];
            for (int i = 0; i < nl.size(); ++i) {
                Node el = (Node)nl.get(i);
                PieSliceInfo _psi = new PieSliceInfo();
                _psi.setName(XMLDOMParser.getAttribute(el, "name"));
                try {
                    _psi.setColor(StyleUtils.getColor(XMLDOMParser.getAttribute(el, "color")));
                }
                catch (Exception e) {
                    _psi.setColor(null);
                }
                psi[i] = _psi;
            }
            ((VariablePieChartStyleModel)this.bean).setPieSlices(psi);
            elem = XMLDOMParser.getSubElement(elemVPC, "Buckets");
            BucketStyle.fetchBuckets(elem, this.bean.getBucketSeries());
        }
        catch (Exception e) {
            throw new StyleException("Invalid VariablePieChartStyle style definition.");
        }
    }

    public VariablePieChartStyle(BucketSeries bkts, PieSliceInfo[] psi, int startRadius, int increment) {
        this.bean = new VariablePieChartStyleModel(bkts);
        ((VariablePieChartStyleModel)this.bean).setStartRadius(startRadius);
        ((VariablePieChartStyleModel)this.bean).setIncrement(increment);
        ((VariablePieChartStyleModel)this.bean).setPieSlices(psi);
        if (psi != null) {
            ((VariablePieChartStyleModel)this.bean).setNumSlices(psi.length);
        }
        this.reset();
    }

    @Override
    public Object clone() {
        VariablePieChartStyle sty = (VariablePieChartStyle)super.clone();
        sty.setModel((StyleModel)this.bean.clone());
        return sty;
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof VariablePieChartStyleModel)) {
            throw new IllegalArgumentException("Not a VariablePieChartStyleModel instance.");
        }
        this.bean = (VariablePieChartStyleModel)model;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void reset() {
        double size = ((VariablePieChartStyleModel)this.bean).getDoubleStartRadius();
        BucketSeries buckets = this.bean.getBucketSeries();
        if (buckets != null) {
            for (int i = 0; i < buckets.size(); ++i) {
                Bucket sb = buckets.getBucket(i);
                if (sb.getRenderStyle() != null || sb.getRenderStyleName() != null) continue;
                PieChartStyle sm = new PieChartStyle((int)size, ((VariablePieChartStyleModel)this.bean).getPieSlices());
                sm.setPieRadius(size);
                sm.setPieRadiusUnit(((VariablePieChartStyleModel)this.bean).getRadiusUnit());
                sm.setStrokeColor(((VariablePieChartStyleModel)this.bean).getStrokeColor());
                sb.setRenderStyle(sm);
                size += ((VariablePieChartStyleModel)this.bean).getDoubleIncrement();
            }
        }
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        this.reset();
        return true;
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        return super.getMaxLegendWidth(g, fontSize);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply VariablePieChartStyle to a point without attribute.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        double w = rect.getWidth();
        double h = rect.getHeight();
        BucketSeries buckets = this.bean.getBucketSeries();
        int nBuckets = buckets.size();
        try {
            int widest = ((PieChartStyle)buckets.getBucket(nBuckets - 1).getRenderStyle()).getPieRadius() * 2;
            int narrowest = ((PieChartStyle)buckets.getBucket(0).getRenderStyle()).getPieRadius() * 2;
            if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                StyleModifiers smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers("PIECHART_" + (nBuckets - 1));
                if (smods != null && smods instanceof PieChartStyleModifiers) {
                    widest = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                }
                if ((smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers("PIECHART_0")) != null && smods instanceof PieChartStyleModifiers) {
                    narrowest = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                }
            }
            widest = Math.max(widest, narrowest);
            double sx = rect.getMinX();
            double sy = rect.getMinY() + 2.0;
            Rectangle2D.Float sr = new Rectangle2D.Float();
            for (int i = 0; i < nBuckets; ++i) {
                StyleModifiers smods = null;
                Bucket bucket = buckets.getBucket(i);
                PieChartStyle sty = (PieChartStyle)bucket.getRenderStyle();
                boolean ignoreName = sty.ignoreSliceDescriptionName();
                sty.ignoreSliceDescriptionName(true);
                int styleW = sty.getPieRadius() * 2;
                int styleH = sty.getPieRadius() * 2;
                if (stymods != null && stymods instanceof AdvancedStyleModifiers && (smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers("PIECHART_" + i)) != null && smods instanceof PieChartStyleModifiers) {
                    styleW = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                    styleH = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                }
                double x = sx + (double)(widest - styleW) / 2.0;
                ((Rectangle2D)sr).setRect(x, sy, w, styleH);
                this.drawBucketWithLabel(g, bucket, sr, (float)((double)styleW / w), 0.0f, smods);
                sy += (double)(styleH + 2);
                sty.ignoreSliceDescriptionName(ignoreName);
            }
        }
        catch (Exception e) {
            g.drawString(" * bad style *", 10, 10);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("VariablePieChartStyle not applicable without an attr value.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("VariablePieChartStyle not applicable without an attr value.");
        }
        double total = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                try {
                    total += Double.parseDouble(values[i].getString());
                    continue;
                }
                catch (Exception e) {
                    throw new StyleNotApplicableException("VariablePieChartStyle needs numeric attributes.");
                }
            }
            total += values[i].getDouble();
        }
        Field value = new Field(total);
        BucketStyle.BucketDescription bd = this.chooseRenderStyle(value, stymods);
        if (bd.style != null) {
            bd.style.apply(null, g, shp, gtype, label, labelPoint, cr, values, bd.styleMods);
        } else {
            System.out.println("Pie chart style not found for value: " + total);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int numSlices = ((VariablePieChartStyleModel)this.bean).getNumSlices();
        if (styleColumns == null) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else {
            if (numSlices < 1) {
                throw new StyleNotApplicableException("VariablePieChartStyle must have at least one slice.");
            }
            if (styleColumns.length < numSlices) {
                throw new StyleNotApplicableException("Not enough style columns for VariablePieChartStyle.");
            }
            Field[] svalue = new Field[numSlices];
            for (int i = 0; i < styleColumns.length; ++i) {
                svalue[i] = null;
                String column = styleColumns[i];
                svalue[i] = Util.getField(column, values);
                if (svalue[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + column + " for VariablePieChartStyle.");
            }
            this.apply(null, g, shp, gtype, label, labelPoint, cr, svalue, stymods);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, styleColumns, stymods);
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }
}

