/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;

public class JavaDBDataSource
extends AbstractDBDataSource {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static String CLIENT_DRIVER_MODE = "CLIENT";
    public static String EMBEDDED_DRIVER_MODE = "EMBEDDED";
    private boolean embeddedMode = true;
    private static Driver loadedDriver = null;
    private String dbName = null;
    private String user = null;
    private String password = null;

    public JavaDBDataSource(String name, String dbName, String user, String password, String mode) throws Exception {
        Connection conn;
        if (user == null || password == null) {
            throw new Exception("User name and password must be defined.");
        }
        this.name = name;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
        log.finest("javadb ds: [name]" + name + ", [dbName]" + dbName + ", [user]" + user);
        String driver = "org.apache.derby.jdbc.EmbeddedDriver";
        if (mode != null && mode.equalsIgnoreCase(CLIENT_DRIVER_MODE)) {
            driver = "org.apache.derby.jdbc.ClientDriver";
            this.embeddedMode = false;
        }
        log.finest("javadb driver: " + driver);
        if (loadedDriver == null) {
            loadedDriver = (Driver)Class.forName(driver).newInstance();
        }
        if ((conn = this.getConnection()) != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.user == null || this.password == null) {
            return null;
        }
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String user, String passwd) throws SQLException {
        if (this.dbName == null || user == null || passwd == null) {
            return null;
        }
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", passwd);
        String protocol = "jdbc:derby:";
        Connection conn = DriverManager.getConnection(protocol + this.dbName, props);
        return conn;
    }

    @Override
    public Connection getProxyConnection(String type, Properties p) throws SQLException {
        return null;
    }

    @Override
    public void close() {
        if (this.embeddedMode && this.dbName != null) {
            try {
                DriverManager.getConnection("jdbc:derby:" + this.dbName + ";shutdown=true");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                    System.out.println("Derby shut down normally");
                }
                System.err.println("Derby did not shut down normally");
            }
        }
    }

    @Override
    public boolean supportOLS() {
        return false;
    }

    @Override
    public DataSource getUnwrappedDataSource() {
        return null;
    }

    @Override
    public String getUserInfoPackageName() {
        return null;
    }

    @Override
    public void setUserInfoPackageName(String pkgName) {
    }

    public static void destroy() {
        if (loadedDriver != null) {
            try {
                DriverManager.deregisterDriver(loadedDriver);
                loadedDriver = null;
            }
            catch (SQLException e) {
                log.warning(e.getMessage());
            }
        }
    }

    @Override
    public HashMap getMetaDataDefinition(String name, int type) {
        return null;
    }

    @Override
    public HashMap storeMetaDataDefinition(String name, int type, HashMap data) {
        return null;
    }

    @Override
    public HashMap deleteMetaData(String name, int type) {
        return null;
    }
}

