/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.ScaleBar;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.Spheroid;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.util.Util;

public class ScaleBarRenderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private ScaleBar definition = null;
    boolean geodetic;
    String unit;
    double earthDistance = -1.0;
    double edpp = 0.0;
    Spheroid spheroid = null;
    private String unitNameI;
    private String edDisplayI;
    private String edHalfDisplayI;
    private String unitNameU;
    private String edDisplayU;
    private double usMarker1Dist;
    private Rectangle2D mDeviceView;
    private Rectangle2D dataView;
    private int barHeight = 7;
    private int srid = 0;
    private String dataSource = null;
    private static NiceRange[] niceRanges = new NiceRange[]{new NiceRange(1.0E-4, 0.001, 1.0E-4), new NiceRange(0.001, 0.01, 0.001), new NiceRange(0.01, 0.1, 0.01), new NiceRange(0.1, 1.0, 0.1), new NiceRange(1.0, 10.0, 1.0), new NiceRange(10.0, 100.0, 10.0), new NiceRange(100.0, 1000.0, 100.0), new NiceRange(1000.0, 5000.0, 500.0), new NiceRange(5000.0, 100000.0, 1000.0), new NiceRange(100000.0, 1000000.0, 5000.0), new NiceRange(1000000.0, 1.0E7, 50000.0), new NiceRange(1.0E7, 1.0E8, 500000.0), new NiceRange(1.0E8, 1.0E9, 5000000.0), new NiceRange(1.0E9, 1.0E10, 5.0E7)};

    private ScaleBarRenderer() {
    }

    public ScaleBarRenderer(ScaleBar def, SRS srs, Rectangle2D dataMBR, Rectangle2D deviceMBR, String ds) {
        this.definition = def;
        this.earthDistance = 0.0;
        this.unit = srs.getUnit();
        this.geodetic = srs.isGeodetic();
        this.spheroid = srs.getSpheroid();
        this.srid = srs.getSRID();
        if (def.getLengthHint() == 0) {
            def.setLengthHint((int)(deviceMBR.getWidth() * 0.175));
        }
        this.mDeviceView = deviceMBR;
        this.dataView = dataMBR;
        this.dataSource = ds;
        this.determineEarthDistance(dataMBR, deviceMBR);
        this.setupDisplayInfo();
    }

    public ScaleBar getDefinition() {
        return this.definition;
    }

    public void setEarthDistance(double earthDistance) {
        this.earthDistance = earthDistance;
    }

    public double getEarthDistance() {
        return this.earthDistance;
    }

    public void setEDPP(double edpp) {
        this.edpp = edpp;
    }

    public double getEDPP() {
        return this.edpp;
    }

    private void determineEarthDistance(Rectangle2D dataMBR, Rectangle2D deviceMBR) {
        Double df_ = SRS.getDistanceConversionFactor(this.unit);
        if (df_ == null && !this.geodetic) {
            return;
        }
        double inMeter = -1.0;
        if (!this.geodetic && this.definition.getTransformToWGS84()) {
            try {
                dataMBR = this.convertMBR(dataMBR, this.srid, 8307, this.dataSource);
            }
            catch (Exception e) {
                double df = df_;
                inMeter = dataMBR.getHeight() * df;
            }
        }
        if (inMeter < 0.0 && (this.geodetic || this.definition.getTransformToWGS84())) {
            if (this.geodetic && this.spheroid == null) {
                return;
            }
            double[] p1 = new double[2];
            double[] p2 = new double[2];
            p1[0] = (dataMBR.getMinX() + dataMBR.getMaxX()) * 0.5 * (Math.PI / 180);
            p2[0] = p1[0];
            p1[1] = dataMBR.getMinY() * (Math.PI / 180);
            p2[1] = dataMBR.getMaxY() * (Math.PI / 180);
            inMeter = Util.dist(p1, p2, this.spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - this.spheroid.getEccentricity2()), this.spheroid.getFlattening());
        } else {
            double df = df_;
            inMeter = dataMBR.getHeight() * df;
        }
        this.edpp = inMeter / deviceMBR.getHeight();
        double barMeters = (double)this.definition.getLengthHint() * this.edpp;
        NiceRange range = this.findRange(barMeters);
        if (range == null) {
            this.earthDistance = -1.0;
            return;
        }
        this.earthDistance = this.findEarthDist(range, barMeters);
    }

    private NiceRange findRange(double barM) {
        for (int i = 0; i < niceRanges.length; ++i) {
            NiceRange r = niceRanges[i];
            if (!(barM >= r.min) || !(barM < r.max)) continue;
            return r;
        }
        log.warning("cannot find a suitable range for scalebar.");
        return null;
    }

    private double findEarthDist(NiceRange range, double barMeters) {
        double startV;
        for (double v = startV = range.min >= 10.0 ? 0.0 : range.min; v < range.max; v += range.increment) {
            double gap = barMeters - v;
            if (gap > range.increment) continue;
            double gap2 = v + range.increment - barMeters;
            return gap > gap2 ? v + range.increment : (v == 0.0 ? range.min : v);
        }
        return -1.0;
    }

    private String cleanup0s(String input) {
        int idx = input.indexOf(".");
        while (input.endsWith("0") && idx >= 0) {
            input = input.substring(0, input.length() - 1);
            idx = input.indexOf(".");
        }
        if (input.endsWith(".")) {
            input = input.substring(0, input.length() - 1);
        }
        return input;
    }

    private void setupDisplayInfo() {
        if (this.earthDistance < 0.0) {
            this.edDisplayI = "";
            this.edHalfDisplayI = "";
            this.unitNameI = "";
            return;
        }
        if (this.earthDistance > 100000.0) {
            int kms = (int)this.earthDistance / 1000;
            this.edDisplayI = "" + kms;
            this.edHalfDisplayI = "" + kms / 2;
            this.unitNameI = "km";
            int miles = (int)(this.earthDistance / 1609.344);
            miles = this.findFloor4Miles(miles);
            this.edDisplayU = "" + miles;
            this.usMarker1Dist = (double)miles * 1609.344;
            this.unitNameU = "mi";
        } else if (this.earthDistance > 10000.0) {
            double kms = this.earthDistance / 1000.0;
            this.edDisplayI = "" + kms;
            this.edDisplayI = this.cleanup0s(this.edDisplayI);
            this.edHalfDisplayI = "" + kms / 2.0;
            this.edHalfDisplayI = this.cleanup0s(this.edHalfDisplayI);
            this.unitNameI = "km";
            int miles = (int)(this.earthDistance / 1609.344);
            miles = this.findFloor4Miles(miles);
            this.edDisplayU = "" + miles;
            this.usMarker1Dist = (double)miles * 1609.344;
            this.unitNameU = "mi";
        } else if (this.earthDistance >= 1000.0) {
            this.edDisplayI = "" + new Integer((int)this.earthDistance);
            this.edHalfDisplayI = "" + new Integer((int)(this.earthDistance / 2.0));
            this.unitNameI = "m";
            if (this.earthDistance >= 1609.344) {
                int miles = (int)(this.earthDistance / 1609.344);
                miles = this.findFloor4Miles(miles);
                this.edDisplayU = "" + miles;
                this.usMarker1Dist = (double)miles * 1609.344;
                this.unitNameU = "mi";
            } else {
                double miles = this.earthDistance / 1609.344;
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                this.edDisplayU = "" + nf.format(miles);
                this.edDisplayU = this.cleanup0s(this.edDisplayU);
                try {
                    this.usMarker1Dist = nf.parse(this.edDisplayU).doubleValue() * 1609.344;
                }
                catch (Exception e) {
                    log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
                }
                this.unitNameU = "mi";
            }
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(4);
            this.edDisplayI = "" + nf.format(this.earthDistance);
            this.edHalfDisplayI = "" + nf.format(this.earthDistance / 2.0);
            try {
                this.earthDistance = nf.parse(this.edDisplayI).doubleValue();
            }
            catch (Exception e) {
                log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
            }
            this.edDisplayI = this.cleanup0s(this.edDisplayI);
            this.edHalfDisplayI = this.cleanup0s(this.edHalfDisplayI);
            this.unitNameI = "m";
            if (this.earthDistance >= 152.0) {
                double miles = this.earthDistance / 1609.344;
                nf.setMaximumFractionDigits(2);
                this.edDisplayU = "" + nf.format(miles);
                this.edDisplayU = this.cleanup0s(this.edDisplayU);
                try {
                    this.usMarker1Dist = nf.parse(this.edDisplayU).doubleValue() * 1609.344;
                }
                catch (Exception e) {
                    log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
                }
                this.unitNameU = "mi";
            } else if (this.earthDistance >= 0.3048) {
                int feet = (int)(this.earthDistance / 0.3048);
                feet = this.findFloor4Miles(feet);
                this.edDisplayU = "" + feet;
                this.usMarker1Dist = (double)feet * 0.3048;
                this.unitNameU = "ft";
            } else {
                double inches = this.earthDistance / 0.0254;
                nf.setMaximumFractionDigits(2);
                this.edDisplayU = "" + nf.format(inches);
                this.edDisplayU = this.cleanup0s(this.edDisplayU);
                try {
                    this.usMarker1Dist = nf.parse(this.edDisplayU).doubleValue() * 0.0254;
                }
                catch (Exception e) {
                    log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
                }
                this.unitNameU = "in";
            }
        }
    }

    private int findFloor4Miles(int miles) {
        if (miles <= 10) {
            return miles;
        }
        if (miles > 10 && miles <= 100) {
            int digit1 = miles % 10;
            return miles - digit1;
        }
        if (miles > 100 && miles <= 1000) {
            int digit12 = miles % 100;
            miles -= digit12;
            if (digit12 > 50) {
                miles += 50;
            }
            return miles;
        }
        int digit123 = miles % 1000;
        miles -= digit123;
        if (digit123 > 500) {
            miles += 500;
        }
        return miles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderScaleBar(Graphics2D g) {
        if (this.earthDistance < 0.0 || this.edpp == 0.0) {
            log.warning("cannot render scale bar.");
            return;
        }
        int barLen = (int)(this.earthDistance / this.edpp);
        double[] sp = this.determineLocation(barLen);
        AffineTransform af = g.getTransform();
        g.setTransform(AffineTransform.getTranslateInstance(sp[0], sp[1]));
        try {
            int x0 = 0;
            int y = 0;
            int x1 = x0 + barLen / 4;
            int x2 = x0 + barLen / 2;
            StyleText st = new StyleText(this.definition.getLabelFont(), this.definition.getLabelColor(), this.definition.getLabelHaloSize());
            if ("METRIC_MODE".equals(this.definition.getMode())) {
                this.renderMetricBar(g, x0, x1, x2, y, barLen, st);
            } else if ("US_MODE".equals(this.definition.getMode())) {
                this.renderUSBar(g, x0, y, barLen, st);
            } else {
                this.renderUSBar(g, x0, y, barLen, st);
                this.renderMetricBar(g, x0, x1, x2, y, barLen, st);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            g.setTransform(af);
        }
    }

    private void renderMetricBar(Graphics2D g, int x0, int x1, int x2, int y, int barLen, StyleText st) throws StyleNotApplicableException {
        int h = this.barHeight;
        int fontSz = this.definition.getLabelFont().getSize();
        float halosize = this.definition.getLabelHaloSize();
        if (this.definition.getMode().equals("DUAL_MODES")) {
            st.apply(g, x0, (float)(y + h * 2) + ((float)fontSz + halosize) / 2.0f + 2.0f, LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.unitNameI, null);
            st.apply(g, x0 + barLen, (float)(y + h * 2) + ((float)fontSz + halosize) / 2.0f + 2.0f, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edDisplayI, null);
            y += h;
        } else if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
            st.apply(g, x0, (int)((float)(y + h) + ((float)fontSz + halosize) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            st.apply(g, x0 + barLen - fontSz, (int)((float)(y + h) + ((float)fontSz + halosize) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayI + " " + this.unitNameI, null);
        } else {
            st.apply(g, x0, (int)((float)y - ((float)fontSz + halosize) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            st.apply(g, x0 + barLen - fontSz, (int)((float)y - ((float)fontSz + halosize) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayI + " " + this.unitNameI, null);
        }
        if (barLen > 75) {
            g.setStroke(new BasicStroke(0.8f));
            g.setColor(this.definition.getColor1());
            g.fillRect(x0, y, barLen / 4 + 1, h);
            g.setColor(this.definition.getColor2());
            g.fillRect(x1, y, barLen / 4 + 1, h);
            g.setColor(this.definition.getColor1());
            g.fillRect(x2, y, barLen / 2, h);
            g.setColor(Color.black);
            g.drawRect(x0, y, barLen - 1, h);
            g.drawLine(x1, y, x1, y + h);
            g.drawLine(x2, y, x2, y + h);
            if (this.definition.getMode().equals("METRIC_MODE")) {
                if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
                    st.apply(g, x0 + barLen / 2, (int)((float)(y + h) + ((float)fontSz + halosize) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edHalfDisplayI, null);
                } else {
                    st.apply(g, x0 + barLen / 2, (int)((float)y - ((float)fontSz + halosize) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edHalfDisplayI, null);
                }
            } else {
                st.apply(g, x0 + barLen / 2, (int)((float)(y + h) + ((float)fontSz + halosize) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edHalfDisplayI, null);
            }
        } else {
            g.setStroke(new BasicStroke(0.8f));
            g.setColor(this.definition.getColor2());
            g.fillRect(x0, y, barLen, h);
            g.setColor(Color.black);
            g.drawRect(x0, y, barLen - 1, h);
        }
    }

    private void renderUSBar(Graphics2D g, int x0, int y, int barLen, StyleText st) throws StyleNotApplicableException {
        int h = this.barHeight;
        int fontSz = this.definition.getLabelFont().getSize();
        int markerLen = (int)(this.usMarker1Dist / this.edpp);
        float halosize = this.definition.getLabelHaloSize();
        if (this.definition.getMode().equals("DUAL_MODES")) {
            st.apply(g, x0, (int)((float)y - ((float)fontSz + halosize) / 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.unitNameU, null);
            st.apply(g, x0 + markerLen, (int)((float)y - ((float)fontSz + halosize) / 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edDisplayU, null);
        } else if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
            st.apply(g, x0, (int)((float)(y + h) + ((float)fontSz + halosize) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            st.apply(g, x0 + markerLen - fontSz, (int)((float)(y + h) + ((float)fontSz + halosize) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayU + " " + this.unitNameU, null);
        } else {
            st.apply(g, x0, (int)((float)y - ((float)fontSz + halosize) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            st.apply(g, x0 + markerLen - fontSz, (int)((float)y - ((float)fontSz + halosize) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayU + " " + this.unitNameU, null);
        }
        g.setStroke(new BasicStroke(0.8f));
        g.setColor(this.definition.getColor2());
        g.fillRect(x0, y, markerLen, h);
        if (this.definition.getMode().equals("DUAL_MODES")) {
            g.setColor(this.definition.getColor1());
            g.fillRect(x0 + markerLen, y, barLen - markerLen, h);
        }
        if (this.definition.getMode().equals("DUAL_MODES")) {
            g.setColor(Color.black);
            g.drawRect(x0, y, barLen - 1, h);
            if (x0 + markerLen < x0 + barLen - 1) {
                g.drawLine(x0 + markerLen, y, x0 + markerLen, y + h);
            }
        } else {
            g.setColor(Color.black);
            g.drawRect(x0, y, markerLen - 1, h);
        }
    }

    private double[] determineLocation(int barLength) {
        double sx = 0.0;
        double sy = 0.0;
        double w = barLength;
        double h = this.barHeight;
        int fs = this.definition.getLabelFont().getSize();
        double xpad = 10.0;
        if (this.definition.getOffsetX() > 0) {
            xpad = this.definition.getOffsetX();
        }
        double ypad = 10.0;
        if (this.definition.getOffsetY() > 0) {
            ypad = this.definition.getOffsetY();
        }
        String pos = this.definition.getPosition();
        float halosize = this.definition.getLabelHaloSize();
        if (halosize < 0.0f) {
            halosize = 0.0f;
        }
        sx = this.mDeviceView.getWidth() / 2.0 - w / 2.0 - (double)(fs * 2);
        if (pos.indexOf("NORTH") >= 0) {
            sy = Math.rint((float)this.definition.getLabelFont().getSize() + halosize + 2.0f + (float)ypad);
            if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition()) && !this.definition.getMode().equalsIgnoreCase("DUAL_MODES")) {
                sy = ypad;
            }
        } else if (pos.indexOf("SOUTH") >= 0) {
            if (this.definition.getMode().equalsIgnoreCase("DUAL_MODES")) {
                sy = Math.rint(this.mDeviceView.getHeight() - 2.0 * h - (double)((float)fs + halosize) - 2.0 - ypad);
            } else {
                sy = Math.rint(this.mDeviceView.getHeight() - h - (double)((float)fs + halosize) - 2.0 - ypad);
                if (!"BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
                    sy = this.mDeviceView.getHeight() - h - ypad;
                }
            }
        }
        if (pos.indexOf("EAST") >= 0) {
            String rhs = "";
            if (this.definition.getMode().equals("DUAL_MODES")) {
                String rhsI = this.edDisplayI;
                String rhsU = this.edDisplayU;
                rhs = rhsI.length() > rhsU.length() ? rhsI : rhsU;
            } else {
                rhs = this.definition.getMode().equals("METRIC_MODE") ? this.edDisplayI + " " + this.unitNameI : this.edDisplayU + " " + this.unitNameU;
            }
            int nchars = rhs.length() <= 2 ? 1 : rhs.length() - 2;
            sx = this.mDeviceView.getWidth() - w - xpad - (double)(fs * nchars);
        } else if (pos.indexOf("WEST") >= 0) {
            sx = xpad;
        }
        return new double[]{sx, sy};
    }

    public double getEdpp() {
        return this.edpp;
    }

    public String getUnitNameI() {
        return this.unitNameI;
    }

    public String getEdDisplayI() {
        return this.edDisplayI;
    }

    public String getEdHalfDisplayI() {
        return this.edHalfDisplayI;
    }

    public String getUnitNameU() {
        return this.unitNameU;
    }

    public double getUsMarker1Dist() {
        return this.usMarker1Dist;
    }

    public String getEdDisplayU() {
        return this.edDisplayU;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    private Rectangle2D convertMBR(Rectangle2D mbr, int fromSrid, int toSrid, String dataSource) throws Exception {
        Connection conn = null;
        conn = DSUtil.getDBConnection(dataSource, null);
        if (conn.isClosed()) {
            log.severe("connection obtained is already closed!");
            throw new Exception("error obtaining connection!");
        }
        double[] inMbr = new double[]{mbr.getMinX(), mbr.getMinY(), mbr.getMaxX(), mbr.getMaxY()};
        double[] outMbr = Util.convertMBR(inMbr, fromSrid, toSrid, conn);
        return new Rectangle2D.Double(outMbr[0], outMbr[1], outMbr[2] - outMbr[0], outMbr[3] - outMbr[1]);
    }

    private static class NiceRange {
        public double min;
        public double max;
        public double increment;

        public NiceRange(double i, double a, double x) {
            this.min = i;
            this.max = a;
            this.increment = x;
        }
    }
}

