/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.xdo.generator.graphics2d.XDOGraphics2D;

public class PDFTTFcache {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String ttfTempDir = null;
    static Hashtable<String, String> ttfRegs = new Hashtable();

    public static void setTemporaryDirectory(String dir) {
        ttfTempDir = dir == null ? null : (!dir.endsWith("" + File.separator) ? dir + File.separator : dir);
    }

    public static String getTemporaryDirectory() {
        return ttfTempDir;
    }

    public static void cleanCache() {
        File f;
        ttfRegs.clear();
        if (ttfTempDir != null && (f = new File(ttfTempDir)) != null && f.isDirectory()) {
            try {
                File[] files = f.listFiles();
                if (files != null && files.length > 0) {
                    for (int j = 0; j < files.length; ++j) {
                        if (files[j].isDirectory() || !files[j].canWrite() || !files[j].getName().endsWith(".ttf")) continue;
                        files[j].delete();
                    }
                }
            }
            catch (Exception e) {
                log.warning("Unable to delete all temporary TTFs.\n" + e.getMessage());
            }
        }
    }

    public static void cleanCacheForDataSource(String datasource) {
        File f;
        String key;
        if (datasource == null) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        Enumeration<String> e = ttfRegs.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            String value = ttfRegs.get(key);
            File f2 = new File(value);
            if (f2 == null || !f2.getName().startsWith(datasource.toLowerCase() + "_")) continue;
            toRemove.add(key);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            key = (String)toRemove.get(i);
            ttfRegs.remove(key);
        }
        if (ttfTempDir != null && (f = new File(ttfTempDir)) != null && f.isDirectory()) {
            try {
                File[] files = f.listFiles();
                if (files != null && files.length > 0) {
                    for (int j = 0; j < files.length; ++j) {
                        if (files[j].isDirectory() || !files[j].canWrite() || !files[j].getName().startsWith(datasource.toLowerCase() + "_") || !files[j].getName().endsWith(".ttf")) continue;
                        files[j].delete();
                    }
                }
            }
            catch (Exception e2) {
                log.warning("Unable to delete all temporary TTFs for data source [" + datasource + "].\n" + e2.getMessage());
            }
        }
    }

    public static String getFilePathForTTF(String ttfName) {
        if (ttfName == null) {
            return null;
        }
        return ttfRegs.get(ttfName);
    }

    public static boolean registerTTF(String ttfName, String fileName, XDOGraphics2D g2dPdf) {
        if (ttfName == null || ttfTempDir == null || fileName == null || g2dPdf == null) {
            return false;
        }
        ttfRegs.put(ttfName, ttfTempDir + fileName);
        log.finest("TTF font [" + ttfName + "] registered with temporary file [" + ttfTempDir + fileName + "] for PDF graphics.");
        g2dPdf.registerFont(ttfName, ttfTempDir + fileName);
        return true;
    }
}

