/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.stylex.HeatMapStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.LoadThemeData2;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.sam.HeatMapCore;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.stylex.HeatMapStyleModifiers;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.util.Util;

public class HeatMapRenderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static void renderHeatMap(Graphics2D g2, Theme t, VisContext vc) {
        log.finest("Heat map processing started for theme " + t.getName() + ".");
        long t0 = System.currentTimeMillis();
        HeatMapStyle style = HeatMapRenderer.getStyle(t, vc);
        if (style == null) {
            log.warning("Heat map style not found or null.");
            return;
        }
        if (t.size() == 0) {
            log.finest("No data points found.");
            return;
        }
        HeatMapStyleModel model = (HeatMapStyleModel)style.getModel();
        Rectangle2D devRect = vc.getDeviceWindow();
        double gridSampleFactor = model.getGridSampleFactor();
        int gridWidth = (int)(devRect.getWidth() / gridSampleFactor);
        int gridHeight = (int)(devRect.getHeight() / gridSampleFactor);
        double splRadius = model.getSpotLightRadius();
        HeatMapStyleModifiers hmmods = (HeatMapStyleModifiers)style.convertToPixelSize(vc);
        if (hmmods != null) {
            splRadius = hmmods.getSpotLightRadius();
        }
        log.finest("Heat map info: grid width=" + gridWidth + ",grid height=" + gridHeight + ", spotlight radius=" + splRadius);
        HeatMapCore core = new HeatMapCore(gridWidth, gridHeight, model, splRadius);
        core.setDataTheme(t, vc);
        core.setCoordBounds(devRect.getMinX(), devRect.getMaxX(), devRect.getMinY(), devRect.getMaxY());
        try {
            core.computeHeatMap();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error while computing heat map for theme: " + t.getName() + ".", ex);
            return;
        }
        HeatMapRenderer.drawComputedHeatMap(g2, core, model, vc, splRadius);
        long t1 = System.currentTimeMillis();
        log.finest("Total time spent computing and rendering heat map for theme " + t.getName() + ": " + (t1 - t0) + "ms.");
        log.finest("Heat map processing completed for theme " + t.getName() + "...");
    }

    private static HeatMapStyle getStyle(Theme t, VisContext vc) {
        StyledFeatureI sf;
        ThemeDefinition td = t.getDefinition();
        ThemeStyleInfo[] styles = td.getStyleList(vc);
        if (styles == null) {
            return null;
        }
        for (int i = 0; i < styles.length; ++i) {
            String styName;
            Style sty;
            ThemeStyleInfo si = styles[i];
            if (!si.isRendering() || (sty = MapMaker.getStyleWithName(styName = si.getName(), td.getDataSourceName(), vc)) == null || !(sty instanceof HeatMapStyle)) continue;
            return (HeatMapStyle)sty;
        }
        try {
            sf = t.getStyledFeature(0);
            if (sf == null) {
                return null;
            }
        }
        catch (Exception ex) {
            log.warning("cannot get a styled feature from theme " + t.getName());
            return null;
        }
        Style sty = sf.getFeatureStyle();
        if (sty == null) {
            sty = MapMaker.getStyleWithName(sf.getFeatureStyleName(), sf.getDataSource(), vc);
        }
        if (sty == null) {
            return null;
        }
        return (HeatMapStyle)sty;
    }

    private static double[][] getEventPoints(Theme t, VisContext vc) {
        StyledFeatureI sf = null;
        ArrayList<double[]> al = new ArrayList<double[]>(t.size());
        for (int i = 0; i < t.size(); ++i) {
            Point2D pt;
            sf = t.getStyledFeature(i);
            if (sf == null || !VectorRenderer.visible(sf, vc.getQueryWindow()) || (pt = VectorRenderer.getPointOfPointFeature(sf, vc)) == null) continue;
            double[] _pt = new double[]{pt.getX(), pt.getY()};
            al.add(_pt);
        }
        double[][] res = new double[al.size()][];
        for (int i = 0; i < al.size(); ++i) {
            res[i] = (double[])al.get(i);
        }
        log.finest("Heat map theme " + t.getName() + " contains " + res.length + " points.");
        return res;
    }

    public static void drawComputedHeatMap(Graphics2D g2, HeatMapCore heatMap, HeatMapStyleModel model, VisContext vc, double t) {
        BufferedImage imageA = null;
        BufferedImage imageB = null;
        BufferedImage imageC = null;
        Color[] gradiant = model.createGradientColors();
        imageA = HeatMapRenderer.drawData(heatMap, gradiant, t);
        imageB = HeatMapRenderer.drawMaskTheme(model.getContainerThemeName(), vc);
        imageC = imageB != null ? HeatMapRenderer.masking(imageA, imageB) : imageA;
        g2.drawImage((Image)imageC, 0, 0, null);
        if (imageA != null) {
            imageA.flush();
            imageA = null;
        }
        if (imageB != null) {
            imageB.flush();
            imageB = null;
        }
        if (imageC != null) {
            imageC.flush();
            imageC = null;
        }
    }

    private static BufferedImage drawData(HeatMapCore heatMap, Color[] gradiant, double t) {
        BufferedImage bufferedImage = new BufferedImage(heatMap.getGridWidth(), heatMap.getGridHeight(), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        long errorCount = 0L;
        if (heatMap.getStyleModel().getMethod() == 3) {
            int y;
            int x;
            double[][] grid = heatMap.getGrid();
            for (x = 0; x < heatMap.getGridWidth(); ++x) {
                for (y = 0; y < heatMap.getGridHeight(); ++y) {
                    HeatMapRenderer.drawAlpha(x, y, grid[x][y], t, heatMap.getMaxGridCellValue(), g2);
                }
            }
            for (x = 0; x < heatMap.getGridWidth(); ++x) {
                for (y = 0; y < heatMap.getGridHeight(); ++y) {
                    int rgb = bufferedImage.getRGB(x, y);
                    Color c = new Color(rgb);
                    int alpha = c.getAlpha();
                    alpha = rgb >>> 24;
                    if (alpha < 0) {
                        alpha = 0;
                    }
                    if (alpha >= gradiant.length) {
                        alpha = gradiant.length - 1;
                    }
                    g2.setColor(gradiant[alpha]);
                    g2.fillRect(x, y, 1, 1);
                }
            }
        } else {
            for (int x = 0; x < heatMap.getGridWidth(); ++x) {
                for (int y = 0; y < heatMap.getGridHeight(); ++y) {
                    Color c = heatMap.getMatchingColor(x, y, gradiant, t);
                    if (c == null) {
                        c = Color.gray;
                        if (errorCount < 10L) {
                            log.warning("invalid data range found.");
                        } else if (errorCount == 10L) {
                            log.warning("invalid data range found. hiding more warnings like this... ");
                        }
                        ++errorCount;
                    }
                    g2.setColor(c);
                    g2.fillRect((int)Math.ceil(x), (int)Math.ceil(y), 1, 1);
                }
            }
        }
        g2.dispose();
        return bufferedImage;
    }

    private static void drawAlpha(int x, int y, double count, double radius, double max, Graphics2D g2) {
        if (count == 0.0) {
            return;
        }
        RadialGradientPaint p = new RadialGradientPaint(new Point2D.Double(x, y), (int)radius, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, (float)(count / max)), new Color(0.0f, 0.0f, 0.0f, 0.0f)});
        int xb = (int)((double)x - radius);
        int yb = (int)((double)y - radius);
        int mul = (int)(2.0 * radius);
        g2.setPaint(p);
        g2.fillRect(xb, yb, mul, mul);
    }

    private static BufferedImage drawMaskTheme(String themeName, VisContext vc) {
        String dataSrc = vc.getMasterDataSourceName();
        try {
            Theme t = ThemeUtils.loadPredefinedGeometryTheme(themeName, dataSrc, vc);
            if (t == null) {
                log.severe("Cannot load predefined geom theme " + themeName + " from data source " + dataSrc + ".");
                return null;
            }
            Rectangle2D box = vc.getQueryWindow();
            LoadThemeData2 td = new LoadThemeData2(t, box, vc);
            td.run();
            StyledFeatureI[] features = t.getStyledFeatures();
            HeatMapRenderer.forceBlackStyle(features);
            return HeatMapRenderer.renderMaskThemeFeatures(features, vc);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception loading or rendering heat map container theme.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Rectangle2D validateQueryBox(Rectangle2D box, Theme t, VisContext vc, String dataSrc) {
        int themeSrid = t.getDefinition().getSrid();
        int masterSrid = vc.getMasterSRID();
        if (masterSrid == themeSrid || box == null) {
            return box;
        }
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(dataSrc, vc);
            if (conn == null) {
                vc.processDataError(null, log, "Cannot obtain connection for data source: " + dataSrc + ". Max connection limit reached?");
                return box;
            }
        }
        catch (Exception ex) {
            log.severe("Exception when obtaining connection for data source: " + dataSrc);
            return box;
        }
        boolean isOracleDB = true;
        try {
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                isOracleDB = false;
            }
            if (!isOracleDB) {
                log.warning("Non-Oracle DB found; no query window transformation will be performed.");
                Rectangle2D rectangle2D = box;
                return rectangle2D;
            }
            double[] inmbr = new double[]{box.getMinX(), box.getMinY(), box.getMaxX(), box.getMaxY()};
            log.log(Level.FINEST, "Query box to be transformed from " + masterSrid + " to " + themeSrid + " (" + box.getMinX() + "," + box.getMinY() + " " + box.getMaxX() + "," + box.getMaxY() + ")");
            double[] outmbr = Util.convertMBR(inmbr, masterSrid, themeSrid, conn);
            if (outmbr != null) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(outmbr[0], outmbr[1], outmbr[2] - outmbr[0], outmbr[3] - outmbr[1]);
                return double_;
            }
            Rectangle2D rectangle2D = box;
            return rectangle2D;
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            Rectangle2D rectangle2D = box;
            return rectangle2D;
        }
        finally {
            if (conn != null) {
                DSUtil.closeDBConnection(conn, dataSrc);
            }
        }
    }

    private static void forceBlackStyle(StyledFeatureI[] features) {
        if (features == null || features.length == 0) {
            return;
        }
        StyleColor black = new StyleColor(Color.black, Color.black);
        for (int i = 0; i < features.length; ++i) {
            StyledFeatureI sf = features[i];
            if (sf == null) continue;
            sf.setFeatureStyleName(null);
            sf.setFeatureStyle(black);
        }
    }

    private static BufferedImage renderMaskThemeFeatures(StyledFeatureI[] features, VisContext vc) {
        int w = (int)vc.getDeviceWindow().getWidth();
        int h = (int)vc.getDeviceWindow().getHeight();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        Color bg = new Color(0, 0, 0, 0);
        g2.setBackground(bg);
        g2.clearRect(0, 0, w, h);
        boolean aa = vc.getAntialiasing();
        if (aa) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        for (int i = 0; i < features.length; ++i) {
            StyledFeature sf = (StyledFeature)features[i];
            if (sf == null) continue;
            try {
                VectorRenderer.renderStyledFeature(g2, sf, vc);
                continue;
            }
            catch (Exception ex) {
                log.warning("Exception rendering a feature. Msg: " + ex.getMessage() + ".");
            }
        }
        g2.dispose();
        return img;
    }

    public static BufferedImage masking(BufferedImage heatMapImg, BufferedImage maskImg) {
        int w = maskImg.getWidth();
        int h = maskImg.getHeight();
        BufferedImage tempImg = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)tempImg.getGraphics();
        g2.drawImage(heatMapImg, 0, 0, w, h, 0, 0, heatMapImg.getWidth(), heatMapImg.getHeight(), null);
        g2.dispose();
        int[] rgbim1 = new int[w];
        int[] rgbim2 = new int[w];
        for (int row = 0; row < h; ++row) {
            tempImg.getRGB(0, row, w, 1, rgbim1, 0, w);
            maskImg.getRGB(0, row, w, 1, rgbim2, 0, w);
            for (int col = 0; col < w; ++col) {
                int rgb2 = rgbim2[col];
                if (rgb2 != 0) continue;
                rgbim1[col] = 0;
            }
            tempImg.setRGB(0, row, w, 1, rgbim1, 0, w);
        }
        return tempImg;
    }
}

