/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomImageRenderer;
import oracle.sdovis.CustomLogo;
import oracle.sdovis.style.Style;

public class GlobalVisContext {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static int dpi = 96;
    static CustomLogo logo;
    static Hashtable customImageRenderers;
    static boolean showQueryWindow;
    static boolean reorientOrdinates;
    static boolean fastUnpickle;
    static boolean ugp;
    static String footnoteFont;
    static String footnoteText;
    static String footnotePosition;
    static Style footnoteStyle;
    static String titleFont;
    static String titleText;
    static String titlePosition;
    static Style titleStyle;
    static Hashtable dsrcGlobalParams;

    public static int getDPI() {
        return dpi;
    }

    public static boolean getUgp() {
        return ugp;
    }

    public static void setUgp(boolean v) {
        ugp = v;
    }

    public static CustomLogo getLogo() {
        return logo;
    }

    public static CustomLogo getLogo(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.logo;
    }

    public static void setLogo(CustomLogo _logo) {
        logo = _logo;
    }

    public static void setLogo(String dataSource, CustomLogo _logo) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.logo = _logo;
    }

    public static void setLogo(String datasource, String file, String position) {
        if (datasource == null) {
            return;
        }
        try {
            GlobalVisContext.setLogo(datasource, new CustomLogo(file, position));
        }
        catch (Exception e) {
            log.severe("error setting data source global logo");
        }
    }

    public static void addCustomImageRenderer(String key, CustomImageRenderer r) {
        customImageRenderers.put(key, r);
    }

    public static CustomImageRenderer findCustomImageRenderer(String format) {
        if (format == null || format.length() == 0 || customImageRenderers == null || customImageRenderers.size() == 0) {
            return null;
        }
        Enumeration enumer = customImageRenderers.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            if (!format.equalsIgnoreCase(key)) continue;
            return (CustomImageRenderer)customImageRenderers.get(key);
        }
        return null;
    }

    public static boolean getReorientGeomOridnates() {
        return reorientOrdinates;
    }

    public static void setReorientGeomOrdinates(boolean v) {
        reorientOrdinates = v;
    }

    public static boolean getFastUnpickle() {
        return fastUnpickle;
    }

    public static void setFastUnpickle(boolean v) {
        fastUnpickle = v;
    }

    public static void setGlobalMapTitle(String t) {
        titleText = t;
    }

    public static String getGlobalMapTitle() {
        return titleText;
    }

    public static void setGlobalMapTitleFont(String name) {
        titleFont = name;
    }

    public static String getGlobalMaptitleFont() {
        return titleFont;
    }

    public static void setGlobalMapTitlePos(String pos) {
        titlePosition = pos;
    }

    public static String getGlobalMapTitlePos() {
        return titlePosition;
    }

    public static Style getGlobalMapTitleStyle() {
        return titleStyle;
    }

    public static void setGlobalMapTitleStyle(Style s) {
        titleStyle = s;
    }

    public static void setGlobalMapFootnote(String t) {
        footnoteText = t;
    }

    public static String getGlobalMapFootnote() {
        return footnoteText;
    }

    public static void setGlobalMapFootnoteFont(String name) {
        footnoteFont = name;
    }

    public static String getGlobalMapFootnoteFont() {
        return footnoteFont;
    }

    public static void setGlobalMapFootnotePos(String pos) {
        footnotePosition = pos;
    }

    public static String getGlobalMapFootnotePos() {
        return footnotePosition;
    }

    public static void setGlobalMapFootnoteStyle(Style s) {
        footnoteStyle = s;
    }

    public static Style getGlobalMapFootnoteStyle() {
        return footnoteStyle;
    }

    public static boolean getShowQueryWindow() {
        return showQueryWindow;
    }

    public static void setShowQueryWindow(boolean v) {
        showQueryWindow = v;
    }

    public static void setGlobalMapTitle(String dataSource, String t) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.titleText = t;
    }

    public static String getGlobalMapTitle(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.titleText;
    }

    public static void setGlobalMapTitleFont(String dataSource, String name) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.titleFont = name;
    }

    public static String getGlobalMaptitleFont(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.titleFont;
    }

    public static void setGlobalMapTitlePos(String dataSource, String pos) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.titlePosition = pos;
    }

    public static String getGlobalMapTitlePos(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.titlePosition;
    }

    public static void setGlobalMapFootnote(String dataSource, String t) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.footnoteText = t;
    }

    public static String getGlobalMapFootnote(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.footnoteText;
    }

    public static void setGlobalMapFootnoteFont(String dataSource, String name) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.footnoteFont = name;
    }

    public static String getGlobalMapFootnoteFont(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.footnoteFont;
    }

    public static void setGlobalMapFootnotePos(String dataSource, String pos) {
        if (dataSource == null) {
            return;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            params = new DatasourceGlobalParams();
            dsrcGlobalParams.put(dataSource.toUpperCase(), params);
        }
        params.footnotePosition = pos;
    }

    public static String getGlobalMapFootnotePos(String dataSource) {
        if (dataSource == null) {
            return null;
        }
        DatasourceGlobalParams params = (DatasourceGlobalParams)dsrcGlobalParams.get(dataSource.toUpperCase());
        if (params == null) {
            return null;
        }
        return params.footnotePosition;
    }

    static {
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Throwable ex) {
            log.warning("will use 96 as default dpi.");
        }
        customImageRenderers = new Hashtable(5);
        reorientOrdinates = true;
        fastUnpickle = false;
        ugp = false;
        footnoteFont = "Sans Serif";
        footnoteText = null;
        footnotePosition = "SOUTH_EAST";
        footnoteStyle = null;
        titleFont = "Dialog";
        titleText = null;
        titlePosition = "NORTH";
        titleStyle = null;
        dsrcGlobalParams = new Hashtable();
    }

    private static class DatasourceGlobalParams {
        public CustomLogo logo = null;
        public String footnoteFont = "Sans Serif";
        public String footnoteText = null;
        public String footnotePosition = "SOUTH_EAST";
        public String titleFont = "Dialog";
        public String titleText = null;
        public String titlePosition = "NORTH";
    }
}

