/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Theme;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeProducer;
import oracle.sdovis.util.Util;

public class DynamicGeometryTheme
extends Theme {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public DynamicGeometryTheme(String name, String dataSrc, String query, String spatialCol, String srid, String featureStyleName, String labelCol, String labelStyleName, boolean passThrough) {
        if (!Util.isQueryAllowed(query)) {
            throw new IllegalArgumentException("Invalid query type!.");
        }
        DynGeomThemeDefinition def = new DynGeomThemeDefinition();
        this.setDefinition(def);
        this.setProducer(new DynGeomThemeProducer(this));
        def.setName(name);
        def.setDataSourceName(dataSrc);
        def.setQuery(query);
        def.setSpatialColumn(spatialCol);
        def.setLabelColumn(labelCol);
        def.setFeatureStyleName(featureStyleName);
        def.setLabelStyleName(labelStyleName);
        def.setPassthrough(passThrough);
        if (labelCol != null && labelCol.indexOf(46) >= 0) {
            int idx = labelCol.indexOf(46);
            labelCol = labelCol.substring(idx + 1, labelCol.length());
            def.setLabelColumn(labelCol);
            log.finer("label column cannot have schema name in it; changing to: " + labelCol);
        }
        int id = 0;
        try {
            id = Integer.parseInt(srid);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        def.setSrid(id);
        DBDataSource db = (DBDataSource)DSManager.get(dataSrc);
        def.set9i(db.is9i());
        log.finest("new DynGeomTheme [name=" + name + ",query=" + query + ",spatialCol=" + spatialCol + ", srid=" + srid + ", featureStyleName=" + featureStyleName + ", labelCol=" + labelCol + ", labelStyleName=" + labelStyleName + ", passthrough=" + passThrough);
    }

    public DynamicGeometryTheme(DynGeomThemeDefinition def, Object[] bindingParameters) {
        int bn;
        if (bindingParameters != null) {
            for (int i = 0; i < bindingParameters.length; ++i) {
                if (Util.isBindingParameterAllowed(bindingParameters[i])) continue;
                throw new IllegalArgumentException(bindingParameters[i] + ":Invalid binding variable!.");
            }
        }
        int n = bn = bindingParameters == null ? 0 : bindingParameters.length;
        if (def.getBindingVariablesNumber() > bn) {
            throw new IllegalArgumentException("Not enough binding variables!.");
        }
        this.setDefinition(def);
        this.setProducer(new DynGeomThemeProducer(this, bindingParameters));
    }

    public DynamicGeometryTheme(DynGeomThemeDefinition def) {
        this.setDefinition(def);
        this.setProducer(new DynGeomThemeProducer(this));
    }

    @Override
    public void destroy() {
        this.decorator = null;
        this.producer.destroy();
        this.definition = null;
    }

    @Override
    public boolean isTextLabelPresent() {
        DynGeomThemeDefinition def = (DynGeomThemeDefinition)this.definition;
        return def.getLabelColumn() != null && def.getLabelStyleName() != null;
    }

    public String getFeatureStyleName() {
        DynGeomThemeDefinition def = (DynGeomThemeDefinition)this.definition;
        return def.getFeatureStyleName();
    }

    public String getLabelStyleName() {
        DynGeomThemeDefinition def = (DynGeomThemeDefinition)this.definition;
        return def.getLabelStyleName();
    }
}

