/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.util.ArrayList;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class LineStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 5937298410199783196L;
    Color fillColor = null;
    SizeDefinition lineWidth = new SizeDefinition(1.0, null);
    int cap = 1;
    int join = 1;
    float[] wingDashPattern = null;
    String wingDashPatternUnit = null;
    SizeDefinition wingWidth = new SizeDefinition(0.0, null);
    float wingPhase = 0.0f;
    Color wingColor = null;
    Color centerLineColor = null;
    float[] centerLineDashPattern = null;
    String centerLineDashPatternUnit = null;
    float centerLinePhase = 0.0f;
    SizeDefinition centerLineWidth = new SizeDefinition(1.0, null);
    boolean hashMarkEnabled = false;
    Color hashMarkColor = Color.black;
    float hashMarkGap = 8.5f;
    float hashMarkLength = 3.0f;
    float hashMarkWidth = 1.0f;
    String hashMarkUnit = null;
    double markerPosition = 0.75;
    String markerStyleName = null;
    SizeDefinition2D markerSize = new SizeDefinition2D(-1.0, -1.0, null);
    public static String MULTIMARKER_NONE = "NONE";
    public static String MULTIMARKER_ALONG_PATH = "ALONG_PATH";
    public static String MULTIMARKER_END_POINTS = "END_POINTS";
    public static String MULTIMARKER_ALL_POINTS = "ALL_POINTS";
    String multipleMarkerPosition = MULTIMARKER_NONE;
    boolean cased = false;
    String[] mpMarkerStyles = null;
    SizeDefinition mpStartingOffset = new SizeDefinition(0.0, null);
    SizeDefinition mpInterval = new SizeDefinition(5.0, null);
    SizeDefinition2D mpMarkerSize = new SizeDefinition2D(-1.0, -1.0, null);

    public LineStyleModel() {
        this.type = 3;
    }

    @Override
    public Object clone() {
        LineStyleModel obj = (LineStyleModel)super.clone();
        if (this.centerLineDashPattern != null) {
            obj.centerLineDashPattern = (float[])this.centerLineDashPattern.clone();
        }
        if (this.wingDashPattern != null) {
            obj.wingDashPattern = (float[])this.wingDashPattern.clone();
        }
        obj.setLineWidth(this.lineWidth);
        obj.setCenterLineWidth(this.centerLineWidth);
        obj.setWingWidth(this.wingWidth);
        obj.setMarkerSize(this.markerSize);
        obj.setMpStartingOffsetSize(this.mpStartingOffset);
        obj.setMpIntervalSize(this.mpInterval);
        obj.setMpMarkerSize(this.mpMarkerSize);
        return obj;
    }

    @Override
    public String getTypeName() {
        return "LINE";
    }

    @Override
    public String toXMLString() {
        String unit;
        String isCased = this.cased ? " cased=\"true\" " : "";
        String xmlDef = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n<desc></desc>\n<g class=\"line\" " + isCased + "style=\"";
        if (this.fillColor != null) {
            xmlDef = xmlDef + "fill:" + StyleUtils.getHexidecimalString(this.fillColor);
            if (this.fillColor.getAlpha() > 0 && this.fillColor.getAlpha() <= 254) {
                xmlDef = xmlDef + ";fill-opacity:" + this.fillColor.getAlpha();
            }
        }
        if (this.lineWidth.getValue() > 0.0) {
            String unit2 = "";
            if (this.lineWidth.getUnit() != null && !this.lineWidth.getUnit().equalsIgnoreCase("px")) {
                unit2 = this.lineWidth.getUnit();
            }
            String lwdStr = StyleUtils.getUSLocaleFormat(this.lineWidth.getValue());
            String lwStr = StyleUtils.cleanDecimalZeros(lwdStr, 1);
            if (this.lineWidth.isPixelUnit()) {
                lwStr = StyleUtils.cleanDecimalZeros(lwdStr, 0);
            }
            xmlDef = this.fillColor != null ? xmlDef + ";stroke-width:" + lwStr + unit2 : xmlDef + "stroke-width:" + lwStr + unit2;
        }
        if (this.cap != 1) {
            if (this.cap == 2) {
                xmlDef = xmlDef + ";stroke-linecap:SQUARE";
            } else if (this.cap == 0) {
                xmlDef = xmlDef + ";stroke-linecap:BUTT";
            }
        }
        if (this.join != 1) {
            if (this.join == 2) {
                xmlDef = xmlDef + ";stroke-linejoin:BEVEL";
            } else if (this.join == 0) {
                xmlDef = xmlDef + ";stroke-linejoin:MITER";
            }
        }
        if (this.markerStyleName != null) {
            String multimkStr = "";
            String mkposStr = "";
            if (this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_END_POINTS) || this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_ALL_POINTS)) {
                multimkStr = "";
                mkposStr = this.multipleMarkerPosition.toLowerCase();
            } else {
                if (this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_ALONG_PATH)) {
                    multimkStr = ";multiple-marker:true";
                }
                mkposStr = "" + this.markerPosition;
            }
            double width = this.markerSize.getWidth();
            double height = this.markerSize.getHeight();
            String unit3 = "";
            if (this.markerSize.getUnit() != null && !this.markerSize.getUnit().equalsIgnoreCase("px")) {
                unit3 = this.markerSize.getUnit();
            }
            if (width == height) {
                String msizeStr = StyleUtils.getUSLocaleFormat(width);
                msizeStr = StyleUtils.cleanDecimalZeros(msizeStr, 1);
                if (this.markerSize.isPixelUnit()) {
                    msizeStr = String.valueOf((int)width);
                }
                xmlDef = xmlDef + ";marker-name:" + XMLUtil.replaceXMLEntities(this.markerStyleName) + ";marker-position:" + mkposStr + ";marker-size:" + msizeStr + unit3;
            } else {
                String mwsizeStr = StyleUtils.getUSLocaleFormat(width);
                mwsizeStr = StyleUtils.cleanDecimalZeros(mwsizeStr, 1);
                if (this.markerSize.isPixelUnit()) {
                    mwsizeStr = String.valueOf((int)width);
                }
                String mhsizeStr = StyleUtils.getUSLocaleFormat(height);
                mhsizeStr = StyleUtils.cleanDecimalZeros(mhsizeStr, 1);
                if (this.markerSize.isPixelUnit()) {
                    mhsizeStr = String.valueOf((int)height);
                }
                xmlDef = xmlDef + ";marker-name:" + XMLUtil.replaceXMLEntities(this.markerStyleName) + ";marker-position:" + mkposStr + ";marker-width:" + mwsizeStr + unit3 + ";marker-height:" + mhsizeStr + unit3;
            }
            xmlDef = xmlDef + multimkStr;
        }
        xmlDef = xmlDef + "\">\n";
        int sublines = 0;
        if (this.wingColor != null) {
            ++sublines;
            xmlDef = xmlDef + "<line class=\"parallel\" style=\"";
            xmlDef = xmlDef + "fill:" + StyleUtils.getHexidecimalString(this.wingColor);
            if (this.wingColor.getAlpha() < 255) {
                xmlDef = xmlDef + ";fill-opacity:" + this.wingColor.getAlpha();
            }
            unit = "";
            if (this.wingWidth.getUnit() != null && !this.wingWidth.getUnit().equalsIgnoreCase("px")) {
                unit = this.wingWidth.getUnit();
            }
            String wwdStr = StyleUtils.getUSLocaleFormat(this.wingWidth.getValue());
            String wwStr = StyleUtils.cleanDecimalZeros(wwdStr, 1);
            if (this.wingWidth.isPixelUnit()) {
                wwStr = StyleUtils.cleanDecimalZeros(wwdStr, 0);
            }
            xmlDef = this.wingWidth.getValue() > 0.0 ? xmlDef + ";stroke-width:" + wwStr + unit + "\"" : xmlDef + ";stroke-width:1" + unit + "\"";
            if (this.wingDashPattern != null && this.wingDashPattern.length > 0) {
                unit = "";
                if (this.wingDashPatternUnit != null && !this.wingDashPatternUnit.equalsIgnoreCase("px")) {
                    unit = this.wingDashPatternUnit;
                }
                xmlDef = xmlDef + " dash=\"" + this.arrayToString(this.wingDashPattern) + unit + "\"";
            }
            xmlDef = xmlDef + " />\n";
        }
        if (this.centerLineColor != null) {
            ++sublines;
            xmlDef = xmlDef + "<line class=\"base\" style=\"";
            xmlDef = xmlDef + "fill:" + StyleUtils.getHexidecimalString(this.centerLineColor);
            if (this.centerLineColor.getAlpha() < 255) {
                xmlDef = xmlDef + ";fill-opacity:" + this.centerLineColor.getAlpha();
            }
            unit = "";
            if (this.centerLineWidth.getUnit() != null && !this.centerLineWidth.getUnit().equalsIgnoreCase("px")) {
                unit = this.centerLineWidth.getUnit();
            }
            String cldStr = StyleUtils.getUSLocaleFormat(this.centerLineWidth.getValue());
            String clStr = StyleUtils.cleanDecimalZeros(cldStr, 1);
            if (this.centerLineWidth.isPixelUnit()) {
                clStr = StyleUtils.cleanDecimalZeros(cldStr, 0);
            }
            xmlDef = this.centerLineWidth.getValue() > 0.0 ? xmlDef + ";stroke-width:" + clStr + unit + "\"" : xmlDef + ";stroke-width:1" + unit + "\"";
            if (this.centerLineDashPattern != null && this.centerLineDashPattern.length > 0) {
                unit = "";
                if (this.centerLineDashPatternUnit != null && !this.centerLineDashPatternUnit.equalsIgnoreCase("px")) {
                    unit = this.centerLineDashPatternUnit;
                }
                xmlDef = xmlDef + " dash=\"" + this.arrayToString(this.centerLineDashPattern) + unit + "\"";
            }
            xmlDef = xmlDef + " />\n";
        }
        if (this.hashMarkEnabled) {
            ++sublines;
            xmlDef = xmlDef + "<line class=\"hashmark\" style=\"";
            if (this.hashMarkColor != null) {
                xmlDef = xmlDef + "fill:" + StyleUtils.getHexidecimalString(this.hashMarkColor);
                if (this.hashMarkColor.getAlpha() < 255) {
                    xmlDef = xmlDef + ";fill-opacity:" + this.hashMarkColor.getAlpha();
                }
            } else {
                xmlDef = xmlDef + "fill:black";
            }
            String hashUnit = "";
            if (this.hashMarkUnit != null && !this.hashMarkUnit.equalsIgnoreCase("px")) {
                hashUnit = this.hashMarkUnit;
            }
            xmlDef = xmlDef + "\" ";
            xmlDef = xmlDef + " dash=\"" + this.hashMarkGap + "," + this.hashMarkLength + hashUnit + "\"";
            xmlDef = xmlDef + " />\n";
        }
        if (sublines == 0) {
            xmlDef = xmlDef + "<line class=\"base\" />";
        }
        if (this.mpMarkerStyles != null) {
            xmlDef = xmlDef + "<marker-pattern ";
            unit = "";
            if (this.mpMarkerSize.getWidth() > 0.0) {
                if (this.mpMarkerSize.getUnit() != null && !this.mpMarkerSize.getUnit().equalsIgnoreCase("px")) {
                    unit = this.mpMarkerSize.getUnit();
                }
                String mwStr = StyleUtils.getUSLocaleFormat(this.mpMarkerSize.getWidth());
                mwStr = StyleUtils.cleanDecimalZeros(mwStr, 1);
                if (this.mpMarkerSize.isPixelUnit()) {
                    mwStr = String.valueOf((int)this.mpMarkerSize.getWidth());
                }
                xmlDef = xmlDef + "width=\"" + mwStr + unit + "\" ";
            }
            if (this.mpMarkerSize.getHeight() > 0.0) {
                if (this.mpMarkerSize.getUnit() != null && !this.mpMarkerSize.getUnit().equalsIgnoreCase("px")) {
                    unit = this.mpMarkerSize.getUnit();
                }
                String mhStr = StyleUtils.getUSLocaleFormat(this.mpMarkerSize.getHeight());
                mhStr = StyleUtils.cleanDecimalZeros(mhStr, 1);
                if (this.mpMarkerSize.isPixelUnit()) {
                    mhStr = String.valueOf((int)this.mpMarkerSize.getHeight());
                }
                xmlDef = xmlDef + "height=\"" + mhStr + unit + "\" ";
            }
            unit = "";
            if (this.mpStartingOffset.getUnit() != null && !this.mpStartingOffset.getUnit().equalsIgnoreCase("px")) {
                unit = this.mpStartingOffset.getUnit();
            }
            String soStr = StyleUtils.getUSLocaleFormat(this.mpStartingOffset.getValue());
            soStr = StyleUtils.cleanDecimalZeros(soStr, 1);
            if (this.mpStartingOffset.isPixelUnit()) {
                soStr = String.valueOf((int)this.mpStartingOffset.getValue());
            }
            xmlDef = xmlDef + "offset=\"" + soStr + unit + "\" ";
            unit = "";
            if (this.mpInterval.getUnit() != null && !this.mpInterval.getUnit().equalsIgnoreCase("px")) {
                unit = this.mpInterval.getUnit();
            }
            String intStr = StyleUtils.getUSLocaleFormat(this.mpInterval.getValue());
            intStr = StyleUtils.cleanDecimalZeros(intStr, 1);
            if (this.mpInterval.isPixelUnit()) {
                intStr = String.valueOf((int)this.mpInterval.getValue());
            }
            xmlDef = xmlDef + "interval=\"" + intStr + unit + "\">\n";
            for (int i = 0; i < this.mpMarkerStyles.length; ++i) {
                xmlDef = xmlDef + "  <marker>" + this.mpMarkerStyles[i].toUpperCase() + "</marker>\n";
            }
            xmlDef = xmlDef + "</marker-pattern>\n";
        }
        xmlDef = xmlDef + "</g>\n</svg>\n";
        return xmlDef;
    }

    private String arrayToString(float[] f) {
        if (f == null || f.length == 0) {
            return "";
        }
        String dash = "" + f[0];
        for (int i = 1; i < f.length; ++i) {
            dash = dash + "," + f[i];
        }
        return dash;
    }

    public void setOverallStyle(Color c, float width, int endCapType, int joinType) {
        this.fillColor = c;
        this.lineWidth.setValue(width);
        this.cap = endCapType;
        this.join = joinType;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineWidth(SizeDefinition lwidth) {
        this.lineWidth = new SizeDefinition(1.0, null);
        if (lwidth == null) {
            return;
        }
        this.lineWidth.setValue(lwidth.getValue());
        this.lineWidth.setUnit(lwidth.getUnit());
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth.setValue(lineWidth);
    }

    public float getLineWidth() {
        return (float)this.lineWidth.getValue();
    }

    public void setLineWidthUnit(String unit) {
        this.lineWidth.setUnit(unit);
    }

    public String getLineWidthUnit() {
        return this.lineWidth.getUnit();
    }

    public SizeDefinition getLineWidthSize() {
        return this.lineWidth;
    }

    public void setCap(int cap) {
        this.cap = cap;
    }

    public int getCap() {
        return this.cap;
    }

    public void setJoin(int join) {
        this.join = join;
    }

    public int getJoin() {
        return this.join;
    }

    public void setWingLineStyle(Color c, float width, float[] dash, float phase) {
        this.wingColor = c;
        this.wingWidth.setValue(width);
        this.wingDashPattern = dash;
        this.wingPhase = phase;
    }

    public void setWingDashPattern(float[] wingDashPattern) {
        this.wingDashPattern = wingDashPattern;
    }

    public float[] getWingDashPattern() {
        return this.wingDashPattern;
    }

    public String getWingDashPatternUnit() {
        return this.wingDashPatternUnit;
    }

    public void setWingDashPatternUnit(String unit) {
        this.wingDashPatternUnit = unit;
    }

    public void setWingWidth(SizeDefinition wwidth) {
        this.wingWidth = new SizeDefinition(0.0, null);
        if (wwidth == null) {
            return;
        }
        this.wingWidth.setValue(wwidth.getValue());
        this.wingWidth.setUnit(wwidth.getUnit());
    }

    public void setWingWidth(float wingWidth) {
        this.wingWidth.setValue(wingWidth);
    }

    public float getWingWidth() {
        return (float)this.wingWidth.getValue();
    }

    public String getWingWidthUnit() {
        return this.wingWidth.getUnit();
    }

    public void setWingWidthUnit(String unit) {
        this.wingWidth.setUnit(unit);
    }

    public SizeDefinition getWingWidthSize() {
        return this.wingWidth;
    }

    public void setWingPhase(float wingPhase) {
        this.wingPhase = wingPhase;
    }

    public float getWingPhase() {
        return this.wingPhase;
    }

    public void setWingColor(Color wingColor) {
        this.wingColor = wingColor;
    }

    public Color getWingColor() {
        return this.wingColor;
    }

    public void setCenterLineStyle(Color c, float width, float[] dash, float phase) {
        this.centerLineColor = c;
        this.centerLineWidth.setValue(width);
        this.centerLineDashPattern = dash;
        this.centerLinePhase = phase;
    }

    public void setCenterLineColor(Color centerLineColor) {
        this.centerLineColor = centerLineColor;
    }

    public Color getCenterLineColor() {
        return this.centerLineColor;
    }

    public void setCenterLineDashPattern(float[] centerLineDashPattern) {
        this.centerLineDashPattern = centerLineDashPattern;
    }

    public float[] getCenterLineDashPattern() {
        return this.centerLineDashPattern;
    }

    public String getCenterLineDashPatternUnit() {
        return this.centerLineDashPatternUnit;
    }

    public void setCenterLineDashPatternUnit(String unit) {
        this.centerLineDashPatternUnit = unit;
    }

    public void setCenterLinePhase(float centerLinePhase) {
        this.centerLinePhase = centerLinePhase;
    }

    public float getCenterLinePhase() {
        return this.centerLinePhase;
    }

    public void setCenterLineWidth(SizeDefinition cwidth) {
        this.centerLineWidth = new SizeDefinition(1.0, null);
        if (cwidth == null) {
            return;
        }
        this.centerLineWidth.setValue(cwidth.getValue());
        this.centerLineWidth.setUnit(cwidth.getUnit());
    }

    public void setCenterLineWidth(float centerLineWidth) {
        this.centerLineWidth.setValue(centerLineWidth);
    }

    public float getCenterLineWidth() {
        return (float)this.centerLineWidth.getValue();
    }

    public String getCenterLineWidthUnit() {
        return this.centerLineWidth.getUnit();
    }

    public void setCenterLineWidthUnit(String unit) {
        this.centerLineWidth.setUnit(unit);
    }

    public SizeDefinition getCenterLineWidthSize() {
        return this.centerLineWidth;
    }

    public void setHashMarkStyle(Color c, float width, float height, float gap) {
        this.hashMarkColor = c;
        this.hashMarkWidth = width;
        this.hashMarkLength = height;
        this.hashMarkGap = gap;
    }

    public void setHashMarkEnabled(boolean hashMarkEnabled) {
        this.hashMarkEnabled = hashMarkEnabled;
    }

    public boolean isHashMarkEnabled() {
        return this.hashMarkEnabled;
    }

    public void setHashMarkColor(Color hashMarkColor) {
        this.hashMarkColor = hashMarkColor;
    }

    public Color getHashMarkColor() {
        return this.hashMarkColor;
    }

    public void setHashMarkGap(float hashMarkGap) {
        this.hashMarkGap = hashMarkGap;
    }

    public float getHashMarkGap() {
        return this.hashMarkGap;
    }

    public void setHashMarkLength(float hashMarkLength) {
        this.hashMarkLength = hashMarkLength;
    }

    public float getHashMarkLength() {
        return this.hashMarkLength;
    }

    public void setHashMarkWidth(float hashMarkWidth) {
        this.hashMarkWidth = hashMarkWidth;
    }

    public float getHashMarkWidth() {
        return this.hashMarkWidth;
    }

    public String getHashMarkUnit() {
        return this.hashMarkUnit;
    }

    public void setHashMarkUnit(String unit) {
        this.hashMarkUnit = unit;
    }

    public void setMarkerPosition(double markerPosition) {
        this.markerPosition = markerPosition < 0.0 ? 0.0 : (markerPosition > 1.0 ? 1.0 : markerPosition);
    }

    public double getMarkerPosition() {
        return this.markerPosition;
    }

    public void setMarkerStyleName(String markerStyleName) {
        this.markerStyleName = markerStyleName;
    }

    public String getMarkerStyleName() {
        return this.markerStyleName;
    }

    public void setMarkerSize(int markerSize) {
        this.markerSize.setWidth(markerSize);
        this.markerSize.setHeight(markerSize);
    }

    public int getMarkerSize() {
        return (int)this.markerSize.getWidth();
    }

    public void setMarkerSizeValue(double value) {
        this.markerSize.setWidth(value);
        this.markerSize.setHeight(value);
    }

    public double getMarkerSizeValue() {
        return this.markerSize.getWidth();
    }

    public void setMarkerWidth(double width) {
        this.markerSize.setWidth(width);
    }

    public double getMarkerWidth() {
        return this.markerSize.getWidth();
    }

    public void setMarkerHeight(double height) {
        this.markerSize.setHeight(height);
    }

    public double getMarkerHeight() {
        return this.markerSize.getHeight();
    }

    public String getMarkerSizeUnit() {
        return this.markerSize.getUnit();
    }

    public void setMarkerSizeUnit(String unit) {
        this.markerSize.setUnit(unit);
    }

    public SizeDefinition getMarkerSizeDef() {
        return new SizeDefinition(this.markerSize.getWidth(), this.markerSize.getUnit());
    }

    public SizeDefinition2D getMarkerSize2DDef() {
        return this.markerSize;
    }

    public void setMarkerSize(SizeDefinition msize) {
        this.markerSize = new SizeDefinition2D(-1.0, -1.0, null);
        if (msize == null) {
            return;
        }
        this.markerSize.setWidth(msize.getValue());
        this.markerSize.setHeight(msize.getValue());
        this.markerSize.setUnit(msize.getUnit());
    }

    public void setMarkerSize(SizeDefinition2D msize) {
        this.markerSize = new SizeDefinition2D(-1.0, -1.0, null);
        if (msize == null) {
            return;
        }
        this.markerSize.setWidth(msize.getWidth());
        this.markerSize.setHeight(msize.getHeight());
        this.markerSize.setUnit(msize.getUnit());
    }

    public boolean isMultipleMarker() {
        return !this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_NONE);
    }

    public void setMultipleMarker(boolean multi) {
        if (!multi) {
            this.multipleMarkerPosition = MULTIMARKER_NONE;
        } else {
            if (this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_END_POINTS) || this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_ALL_POINTS)) {
                return;
            }
            this.multipleMarkerPosition = MULTIMARKER_ALONG_PATH;
        }
    }

    public void setMultipleMarkerPosition(String position) {
        this.multipleMarkerPosition = position == null || !position.equalsIgnoreCase(MULTIMARKER_NONE) && !position.equalsIgnoreCase(MULTIMARKER_ALONG_PATH) && !position.equalsIgnoreCase(MULTIMARKER_END_POINTS) && !position.equalsIgnoreCase(MULTIMARKER_ALL_POINTS) ? MULTIMARKER_NONE : position;
    }

    public String getMultipleMarkerPosition() {
        return this.multipleMarkerPosition;
    }

    public void setCased(boolean cased) {
        this.cased = cased;
    }

    public boolean isCased() {
        return this.cased;
    }

    public void setMpMarkerStyles(String[] styles) {
        this.mpMarkerStyles = styles;
    }

    public String[] getMpMarkerStyles() {
        return this.mpMarkerStyles;
    }

    public void setMpStartingOffsetSize(SizeDefinition osize) {
        this.mpStartingOffset = new SizeDefinition(0.0, null);
        if (osize == null) {
            return;
        }
        this.mpStartingOffset.setValue(osize.getValue());
        this.mpStartingOffset.setUnit(osize.getUnit());
    }

    public void setMpStartingOffset(float param) {
        this.mpStartingOffset.setValue(param);
    }

    public float getMpStartingOffset() {
        return (float)this.mpStartingOffset.getValue();
    }

    public String getMpStartingOffsetUnit() {
        return this.mpStartingOffset.getUnit();
    }

    public void setMpStartingOffsetUnit(String unit) {
        this.mpStartingOffset.setUnit(unit);
    }

    public SizeDefinition getMpStartingOffsetSize() {
        return this.mpStartingOffset;
    }

    public void setMpInterval(float param) {
        this.mpInterval.setValue(param);
    }

    public float getMpInterval() {
        return (float)this.mpInterval.getValue();
    }

    public String getMpIntervalUnit() {
        return this.mpInterval.getUnit();
    }

    public void setMpIntervalUnit(String unit) {
        this.mpInterval.setUnit(unit);
    }

    public SizeDefinition getMpIntervalSize() {
        return this.mpInterval;
    }

    public void setMpIntervalSize(SizeDefinition isize) {
        this.mpInterval = new SizeDefinition(5.0, null);
        if (isize == null) {
            return;
        }
        this.mpInterval.setValue(isize.getValue());
        this.mpInterval.setUnit(isize.getUnit());
    }

    public void setMpMarkerSize(SizeDefinition2D size) {
        this.mpMarkerSize = new SizeDefinition2D(-1.0, -1.0, null);
        if (size == null) {
            return;
        }
        this.mpMarkerSize.setWidth(size.getWidth());
        this.mpMarkerSize.setHeight(size.getHeight());
        this.mpMarkerSize.setUnit(size.getUnit());
    }

    public SizeDefinition2D getMpMarkerSize() {
        return this.mpMarkerSize;
    }

    public void setMpMarkerWidth(double width) {
        if (width <= 0.0) {
            return;
        }
        this.mpMarkerSize.setWidth(width);
    }

    public double getMpMarkerWidth() {
        return this.mpMarkerSize.getWidth();
    }

    public void setMpMarkerHeight(double height) {
        if (height <= 0.0) {
            return;
        }
        this.mpMarkerSize.setHeight(height);
    }

    public double getMpMarkerHeight() {
        return this.mpMarkerSize.getHeight();
    }

    public void setMpMarkerUnit(String unit) {
        this.mpMarkerSize.setUnit(unit);
    }

    public String getMpMarkerUnit() {
        return this.mpMarkerSize.getUnit();
    }

    @Override
    public String[] getStyleDependency() {
        ArrayList<String> depStyles = new ArrayList<String>();
        if (this.markerStyleName != null) {
            depStyles.add(this.markerStyleName);
        }
        if (this.mpMarkerStyles != null) {
            for (int i = 0; i < this.mpMarkerStyles.length; ++i) {
                depStyles.add(this.mpMarkerStyles[i]);
            }
        }
        if (depStyles.size() == 0) {
            return null;
        }
        return depStyles.toArray(new String[depStyles.size()]);
    }
}

