/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import oracle.lbs.util.APIKeyStorage;

public class APIKeyManager {
    private static HashMap<String, APIKeyEntry> cacheByUid = new HashMap(256);
    private static HashMap<String, APIKeyEntry> cacheByApiKey = new HashMap(256);
    APIKeyStorage store;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void setAPIKeyStorage(APIKeyStorage store) {
        this.store = store;
    }

    String hashKey(String key, String salt) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            if (salt != null && salt.length() > 0) {
                messageDigest.update(salt.getBytes());
            }
            String hash = APIKeyManager.byteArray2Hex(messageDigest.digest());
            System.out.println("hash=" + hash);
            return hash;
        }
        catch (Exception ex) {
            System.err.println("Exception generating SHA-256 hash !");
            ex.printStackTrace(System.err);
            return null;
        }
    }

    APIKeyEntry generateKey(APIKeyEntry ent, String salt) {
        String hash;
        if (ent == null) {
            ent = new APIKeyEntry();
        }
        UUID[] id = new UUID[5];
        for (int i = 0; i < 5; ++i) {
            id[i] = UUID.randomUUID();
        }
        int idx = Math.abs(new Random(System.currentTimeMillis()).nextInt());
        String key = id[idx % 5].toString();
        ent.key = key = key.replaceAll("-", "");
        ent.hash = hash = this.hashKey(key, salt);
        System.out.println("key=" + key);
        return ent;
    }

    String getKey(String key) {
        APIKeyEntry ent = cacheByApiKey.get(key);
        return ent == null ? null : ent.key;
    }

    String getKeyFor(String uid) {
        APIKeyEntry ent = cacheByUid.get(uid);
        return ent == null ? null : ent.key;
    }

    public static String byteArray2Hex(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(hex[(b & 0xF0) >> 4]);
            sb.append(hex[b & 0xF]);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        APIKeyEntry ent = new APIKeyEntry();
        ent.uid = "lj.qian@oracle.com";
        APIKeyManager mgr = new APIKeyManager();
        mgr.generateKey(ent, null);
        mgr.generateKey(ent, "salt-123");
        mgr.hashKey("d5df8636a0f44abe8c793e7d1c490514", null);
        mgr.hashKey("ea1aa88683cc4086934b60af13704537", "salt-123");
    }

    public static class APIKeyEntry {
        String hash;
        String key;
        String uid;
        String contact;
        String organization;
        String appName;
        Date issueDate;
        int expireWithinDays;
    }
}

