/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSResponseHandler;
import oracle.ocvs.OCVSSession;

public class OCVSUpdatedHandler
extends OCVSResponseHandler {
    @Override
    public String getResponseId() {
        return "Updated";
    }

    @Override
    public void handleResponse(OCVSSession session, String argument) throws ParseException, IOException, OCVSClientException {
        OCVSPathName pathName = this.receivePathName(session, argument);
        String newEntriesLine = session.receiveLine();
        OCVSEntry entry = OCVSEntry.parseEntrySpec(newEntriesLine);
        int type = entry.isBinary() ? 1 : 0;
        File tempFile = session.receiveModeFile(type);
        File dataFile = pathName.constructFile(session.getWorkingDirectory());
        this.createDirectoryStructure(session, pathName);
        if (dataFile.exists() && !this.handleExistingDataFile(session, pathName, dataFile)) {
            return;
        }
        if (!OCVSFileUtil.renameTo(tempFile, dataFile)) {
            throw new IOException(MessageFormat.format("cannot create {0}", dataFile.getPath()));
        }
        if (session.getModTime() != null) {
            dataFile.setLastModified(session.getModTime().getTime());
        }
        this.updateEntry(dataFile, newEntriesLine);
    }

    protected boolean handleExistingDataFile(OCVSSession session, OCVSPathName pathName, File dataFile) throws IOException {
        this.deleteFile(dataFile);
        return true;
    }

    public void createDirectoryStructure(OCVSSession session, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
        super.createDirectoryStructure(session, this.createPathName(session, directory));
    }

    private OCVSPathName createPathName(OCVSSession session, OCVSDirectory directory) throws IOException {
        String repositoryName = this.appendServerSeparator(directory.constructRemotePath(session.getRoot().getRepository()));
        return new OCVSPathName(directory.getLocalPath(), repositoryName);
    }

    private String appendServerSeparator(String requestPath) {
        if (requestPath.endsWith(String.valueOf('/'))) {
            return requestPath;
        }
        return requestPath + '/';
    }
}

