/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSUserInfo;

public class OCVSSsh2Connection
extends OCVSConnection {
    private static final String SSH_DIRECTORY = System.getProperty("user.home") + File.separator + ".ssh";
    private static JSch _jsch;
    private static final Collection _identities;
    private final String _userName;
    private final String _hostName;
    private final OCVSUserInfo _userInfo;
    private String _key;
    private String _server = "cvs";
    private String _proxy;
    private int _proxyPort = 3128;
    private Session _session;
    private Channel _channel;
    private PipedInputStream _inputStream;
    private PipedOutputStream _outputStream;

    public OCVSSsh2Connection(String userName, String hostName, OCVSUserInfo userInfo) {
        this._userName = userName;
        this._hostName = hostName;
        this._userInfo = userInfo;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setServer(String server) {
        this._server = server;
    }

    public void setProxy(String proxy) {
        this._proxy = proxy;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    @Override
    protected void openImpl() throws IOException, JSchException {
        if (this._session != null) {
            throw new IllegalStateException();
        }
        this._session = this.createSession();
        this._channel = this.createChannel();
    }

    @Override
    protected void closeImpl() throws IOException {
        if (this._session == null) {
            throw new IllegalStateException();
        }
        this._channel.disconnect();
        this._channel = null;
        this._session.disconnect();
        this._session = null;
        this._inputStream = null;
        this._outputStream = null;
    }

    @Override
    protected InputStream getInputStreamImpl() throws IOException {
        return this._inputStream;
    }

    @Override
    protected OutputStream getOutputStreamImpl() throws IOException {
        return this._outputStream;
    }

    private Session createSession() throws JSchException {
        File userSshDirectoryFile;
        if (_jsch == null) {
            _jsch = new JSch();
            _jsch.setKnownHosts(SSH_DIRECTORY + File.separator + "known_hosts");
        }
        if (this._key != null && !_identities.contains(this._key)) {
            _identities.add(this._key);
            _jsch.addIdentity(this._key);
        }
        if (!(userSshDirectoryFile = new File(SSH_DIRECTORY)).exists()) {
            userSshDirectoryFile.mkdir();
        }
        Session session = _jsch.getSession(this._userName, this._hostName, 22);
        if (this._proxy != null) {
            session.setProxy((Proxy)new ProxyHTTP(this._proxy, this._proxyPort));
        }
        session.setUserInfo((UserInfo)this._userInfo);
        session.connect();
        return session;
    }

    private Channel createChannel() throws JSchException, IOException {
        ChannelExec channel = (ChannelExec)this._session.openChannel("exec");
        channel.setCommand(this._server + ' ' + "server");
        this._inputStream = new PipedInputStream();
        this._outputStream = new PipedOutputStream();
        channel.setInputStream((InputStream)new PipedInputStream(this._outputStream));
        channel.setOutputStream((OutputStream)new PipedOutputStream(this._inputStream));
        channel.connect();
        this._userInfo.cachePassword();
        return channel;
    }

    static {
        _identities = new ArrayList();
    }
}

