/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSFileNameConstants;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSResponseHandler;
import oracle.ocvs.OCVSSession;

public class OCVSSetStaticDirHandler
extends OCVSResponseHandler {
    @Override
    public String getResponseId() {
        return "Set-static-directory";
    }

    @Override
    public void handleResponse(OCVSSession session, String argument) throws ParseException, IOException, OCVSClientException {
        OCVSPathName pathName = this.receivePathName(session, argument);
        this.createDirectoryStructure(session, pathName);
        File staticFlagFile = new File(pathName.constructFile(session.getWorkingDirectory()), OCVSFileNameConstants.CVSADM_ENTSTAT);
        this.adjustStaticDirectoryFlag(staticFlagFile);
    }

    protected void adjustStaticDirectoryFlag(File staticFlagFile) throws IOException {
        staticFlagFile.createNewFile();
    }
}

