/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ocvs.OCVSFileUtil;

public class OCVSRuntimeUtil {
    private static final String SH = "sh";
    private static Map _environmentVariables;

    private OCVSRuntimeUtil() {
    }

    public static final Map getEnvironmentVariableMap() {
        if (_environmentVariables == null) {
            try {
                OCVSRuntimeUtil.readEnvironmentVariables();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return Collections.EMPTY_MAP;
            }
        }
        return Collections.unmodifiableMap(_environmentVariables);
    }

    static final boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private static final void readEnvironmentVariables() throws IOException {
        String[] cmdArray = new String[]{"set"};
        File scriptFile = null;
        if (OCVSRuntimeUtil.isWindows()) {
            cmdArray = OCVSRuntimeUtil.createWin32CommandArray(cmdArray);
        } else {
            scriptFile = OCVSFileUtil.createTempFile(SH);
            OCVSFileUtil.writeFileLines(scriptFile, cmdArray);
            cmdArray = new String[]{SH, scriptFile.getAbsolutePath()};
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmdArray).getInputStream()));
        _environmentVariables = new HashMap();
        String line = null;
        while ((line = br.readLine()) != null) {
            int i = line.indexOf(61);
            if (i <= 0 || i >= line.length() - 1) continue;
            String name = line.substring(0, i);
            String value = line.substring(i + 1).trim();
            if (name.indexOf(32) >= 0 || value.equals("")) continue;
            _environmentVariables.put(name.toUpperCase(), value);
        }
        if (scriptFile != null) {
            scriptFile.delete();
        }
    }

    private static final String[] createWin32CommandArray(String[] cmdArray) {
        String[] cmdArray2 = new String[cmdArray.length + 2];
        int i = 0;
        cmdArray2[i++] = "cmd.exe";
        cmdArray2[i++] = "/c";
        System.arraycopy(cmdArray, 0, cmdArray2, i, cmdArray.length);
        return cmdArray2;
    }
}

