/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSFile;
import oracle.ocvs.OCVSFileNameConstants;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSResourceVisitor;
import oracle.ocvs.OCVSSession;

public abstract class OCVSResource {
    private final File _file;
    private final String _localPath;
    private OCVSEntry _entry;

    public OCVSResource(File file) {
        this(file, file.getName());
    }

    public OCVSResource(File file, String localPath) {
        this._file = file;
        this._localPath = localPath;
    }

    public abstract void acceptVisitor(OCVSSession var1, OCVSResourceVisitor var2) throws IOException, ParseException, OCVSClientException;

    public File getFile() {
        return this._file;
    }

    public String getLocalPath() {
        return this._localPath;
    }

    public OCVSEntry getCachedEntry() {
        return this._entry;
    }

    public OCVSEntry readEntry() throws IOException, ParseException {
        this._entry = this.readEntryImpl();
        return this.getCachedEntry();
    }

    public OCVSDirectory constructParentDirectory() {
        if (this._localPath.equals(".")) {
            return null;
        }
        File parentFile = this._file.getParentFile();
        String parentLocalPath = OCVSPathName.extractServerPathParent(this._localPath);
        if (parentFile == null) {
            return null;
        }
        if (parentLocalPath == null) {
            parentLocalPath = ".";
        }
        return new OCVSDirectory(parentFile, parentLocalPath);
    }

    public String constructRemotePath(String rootPath) throws IOException {
        OCVSDirectory parentDirectory = this.constructParentDirectory();
        if (parentDirectory == null) {
            return rootPath;
        }
        String parentPath = parentDirectory.constructRemotePath(rootPath);
        if (parentPath == null) {
            return rootPath;
        }
        StringBuilder remotePathBuffer = new StringBuilder(parentPath);
        remotePathBuffer.append('/');
        remotePathBuffer.append(this._file.getName());
        return remotePathBuffer.toString();
    }

    public boolean isDirectory() {
        return false;
    }

    public String extractFileName() {
        return OCVSPathName.extractServerPathFileName(this._localPath);
    }

    private OCVSEntry readEntryImpl() throws IOException, ParseException {
        String[] entriesData = OCVSFileUtil.readFileLines(new File(this._file.getParentFile(), OCVSFileNameConstants.CVSADM_ENT));
        if (entriesData == null) {
            return null;
        }
        for (int i = 0; i < entriesData.length; ++i) {
            OCVSEntry entry = OCVSEntry.parseEntrySpec(entriesData[i]);
            if (!entry.getUser().equals(this._file.getName()) || this._file.exists() && entry.getType() == 1 != this._file.isDirectory()) continue;
            return entry;
        }
        return null;
    }

    public static final OCVSResource createResource(File file, String localPath) {
        return file.isDirectory() ? new OCVSDirectory(file, localPath) : new OCVSFile(file, localPath);
    }
}

