/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSFile;
import oracle.ocvs.OCVSFileStateVisitor;
import oracle.ocvs.OCVSNoop;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSSession;

public class OCVSRelease
extends OCVSCommand {
    public static final OCVSOption OPTION_DELETE_THE_GIVEN_DIRECTORY = new OCVSOption("-d", 2);
    private boolean _noOp;

    public OCVSRelease() {
        super("release");
    }

    @Override
    public String getCommandId() {
        return "release";
    }

    @Override
    public void executeRequest(OCVSSession session) throws ParseException, IOException, OCVSException {
        if (this._noOp && session.isRequestValid("noop")) {
            new OCVSNoop().executeRequest(session);
            return;
        }
        super.executeRequest(session);
    }

    @Override
    public int executeCommand(OCVSProcessIO io, File dir, Map options, String[] arguments) throws Exception {
        this._noOp = false;
        return super.executeCommand(io, dir, options, arguments);
    }

    @Override
    protected OCVSResource[] createResourceStructure(OCVSSession session, Map options, String[] paths) throws IOException, ParseException, OCVSClientException {
        ArrayList<OCVSResource> resources = new ArrayList<OCVSResource>(Arrays.asList(super.createResourceStructure(session, paths)));
        Iterator itr = resources.iterator();
        while (itr.hasNext()) {
            OCVSResource resource = (OCVSResource)itr.next();
            if (!resource.isDirectory()) {
                throw new OCVSClientException(MessageFormat.format("no such directory: {0}", resource.getLocalPath()));
            }
            if (!new File(resource.getFile(), "CVS").exists()) {
                throw new OCVSClientException(MessageFormat.format("no repository directory: {0}", resource.getLocalPath()));
            }
            OCVSEntry[] entries = this.listEntries((OCVSDirectory)resource);
            int alteredFiles = 0;
            for (int j = 0; j < entries.length; ++j) {
                if (entries[j].getType() != 0) continue;
                ++alteredFiles;
            }
            OCVSProcessIO io = session.getSessionIO().getProcessIO();
            io._out.println(MessageFormat.format("You have [{0}] altered files in this repository.", Integer.toString(alteredFiles)));
            String message = !options.containsKey(OPTION_DELETE_THE_GIVEN_DIRECTORY) ? "Are you sure you want to release directory `{0}''?" : "Are you sure you want to release (and delete) directory `{0}''?";
            if (io.getPrompter().promptReleaseYesNo(MessageFormat.format(message, resource.getLocalPath()))) continue;
            itr.remove();
            io._out.println(MessageFormat.format("** `{0}'' aborted by user choice.", this.getCommandId()));
        }
        this._noOp = resources.size() <= 0;
        return resources.toArray(new OCVSResource[0]);
    }

    @Override
    protected OCVSFileStateVisitor createResourceVisitor() {
        return new OCVSFileStateVisitor(){

            @Override
            public void visitFile(OCVSSession session, OCVSFile file) throws IOException, ParseException, OCVSClientException {
            }

            @Override
            public void visitDirectory(OCVSSession session, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
            }
        };
    }

    @Override
    protected void sessionPrepared(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
        for (int i = 0; i < resources.length; ++i) {
            if (!options.containsKey(OPTION_DELETE_THE_GIVEN_DIRECTORY)) continue;
            this.deleteRepositories((OCVSDirectory)resources[i]);
        }
    }

    private OCVSEntry[] listEntries(OCVSDirectory repository) throws IOException, ParseException {
        ArrayList entries = new ArrayList();
        this.listEntries(repository, entries);
        return entries.toArray(new OCVSEntry[0]);
    }

    private void listEntries(OCVSDirectory repository, Collection c) throws IOException, ParseException {
        OCVSEntry[] entries = repository.listEntries();
        if (entries == null) {
            return;
        }
        c.addAll(Arrays.asList(entries));
        OCVSResource[] resources = repository.listResources();
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].isDirectory()) continue;
            this.listEntries((OCVSDirectory)resources[i], c);
        }
    }

    private void deleteRepositories(OCVSDirectory repository) throws IOException, ParseException {
        OCVSEntry[] entries = repository.listEntries();
        if (entries == null) {
            return;
        }
        OCVSResource[] resources = repository.listResources();
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].isDirectory()) continue;
            this.deleteRepositories((OCVSDirectory)resources[i]);
        }
        ArrayList<File> deletionFiles = new ArrayList<File>();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getType() != 0) continue;
            deletionFiles.add(new File(repository.getFile(), entries[i].getUser()));
        }
        this.deleteFiles(deletionFiles.toArray(new File[0]));
        File adminDirFile = new File(repository.getFile(), "CVS");
        this.deleteFiles(adminDirFile.listFiles());
        this.deleteFile(adminDirFile);
        if (repository.getFile().list().length <= 0) {
            repository.getFile().delete();
        }
    }

    private void deleteFiles(File[] files) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            this.deleteFile(files[i]);
        }
    }

    private void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException(MessageFormat.format("cannot delete {0}", file.getPath()));
        }
    }
}

