/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSFileStateVisitor;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSIgnorePatternList;
import oracle.ocvs.OCVSImportFileStateVisitor;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSSession;
import oracle.ocvs.OCVSWrapper;

public class OCVSImport
extends OCVSCommand {
    public static final OCVSOption OPTION_READ_MESSAGE_FROM_FILE = new OCVSOption(0);
    public static final OCVSOption OPTION_LOG_MESSAGE = new OCVSOption("-m", 2);
    public static final OCVSOption OPTION_MORE_FILES_TO_IGNORE = new OCVSOption("-I", 2);
    public static final OCVSOption OPTION_WRAPPERS_SPECIFICATION_LINE = new OCVSOption("-W", 2);
    public static final OCVSOption OPTION_VENDOR_BRANCH_ID = new OCVSOption("-b", 2);

    public OCVSImport() {
        super("import");
    }

    @Override
    public String getCommandId() {
        return "import";
    }

    @Override
    protected int indexOfFileArgument(String[] arguments) throws OCVSClientException {
        if (arguments.length <= 0) {
            throw new OCVSClientException("must specify repository");
        }
        if (arguments.length <= 1) {
            throw new OCVSClientException("must specify vendor tag");
        }
        if (arguments.length <= 2) {
            throw new OCVSClientException("must specify release tag");
        }
        return 3;
    }

    @Override
    protected String[] processArguments(OCVSSession session, String[] arguments) throws OCVSClientException {
        return arguments;
    }

    @Override
    protected void processOptions(OCVSSession session, Map options) throws IOException, OCVSClientException {
        String cvsignore;
        super.processOptions(session, options);
        if (options.containsKey(OPTION_READ_MESSAGE_FROM_FILE)) {
            if (options.containsKey(OPTION_LOG_MESSAGE)) {
                throw new OCVSClientException("cannot specify both a message and a log file");
            }
            File logFile = new File((String)options.get(OPTION_READ_MESSAGE_FROM_FILE));
            if (!logFile.exists()) {
                throw new OCVSClientException(MessageFormat.format("can''t stat {0}: No such file or directory", logFile.getPath()));
            }
            options.put(OPTION_LOG_MESSAGE, OCVSFileUtil.readFileBytes(logFile));
        }
        if (!options.containsKey(OPTION_LOG_MESSAGE)) {
            options.put(OPTION_LOG_MESSAGE, "");
        }
        if (!options.containsKey(OPTION_VENDOR_BRANCH_ID)) {
            options.put(OPTION_VENDOR_BRANCH_ID, "1.1.1");
        }
        ArrayList<OCVSWrapper> wrappers = new ArrayList<OCVSWrapper>();
        for (Map.Entry entry : options.entrySet()) {
            try {
                String optionId = ((OCVSOption)entry.getKey()).getOptionId();
                if (optionId == null || !OPTION_WRAPPERS_SPECIFICATION_LINE.getOptionId().equals(optionId)) continue;
                wrappers.add(OCVSWrapper.parseWrapperSpec((String)entry.getValue()));
            }
            catch (ParseException optionId) {}
        }
        session.setWrappers(wrappers);
        OCVSIgnorePatternList ignorePatternList = OCVSIgnorePatternList.load(new File(System.getProperty("user.home")));
        String string = cvsignore = this.getEnvironmentParams() != null ? (String)this.getEnvironmentParams().get("CVSIGNORE") : null;
        if (cvsignore != null) {
            ignorePatternList = ignorePatternList.union(new OCVSIgnorePatternList(cvsignore));
        }
        for (Map.Entry entry : options.entrySet()) {
            String optionId = ((OCVSOption)entry.getKey()).getOptionId();
            if (optionId == null || !OPTION_MORE_FILES_TO_IGNORE.getOptionId().equals(optionId)) continue;
            ignorePatternList = ignorePatternList.union(new OCVSIgnorePatternList((String)entry.getValue()));
        }
        session.setIgnorePatternList(ignorePatternList);
    }

    @Override
    protected OCVSResource[] createResourceStructure(OCVSSession session, Map options, String[] paths) throws IOException, ParseException, OCVSClientException {
        return this.createResourceStructure(session, new String[]{""});
    }

    @Override
    protected OCVSResource[] processResources(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
        return resources;
    }

    @Override
    protected OCVSFileStateVisitor createResourceVisitor() {
        return new OCVSImportFileStateVisitor();
    }

    @Override
    protected void sendResourceArguments(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
    }
}

