/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;

class OCVSIgnorePatternList {
    private static final String FILENAME = ".cvsignore";
    private final ArrayList<String> _ignoreList = new ArrayList();

    OCVSIgnorePatternList() {
    }

    OCVSIgnorePatternList(String patternListSpec) {
        StringTokenizer tokenizer = new StringTokenizer(patternListSpec);
        while (tokenizer.hasMoreTokens()) {
            this._ignoreList.add(tokenizer.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final OCVSIgnorePatternList load(File directoryFile) throws IOException {
        File cvsignoreFile = new File(directoryFile, FILENAME);
        if (!cvsignoreFile.exists() || cvsignoreFile.isDirectory()) {
            return new OCVSIgnorePatternList();
        }
        try (BufferedReader in = new BufferedReader(new FileReader(cvsignoreFile));){
            String line;
            StringBuilder fileBuffer = new StringBuilder();
            while ((line = in.readLine()) != null) {
                fileBuffer.append(line);
                fileBuffer.append('\n');
            }
            OCVSIgnorePatternList oCVSIgnorePatternList = new OCVSIgnorePatternList(fileBuffer.toString());
            return oCVSIgnorePatternList;
        }
    }

    final OCVSIgnorePatternList union(OCVSIgnorePatternList other) {
        OCVSIgnorePatternList union = new OCVSIgnorePatternList();
        union._ignoreList.addAll(this._ignoreList);
        union._ignoreList.addAll(other._ignoreList);
        return union;
    }

    final boolean accept(File file) throws IOException {
        for (String ignorePattern : this._ignoreList) {
            if (!this.matchesRegEx(file.getName(), this.createRegExFromWildcard(ignorePattern))) continue;
            return true;
        }
        return false;
    }

    private final boolean matchesRegEx(String name, String regex) {
        try {
            return name.matches(regex);
        }
        catch (PatternSyntaxException pse) {
            return false;
        }
    }

    private final String createRegExFromWildcard(String wildcard) {
        StringBuilder patternBuffer = new StringBuilder();
        patternBuffer.append("\\Q");
        for (int i = 0; i < wildcard.length(); ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                patternBuffer.append("\\E");
                patternBuffer.append(".*");
                patternBuffer.append("\\Q");
                continue;
            }
            if (c == '?') {
                patternBuffer.append("\\E");
                patternBuffer.append(".");
                patternBuffer.append("\\Q");
                continue;
            }
            patternBuffer.append(c);
        }
        patternBuffer.append("\\E");
        return patternBuffer.toString();
    }
}

