/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import oracle.ocvs.OCVSBaseResourceVisitor;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSFile;
import oracle.ocvs.OCVSIgnorePatternList;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSSession;
import oracle.ocvs.OCVSWrapper;

public class OCVSFileStateVisitor
extends OCVSBaseResourceVisitor {
    public static final int FSTAT_MODIFIED = 0;
    public static final int FSTAT_UNCHANGED = 1;
    public static final int FSTAT_QUESTIONABLE = 2;
    public static final int FSTAT_ABSENT = 3;
    public static final int FSTAT_REMOVED = 4;
    private boolean _useIsModified;
    private boolean _suppressQuestionable;
    private File _lastDirectory;

    public void setUseIsModified(boolean useIsModified) {
        this._useIsModified = useIsModified;
    }

    public void setSuppressQuestionable(boolean suppressQuestionable) {
        this._suppressQuestionable = suppressQuestionable;
    }

    @Override
    public void visitFile(OCVSSession session, OCVSFile file) throws IOException, ParseException, OCVSClientException {
        this.sendFile(session, file);
    }

    @Override
    public void visitDirectory(OCVSSession session, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
        if (directory.isQuestionable()) {
            OCVSDirectory parentDirectory = directory.constructParentDirectory();
            if (parentDirectory != null) {
                this.visitQuestionableDirectory(session, parentDirectory, directory);
            }
            return;
        }
        this.sendDirectory(session, directory);
        this.visitDirectoryContents(session, directory);
    }

    @Override
    protected void visitDirectoryContents(OCVSSession session, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
        int i;
        OCVSResource[] resources = directory.listResources();
        if (session.getIgnorePatternList() != null) {
            for (int i2 = 0; resources != null && i2 < resources.length; ++i2) {
                OCVSIgnorePatternList ignorePatternList = OCVSIgnorePatternList.load(directory.getFile());
                if (!(ignorePatternList = ignorePatternList.union(session.getIgnorePatternList())).accept(resources[i2].getFile())) continue;
                session.getSessionIO().getProcessIO()._out.println("I ./" + resources[i2].getLocalPath());
                resources[i2] = null;
            }
        }
        OCVSEntry[] entries = directory.listEntries();
        for (i = 0; entries != null && i < entries.length; ++i) {
            File entryFile;
            if (entries[i].getType() != 0 || (entryFile = new File(directory.getFile(), entries[i].getUser())).exists()) continue;
            this.sendFile(session, (OCVSFile)directory.createChildResource(entryFile.getName()));
        }
        for (i = 0; resources != null && i < resources.length; ++i) {
            if (resources[i] == null) continue;
            OCVSDirectory currentDirectory = null;
            if (resources[i].isDirectory()) {
                currentDirectory = (OCVSDirectory)resources[i];
            }
            if (currentDirectory != null && currentDirectory.isQuestionable()) {
                this.visitQuestionableDirectory(session, directory, currentDirectory);
                continue;
            }
            super.visitChildResource(session, resources[i]);
        }
    }

    protected void visitQuestionableDirectory(OCVSSession session, OCVSDirectory parent, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
        this.sendDirectory(session, parent);
        session.sendQuestionable(directory.extractFileName());
    }

    protected void sendFile(OCVSSession session, OCVSFile file) throws IOException, ParseException, OCVSClientException {
        int state = -1;
        if (!file.getFile().exists()) {
            state = 3;
        }
        OCVSEntry entry = file.readEntry();
        if (state < 0 && entry == null) {
            state = 2;
        }
        if ((state < 0 || state == 3) && entry != null && entry.getVersion().startsWith("-")) {
            state = 4;
        }
        if (state < 0) {
            String fileTimestamp;
            String string = fileTimestamp = entry != null ? file.createTimestamp() : "";
            if (!fileTimestamp.equals(entry.getTimestamp())) {
                state = 0;
            }
        }
        if (state < 0) {
            state = 1;
        }
        if (entry != null) {
            this.sendEntry(session, entry, file, state);
        }
        this.sendFileState(session, file, state);
    }

    protected void sendDirectory(OCVSSession session, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
        String tagSpec;
        File directoryFile = directory.getFile();
        if (!directoryFile.exists()) {
            return;
        }
        if (this._lastDirectory != null && directoryFile.equals(this._lastDirectory)) {
            return;
        }
        OCVSDirectory parentDirectory = directory.constructParentDirectory();
        if (parentDirectory != null) {
            this.sendDirectory(session, parentDirectory);
        }
        this._lastDirectory = directoryFile;
        String remotePath = directory.constructRemotePath(session.getRoot().getRepository());
        String localPath = OCVSPathName.trimServerSeparators(directory.getLocalPath());
        session.sendDirectory(localPath, remotePath);
        if (directory.isStaticDirectory()) {
            session.sendStaticDirectory();
        }
        if ((tagSpec = directory.readTagSpec()) != null) {
            session.sendSticky(tagSpec);
        }
    }

    protected void sendEntry(OCVSSession session, OCVSEntry entry, OCVSFile file, int state) throws IOException, ParseException, OCVSClientException {
        this.sendDirectory(session, file.constructParentDirectory());
        OCVSEntry serverEntry = new OCVSEntry(entry);
        if (entry.getConflict() != null) {
            serverEntry.setConflict(file.createTimestamp().equals(entry.getConflict()) ? "=" : "modified");
        }
        serverEntry.setTimestamp("");
        session.sendEntry(serverEntry.toString());
    }

    protected void sendFileState(OCVSSession session, OCVSFile file, int state) throws IOException, ParseException, OCVSClientException {
        if (state == 3) {
            return;
        }
        if (state == 4) {
            return;
        }
        this.sendDirectory(session, file.constructParentDirectory());
        if (state == 2) {
            this.sendQuestionableFile(session, file);
        }
        if (state == 0) {
            this.sendModifiedFile(session, file);
        }
        if (state == 1) {
            this.sendUnchangedFile(session, file);
        }
    }

    private void sendQuestionableFile(OCVSSession session, OCVSFile file) throws IOException {
        if (this._suppressQuestionable) {
            this.sendModifiedFile(session, file);
        } else {
            session.sendQuestionable(file.extractFileName());
        }
    }

    private void sendModifiedFile(OCVSSession session, OCVSFile file) throws IOException {
        OCVSEntry entry = file.getCachedEntry();
        Collection wrappers = session.getWrappers();
        int type = entry != null && entry.isBinary() ? 1 : 0;
        OCVSWrapper matchingWrapper = null;
        if (wrappers != null) {
            for (OCVSWrapper wrapper : wrappers) {
                if (wrapper.getOption() != 0 || !wrapper.matches(file.extractFileName())) continue;
                matchingWrapper = wrapper;
                if (!wrapper.getValue().equals("b")) break;
                type = 1;
                break;
            }
        }
        if (entry == null && matchingWrapper != null) {
            session.sendKopt(matchingWrapper.getValue());
        }
        if (this._useIsModified) {
            session.sendIsModified(file.getFile(), type);
        } else {
            session.sendModified(file.getFile(), type);
        }
    }

    private void sendUnchangedFile(OCVSSession session, OCVSFile file) throws IOException {
        session.sendUnchanged(file.extractFileName());
    }
}

