/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSFileNameConstants;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSResourceVisitor;
import oracle.ocvs.OCVSSession;

public class OCVSDirectory
extends OCVSResource {
    public OCVSDirectory(File file) {
        super(file, ".");
    }

    public OCVSDirectory(File file, String localPath) {
        super(file, localPath != null && localPath.equals("") ? "." : localPath);
    }

    @Override
    public void acceptVisitor(OCVSSession session, OCVSResourceVisitor visitor) throws IOException, ParseException, OCVSClientException {
        visitor.visitDirectory(session, this);
    }

    public String readRepository() throws IOException {
        String[] repositoryData = OCVSFileUtil.readFileLines(new File(this.getFile(), OCVSFileNameConstants.CVSADM_REP));
        return repositoryData != null && repositoryData.length > 0 ? repositoryData[0] : null;
    }

    public String readTagSpec() throws IOException {
        String[] tagSpecData = OCVSFileUtil.readFileLines(new File(this.getFile(), OCVSFileNameConstants.CVSADM_TAG));
        return tagSpecData != null && tagSpecData.length > 0 ? tagSpecData[0] : null;
    }

    public boolean isStaticDirectory() {
        return new File(this.getFile(), OCVSFileNameConstants.CVSADM_ENTSTAT).exists();
    }

    public boolean isQuestionable() throws IOException {
        return this.readRepository() == null;
    }

    public boolean isManaged() {
        return OCVSDirectory.isManaged(this.getFile());
    }

    public OCVSResource[] listResources() {
        File[] contentsFiles = this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equals("CVS");
            }
        });
        if (contentsFiles == null) {
            return null;
        }
        Arrays.sort(contentsFiles, new Comparator(){

            public int compare(Object o1, Object o2) {
                File file1 = (File)o1;
                File file2 = (File)o2;
                if (file1.isDirectory() != file2.isDirectory()) {
                    return file2.isDirectory() ? -1 : 1;
                }
                return file1.getName().compareTo(file2.getName());
            }
        });
        OCVSResource[] resources = new OCVSResource[contentsFiles.length];
        for (int i = 0; i < resources.length; ++i) {
            resources[i] = this.createChildResource(contentsFiles[i].getName());
        }
        return resources;
    }

    public OCVSEntry[] listEntries() throws IOException, ParseException {
        String[] entriesData = OCVSFileUtil.readFileLines(new File(this.getFile(), OCVSFileNameConstants.CVSADM_ENT));
        if (entriesData == null) {
            return null;
        }
        OCVSEntry[] entries = new OCVSEntry[entriesData.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = OCVSEntry.parseEntrySpec(entriesData[i]);
        }
        return entries;
    }

    @Override
    public String constructRemotePath(String rootPath) throws IOException {
        String repositoryPath = this.readRepository();
        if (repositoryPath == null) {
            return super.constructRemotePath(rootPath);
        }
        StringBuilder remotePathBuffer = new StringBuilder(rootPath);
        remotePathBuffer.append('/');
        remotePathBuffer.append(repositoryPath);
        return remotePathBuffer.toString();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    OCVSResource createChildResource(String fileName) {
        StringBuilder localPathBuffer = new StringBuilder();
        if (!this.getLocalPath().equals(".")) {
            localPathBuffer.append(OCVSPathName.trimServerSeparators(this.getLocalPath()));
            localPathBuffer.append('/');
        }
        localPathBuffer.append(fileName);
        return OCVSResource.createResource(new File(this.getFile(), fileName), localPathBuffer.toString());
    }

    public static final boolean isManaged(File directoryFile) {
        return new File(directoryFile, "CVS").isDirectory();
    }
}

