/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSCommitFileStateVisitor;
import oracle.ocvs.OCVSFileStateVisitor;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSSession;

public class OCVSCommit
extends OCVSCommand {
    public static final OCVSOption OPTION_READ_MESSAGE_FROM_FILE = new OCVSOption(0);
    public static final OCVSOption OPTION_LOG_MESSAGE = new OCVSOption("-m", 2);
    public static final OCVSOption OPTION_FORCE_COMMIT = new OCVSOption("-f", 2);

    public OCVSCommit() {
        super("ci");
    }

    @Override
    public String getCommandId() {
        return "commit";
    }

    @Override
    protected void processOptions(OCVSSession session, Map options) throws IOException, OCVSClientException {
        super.processOptions(session, options);
        if (options.containsKey(OPTION_READ_MESSAGE_FROM_FILE)) {
            if (options.containsKey(OPTION_LOG_MESSAGE)) {
                throw new OCVSClientException("cannot specify both a message and a log file");
            }
            File logFile = new File((String)options.get(OPTION_READ_MESSAGE_FROM_FILE));
            if (!logFile.exists()) {
                throw new OCVSClientException(MessageFormat.format("can''t stat {0}: No such file or directory", logFile.getPath()));
            }
            options.put(OPTION_LOG_MESSAGE, OCVSFileUtil.readFileBytes(logFile));
            return;
        }
        if (!options.containsKey(OPTION_LOG_MESSAGE)) {
            options.put(OPTION_LOG_MESSAGE, "");
        }
    }

    @Override
    protected OCVSFileStateVisitor createResourceVisitor() {
        return new OCVSCommitFileStateVisitor();
    }

    @Override
    protected void sendResourceArguments(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
    }
}

