/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.util.Collection;
import java.util.Map;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSCommandOption;

public class OCVSCommandSpec {
    private final String _tokenSpec;
    private final Class _commandClass;
    private final String _optionSpec;
    private final boolean _useArguments;

    OCVSCommandSpec(String tokenSpec, Class commandClass, String optionSpec) {
        this(tokenSpec, commandClass, optionSpec, true);
    }

    OCVSCommandSpec(String tokenSpec, Class commandClass, String optionSpec, boolean useArguments) {
        this._tokenSpec = tokenSpec;
        this._commandClass = commandClass;
        this._optionSpec = optionSpec;
        this._useArguments = useArguments;
    }

    public String getTokenSpec() {
        return this._tokenSpec;
    }

    public Class getCommandClass() {
        return this._commandClass;
    }

    public String getOptionSpec() {
        return this._optionSpec;
    }

    public boolean getUseArguments() {
        return this._useArguments;
    }

    public void populateOptions(Map options, Collection c) {
        for (OCVSCommandOption cmdOption : c) {
            if (cmdOption.getId() == 'l') {
                options.put(OCVSCommand.OPTION_LOCAL_DIRECTORY_ONLY, null);
            }
            if (cmdOption.getId() == 'R') {
                options.remove(OCVSCommand.OPTION_LOCAL_DIRECTORY_ONLY);
            }
            if (cmdOption.getId() == 'r' && cmdOption.getOccurrence() == 1) {
                options.put(OCVSCommand.OPTION_USE_FILE_REVISION, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'D' && cmdOption.getOccurrence() == 1) {
                options.put(OCVSCommand.OPTION_USE_DATE, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'k') {
                options.put(OCVSCommand.OPTION_USE_RCS_KOPT, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'n') {
                options.put(OCVSCommand.OPTION_DO_NOT_RUN_MODULE_PROGRAM, null);
            }
            if (cmdOption.getId() == 'f') {
                options.put(OCVSCommand.OPTION_FORCE_HEAD_REVISION_MATCH, null);
            }
            this.populateOption(options, cmdOption);
        }
    }

    protected void populateOption(Map options, OCVSCommandOption cmdOption) {
    }
}

