/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.hierarchical.ConstraintManager;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvNodeGroup;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvGroupSpreadConstraint
extends IlvHierarchicalConstraint {
    static final long serialVersionUID = 4738965472489682855L;
    private IlvNodeGroup a;
    private int b;

    public IlvGroupSpreadConstraint(IlvNodeGroup ilvNodeGroup, int n) {
        super(Float.MAX_VALUE);
        this.a = ilvNodeGroup;
        this.setSpreadSize(n);
    }

    public IlvGroupSpreadConstraint(IlvGroupSpreadConstraint ilvGroupSpreadConstraint) {
        super(ilvGroupSpreadConstraint);
        this.a = ilvGroupSpreadConstraint.a;
        this.b = ilvGroupSpreadConstraint.b;
    }

    public IlvGroupSpreadConstraint(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = (IlvNodeGroup)ilvInputStream.readPersistentObject("group");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = null;
        }
        try {
            this.b = ilvInputStream.readInt("spreadSize");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = Integer.MAX_VALUE;
        }
    }

    public IlvHierarchicalConstraint copy() {
        return new IlvGroupSpreadConstraint(this);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("group", (IlvPersistentObject)this.getGroup());
        ilvOutputStream.write("spreadSize", this.b);
    }

    public final IlvNodeGroup getGroup() {
        return this.a;
    }

    public final int getSpreadSize() {
        return this.b;
    }

    public final void setSpreadSize(int n) {
        this.b = n < 0 ? Integer.MAX_VALUE : n;
    }

    final Object c() {
        return this.a;
    }

    final void a(Object object) {
        this.a = (IlvNodeGroup)object;
    }

    final boolean a(IlvGraphModel ilvGraphModel) {
        return this.a(ilvGraphModel, this.getGroup());
    }

    final void a(HGraph hGraph) {
        this.a(true);
        this.a(hGraph, this.getGroup());
    }

    final void a(ConstraintManager constraintManager) {
        constraintManager.a(this.getGroup());
    }
}

