/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.ui.Colors;

public final class DisplayOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private JCheckBox checkBox_showCodeFoldingMargin;
    private JCheckBox checkBox_showCodeFoldingHighlight;
    private JCheckBox checkBox_showWhitespaceChars;
    private JCheckBox checkBox_showRightMargin;
    private WholeNumberField textField_rightMarginColumn;
    private CustomColorChoice colorChoice_rightMarginColor;
    private JCheckBox checkBox_autoBraceMatch;
    private JCheckBox checkBox_braceEnclosingBlock;
    private JCheckBox checkBox_braceEnclosingParens;
    private JSlider slider_braceMatchDelay;
    private JLabel label_braceMatchDelayText;
    private NumberFormat numberFormatter;
    private JCheckBox checkBox_useAAText;
    private JCheckBox checkBox_showBreadcrumbs;
    private JCheckBox checkBox_showScrollTip;

    public DisplayOptionsPanel() {
        this.setHelpID("f1_idedidesetdisplay_html");
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        DisplayOptions displayOptions = DisplayOptions.getInstance(tc.getPropertyStorage());
        boolean showCodeFoldingMargin = displayOptions.getShowCodeFoldingMargin();
        boolean showCodeFoldingHighlight = displayOptions.getShowCodeFoldingHighlight();
        boolean showRightMargin = displayOptions.getShowRightMargin();
        int rightMarginColor = displayOptions.getRightMarginColor();
        this.checkBox_showCodeFoldingMargin.setSelected(showCodeFoldingMargin);
        this.checkBox_showCodeFoldingHighlight.setSelected(showCodeFoldingHighlight);
        this.checkBox_showRightMargin.setSelected(showRightMargin);
        this.colorChoice_rightMarginColor.setClosestSelectedColor(new Color(rightMarginColor));
        boolean autoBraceMatch = displayOptions.getAutoBraceMatch();
        boolean braceEnclosingBlock = displayOptions.getBraceEnclosingBlock();
        boolean braceEnclosingParens = displayOptions.getBraceEnclosingParens();
        int braceMatchDelay = displayOptions.getBraceMatchDelay();
        this.checkBox_autoBraceMatch.setSelected(autoBraceMatch);
        this.checkBox_braceEnclosingBlock.setSelected(braceEnclosingBlock);
        this.checkBox_braceEnclosingParens.setSelected(braceEnclosingParens);
        this.slider_braceMatchDelay.setValue(braceMatchDelay / 100);
        boolean useAAText = displayOptions.getUseAAText();
        this.checkBox_useAAText.setSelected(useAAText);
        this.checkBox_showBreadcrumbs.setSelected(displayOptions.getShowBreadcrumbs());
        this.checkBox_showWhitespaceChars.setSelected(displayOptions.getShowWhitespaceChars());
        this.checkBox_showScrollTip.setSelected(displayOptions.getShowScrollTip());
        if (DisplayOptionsPanel.showMarginColumn()) {
            this.textField_rightMarginColumn.setValue(displayOptions.getRightMarginColumn());
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DisplayOptions displayOptions = DisplayOptions.getInstance(tc.getPropertyStorage());
        if (DisplayOptionsPanel.showMarginColumn()) {
            int rightMarginColumn;
            try {
                rightMarginColumn = this.textField_rightMarginColumn.getValue();
            }
            catch (NullPointerException e) {
                rightMarginColumn = -1;
            }
            if (rightMarginColumn < 10 || rightMarginColumn > 200) {
                String rightMarginError = OptionsArb.getString(30);
                String rightMarginTitle = OptionsArb.getString(31);
                this.showErrorDialog(rightMarginError, rightMarginTitle);
                this.textField_rightMarginColumn.selectAll();
                this.textField_rightMarginColumn.requestFocus();
                throw new TraversalException(null);
            }
        }
        boolean showCodeFoldingMargin = this.checkBox_showCodeFoldingMargin.isSelected();
        boolean showCodeFoldingHighlight = this.checkBox_showCodeFoldingHighlight.isSelected();
        boolean showRightMargin = this.checkBox_showRightMargin.isSelected();
        Color rightMarginColor = this.colorChoice_rightMarginColor.getSelectedColor();
        boolean showWhitespace = this.checkBox_showWhitespaceChars.isSelected();
        displayOptions.setShowCodeFoldingMargin(showCodeFoldingMargin);
        displayOptions.setShowCodeFoldingHighlight(showCodeFoldingHighlight);
        displayOptions.setShowRightMargin(showRightMargin);
        displayOptions.setRightMarginColor(rightMarginColor.getRGB());
        displayOptions.setShowWhitespaceChars(showWhitespace);
        boolean autoBraceMatch = this.checkBox_autoBraceMatch.isSelected();
        boolean braceEnclosingBlock = this.checkBox_braceEnclosingBlock.isSelected();
        boolean braceEnclosingParens = this.checkBox_braceEnclosingParens.isSelected();
        int braceMatchDelay = this.slider_braceMatchDelay.getValue() * 100;
        displayOptions.setAutoBraceMatch(autoBraceMatch);
        displayOptions.setBraceEnclosingBlock(braceEnclosingBlock);
        displayOptions.setBraceEnclosingParens(braceEnclosingParens);
        displayOptions.setBraceMatchDelay(braceMatchDelay);
        boolean useAAText = this.checkBox_useAAText.isSelected();
        displayOptions.setUseAAText(useAAText);
        displayOptions.setShowBreadcrumbs(this.checkBox_showBreadcrumbs.isSelected());
        displayOptions.setShowScrollTip(this.checkBox_showScrollTip.isSelected());
        if (DisplayOptionsPanel.showMarginColumn()) {
            displayOptions.setRightMarginColumn(this.textField_rightMarginColumn.getValue());
        }
    }

    private static boolean showMarginColumn() {
        return !EditorProperties.getProperties().getBooleanProperty("right-margin-column-at-wrap");
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        DisplayOptions displayOptions = DisplayOptions.getInstance(tc.getPropertyStorage());
        DisplayOptionsPanel.applyOptions(displayOptions);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(DisplayOptions displayOptions) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean showCodeFoldingMargin = displayOptions.getShowCodeFoldingMargin();
        properties.putBooleanProperty("code-folding-margin-visible", showCodeFoldingMargin);
        boolean showCodeFoldingHighlight = displayOptions.getShowCodeFoldingHighlight();
        properties.putBooleanProperty("code-folding-highlight", showCodeFoldingHighlight);
        boolean codeFoldingEnabled = displayOptions.getCodeFoldingEnabled();
        properties.putBooleanProperty("code-folding-enabled", codeFoldingEnabled);
        boolean showRightMargin = displayOptions.getShowRightMargin();
        properties.putBooleanProperty("right-margin-visible", showRightMargin);
        boolean rightMarginAtWrap = displayOptions.getRightMarginColumnAtWrap();
        properties.putBooleanProperty("right-margin-column-at-wrap", rightMarginAtWrap);
        if (DisplayOptionsPanel.showMarginColumn()) {
            int rightMarginColumn = displayOptions.getRightMarginColumn();
            properties.putIntegerProperty("right-margin-column", rightMarginColumn);
        }
        int rightMarginColorRGB = displayOptions.getRightMarginColor();
        Color rightMarginColor = new Color(rightMarginColorRGB);
        properties.putProperty("right-margin-color", (Object)rightMarginColor);
        boolean autoBraceMatch = displayOptions.getAutoBraceMatch();
        boolean braceEnclosingBlock = displayOptions.getBraceEnclosingBlock();
        boolean braceEnclosingParens = displayOptions.getBraceEnclosingParens();
        int braceMatchDelay = displayOptions.getBraceMatchDelay();
        properties.putBooleanProperty("brace-matching-auto", autoBraceMatch);
        properties.putBooleanProperty("brace-matching-enclosing-blocks", braceEnclosingBlock);
        properties.putBooleanProperty("brace-matching-enclosing-parens", braceEnclosingParens);
        properties.putIntegerProperty("brace-matching-delay", braceMatchDelay);
        boolean useAAText = displayOptions.getUseAAText();
        properties.putBooleanProperty("editor-antialiasing", useAAText);
        boolean showWhitespaceChars = displayOptions.getShowWhitespaceChars();
        properties.putBooleanProperty("show-whitespace-chars", showWhitespaceChars);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        float value = (float)this.slider_braceMatchDelay.getValue() / 10.0f;
        String valueStr = OptionsArb.format(116, this.numberFormatter.format(value));
        this.slider_braceMatchDelay.setToolTipText(valueStr);
        this.label_braceMatchDelayText.setText(valueStr);
    }

    private void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, title, 2);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String showCodeFoldingMarginText = OptionsArb.getString(21);
        this.checkBox_showCodeFoldingMargin = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showCodeFoldingMargin, (String)showCodeFoldingMarginText);
        String showCodeFoldingHighlightText = OptionsArb.getString(22);
        this.checkBox_showCodeFoldingHighlight = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showCodeFoldingHighlight, (String)showCodeFoldingHighlightText);
        Component[] dependents = new Component[]{this.checkBox_showCodeFoldingHighlight};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_showCodeFoldingMargin, dependents);
        String showRightMarginText = OptionsArb.getString(23);
        this.checkBox_showRightMargin = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showRightMargin, (String)showRightMarginText);
        this.textField_rightMarginColumn = new WholeNumberField(3);
        String rightMarginColorText = OptionsArb.getString(25);
        JLabel label_rightMarginColor = new JLabel();
        this.colorChoice_rightMarginColor = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_rightMarginColor, (Component)this.colorChoice_rightMarginColor, (String)rightMarginColorText);
        JLabel label_rightMarginHint = new JLabel(OptionsArb.getString(24));
        label_rightMarginHint.setForeground(Colors.HINT_TEXT);
        dependents = new Component[]{this.textField_rightMarginColumn, label_rightMarginColor, this.colorChoice_rightMarginColor};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_showRightMargin, dependents);
        String autoBraceMatchText = OptionsArb.getString(26);
        this.checkBox_autoBraceMatch = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autoBraceMatch, (String)autoBraceMatchText);
        String braceEnclosingBlockText = OptionsArb.getString(27);
        this.checkBox_braceEnclosingBlock = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_braceEnclosingBlock, (String)braceEnclosingBlockText);
        String showWhitespaceChars = OptionsArb.getString(19);
        this.checkBox_showWhitespaceChars = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showWhitespaceChars, (String)showWhitespaceChars);
        String braceEnclosingParensText = OptionsArb.getString(28);
        this.checkBox_braceEnclosingParens = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_braceEnclosingParens, (String)braceEnclosingParensText);
        String braceMatchDelayText = OptionsArb.getString(29);
        JLabel label_braceMatchDelay = new JLabel();
        this.slider_braceMatchDelay = new JSlider(1, 20, 2);
        this.slider_braceMatchDelay.addChangeListener(this);
        this.label_braceMatchDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_braceMatchDelay, (Component)this.slider_braceMatchDelay, (String)braceMatchDelayText);
        String minValue = OptionsArb.getString(117);
        String maxValue = OptionsArb.getString(118);
        JLabel label_minValue = new JLabel(minValue);
        JLabel label_maxValue = new JLabel(maxValue);
        this.slider_braceMatchDelay.setPaintLabels(false);
        this.slider_braceMatchDelay.setPaintTicks(true);
        this.slider_braceMatchDelay.setMajorTickSpacing(10);
        this.slider_braceMatchDelay.setMinorTickSpacing(1);
        this.slider_braceMatchDelay.setSnapToTicks(true);
        dependents = new Component[]{this.slider_braceMatchDelay, label_braceMatchDelay, this.label_braceMatchDelayText, label_minValue, label_maxValue, this.checkBox_braceEnclosingBlock, this.checkBox_braceEnclosingParens};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_autoBraceMatch, dependents);
        this.checkBox_autoBraceMatch.addItemListener((ItemListener)tracker);
        this.slider_braceMatchDelay.setValue(1);
        this.checkBox_showScrollTip = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showScrollTip, (String)OptionsArb.getString(33));
        String useAAText = OptionsArb.getString(18);
        this.checkBox_useAAText = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useAAText, (String)useAAText);
        String showBreadcrumbsText = OptionsArb.getString(20);
        this.checkBox_showBreadcrumbs = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showBreadcrumbs, (String)showBreadcrumbsText);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gapy 2"));
        this.add(this.checkBox_useAAText, "span, wrap");
        this.add(this.checkBox_showWhitespaceChars, "span, wrap");
        this.add(this.checkBox_showBreadcrumbs, "span, wrap");
        this.add(this.checkBox_showScrollTip, "span, wrap");
        this.add(this.checkBox_showCodeFoldingMargin, "span, wrap");
        this.add(this.checkBox_showCodeFoldingHighlight, "gapleft 16, span, wrap");
        if (DisplayOptionsPanel.showMarginColumn()) {
            this.add(this.checkBox_showRightMargin, "gaptop 8");
            this.add((Component)this.textField_rightMarginColumn, "gapleft 4, span, wrap");
            this.add(label_rightMarginColor, "gapleft 16");
            this.add((Component)this.colorChoice_rightMarginColor, "wrap");
        } else {
            this.add(this.checkBox_showRightMargin, "gaptop 8, span, wrap");
            this.add(label_rightMarginColor, "gapleft 16");
            this.add((Component)this.colorChoice_rightMarginColor, "wrap");
            this.add(label_rightMarginHint, "gapleft 16, wrap, span");
        }
        this.add(this.checkBox_autoBraceMatch, "span, gaptop 8, wrap");
        this.add(this.checkBox_braceEnclosingBlock, "gapleft 16, span, wrap");
        this.add(this.checkBox_braceEnclosingParens, "gapleft 16, span, wrap");
        this.add(label_braceMatchDelay, "gapleft 16, span, wrap, gaptop 4");
        this.add(label_minValue, "gapleft 16, split, span, top, gaptop 4");
        this.add(this.slider_braceMatchDelay, "top, gaptop 4");
        this.add(label_maxValue, "wrap, top, gaptop 4");
        this.add(this.label_braceMatchDelayText, "gapleft 16, span, wrap, center");
    }
}

