/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.CEditor;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.plugins.EditorPlugin;

public class SelectionSurroundPlugin
implements EditorPlugin {
    private final Listener listener = new Listener();
    private BasicEditorPane editor;
    private final char[][] surrounds = new char[][]{{'\'', '\''}, {'\"', '\"'}, {'[', ']'}, {'(', ')'}, {'{', '}'}};

    public void install(BasicEditorPane editor) {
        editor.addKeyListener((KeyListener)this.listener);
        this.editor = editor;
    }

    public void deinstall(BasicEditorPane editor) {
        editor.removeKeyListener((KeyListener)this.listener);
        editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected char[][] getSurrounds() {
        return this.surrounds;
    }

    private class Listener
    extends KeyAdapter {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyTyped(KeyEvent e) {
            EditorOptions options = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            if (!options.getAutoSurroundSelection()) {
                return;
            }
            if (e.isAltDown() || e.isMetaDown() || e.isControlDown()) {
                return;
            }
            char keyChar = e.getKeyChar();
            char[] foundSurround = null;
            for (char[] surround : SelectionSurroundPlugin.this.getSurrounds()) {
                if (keyChar != surround[0]) continue;
                foundSurround = surround;
                break;
            }
            if (foundSurround != null && SelectionSurroundPlugin.this.editor.hasSelection()) {
                if (!SelectionSurroundPlugin.this.editor.makeEditable()) {
                    return;
                }
                SelectionSurroundPlugin.this.editor.beginEdit(new EditDescriptor(CEditor.get("UNDO_AUTO_SURROUND_SELECTION")));
                try {
                    int start = SelectionSurroundPlugin.this.editor.getSelectionStart();
                    int end = SelectionSurroundPlugin.this.editor.getSelectionEnd();
                    SelectionSurroundPlugin.this.editor.insertString(end, "" + foundSurround[1], null);
                    SelectionSurroundPlugin.this.editor.insertString(start, "" + foundSurround[0], null);
                    SelectionSurroundPlugin.this.editor.select(start + 1, end + 1);
                    e.consume();
                }
                catch (BadLocationException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                }
                finally {
                    SelectionSurroundPlugin.this.editor.endEdit();
                }
            }
        }
    }
}

