/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.CodeEditorDragDropPlugin;
import oracle.ide.ceditor.CodeEditorFeedbackManager;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorHelpableProvider;
import oracle.ide.ceditor.CodeEditorHook;
import oracle.ide.ceditor.CodeEditorScrollableSectionView;
import oracle.ide.ceditor.CodeEditorSectionView;
import oracle.ide.ceditor.CodeEditorViewSelectionSetter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.ceditor.DropHandlerPlugin;
import oracle.ide.ceditor.EditorOffsetLabel;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.LongLineDetector;
import oracle.ide.ceditor.MarginLayout;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.ViewLimitProvider;
import oracle.ide.ceditor.ViewLimitProviderFactory;
import oracle.ide.ceditor.ViewSelectionHelper;
import oracle.ide.ceditor.ViewSelectionHelperFactory;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.TextEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.help.HelpableProvider;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.Layout;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.editor.EditorException;
import oracle.ideimpl.util.DropFileUtil;
import oracle.ideimpl.vcs.VCSUtil;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.NavigationListener;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.editor.plugins.TrailingSpacePlugin;
import oracle.javatools.ui.SectionView;
import oracle.javatools.ui.overview.Overview;
import oracle.javatools.ui.overview.OverviewListener;
import oracle.javatools.ui.overview.OverviewStatus;
import oracle.javatools.util.Pair;

public final class CodeEditor
extends Editor
implements CaretListener,
FindableEditor,
BasicEditorPaneContainer,
ToolTipProvider,
UndoableEditListener,
BaseLayoutListener,
PopupManager,
TextEditor,
PropertyChangeListener {
    @Deprecated
    public static final String EDITOR_CONTEXT = "editor-ide-context";
    private static final int DEFAULT_CURSOR_LISTENER_DELAY = 250;
    private JComponent fixedBottomMargin = new JPanel((LayoutManager)new MigLayout("ins 0, gap 0 0, fill, hidemode 2, wrap 1", "[fill]", ""));
    private JComponent fixedRightMargin;
    private JComponent fixedTopMargin;
    private VetoableChangeListener vetoableChangeListener;
    @Deprecated
    public static final String TYPE_PLAIN = CodeEditorConstants.TYPE_PLAIN;
    @Deprecated
    public static final String TYPE_JAVA = CodeEditorConstants.TYPE_JAVA;
    @Deprecated
    public static final String TYPE_SQL = CodeEditorConstants.TYPE_SQL;
    @Deprecated
    public static final String TYPE_PLSQL = CodeEditorConstants.TYPE_PLSQL;
    @Deprecated
    public static final String TYPE_JSP = CodeEditorConstants.TYPE_JSP;
    @Deprecated
    public static final String TYPE_HTML = CodeEditorConstants.TYPE_HTML;
    @Deprecated
    public static final String TYPE_XML = CodeEditorConstants.TYPE_XML;
    @Deprecated
    public static final String TYPE_PROPERTIES = CodeEditorConstants.TYPE_PROPERTIES;
    @Deprecated
    public static final String TYPE_IDL = CodeEditorConstants.TYPE_IDL;
    @Deprecated
    public static final String TYPE_CPP = CodeEditorConstants.TYPE_CPP;
    @Deprecated
    public static final String TYPE_JS = CodeEditorConstants.TYPE_JS;
    @Deprecated
    public static final String TYPE_DIFF = CodeEditorConstants.TYPE_DIFF;
    private BasicEditorPane editorComponent;
    private SectionView editorSectionView;
    private SectionView lMarginSectionView;
    private JPanel leftMargin;
    private CEToolbar topToolbar;
    private MyStructureChangeListener structureChangeListener;
    private CodeEditorGutter gutterComponent;
    private CodeFoldingMargin codeFoldingMargin;
    private BasicEditorOverview overview;
    @Deprecated
    private FileOverviewMargin fileOverviewMargin;
    private List<CursorListener> cursorListeners;
    private List<CursorListener> cursorListenersBatched;
    private Timer cursorListenerTimer;
    private List<HelpableProvider> helpableProviders;
    private HelpInfo helpInfo;
    private NodeUpdater nodeUpdater;
    private TextBufferL textBufferL;
    private List<CEToolTipProvider> ceToolTipProviders;
    private static final String OFFSET_PROP = "offset";
    private static final String TAB_SIZE_PROP = "tabsize";
    private TextNode ideNode;
    private static List<EditorPluginsFactory> pluginsFactoryList;
    private static List<ViewSelectionHelperFactory> viewSelectionHelperFactoryList;
    private List<ViewSelectionHelper> viewSelectionHelperList;
    private static List<ViewLimitProviderFactory> viewLimitProviderFactoryList;
    private ViewLimitProvider viewLimitProvider;
    private static List<Class> classList;
    private static List<String> typeList;
    private Element[] viewSelection;
    private NavigationListener navigationL;
    private static final DataFlavor CONTEXT_FLAVOR;
    private static final DataFlavor FILELIST_FLAVOR;
    private static final DataFlavor URILIST_FLAVOR;
    private static final DataFlavor[] EXTRA_CUSTOM_FLAVORS;

    public CodeEditor() {
        this.fixedBottomMargin.setOpaque(false);
        this.fixedRightMargin = new JPanel((LayoutManager)new MigLayout("ins 0, gap 0 0, fill"));
        this.fixedRightMargin.setOpaque(false);
        this.fixedTopMargin = new JPanel((LayoutManager)new MigLayout("ins 0, gap 0 0, fill, hidemode 2, wrap 1", "[fill]", ""));
        this.fixedTopMargin.setOpaque(false);
        this.viewSelection = EMPTY_SELECTION;
        this.cursorListeners = new CopyOnWriteArrayList<CursorListener>();
        this.cursorListenersBatched = new CopyOnWriteArrayList<CursorListener>();
        this.helpableProviders = new CopyOnWriteArrayList<HelpableProvider>();
        this.ceToolTipProviders = new CopyOnWriteArrayList<CEToolTipProvider>();
    }

    @Deprecated
    public static void registerFactory(EditorPluginsFactory factory) {
        if (factory != null) {
            pluginsFactoryList.add(factory);
        }
    }

    static void registerFactoryDirectly(EditorPluginsFactory factory) {
        if (factory != null) {
            pluginsFactoryList.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNodeType(Class nodeClass, String highlightingType) {
        Class<TextNode> textNodeClass = TextNode.class;
        if (textNodeClass.isAssignableFrom(nodeClass)) {
            List<Class> list = classList;
            synchronized (list) {
                classList.add(nodeClass);
                typeList.add(highlightingType);
            }
        } else {
            Assert.println((String)("CodeEditor: node class does not implement TextNode: " + nodeClass.getName()));
        }
    }

    public void changeDocumentType(String highlightingType) {
        LanguageSupport support = LanguageModule.createSupportForFileType((String)highlightingType);
        if (support != null) {
            BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
            document.setLanguageSupport(support);
        }
    }

    public static HighlightStyle createHighlightStyle(String internalName, String publicName, int priority, Color fgColor, Color bgColor) {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        return registry.createStyle(internalName, publicName, true, priority, fgColor, bgColor);
    }

    public static HighlightStyle createHighlightStyle(String internalName, String publicName, int priority, Color fgColor, Color bgColor, int fontStyle, int underlinePredefine, Color underlineColor) {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        return registry.createStyle(internalName, publicName, true, priority, fgColor, bgColor, fontStyle, underlinePredefine, underlineColor);
    }

    public Toolbar getToolbar() {
        if (this.topToolbar == null) {
            this.topToolbar = new CEToolbar();
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            this.structureChangeListener = new MyStructureChangeListener();
            editorOptions.addStructureChangeListener(this.structureChangeListener);
            this.fixedTopMargin.add((Component)((Object)this.topToolbar), "dock north, growx, wmin 10");
        }
        return this.topToolbar;
    }

    public void setFixedBottomMarginComponent(JComponent panel) {
        if (panel == null) {
            throw new IllegalStateException();
        }
        String CLIENTKEY = "client_key";
        panel.putClientProperty(CLIENTKEY, Boolean.TRUE);
        for (Component c : this.fixedBottomMargin.getComponents()) {
            if (!(c instanceof JComponent) || ((JComponent)c).getClientProperty(CLIENTKEY) != Boolean.TRUE) continue;
            this.fixedBottomMargin.remove(c);
            break;
        }
        this.fixedBottomMargin.add((Component)panel, "Center");
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.editorComponent.getText(offset, length);
    }

    public void setCaretPosition(int offset) {
        this.editorComponent.setCaretPosition(offset);
    }

    public void moveCaretPosition(int offset) {
        this.editorComponent.moveCaretPosition(offset);
    }

    public int getCaretPosition() {
        return this.editorComponent.getCaretPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretLine() {
        BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
        document.readLock();
        int line = 0;
        try {
            int offset = this.editorComponent.getCaretPosition();
            LineMap lineMap = document.getLineMap();
            line = lineMap.getLineFromOffset(offset);
        }
        finally {
            document.readUnlock();
        }
        return ++line;
    }

    public void replaceSelection(String content) {
        this.editorComponent.replaceSelection(content);
    }

    public boolean hasSelectedText() {
        int selectionEnd;
        int selectionStart = this.editorComponent.getSelectionStart();
        return selectionStart != (selectionEnd = this.editorComponent.getSelectionEnd());
    }

    public String getSelectedText() {
        return this.editorComponent.getSelectedText();
    }

    public int getSelectionStart() {
        return this.editorComponent == null ? 0 : this.editorComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.editorComponent == null ? 0 : this.editorComponent.getSelectionEnd();
    }

    public void setSelectionStart(int selectionStart) {
        this.editorComponent.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        this.editorComponent.setSelectionEnd(selectionEnd);
    }

    public void addCursorListener(CursorListener listener) {
        this.addCursorListener(listener, false);
    }

    public void addCursorListener(CursorListener listener, boolean batchEvents) {
        if (batchEvents) {
            if (!this.cursorListenersBatched.contains(listener)) {
                this.cursorListenersBatched.add(listener);
            }
        } else if (this.cursorListeners != null && !this.cursorListeners.contains(listener)) {
            this.cursorListeners.add(listener);
        }
    }

    public void removeCursorListener(CursorListener listener) {
        int index;
        if (this.cursorListeners != null && (index = this.cursorListeners.indexOf(listener)) != -1) {
            this.cursorListeners.remove(index);
        }
        this.cursorListenersBatched.remove(listener);
    }

    public CodeEditorGutter getGutter() {
        return this.gutterComponent;
    }

    @Deprecated
    public FileOverviewMargin getFileOverviewMargin() {
        return this.fileOverviewMargin;
    }

    public BasicEditorOverview getOverview() {
        return this.overview;
    }

    public void addCEToolTipProvider(CEToolTipProvider provider) {
        if (this.editorComponent != null) {
            if (this.ceToolTipProviders.size() == 0) {
                this.editorComponent.addToolTipProvider((ToolTipProvider)this);
            }
            this.ceToolTipProviders.add(provider);
        }
    }

    public void removeCEToolTipProvider(CEToolTipProvider provider) {
        if (this.editorComponent != null) {
            this.ceToolTipProviders.remove(provider);
            if (this.ceToolTipProviders.size() == 0) {
                this.editorComponent.removeToolTipProvider((ToolTipProvider)this);
            }
        }
    }

    public boolean gotoOffset(int offset, int selectionLength) {
        BasicDocument document = (BasicDocument)this.editorComponent.getDocument();
        int documentLength = document.getLength();
        int startOffset = Math.max(0, Math.min(offset, documentLength));
        int endOffset = Math.max(startOffset, Math.min(startOffset + selectionLength, documentLength));
        this.editorComponent.setCaretPositionCenter(startOffset);
        if (startOffset != endOffset) {
            this.editorComponent.moveCaretPositionCenter(endOffset);
        }
        return offset == startOffset && selectionLength == endOffset - startOffset;
    }

    public boolean gotoLine(int line, int column, boolean highlightLine) {
        return this.editorComponent.gotoLine(line, column, highlightLine);
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.editorComponent;
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            this.fireBatchedCursorUpdate();
            Context context = new Context(this.getContext());
            if (context.getElement() == null) {
                Node element = context.getNode();
                context.setSelection(new Element[]{element});
                context.setElement((Element)element);
            }
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup(BasicEditorPane editorPane) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("code-folding-margin")) {
            if (this.codeFoldingMargin != null) {
                this.leftMargin.remove((Component)this.codeFoldingMargin);
            }
            this.codeFoldingMargin = (CodeFoldingMargin)event.getNewValue();
            if (this.codeFoldingMargin != null) {
                this.leftMargin.add((Component)this.codeFoldingMargin, "dock east");
            }
        } else if (propertyName.equals("editor-font") && this.editorComponent.getCaret() instanceof BasicCaret) {
            BasicCaret bCaret = (BasicCaret)this.editorComponent.getCaret();
            if (bCaret.getEditorSelection() instanceof EditorSelectionColumns && !EditorSelectionColumns.isEditorFixedWidthFont((BasicEditorPane)this.editorComponent)) {
                IdeAction action = IdeAction.get((int)81);
                action.setState(true);
            }
        } else if (propertyName.equals("view-limited")) {
            try {
                int y1 = -1;
                int y2 = -1;
                int startOffset = this.editorComponent.getValidOffsetStart();
                int endOffset = this.editorComponent.getValidOffsetEnd();
                if (startOffset != -1 && endOffset != -1) {
                    Rectangle r = this.editorComponent.modelToView(startOffset);
                    if (r == null) {
                        return;
                    }
                    y1 = r.y;
                    r = this.editorComponent.modelToView(endOffset);
                    if (r == null) {
                        return;
                    }
                    y2 = r.y + r.height;
                }
                this.editorSectionView.setViewBounds(y1, y2);
                this.lMarginSectionView.setViewBounds(y1, y2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        CodeEditorController editorController = (CodeEditorController)this.getController();
        Context context = this.getContext();
        if (Ide.getMainWindow().getLastActiveView() == this) {
            editorController.checkCommandsAfterNavigation(context);
        }
        for (CursorListener listener : this.cursorListeners) {
            try {
                listener.cursorUpdate(this);
            }
            catch (RuntimeException runtimeException) {}
        }
        this._startOrResetCursorListenerTimer();
    }

    private void _startOrResetCursorListenerTimer() {
        if (this.cursorListenerTimer == null) {
            this.cursorListenerTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CodeEditor.this.fireBatchedCursorUpdate();
                }
            });
            this.cursorListenerTimer.setRepeats(false);
            this.cursorListenerTimer.start();
        } else {
            this.cursorListenerTimer.restart();
        }
    }

    private void fireBatchedCursorUpdate() {
        int listSize;
        int i = listSize = this.cursorListenersBatched.size();
        while (i > 0) {
            CursorListener listener = this.cursorListenersBatched.get(--i);
            try {
                listener.cursorUpdate(this);
            }
            catch (RuntimeException runtimeException) {}
        }
        this.cursorListenerTimer = null;
    }

    public int getLineCount() {
        return this.editorComponent.getLineCount();
    }

    public int getLineFromOffset(int offset) {
        return this.editorComponent.getLineFromOffset(offset) + 1;
    }

    public int getLineStartOffset(int line) {
        return this.editorComponent.getLineStartOffset(line - 1);
    }

    public int getLineEndOffset(int line) {
        return this.editorComponent.getLineEndOffset(line - 1);
    }

    public static Context getContext(BasicEditorPane editor) {
        Context context = (Context)editor.getProperty(EDITOR_CONTEXT);
        return context;
    }

    protected Element[] getSelectionFromUI() {
        if (this.viewSelection != null) {
            return this.viewSelection;
        }
        if (this.ideNode != null) {
            return new Element[]{this.ideNode};
        }
        return EMPTY_SELECTION;
    }

    public static void registerViewSelectionHelperFactory(ViewSelectionHelperFactory factory) {
        if (!viewSelectionHelperFactoryList.contains(factory)) {
            viewSelectionHelperFactoryList.add(factory);
        }
    }

    public static void registerViewLimitProviderFactory(ViewLimitProviderFactory factory) {
        if (!viewLimitProviderFactoryList.contains(factory)) {
            viewLimitProviderFactoryList.add(factory);
        }
    }

    ViewLimitProvider getViewLimitProvider() {
        return this.viewLimitProvider;
    }

    public static CodeEditor getCodeEditor(BasicEditorPane editor) {
        View view;
        Context context = CodeEditor.getContext(editor);
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            return (CodeEditor)view;
        }
        return null;
    }

    public synchronized void setContext(Context context) {
        Node node;
        if (context != null && (node = context.getNode()) instanceof TextNode) {
            Context ourContext = new Context(context);
            Node element = context.getNode();
            ourContext.setSelection(new Element[]{element});
            ourContext.setElement((Element)element);
            if (this.editorComponent == null) {
                this.ideNode = (TextNode)node;
                this.updateSelection();
                super.setContext(ourContext);
                Context realContext = this.getContext();
                this.initializeEditor(realContext);
            } else {
                if (node != this.ideNode) {
                    throw new IllegalStateException("Reset of context w/ different node");
                }
                super.setContext(ourContext);
                Context realContext = this.getContext();
                this.updateEditorContext(realContext);
            }
        }
    }

    public void open() {
        this.editorComponent.requestFocus();
    }

    public Component getDefaultFocusComponent() {
        return this.editorComponent;
    }

    public void close() {
        super.close();
        EditorManager.getEditorManager().removeLayoutListener(this.getId());
        this.gutterComponent.removeAllGutterColumns();
        this.gutterComponent = null;
        this.fileOverviewMargin = null;
        this.overview.dispose();
        this.overview = null;
        if (this.topToolbar != null) {
            this.topToolbar.dispose();
            this.topToolbar.removeAll();
        }
        if (this.structureChangeListener != null) {
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            editorOptions.removeStructureChangeListener(this.structureChangeListener);
            this.structureChangeListener = null;
        }
        this.editorComponent.removeVetoableChangeListener(this.vetoableChangeListener);
        BasicDocument editorDocument = (BasicDocument)this.editorComponent.getDocument();
        editorDocument.removeUndoableEditListener((UndoableEditListener)this);
        this.editorComponent.removePopupManager((PopupManager)this);
        this.editorComponent.removeCaretListener((CaretListener)this);
        this.editorComponent.removeNavigationListener(this.navigationL);
        this.editorComponent.removePropertyChangeListener((PropertyChangeListener)this);
        this.editorComponent.dispose();
        this.editorComponent = null;
        editorDocument.getTextBuffer().removeTextBufferListener((TextBufferListener)this.textBufferL);
        this.editorSectionView.setWrappedComponent(null);
        this.editorSectionView = null;
        this.lMarginSectionView.setWrappedComponent(null);
        this.lMarginSectionView = null;
        this.ceToolTipProviders.clear();
        this.ceToolTipProviders = null;
        for (ViewSelectionHelper vsHelper : this.viewSelectionHelperList) {
            vsHelper.detach(this);
        }
        this.cursorListeners = null;
        this.cursorListenersBatched.clear();
        this.nodeUpdater = null;
    }

    public Controller getController() {
        return CodeEditorController.getDefaultController();
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute.equals("menu_id")) {
            return CEditorArb.getString(6);
        }
        return super.getEditorAttribute(attribute);
    }

    public void saveSettings(StructuredPropertyAccess node) {
        try {
            int caretPosition = this.getCaretPosition();
            node.setProperty(OFFSET_PROP, Integer.toString(caretPosition));
            int tabSize = this.editorComponent.getIntegerProperty("tab-size");
            node.setProperty(TAB_SIZE_PROP, Integer.toString(tabSize));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        super.saveSettings(node);
    }

    public void loadSettings(StructuredPropertyAccess node) {
        int caretPos = node.getIntegerProperty(OFFSET_PROP, 0);
        int tabSize = node.getIntegerProperty(TAB_SIZE_PROP, 0);
        this.editorComponent.setCaretPositionCenter(caretPos);
        if (tabSize != 0) {
            this.editorComponent.putIntegerProperty("tab-size", tabSize);
        }
        super.loadSettings(node);
    }

    public Component getGUI() {
        return this.editorSectionView;
    }

    public Component getScrollableLeftMargin() {
        return this.lMarginSectionView;
    }

    public void addComponentToMargin(JComponent component, MarginLocation marginLocation) {
        switch (marginLocation) {
            case LEFT: {
                this.leftMargin.add((Component)component, Math.min(1, this.leftMargin.getComponentCount()));
                break;
            }
            case TOP: {
                this.fixedTopMargin.add((Component)component, "dock south, growx, wmin 10");
                break;
            }
            case BOTTOM: {
                this.fixedBottomMargin.add((Component)component, "dock north, growx, wmin 10");
                break;
            }
            case RIGHT: {
                this.fixedRightMargin.add((Component)component, "dock west");
            }
        }
    }

    public Component getFixedRightMargin() {
        return this.fixedRightMargin;
    }

    public Component getFixedTopMargin() {
        if (this.topToolbar == null) {
            this.getToolbar();
        }
        return this.fixedTopMargin;
    }

    public Component getFixedBottomMargin() {
        return this.fixedBottomMargin;
    }

    public Icon getTabIcon() {
        return CEditorArb.getIcon(2);
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
        CEToolTipProvider provider;
        String result = null;
        Iterator<CEToolTipProvider> iterator = this.ceToolTipProviders.iterator();
        while (iterator.hasNext() && ((result = (provider = iterator.next()).getToolTipText(this, mouseEvent, offset)) == null || result.length() <= 0)) {
        }
        return result;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent event) {
        UndoableEdit edit = event.getEdit();
        UndoWrapperCommand command = new UndoWrapperCommand(edit, this.nodeUpdater);
        CommandProcessor processor = CommandProcessor.getInstance();
        command.setContext(this.getContext());
        try {
            processor.invoke((Command)command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(Layout layout) {
    }

    public void init(Layout layout) {
    }

    public void close(Layout layout) {
    }

    public HelpInfo getHelpInfo() {
        HelpInfo helpInfo = null;
        String filename = this.ideNode.getURL().getFile();
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex > -1 && dotIndex < filename.length()) {
            String extension = filename.substring(dotIndex + 1);
            Collection<CodeEditorHelpableProvider> helpableProviders = CodeEditorHook.get().codeEditorHelpableProviders(extension, (Node)this.ideNode);
            for (CodeEditorHelpableProvider helpableProvider : helpableProviders) {
                if (helpableProvider.hasHelpInfo(this, this.getCaretPosition())) {
                    // empty if block
                }
                if ((helpInfo = helpableProvider.getHelpInfo(this, this.getCaretPosition())) == null) continue;
                break;
            }
        }
        if (helpInfo == null) {
            HelpableProvider provider;
            int numProviders = this.helpableProviders.size();
            boolean hasNull = false;
            for (int i = numProviders - 1; i >= 0; --i) {
                provider = this.helpableProviders.get(i);
                if (provider != null) {
                    helpInfo = provider.getHelpInfo((Helpable)this);
                } else {
                    hasNull = true;
                }
                if (helpInfo != null) break;
            }
            if (hasNull) {
                Iterator<HelpableProvider> iterator = this.helpableProviders.iterator();
                while (iterator.hasNext()) {
                    provider = iterator.next();
                    if (provider != null) continue;
                    iterator.remove();
                }
            }
        }
        if (helpInfo != null) {
            return helpInfo;
        }
        if (this.helpInfo != null) {
            return this.helpInfo;
        }
        return new HelpInfo("f1_idecodeeditor_html");
    }

    public void setHelpInfo(HelpInfo helpInfo) {
        this.helpInfo = helpInfo;
    }

    public void setToolbarHelpInfo(HelpInfo helpInfo) {
        CEToolbar toolbar = (CEToolbar)this.getToolbar();
        toolbar.setHelpInfo(helpInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHelpableProvider(HelpableProvider helpableProvider) {
        List<HelpableProvider> list = this.helpableProviders;
        synchronized (list) {
            if (!this.helpableProviders.contains(helpableProvider)) {
                this.helpableProviders.add(helpableProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHelpableProvider(HelpableProvider helpableProvider) {
        List<HelpableProvider> list = this.helpableProviders;
        synchronized (list) {
            int index = this.helpableProviders.indexOf(helpableProvider);
            if (index != -1) {
                this.helpableProviders.set(index, null);
            }
        }
    }

    @Deprecated
    public void setHelpableProvider(HelpableProvider helpableProvider) {
        this.addHelpableProvider(helpableProvider);
    }

    @Deprecated
    public HelpableProvider getHelpableProvider() {
        return null;
    }

    private void updateEditorContext(Context context) {
        this.editorComponent.putProperty(EDITOR_CONTEXT, (Object)context);
    }

    private void initializeEditor(Context context) {
        TextBuffer textBuffer = null;
        try {
            textBuffer = this.ideNode.acquireTextBufferOrThrow();
        }
        catch (IOException exception) {
            Logger.getLogger("global").log(Level.SEVERE, "Error aquiring text buffer: " + exception.getLocalizedMessage(), exception);
            throw new EditorException(EditorException.Type.CREATION, true, (Throwable)exception);
        }
        LongLineDetector.detectLongLines(textBuffer, context);
        EditorManager.getEditorManager().addLayoutListener(this.getId(), (BaseLayoutListener)this);
        this.editorComponent = EditorFactory.createIdeEditorPane();
        this.fixedBottomMargin.add((Component)new EditorOffsetLabel(this.editorComponent), "dock east");
        this.editorSectionView = new CodeEditorScrollableSectionView((JComponent)this.editorComponent);
        this.updateEditorContext(context);
        URL docURL = this.ideNode.getURL();
        URL parentURL = URLFileSystem.getParent((URL)docURL);
        String docFilename = URLFileSystem.getFileName((URL)docURL);
        String docDirectory = URLFileSystem.getPlatformPathName((URL)parentURL);
        String accessibleName = CEditorArb.format(9, docFilename, docDirectory);
        AccessibleUtils.updateAccessibleName((Accessible)this.editorComponent, (String)accessibleName, (boolean)true);
        String nodeType = CodeEditor.getTypeForNode(this.ideNode);
        if (nodeType == null) {
            nodeType = URLFileSystem.getPlatformPathName((URL)this.ideNode.getURL());
        }
        BasicDocument editorDocument = new BasicDocument(nodeType, textBuffer);
        editorDocument.addUndoableEditListener((UndoableEditListener)this);
        this.editorComponent.setDocument((Document)editorDocument);
        Attributes attributes = this.ideNode.getAttributes();
        if (attributes.isSet(ElementAttributes.NON_EDITABLE)) {
            this.editorComponent.setProtected(true);
        }
        this.editorComponent.addPopupManager((PopupManager)this);
        this.editorComponent.addCaretListener((CaretListener)this);
        this.navigationL = new NavigationL();
        this.editorComponent.addNavigationListener(this.navigationL);
        this.editorComponent.setFocusTraversalKeysEnabled(false);
        TrailingSpacePlugin trailingPlugin = new TrailingSpacePlugin();
        this.editorComponent.installPlugin((EditorPlugin)trailingPlugin);
        this.leftMargin = new JPanel(new MarginLayout(1));
        this.gutterComponent = new CodeEditorGutter(this);
        this.editorComponent.installPlugin((EditorPlugin)this.gutterComponent);
        this.leftMargin.add((Component)((Object)this.gutterComponent), "");
        this.lMarginSectionView = new CodeEditorSectionView(this.leftMargin){

            public Color getBackground() {
                if (CodeEditor.this.editorComponent == null) {
                    return Color.WHITE;
                }
                return CodeEditor.this.editorComponent.getBackground();
            }
        };
        this.editorComponent.addPropertyChangeListener((PropertyChangeListener)this);
        this.fileOverviewMargin = new FileOverviewMargin();
        this.overview = this.createOverview();
        this.fixedRightMargin.add((Component)this.overview.getGUI(), "grow,dock east");
        this.editorComponent.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.editorComponent.installPlugin((EditorPlugin)new CodeEditorDragDropPlugin());
        this.installPluginsDeclared();
        this.installPluginsRegistered();
        this.editorComponent.installPlugin((EditorPlugin)new CEOpenEditorDropHandler());
        this.viewSelectionHelperList = new ArrayList<ViewSelectionHelper>();
        ViewSelectionSetterHelper setter = new ViewSelectionSetterHelper();
        for (ViewSelectionHelperFactory vshFactory : viewSelectionHelperFactoryList) {
            ViewSelectionHelper helper = vshFactory.createSelectionHelper(this);
            if (helper == null) continue;
            this.viewSelectionHelperList.add(helper);
            helper.attach(this, setter);
        }
        for (ViewLimitProviderFactory factory : viewLimitProviderFactoryList) {
            ViewLimitProvider provider = factory.createViewLimitProvider(this);
            if (provider == null) continue;
            if (this.viewLimitProvider != null) {
                throw new IllegalStateException("Two ViewLimitProviders are attempting to attach to the same CodeEditor instance.\n" + this.viewLimitProvider + "\n" + provider);
            }
            this.viewLimitProvider = provider;
            provider.attach(this);
        }
        this.vetoableChangeListener = new VetoableChangeL(this.ideNode);
        this.editorComponent.addVetoableChangeListener(this.vetoableChangeListener);
        this.nodeUpdater = NodeUpdater.getUpdater((Subject)this.ideNode, textBuffer);
        this.textBufferL = new TextBufferL();
        textBuffer.addTextBufferListener((TextBufferListener)this.textBufferL);
        this.editorComponent.addFeedbackManager((FeedbackManager)new CodeEditorFeedbackManager());
        if (this.editorComponent.getCaret() instanceof BasicCaret) {
            EditorSelectionColumns editorSelection;
            IdeAction action = IdeAction.get((int)81);
            boolean shouldBlock = action.getState();
            if (shouldBlock) {
                editorSelection = new EditorSelectionColumns();
                if (editorSelection.canSupportEditor(this.editorComponent)) {
                    this.editorComponent.putIntegerProperty("caret-editor-selection-type", 21);
                } else {
                    editorSelection = new EditorSelectionWrap();
                    this.editorComponent.putIntegerProperty("caret-editor-selection-type", 20);
                    action.setState(true);
                }
            } else {
                editorSelection = new EditorSelectionWrap();
                this.editorComponent.putIntegerProperty("caret-editor-selection-type", 20);
            }
            ((BasicCaret)this.editorComponent.getCaret()).setEditorSelection((EditorSelection)editorSelection);
            editorSelection.install(this.editorComponent);
        }
    }

    private void installPluginsRegistered() {
        Context ideContext = this.getContext();
        for (EditorPluginsFactory factory : pluginsFactoryList) {
            try {
                List pluginsList = factory.createPlugins(ideContext);
                int numPlugins = pluginsList.size();
                for (int j = 0; j < numPlugins; ++j) {
                    EditorPlugin plugin = (EditorPlugin)pluginsList.get(j);
                    if (!(plugin instanceof EditorPlugin)) continue;
                    this.editorComponent.installPlugin(plugin);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private void installPluginsDeclared() {
        try {
            CodeEditorHook codeEditorHook = CodeEditorHook.get();
            String filename = this.ideNode.getURL().getFile();
            Collection<EditorPlugin> editorPluginCollection = null;
            int dotIndex = filename.lastIndexOf(".");
            if (dotIndex > -1 && dotIndex < filename.length()) {
                String extension = filename.substring(dotIndex + 1);
                editorPluginCollection = codeEditorHook.editorPlugins(extension, (Node)this.ideNode);
            }
            if (editorPluginCollection == null) {
                editorPluginCollection = codeEditorHook.editorPlugins(null, (Node)this.ideNode);
            }
            for (EditorPlugin editorPlugin : editorPluginCollection) {
                this.editorComponent.installPlugin(editorPlugin);
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.WARNING, "CodeEditor: Cannot create declared code editor plugins", e);
        }
    }

    private BasicEditorOverview createOverview() {
        final BasicEditorOverview overview = new BasicEditorOverview(this.editorComponent);
        overview.setShowCaretMark(true);
        overview.setShowEditMark(true);
        overview.setStatus(new OverviewStatus((Overview)overview));
        overview.addOverviewListener((OverviewListener)new OverviewListener<BasicEditorOverviewMark>(){

            public void markAdded(BasicEditorOverviewMark overviewMark) {
            }

            public void markRemoved(BasicEditorOverviewMark overviewMark) {
            }

            public void markClicked(BasicEditorOverviewMark overviewMark) {
                try {
                    int selectionStart = overviewMark.getStartOffset();
                    if (selectionStart < 0) {
                        return;
                    }
                    int selectionLength = overviewMark.getEndOffset() - selectionStart;
                    OffsetNavigationPoint point = new OffsetNavigationPoint(CodeEditor.this.getContext(), selectionStart, selectionLength);
                    NavigationManager.getNavigationManager().navigateTo((NavigationPoint)point);
                    return;
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                    return;
                }
            }

            public void overviewClicked(float relativeLocation) {
                int line = CodeEditor.this.editorComponent.getLineCount();
                int row = CodeEditor.this.editorComponent.getRowForLine(line) - 1;
                int navRow = Math.round((float)row * relativeLocation) + 1;
                line = CodeEditor.this.editorComponent.getLineFromRow(navRow) - 1;
                int offset = CodeEditor.this.editorComponent.getLineStartOffset(line);
                CodeEditor.this.editorComponent.setCaretPositionCenter(offset);
            }

            public void overviewPopup(float relativeLocation, MouseEvent me) {
            }
        });
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent e) {
                overview.rebuild();
            }

            public void viewDeactivated(ViewEvent e) {
            }

            public void viewClosed(ViewEvent e) {
            }
        });
        return overview;
    }

    private void updateSectionView() {
        try {
            int startOff = this.editorComponent.getValidOffsetStart();
            int endOff = this.editorComponent.getValidOffsetEnd();
            if (startOff == -1 || endOff == -1) {
                return;
            }
            Rectangle startR = this.editorComponent.modelToView(startOff);
            if (startR == null) {
                return;
            }
            Rectangle endR = this.editorComponent.modelToView(endOff);
            if (endR == null) {
                return;
            }
            this.editorSectionView.setViewBounds(startR.y, endR.y + endR.height);
            this.lMarginSectionView.setViewBounds(startR.y, endR.y + endR.height);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getTypeForNode(TextNode textNode) {
        Class<?> nodeClass = textNode.getClass();
        List<Class> list = classList;
        synchronized (list) {
            Class registeredClass;
            int i;
            int numClasses = classList.size();
            for (i = 0; i < numClasses; ++i) {
                registeredClass = classList.get(i);
                if (registeredClass != nodeClass) continue;
                return typeList.get(i);
            }
            for (i = 0; i < numClasses; ++i) {
                registeredClass = classList.get(i);
                if (!registeredClass.isAssignableFrom(nodeClass)) continue;
                return typeList.get(i);
            }
        }
        return null;
    }

    private void setSelection(Element[] selectedElements) {
        this.viewSelection = selectedElements;
        this.updateSelectionImpl(false);
    }

    protected String getEditorText() {
        return this.editorComponent.getText();
    }

    @Deprecated
    protected boolean canCut() {
        return this.editorComponent.canCut();
    }

    @Deprecated
    protected boolean canCopy() {
        return this.editorComponent.canCopy();
    }

    @Deprecated
    protected boolean canPaste() {
        return this.editorComponent.canPaste();
    }

    void setLimitView(boolean limit) {
        ViewLimitProvider provider = this.getViewLimitProvider();
        if (provider != null) {
            Rectangle visibleRect = this.editorComponent.getVisibleRect();
            Pair offsetPair = limit ? provider.getLimitedOffsets() : new Pair((Object)-1, (Object)-1);
            this.editorComponent.setValidOffsetBounds(((Integer)offsetPair.first).intValue(), ((Integer)offsetPair.second).intValue());
            if (!limit) {
                visibleRect.height = this.editorSectionView.getHeight();
                this.editorComponent.scrollRectToVisible(visibleRect);
            }
        }
    }

    boolean isLimitView() {
        return this.editorComponent.getValidOffsetStart() != -1 && this.editorComponent.getValidOffsetEnd() != -1;
    }

    static {
        classList = new ArrayList<Class>();
        typeList = new ArrayList<String>();
        pluginsFactoryList = new CopyOnWriteArrayList<EditorPluginsFactory>();
        viewSelectionHelperFactoryList = new ArrayList<ViewSelectionHelperFactory>();
        viewLimitProviderFactoryList = new ArrayList<ViewLimitProviderFactory>();
        CONTEXT_FLAVOR = TransferableContext.contextFlavor;
        FILELIST_FLAVOR = DataFlavor.javaFileListFlavor;
        URILIST_FLAVOR = DropFileUtil.uriListFlavor;
        EXTRA_CUSTOM_FLAVORS = new DataFlavor[]{CONTEXT_FLAVOR, FILELIST_FLAVOR, URILIST_FLAVOR};
    }

    private class VetoableChangeL
    implements VetoableChangeListener {
        private long _checkOutFailureTimeMillis;
        private TextNode _ideNode;

        VetoableChangeL(TextNode ideNode) {
            this._ideNode = ideNode;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (pce.getPropertyName().equals("consumerVetoForMakeEditable")) {
                throw new PropertyVetoException(null, pce);
            }
            if (!pce.getPropertyName().equals("isEditable")) {
                return;
            }
            if (!pce.getOldValue().equals(Boolean.FALSE)) {
                return;
            }
            if (!pce.getNewValue().equals(Boolean.TRUE)) {
                return;
            }
            if (System.currentTimeMillis() - this._checkOutFailureTimeMillis < 250L) {
                throw new PropertyVetoException(null, pce);
            }
            if (!VCSUtil.checkOutOnUndoStack((Node)this._ideNode)) {
                this._checkOutFailureTimeMillis = System.currentTimeMillis();
                throw new PropertyVetoException(null, pce);
            }
        }
    }

    private class TextBufferL
    implements TextBufferListener {
        private TextBufferL() {
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            CodeEditor.this.updateSectionView();
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            CodeEditor.this.updateSectionView();
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            CodeEditor.this.updateSectionView();
        }
    }

    private class NavigationL
    implements NavigationListener {
        private NavigationL() {
        }

        public void navigated(BasicEditorPane editor, int offset) {
            boolean limit = IdeAction.get((int)CodeEditorConstants.EDIT_SELECTED_ONLY_CMD_ID).getState();
            CodeEditor.this.setLimitView(limit);
        }
    }

    private class ViewSelectionSetterHelper
    implements CodeEditorViewSelectionSetter {
        private ViewSelectionSetterHelper() {
        }

        @Override
        public void setSelection(Element[] newSelection) {
            CodeEditor.this.setSelection(newSelection);
        }
    }

    private final class CEOpenEditorDropHandler
    extends DropHandlerPlugin {
        private CEOpenEditorDropHandler() {
        }

        @Override
        protected Point getDropLocationToPaint(DropTargetDragEvent event) {
            return null;
        }

        @Override
        protected int shouldAllowDrag(DropTargetDragEvent event) {
            return this._allow(event, event.getDropAction());
        }

        @Override
        protected int shouldAllowDrop(DropTargetDropEvent event) {
            return this._allow(event, event.getDropAction());
        }

        private int _allow(DropTargetEvent event, int dropAction) {
            for (int i = 0; i < EXTRA_CUSTOM_FLAVORS.length; ++i) {
                if (!DndUtils.isDataFlavorSupported((DropTargetEvent)event, (DataFlavor)EXTRA_CUSTOM_FLAVORS[i])) continue;
                return dropAction;
            }
            return 0;
        }

        @Override
        protected boolean performDrop(DropTargetDropEvent event) {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(CONTEXT_FLAVOR)) {
                return this.handleContextDrop(transferable);
            }
            if (transferable.isDataFlavorSupported(FILELIST_FLAVOR) || transferable.isDataFlavorSupported(URILIST_FLAVOR)) {
                return this.handleFileListDrop(event);
            }
            return false;
        }

        protected boolean handleFileListDrop(DropTargetDropEvent event) {
            boolean dropSuccess = false;
            try {
                Transferable transferable = event.getTransferable();
                List fileList = event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? (List)transferable.getTransferData(DataFlavor.javaFileListFlavor) : DropFileUtil.uriTransferableToFileList((Transferable)transferable);
                for (File file : fileList) {
                    URL url = URLFactory.newFileURL((File)file);
                    EditorUtil.openDefaultEditorInFrameExternal((URL)url);
                }
                dropSuccess = true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return dropSuccess;
        }

        protected boolean handleContextDrop(Transferable transferable) {
            boolean dropSuccess = false;
            try {
                EditorManager editorManager = EditorManager.getEditorManager();
                TransferableContext contextData = (TransferableContext)transferable.getTransferData(CONTEXT_FLAVOR);
                Context context = contextData.getContext();
                Element[] elements = context.getSelection();
                if (elements != null) {
                    for (Element element : elements) {
                        if (!(element instanceof Node) || editorManager.getDefaultAddin(element) == null) continue;
                        Context myContext = CodeEditor.this.getContext();
                        editorManager.openDefaultEditorInFrame(myContext);
                        EditorUtil.openDefaultEditorInFrame((Element)element);
                    }
                }
                dropSuccess = true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return dropSuccess;
        }
    }

    public static enum MarginLocation {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;

    }

    private class MyStructureChangeListener
    extends StructureChangeListener {
        private MyStructureChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            CodeEditor.this.topToolbar.updateVisibility();
        }
    }

    protected class CEToolbar
    extends Toolbar
    implements Helpable {
        private HelpInfo helpInfo = new HelpInfo("f1_idecodeeditor_html");

        protected CEToolbar() {
            this.updateVisibility();
        }

        protected void addImpl(Component comp, Object constraints, int index) {
            super.addImpl(comp, constraints, index);
            this.updateVisibility();
        }

        public void remove(int i) {
            super.remove(i);
            this.updateVisibility();
        }

        protected void updateVisibility() {
            Preferences preferences;
            EditorOptions editorOptions;
            boolean visible = false;
            if (this.getComponentCount() > 0 && (editorOptions = EditorOptions.getInstance((PropertyStorage)(preferences = Preferences.getPreferences()))).getShowToolbar()) {
                visible = true;
            }
            this.setVisible(visible);
        }

        public HelpInfo getHelpInfo() {
            return this.helpInfo;
        }

        protected void setHelpInfo(HelpInfo helpInfo) {
            this.helpInfo = helpInfo;
        }
    }
}

