/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class AbstractEditorHoverPlugin
implements EditorPlugin {
    private HoverProvider _provider;
    private BasicEditorPane _editor;

    protected BasicEditorPane getEditor() {
        return this._editor;
    }

    public void install(BasicEditorPane editor) {
        if (editor instanceof IdeEditorPane && this.installHoverableEditor(editor)) {
            this._editor = editor;
            this._provider = new HoverableImpl();
            ((IdeEditorPane)editor).getMultiHoverProvider().registerProvider(this._provider);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        if (editor instanceof IdeEditorPane && this._provider != null) {
            ((IdeEditorPane)this._editor).getMultiHoverProvider().unregisterProvider(this._provider);
        }
        this._editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected abstract boolean installHoverableEditor(BasicEditorPane var1);

    protected abstract NumberRange getRectangleOffsets(BasicEditorPane var1, List<HoverFlavor> var2, int var3);

    protected abstract Hover getHover(BasicEditorPane var1, List<HoverFlavor> var2, int var3, Rectangle var4);

    private class HoverableImpl
    implements HoverProvider {
        private HoverableImpl() {
        }

        public Hover hover(JComponent comp, Point p, List<HoverFlavor> flavors) {
            int offset;
            assert (comp == AbstractEditorHoverPlugin.this._editor);
            SwingUtilities.convertPointFromScreen(p, (Component)AbstractEditorHoverPlugin.this._editor);
            try {
                offset = AbstractEditorHoverPlugin.this._editor.viewToModel(p);
            }
            catch (NullPointerException npe) {
                return null;
            }
            NumberRange range = AbstractEditorHoverPlugin.this.getRectangleOffsets(AbstractEditorHoverPlugin.this._editor, flavors, offset);
            if (range != null) {
                try {
                    Rectangle sRect = AbstractEditorHoverPlugin.this._editor.modelToView(range.start);
                    Rectangle eRect = AbstractEditorHoverPlugin.this._editor.modelToView(range.end);
                    sRect.add(eRect);
                    Rectangle r = sRect.intersection(AbstractEditorHoverPlugin.this._editor.getVisibleRect());
                    Hover hover = AbstractEditorHoverPlugin.this.getHover(AbstractEditorHoverPlugin.this._editor, flavors, offset, r);
                    if (hover != null) {
                        hover.showHover();
                        return hover;
                    }
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
            return null;
        }
    }
}

