/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import java.lang.reflect.Constructor;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.common.AbstractHashDependable;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.providers.AbstractHashDependableIOProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class LegacyHashDependableIOProvider
extends AbstractHashDependableIOProvider {
    @Override
    protected boolean canRead(Element element, HashStructure hash, ToolkitContext tkContext, Cookie cookie) {
        String className = hash.getString("adapterClass");
        return ModelUtil.hasLength((String)className);
    }

    @Override
    protected boolean canWrite(Element element, Dependable dependable, ToolkitContext tkContext, Cookie cookie) {
        return dependable instanceof AbstractHashDependable;
    }

    @Override
    protected Dependable read(Element element, HashStructure hash, Cookie cookie) {
        String className = hash.getString("adapterClass");
        try {
            Class<?> dependableClass = Class.forName(className);
            Constructor<?> profileConstructor = dependableClass.getDeclaredConstructor(HashStructure.class);
            HashStructure originalHash = HashStructure.newInstance();
            hash.copyTo(originalHash);
            originalHash.remove("adapterClass");
            Dependable typedDependable = (Dependable)profileConstructor.newInstance(originalHash);
            Assert.println((String)("Warning: Dependable " + typedDependable.getClass() + " does not have a HashDependableIO module"));
            return typedDependable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void write(Element element, Dependable dependable, HashStructure hash, Cookie cookie) {
        assert (dependable instanceof AbstractHashDependable);
        ((AbstractHashDependable)dependable).getHashStructure().copyTo(hash);
        String className = dependable.getClass().getName();
        hash.putString("adapterClass", className);
        Assert.println((String)("WARNING: Dependable " + className + " does not have a HashDependableIO module."));
    }
}

