/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction.metadataStateManager;

import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.ParticipantOwner;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;
import oracle.olapi.transaction.metadataStateManager.MetadataStateOwner;

public abstract class BaseMetadataStateHolder
implements Participant {
    private BaseMetadataStateHolder m_Next = null;
    private BaseMetadataStateHolder m_Prev = null;
    private MetadataStateManager m_Manager = null;
    private MetadataContext m_MetadataContext = null;
    private BaseMetadataStateHolder m_Parent = null;
    private int m_ChildCount = 0;

    BaseMetadataStateHolder(MetadataStateManager metadataStateManager, MetadataContext metadataContext, BaseMetadataStateHolder baseMetadataStateHolder) {
        this.initialize(metadataStateManager, metadataContext, baseMetadataStateHolder);
    }

    public final void commit(Transaction transaction) {
        if (null != this.getParent()) {
            this.getParent().updateFromChild(this);
        }
        this.getManager().commit(this, transaction);
    }

    void decrementChildCount() {
        --this.m_ChildCount;
    }

    int getChildCount() {
        return this.m_ChildCount;
    }

    final MetadataStateManager getManager() {
        return this.m_Manager;
    }

    public final MetadataContext getMetadataContext() {
        return this.m_MetadataContext;
    }

    final BaseMetadataStateHolder getNext() {
        return this.m_Next;
    }

    BaseMetadataStateHolder getParent() {
        return this.m_Parent;
    }

    final BaseMetadataStateHolder getPrev() {
        return this.m_Prev;
    }

    public abstract boolean hasState();

    private final void initialize(MetadataStateManager metadataStateManager, MetadataContext metadataContext, BaseMetadataStateHolder baseMetadataStateHolder) {
        this.m_Manager = metadataStateManager;
        this.m_MetadataContext = metadataContext;
        if (null != baseMetadataStateHolder) {
            this.m_Next = baseMetadataStateHolder;
            this.m_Prev = baseMetadataStateHolder.getPrev();
            baseMetadataStateHolder.setPrev(this);
        }
        if (null == this.m_Prev) {
            metadataStateManager.setFirstHolder(this);
        } else {
            this.m_Prev.setNext(this);
        }
        if (metadataContext instanceof ParticipantOwner) {
            ((ParticipantOwner)((Object)metadataContext)).registerParticipant(this);
        }
    }

    void incrementChildCount() {
        ++this.m_ChildCount;
    }

    final boolean isDescendantOrSelf(BaseMetadataStateHolder baseMetadataStateHolder) {
        for (BaseMetadataStateHolder baseMetadataStateHolder2 = this; null != baseMetadataStateHolder2; baseMetadataStateHolder2 = baseMetadataStateHolder2.getParent()) {
            if (baseMetadataStateHolder2 != baseMetadataStateHolder) continue;
            return true;
        }
        return false;
    }

    public final void prepare(Transaction transaction) throws NotCommittableException {
        this.getManager().prepare(this.getMetadataContext(), transaction);
    }

    final void removeFromManager() {
        if (null == this.getPrev()) {
            this.getManager().setFirstHolder(this.getNext());
        } else {
            this.getPrev().setNext(this.getNext());
        }
        if (null != this.getNext()) {
            this.getNext().setPrev(this.getPrev());
        }
        this.setParent(null);
    }

    public abstract void revert();

    public final void rollback() {
        this.getManager().rollback(this);
    }

    void setChildCount(int n) {
        this.m_ChildCount = n;
    }

    final void setNext(BaseMetadataStateHolder baseMetadataStateHolder) {
        this.m_Next = baseMetadataStateHolder;
    }

    void setParent(BaseMetadataStateHolder baseMetadataStateHolder) {
        if (null != this.m_Parent) {
            this.m_Parent.decrementChildCount();
        }
        if (null != baseMetadataStateHolder) {
            baseMetadataStateHolder.incrementChildCount();
        }
        this.m_Parent = baseMetadataStateHolder;
    }

    final void setPrev(BaseMetadataStateHolder baseMetadataStateHolder) {
        this.m_Prev = baseMetadataStateHolder;
    }

    abstract void updateFromChild(BaseMetadataStateHolder var1);

    public abstract void refresh();

    final void unregisterAsParticipant() {
        ParticipantOwner participantOwner = (ParticipantOwner)((Object)this.getMetadataContext());
        participantOwner.unregisterParticipant(this);
    }

    public MetadataStateOwner getOwner() {
        return this.getManager().getOwner();
    }
}

