/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.syntax.BuildSpecification;
import oracle.olapi.syntax.Buildable;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;

public final class BuildItem
extends SyntaxObject {
    private Buildable m_BuildObject = null;
    private String m_BuildSpecName = null;
    private BuildSpecification m_InlineBuildSpec = null;
    private long m_AsOfSCN = 0L;

    private BuildItem(Buildable buildable, String string, BuildSpecification buildSpecification, long l) {
        BuildItem.validateValue(buildable);
        this.m_BuildObject = buildable;
        this.m_BuildSpecName = string;
        this.m_InlineBuildSpec = buildSpecification;
        this.m_AsOfSCN = l;
    }

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(((MdmObject)((Object)this.getBuildObject())).getID());
        if (null != this.getBuildSpecName()) {
            syntaxPrintingContext.append(" USING ");
            syntaxPrintingContext.append(this.getBuildSpecName());
        } else if (null != this.getInlineBuildSpecification()) {
            syntaxPrintingContext.append(" USING ");
            this.getInlineBuildSpecification().printCommands(syntaxPrintingContext);
        }
        if (this.getAsOfSCN() > 0L) {
            syntaxPrintingContext.append(" AS OF SCN ");
            syntaxPrintingContext.append(Long.toString(this.getAsOfSCN()));
        }
    }

    public BuildItem(Buildable buildable) {
        this(buildable, null, null, 0L);
    }

    public BuildItem(Buildable buildable, long l) {
        this(buildable, null, null, l);
    }

    public BuildItem(Buildable buildable, String string) {
        this(buildable, string, null, 0L);
    }

    public BuildItem(Buildable buildable, String string, long l) {
        this(buildable, string, null, l);
    }

    public BuildItem(Buildable buildable, BuildSpecification buildSpecification) {
        this(buildable, null, buildSpecification, 0L);
    }

    public BuildItem(Buildable buildable, BuildSpecification buildSpecification, long l) {
        this(buildable, null, buildSpecification, l);
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBuildItem(this, object);
    }

    public String getBuildSpecName() {
        return this.m_BuildSpecName;
    }

    public Buildable getBuildObject() {
        return this.m_BuildObject;
    }

    public BuildSpecification getInlineBuildSpecification() {
        return this.m_InlineBuildSpec;
    }

    public long getAsOfSCN() {
        return this.m_AsOfSCN;
    }
}

