/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.KeyValuePair;
import oracle.olapi.metadata.MetadataAssociationProperty;
import oracle.olapi.metadata.MetadataListProperty;
import oracle.olapi.metadata.MetadataMapProperty;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataStringProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseMetadataObjectState
implements IncrementalMetadataState {
    LinkedHashMap<XMLTag, MetadataProperty> m_properties = new LinkedHashMap();

    BaseMetadataObjectState() {
    }

    private synchronized void addProperty(MetadataProperty metadataProperty) {
        this.m_properties.put(metadataProperty.getPropertyTag(), metadataProperty);
    }

    final synchronized boolean addAllChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        boolean bl = false;
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (metadataProperty.getPropertyTag() == BaseMetadataXMLTags.OWNER) continue;
            bl = metadataProperty.addChildrenToXMLWriter(metadataToXMLConverter, list) || bl;
        }
        return bl;
    }

    final synchronized boolean addContainedChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        boolean bl = false;
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (!metadataProperty.getPropertyTag().isXMLContainedObject()) continue;
            bl = metadataProperty.addChildrenToXMLWriter(metadataToXMLConverter, list) || bl;
        }
        return bl;
    }

    final synchronized void gatherReferencedSources(List list) {
        boolean bl = false;
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            metadataProperty.gatherReferencedSources(list);
        }
    }

    void gatherContainedChildren(List<MetadataObjectHolder> list) {
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (!metadataProperty.getPropertyTag().isXMLContainedObject()) continue;
            metadataProperty.gatherMetadataObjects(list);
        }
    }

    final void addToListProperty(XMLTag xMLTag, Object object, BaseMetadataObject baseMetadataObject) {
        this.addToListProperty(xMLTag, object, -1, baseMetadataObject);
    }

    final void addToListProperty(XMLTag xMLTag, Object object, int n, BaseMetadataObject baseMetadataObject) {
        if (xMLTag.getDataType() == 0 && null == object) {
            return;
        }
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(xMLTag);
        if (null == metadataListProperty) {
            metadataListProperty = new MetadataListProperty(xMLTag);
            this.addProperty(metadataListProperty);
        }
        metadataListProperty.addObject(object, n, baseMetadataObject);
    }

    final void removeFromListProperty(XMLTag xMLTag, Object object, BaseMetadataObject baseMetadataObject) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(xMLTag);
        if (null == metadataListProperty) {
            return;
        }
        metadataListProperty.removeObject(object, baseMetadataObject);
    }

    final void clearListProperty(XMLTag xMLTag, BaseMetadataObject baseMetadataObject) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(xMLTag);
        if (null == metadataListProperty) {
            return;
        }
        metadataListProperty.clearObjects(baseMetadataObject);
    }

    void mapObject(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder, Object object, BaseMetadataObject baseMetadataObject) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(xMLTag);
        if (null == metadataMapProperty) {
            metadataMapProperty = new MetadataMapProperty(xMLTag);
            this.addProperty(metadataMapProperty);
        }
        metadataMapProperty.putObject(metadataObjectHolder, object, baseMetadataObject);
    }

    MetadataObject getMappedObject(XMLTag xMLTag, MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(xMLTag);
        if (null == metadataMapProperty) {
            return null;
        }
        return metadataMapProperty.getMetadataObjectValue(metadataObject, baseMetadataProvider);
    }

    String getMappedValue(XMLTag xMLTag, MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(xMLTag);
        if (null == metadataMapProperty) {
            return null;
        }
        return metadataMapProperty.getStringValue(metadataObject, baseMetadataProvider);
    }

    final synchronized void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        MetadataProperty metadataProperty;
        metadataToXMLConverter.setInAttributes(true);
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            metadataProperty = iterator.next().getValue();
            if (!metadataProperty.isAttribute(metadataToXMLConverter, baseMetadataObject) || !metadataProperty.isXMLWriteable(metadataToXMLConverter, baseMetadataObject)) continue;
            if (metadataToXMLConverter.getXMLFormat().is11gPartialXMLMode()) {
                metadataProperty.appendIncrementalXMLString(metadataToXMLConverter, baseMetadataObject);
                continue;
            }
            metadataProperty.appendXMLString(metadataToXMLConverter, baseMetadataObject);
        }
        metadataToXMLConverter.closeTag();
        metadataToXMLConverter.setInAttributes(false);
        iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            metadataProperty = iterator.next().getValue();
            if (metadataProperty.isAttribute(metadataToXMLConverter, baseMetadataObject) || !metadataProperty.isXMLWriteable(metadataToXMLConverter, baseMetadataObject)) continue;
            if (metadataToXMLConverter.getXMLFormat().is11gPartialXMLMode()) {
                metadataProperty.appendIncrementalXMLString(metadataToXMLConverter, baseMetadataObject);
                continue;
            }
            metadataProperty.appendXMLString(metadataToXMLConverter, baseMetadataObject);
        }
    }

    @Override
    public synchronized IncrementalMetadataState copyState() {
        BaseMetadataObjectState baseMetadataObjectState = new BaseMetadataObjectState();
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            MetadataProperty metadataProperty2 = metadataProperty.cloneProperty(true);
            baseMetadataObjectState.addProperty(metadataProperty2);
        }
        return baseMetadataObjectState;
    }

    private synchronized MetadataProperty findProperty(XMLTag xMLTag) {
        return this.m_properties.get(xMLTag);
    }

    boolean hasProperty(XMLTag xMLTag) {
        return null != this.findProperty(xMLTag);
    }

    synchronized boolean isEmpty() {
        return this.m_properties.isEmpty();
    }

    List getPropertyListValues(XMLTag xMLTag, BaseMetadataProvider baseMetadataProvider) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(xMLTag);
        ArrayList arrayList = new ArrayList();
        if (null != metadataListProperty) {
            metadataListProperty.getObjects(arrayList, baseMetadataProvider);
        }
        return arrayList;
    }

    boolean listPropertyContainsValue(XMLTag xMLTag, Object object) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(xMLTag);
        if (null != metadataListProperty) {
            return metadataListProperty.containsObject(object);
        }
        return false;
    }

    Object getPropertyObjectValue(XMLTag xMLTag, BaseMetadataProvider baseMetadataProvider) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)this.findProperty(xMLTag);
        if (null == metadataAssociationProperty) {
            return null;
        }
        return metadataAssociationProperty.getObjectValue(baseMetadataProvider);
    }

    MetadataObjectHolder getPropertyObjectHolder(XMLTag xMLTag) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)this.findProperty(xMLTag);
        if (null == metadataAssociationProperty) {
            return null;
        }
        return metadataAssociationProperty.getObjectHolder();
    }

    String getPropertyStringValue(XMLTag xMLTag) {
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(xMLTag);
        String string = "";
        if (null == metadataStringProperty || 0 == metadataStringProperty.getPropertyValue().length()) {
            if (null != xMLTag.getDefaultStringValue()) {
                string = xMLTag.getDefaultStringValue();
            }
        } else {
            string = metadataStringProperty.getPropertyValue();
        }
        return string;
    }

    int getPropertyIntegerValue(XMLTag xMLTag, int n) {
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(xMLTag);
        if (null == metadataStringProperty) {
            return n;
        }
        return Integer.parseInt(metadataStringProperty.getPropertyValue());
    }

    void setPropertyObjectValue(XMLTag xMLTag, Object object, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject) {
        this.setPropertyObjectValue(xMLTag, object, baseMetadataProvider, baseMetadataObject, false);
    }

    void setPropertyObjectValue(XMLTag xMLTag, Object object, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject, boolean bl) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)this.findProperty(xMLTag);
        if (null == metadataAssociationProperty) {
            metadataAssociationProperty = new MetadataAssociationProperty(xMLTag, object);
            this.addProperty(metadataAssociationProperty);
            if ((xMLTag.getRelationshipType() == 3 || xMLTag.getRelationshipType() == 4) && baseMetadataProvider.getDataProvider().read11gMetadata()) {
                metadataAssociationProperty.setIsFixedValue(true);
            }
        } else {
            metadataAssociationProperty.setObject(object, bl, baseMetadataObject);
        }
    }

    void setPropertyStringValue(XMLTag xMLTag, String string, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject) {
        this.setPropertyStringValue(xMLTag, string, baseMetadataProvider, baseMetadataObject, false);
    }

    void setPropertyStringValue(XMLTag xMLTag, String string, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject, boolean bl) {
        String string2 = xMLTag.validateStringValue(string);
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(xMLTag);
        if (null == metadataStringProperty) {
            if (null == string2) {
                return;
            }
            metadataStringProperty = new MetadataStringProperty(xMLTag, string2);
            this.addProperty(metadataStringProperty);
            if (xMLTag.getXMLType() == 3 && baseMetadataProvider.getDataProvider().read11gMetadata()) {
                metadataStringProperty.setIsFixedValue(true);
            }
        } else {
            metadataStringProperty.setPropertyValue(string2, bl, baseMetadataObject);
        }
        metadataStringProperty.setLocal(true);
    }

    void setPropertyIntegerValue(XMLTag xMLTag, int n, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject) {
        String string = Integer.toString(n);
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(xMLTag);
        if (null == metadataStringProperty) {
            metadataStringProperty = new MetadataStringProperty(xMLTag, string);
            this.addProperty(metadataStringProperty);
            if (xMLTag.getXMLType() == 3 && baseMetadataProvider.getDataProvider().read11gMetadata()) {
                metadataStringProperty.setIsFixedValue(true);
            }
        } else {
            metadataStringProperty.setPropertyValue(string, baseMetadataObject);
        }
        metadataStringProperty.setLocal(true);
    }

    void copyPropertyTo(BaseMetadataObjectState baseMetadataObjectState, XMLTag xMLTag, BaseMetadataProvider baseMetadataProvider, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        MetadataProperty metadataProperty = this.findProperty(xMLTag);
        if (metadataProperty != null) {
            this.copyPropertyTo(baseMetadataObjectState, metadataProperty, baseMetadataProvider, copyPolicy, copyReferenceType);
        }
    }

    private void copyPropertyTo(BaseMetadataObjectState baseMetadataObjectState, MetadataProperty metadataProperty, BaseMetadataProvider baseMetadataProvider, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        if (metadataProperty instanceof MetadataListProperty) {
            MetadataListProperty metadataListProperty = (MetadataListProperty)metadataProperty;
            ArrayList arrayList = new ArrayList();
            metadataListProperty.getObjects(arrayList, baseMetadataProvider);
            for (Object e : arrayList) {
                Object object;
                if (metadataListProperty.isMetadataObjectList()) {
                    object = (BaseMetadataObject)e;
                    BaseMetadataObject baseMetadataObject = (BaseMetadataObject)copyPolicy.copyReference(object, copyReferenceType);
                    baseMetadataObjectState.addToListProperty(metadataListProperty.getPropertyTag(), baseMetadataObject.getHolder(), null);
                    continue;
                }
                object = copyPolicy.copyReference(e, copyReferenceType);
                baseMetadataObjectState.addToListProperty(metadataListProperty.getPropertyTag(), object, null);
            }
        } else if (metadataProperty instanceof MetadataMapProperty) {
            MetadataMapProperty metadataMapProperty = (MetadataMapProperty)metadataProperty;
            for (KeyValuePair keyValuePair : metadataMapProperty.getPairs()) {
                Object object;
                BaseMetadataObject baseMetadataObject = (BaseMetadataObject)copyPolicy.copyExternalReference(baseMetadataProvider.fetchMetadataObject(keyValuePair.getKeyHolder()));
                if (metadataMapProperty.isMetadataObjectMap()) {
                    object = (BaseMetadataObject)copyPolicy.copyReference(baseMetadataProvider.fetchMetadataObject(keyValuePair.getValueHolder()), copyReferenceType);
                    baseMetadataObjectState.mapObject(metadataProperty.getPropertyTag(), baseMetadataObject.getHolder(), ((BaseMetadataObject)object).getHolder(), null);
                    continue;
                }
                object = (String)copyPolicy.copyReference(keyValuePair.getValue(), copyReferenceType);
                baseMetadataObjectState.mapObject(metadataProperty.getPropertyTag(), baseMetadataObject.getHolder(), object, null);
            }
        } else if (metadataProperty instanceof MetadataStringProperty) {
            MetadataStringProperty metadataStringProperty = (MetadataStringProperty)metadataProperty;
            baseMetadataObjectState.setPropertyStringValue(metadataProperty.getPropertyTag(), (String)copyPolicy.copyReference(metadataStringProperty.getPropertyValue(), copyReferenceType), baseMetadataProvider, null);
        } else if (metadataProperty instanceof MetadataAssociationProperty) {
            MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)metadataProperty;
            if (metadataAssociationProperty.isMetadataObject()) {
                MetadataObject metadataObject = (MetadataObject)metadataAssociationProperty.getObjectValue(baseMetadataProvider);
                BaseMetadataObject baseMetadataObject = (BaseMetadataObject)copyPolicy.copyReference(metadataObject, copyReferenceType);
                baseMetadataObjectState.setPropertyObjectValue(metadataProperty.getPropertyTag(), baseMetadataObject.getHolder(), baseMetadataProvider, null);
            } else {
                baseMetadataObjectState.setPropertyObjectValue(metadataProperty.getPropertyTag(), metadataAssociationProperty.getObject(), baseMetadataProvider, null);
            }
        } else {
            throw new CopyException("Unknown property type.");
        }
    }

    synchronized void copyAllPropertiesTo(BaseMetadataObjectState baseMetadataObjectState, BaseMetadataProvider baseMetadataProvider, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (null != baseMetadataObjectState.findProperty(metadataProperty.getPropertyTag())) continue;
            this.copyPropertyTo(baseMetadataObjectState, metadataProperty, baseMetadataProvider, copyPolicy, copyReferenceType);
        }
    }

    @Override
    public synchronized IncrementalMetadataState createState() {
        BaseMetadataObjectState baseMetadataObjectState = new BaseMetadataObjectState();
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            MetadataProperty metadataProperty2 = metadataProperty.cloneProperty(false);
            baseMetadataObjectState.addProperty(metadataProperty2);
        }
        return baseMetadataObjectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFromChild(IncrementalMetadataState incrementalMetadataState) {
        BaseMetadataObjectState baseMetadataObjectState;
        BaseMetadataObjectState baseMetadataObjectState2 = baseMetadataObjectState = (BaseMetadataObjectState)incrementalMetadataState;
        synchronized (baseMetadataObjectState2) {
            Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = baseMetadataObjectState.m_properties.entrySet().iterator();
            while (iterator.hasNext()) {
                MetadataProperty metadataProperty = iterator.next().getValue();
                MetadataProperty metadataProperty2 = metadataProperty;
                MetadataProperty metadataProperty3 = this.findProperty(metadataProperty2.getPropertyTag());
                if (null != metadataProperty3) {
                    metadataProperty3.updateFromChild(metadataProperty2);
                    continue;
                }
                this.addProperty(metadataProperty2.cloneProperty(true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateFromParent(IncrementalMetadataState incrementalMetadataState) {
        BaseMetadataObjectState baseMetadataObjectState;
        BaseMetadataObjectState baseMetadataObjectState2 = baseMetadataObjectState = (BaseMetadataObjectState)incrementalMetadataState;
        synchronized (baseMetadataObjectState2) {
            MetadataProperty metadataProperty;
            MetadataProperty metadataProperty2;
            Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
            while (iterator.hasNext()) {
                metadataProperty2 = iterator.next().getValue();
                metadataProperty = metadataProperty2;
                if (metadataProperty.isLocal() || null != baseMetadataObjectState.findProperty(metadataProperty.getPropertyTag())) continue;
                iterator.remove();
            }
            iterator = baseMetadataObjectState.m_properties.entrySet().iterator();
            while (iterator.hasNext()) {
                metadataProperty2 = iterator.next().getValue();
                metadataProperty = metadataProperty2;
                MetadataProperty metadataProperty3 = this.findProperty(metadataProperty.getPropertyTag());
                if (null != metadataProperty3) {
                    metadataProperty3.updateFromParent(metadataProperty);
                    continue;
                }
                this.addProperty(metadataProperty.cloneProperty(false));
            }
        }
        return true;
    }

    final synchronized boolean isServerSendable(BaseMetadataObjectState baseMetadataObjectState) {
        boolean bl = false;
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            MetadataProperty metadataProperty2 = null;
            if (null != baseMetadataObjectState) {
                metadataProperty2 = baseMetadataObjectState.findProperty(metadataProperty.getPropertyTag());
            }
            bl = metadataProperty.isServerSendable(metadataProperty2) || bl;
        }
        return bl;
    }

    public synchronized void getDeletedChildren(Set set) {
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (!metadataProperty.getPropertyTag().isRelationshipContainedObject()) continue;
            metadataProperty.getRemovedElements(set);
        }
    }

    public final void getNestedSubObjects(List list, boolean bl) {
        ArrayList arrayList = null;
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (!metadataProperty.getPropertyTag().isNestedSubObject()) continue;
            Object object = null;
            if (bl) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                object = arrayList;
            } else {
                object = list;
            }
            metadataProperty.getAssociatedObjects((List)object);
        }
        if (!bl || arrayList == null) {
            return;
        }
        list.addAll(arrayList);
        for (Object object : arrayList) {
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)((MetadataObjectHolder)object).getMetadataObject();
            baseMetadataObject.getNestedSubObjects(list, bl);
        }
    }

    public synchronized void updatePersistentState(short s) {
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (!metadataProperty.getPropertyTag().isNestedSubObject()) continue;
            metadataProperty.updatePersistentState(s);
        }
    }

    synchronized void revertPersistentState() {
        Iterator<Map.Entry<XMLTag, MetadataProperty>> iterator = this.m_properties.entrySet().iterator();
        while (iterator.hasNext()) {
            MetadataProperty metadataProperty = iterator.next().getValue();
            if (!metadataProperty.getPropertyTag().isNestedSubObject()) continue;
            metadataProperty.revertPersistentState();
        }
    }
}

