/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.Date;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;

public final class DateSource
extends Source {
    public DateSource(SourceDefinition sourceDefinition) {
        super(sourceDefinition);
    }

    public final DateSource appendValue(Date date) {
        return this.appendValues(new Date[]{date});
    }

    public final DateSource appendValues(Date[] dateArray) {
        return (DateSource)this.appendValues(this.getDataProvider().createListSource(dateArray));
    }

    Source createInstance(SourceDefinition sourceDefinition) {
        return new DateSource(sourceDefinition);
    }

    public final BooleanSource eq(Date date) {
        return this.eq(this.getDataProvider().createListSource(new Date[]{date}));
    }

    public final BooleanSource ge(Date date) {
        return this.ge(this.getDataProvider().createListSource(new Date[]{date}));
    }

    public Source getDataType() {
        return this.getDataProvider().getFundamentalMetadataProvider().getDateDataType().getSource();
    }

    public final BooleanSource gt(Date date) {
        return this.gt(this.getDataProvider().createListSource(new Date[]{date}));
    }

    public final BooleanSource le(Date date) {
        return this.le(this.getDataProvider().createListSource(new Date[]{date}));
    }

    public final BooleanSource lt(Date date) {
        return this.lt(this.getDataProvider().createListSource(new Date[]{date}));
    }

    public final BooleanSource ne(Date date) {
        return this.ne(this.getDataProvider().createListSource(new Date[]{date}));
    }

    public final DateSource plusDays(int n) {
        return this.plusDays(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final DateSource plusDays(NumberSource numberSource) {
        return this.getSourceExpressionFactory().plusDays(this, numberSource);
    }

    public final DateSource plusMonths(int n) {
        return this.plusMonths(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final DateSource plusMonths(NumberSource numberSource) {
        return this.getSourceExpressionFactory().plusMonths(this, numberSource);
    }

    public final NumberSource positionOfValue(Date date) {
        return this.positionOfValues(new Date[]{date});
    }

    public final NumberSource positionOfValues(Date[] dateArray) {
        return this.positionOfValues(this.getDataProvider().createListSource(dateArray));
    }

    public final DateSource removeValue(Date date) {
        return this.removeValues(new Date[]{date});
    }

    public final DateSource removeValues(Date[] dateArray) {
        return (DateSource)this.removeValues(this.getDataProvider().createListSource(dateArray));
    }

    public final DateSource selectValue(Date date) {
        return this.selectValues(new Date[]{date});
    }

    public final DateSource selectValues(Date[] dateArray) {
        return (DateSource)this.selectValues(this.getDataProvider().createListSource(dateArray));
    }
}

