/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.mdm;

import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.Property;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;

public class MdmProperty
implements MetadataObject,
Property {
    private String _id;
    private FundamentalMetadataObject _type;
    private int _propertyType = -1;
    static final int PARENT = 0;
    static final int ANCESTORS = 1;
    static final int DESCRIPTION = 2;
    static final int SHORT_DESCRIPTION = 3;
    static final int LEVEL = 4;
    static final int LEVEL_DEPTH = 5;

    public Source value(Source source) {
        SourceDefinition sourceDefinition = source.getDefinition();
        while (sourceDefinition instanceof AliasDefinition) {
            sourceDefinition = ((AliasDefinition)sourceDefinition).getBase();
        }
        MdmSourceDefinition mdmSourceDefinition = (MdmSourceDefinition)sourceDefinition;
        MdmAttribute mdmAttribute = this.getAttribute(mdmSourceDefinition.getMdmSource());
        return mdmAttribute.getSource();
    }

    private MdmAttribute getAttribute(MdmSource mdmSource) {
        MdmHierarchy mdmHierarchy = null;
        MdmLevelHierarchy mdmLevelHierarchy = null;
        MdmDimension mdmDimension = null;
        switch (this._propertyType) {
            case 0: {
                mdmHierarchy = (MdmHierarchy)mdmSource;
                return mdmHierarchy.getParentAttribute();
            }
            case 1: {
                mdmHierarchy = (MdmHierarchy)mdmSource;
                return mdmHierarchy.getAncestorsAttribute();
            }
            case 4: {
                mdmLevelHierarchy = (MdmLevelHierarchy)mdmSource;
                return mdmLevelHierarchy.getLevelAttribute();
            }
            case 5: {
                mdmLevelHierarchy = (MdmLevelHierarchy)mdmSource;
                return mdmLevelHierarchy.getLevelDepthAttribute();
            }
            case 2: {
                mdmDimension = (MdmDimension)mdmSource;
                return mdmDimension.getPrimaryDimension().getValueDescriptionAttribute();
            }
            case 3: {
                mdmDimension = (MdmDimension)mdmSource;
                return mdmDimension.getPrimaryDimension().getShortValueDescriptionAttribute();
            }
        }
        return null;
    }

    MdmProperty(String string, FundamentalMetadataObject fundamentalMetadataObject, int n) {
        this._id = string;
        this._type = fundamentalMetadataObject;
        this._propertyType = n;
    }

    public final String getID() {
        return this._id;
    }

    public Property getProperty() {
        return this;
    }

    public final MetadataObject getType() {
        return this._type;
    }
}

