/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class DoubleHelper {
    private DoubleHelper() {
    }

    public static double SQL2Java(InterfaceStub interfaceStub, Double d) {
        double d2 = d;
        OlapiTracer.log("DoubleHelper.SQL2Java: sqldouble = " + d + ", jdouble = " + d2);
        return d2;
    }

    public static Double Java2SQL(InterfaceStub interfaceStub, double d) {
        Double d2 = new Double(d);
        OlapiTracer.log("DoubleHelper.Java2SQL: jdouble = " + d + ", sqldouble = " + d2);
        return d2;
    }

    public static double SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("DoubleHelper.SQL2Java");
        double d = 0.0;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            d = NUMBER.toDouble((byte[])byArray);
            OlapiTracer.log("jdouble = " + d);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("DoubleHelper.SQL2Java");
        return d;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, double d) {
        OlapiTracer.enter("DoubleHelper.Java2SQL");
        OlapiTracer.log("jdouble = " + d);
        try {
            byte[] byArray = NUMBER.toBytes((double)d);
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("DoubleHelper.Java2SQL");
    }
}

