/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform.jboss;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class JbossAdfServerPlatformSupport
extends AdfServerPlatformSupport {
    private static final Logger logger = Logger.getLogger(JbossAdfServerPlatformSupport.class.getName());
    protected ServerPlatformSupport svrcomp = null;

    public JbossAdfServerPlatformSupport() throws PortabilityLayerException {
        this.getConcretePlatformSupport();
    }

    @Override
    public Object getConcretePlatformSupport() throws PortabilityLayerException {
        if (this.svrcomp == null) {
            try {
                this.svrcomp = (ServerPlatformSupport)Class.forName("oracle.jrf.jboss.JBossJrfInternalPlatform").newInstance();
            }
            catch (Exception ex) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10025", new String[]{ex.getMessage()}), ex);
            }
        }
        return this.svrcomp;
    }

    public JbossAdfServerPlatformSupport(ServerPlatformSupport svr) {
        this.svrcomp = svr;
    }

    @Override
    public Connection getNativeDBConnection(Connection datasourceJdbcConnection, Class targetUnwrapClass) {
        try {
            ClassLoader cl = ClassUtils.getClassLoader(JbossAdfServerPlatformSupport.class);
            Class jBossConnectionWrapperClass = cl.loadClass("org.jboss.resource.adapter.jdbc.WrappedConnection");
            if (targetUnwrapClass != null) {
                jBossConnectionWrapperClass = targetUnwrapClass;
            }
            if (jBossConnectionWrapperClass.isAssignableFrom(datasourceJdbcConnection.getClass())) {
                Method getUnderlyingConnection = jBossConnectionWrapperClass.getMethod("getUnderlyingConnection", null);
                return (Connection)getUnderlyingConnection.invoke((Object)getUnderlyingConnection, datasourceJdbcConnection);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Encountered exception", e);
        }
        return datasourceJdbcConnection;
    }
}

