/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.SensorTree;
import oracle.adf.share.perf.analysis.TimerResult;
import oracle.adf.share.perf.analysis.TreeNode;

class SensorTable {
    private LinkedHashMap mThreads = new LinkedHashMap();
    private String mUrl = null;
    private int mMinThreadCount = Integer.MAX_VALUE;
    private int mMaxThreadCount = Integer.MIN_VALUE;
    private long mTotalThreadCount = 0L;
    private long mRequestCount = 0L;
    private int mRIDCounter = 5000;
    private static final int INDENTATION_SPACES = 2;
    private static final double IGNORE_THREAD_RATIO = Analyzer.sAllPattern ? 0.0 : 0.05;

    SensorTable() {
    }

    void add(SensorResult result) {
        String key;
        SensorThread thread;
        int nameIdx = result.mNameIndex;
        boolean setUrlThread = false;
        if (((String)Analyzer.sSensorTypes.get(nameIdx)).equalsIgnoreCase("s") && ((String)Analyzer.sSensorNames.get(nameIdx)).endsWith("/url")) {
            String url = result.getValue();
            try {
                try {
                    int len;
                    while ((len = url.length()) != (url = URLDecoder.decode(url, "UTF-8")).length()) {
                    }
                }
                catch (Exception len) {
                    // empty catch block
                }
                StringBuffer sb = new StringBuffer(url);
                block5: for (int i = 0; i < Analyzer.sReplaceParams.size(); ++i) {
                    int pLen;
                    for (int start = 0; start <= sb.length(); start += pLen + 1 + 1 + pLen + 1 + 1) {
                        start = sb.indexOf(Analyzer.sReplaceParams.elementAt(i) + "=", start);
                        pLen = Analyzer.sReplaceParams.elementAt(i).length();
                        if (start == -1) continue block5;
                        int end1 = sb.indexOf("&", start + pLen + 1);
                        int end2 = sb.indexOf("?", start + pLen + 1);
                        int end = end1;
                        if (end1 == -1) {
                            end = end2;
                        } else if (end2 < end1 && end2 != -1) {
                            end = end2;
                        }
                        if (end == -1) {
                            end = sb.length();
                        }
                        sb.replace(start + pLen + 1, end, "<" + Analyzer.sReplaceParams.elementAt(i) + ">");
                    }
                }
                result.mValue = this.mUrl = sb.toString();
            }
            catch (Exception e) {
                System.out.println("wrong url: " + url);
                e.printStackTrace(System.out);
                System.exit(1);
            }
            setUrlThread = true;
        }
        if ((thread = (SensorThread)this.mThreads.get(key = result.mRID)) == null) {
            thread = new SensorThread();
            this.mThreads.put(key, thread);
        }
        if (setUrlThread) {
            thread.setHaveUrl();
        }
        thread.add(result);
    }

    String getURL() {
        return this.mUrl;
    }

    void reBaseTimeStamp() {
        SensorThread thread;
        Iterator itr = this.mThreads.entrySet().iterator();
        long earliestTS = Long.MAX_VALUE;
        while (itr.hasNext()) {
            thread = (SensorThread)itr.next().getValue();
            if (thread.getEarliestTimeStamp() >= earliestTS) continue;
            earliestTS = thread.getEarliestTimeStamp();
        }
        itr = this.mThreads.entrySet().iterator();
        while (itr.hasNext()) {
            thread = (SensorThread)itr.next().getValue();
            thread.reBaseTimeStamp(earliestTS);
        }
    }

    void print(PrintStream out) {
        Iterator itr = this.mThreads.entrySet().iterator();
        int threadCount = 1;
        int threadSize = this.mThreads.size();
        while (itr.hasNext()) {
            int depth = 1;
            Map.Entry entry = itr.next();
            SensorThread thread = (SensorThread)entry.getValue();
            if (threadSize > 1) {
                out.println("Thread " + threadCount + ": [id=" + entry.getKey() + "]");
                ++depth;
                ++threadCount;
            }
            thread.print(out, depth);
        }
    }

    void aggregate(SensorTable table) {
        if (this.mTotalThreadCount == 0L) {
            this.mTotalThreadCount = this.mThreads.size();
            this.mMaxThreadCount = this.mThreads.size();
            this.mMinThreadCount = this.mThreads.size();
            this.mRequestCount = 1L;
        }
        if (table.mThreads.size() > this.mMaxThreadCount) {
            this.mMaxThreadCount = table.mThreads.size();
        }
        if (table.mThreads.size() < this.mMinThreadCount) {
            this.mMinThreadCount = table.mThreads.size();
        }
        this.mTotalThreadCount += (long)table.mThreads.size();
        ++this.mRequestCount;
        Iterator srcItr = table.mThreads.entrySet().iterator();
        while (srcItr.hasNext()) {
            boolean matchThread = false;
            Map.Entry entry = srcItr.next();
            SensorThread srcThread = (SensorThread)entry.getValue();
            SensorThread tgtThread = null;
            Iterator tgtItr = this.mThreads.entrySet().iterator();
            while (!matchThread && tgtItr.hasNext()) {
                entry = tgtItr.next();
                tgtThread = (SensorThread)entry.getValue();
                matchThread = tgtThread.match(srcThread);
            }
            if (matchThread) {
                tgtThread.aggregate(srcThread);
                continue;
            }
            if (!((double)this.mRequestCount * IGNORE_THREAD_RATIO < 100.0)) continue;
            this.mThreads.put(Integer.toString(this.mRIDCounter++), srcThread);
        }
    }

    void removeMinorSensors() {
        for (Map.Entry entry : this.mThreads.entrySet()) {
            SensorThread thread = (SensorThread)entry.getValue();
            thread.removeMinorSensors();
        }
    }

    SensorTree convertToTree() {
        if (this.mTotalThreadCount == 0L) {
            this.mTotalThreadCount = this.mThreads.size();
            this.mMaxThreadCount = this.mThreads.size();
            this.mMinThreadCount = this.mThreads.size();
            this.mRequestCount = 1L;
        }
        SensorTree tree = new SensorTree(this.mMinThreadCount, this.mMaxThreadCount, this.mTotalThreadCount, this.mRequestCount);
        for (Map.Entry entry : this.mThreads.entrySet()) {
            SensorThread thread = (SensorThread)entry.getValue();
            ArrayList sensors = thread.getSensors();
            if (sensors.size() == 0) continue;
            SensorResult root = (SensorResult)sensors.get(0);
            if ((double)root.mHit < IGNORE_THREAD_RATIO * (double)this.mRequestCount) continue;
            TreeNode threadTree = null;
            for (SensorResult result : sensors) {
                threadTree = tree.insertToThread(threadTree, result);
            }
            if (threadTree == null) continue;
            tree.addThread(threadTree, thread.hasUrl());
        }
        return tree;
    }

    private class SensorThread {
        private long mEarliestTS = Long.MAX_VALUE;
        private ArrayList mSensors = new ArrayList();
        private boolean mHasUrl = false;

        private SensorThread() {
        }

        ArrayList getSensors() {
            return this.mSensors;
        }

        void setHaveUrl() {
            this.mHasUrl = true;
        }

        boolean hasUrl() {
            return this.mHasUrl;
        }

        void add(SensorResult result) {
            this.mSensors.add(result);
            if (this.mEarliestTS > result.mTimeStamp) {
                this.mEarliestTS = result.mTimeStamp;
            }
        }

        long getEarliestTimeStamp() {
            return this.mEarliestTS;
        }

        void reBaseTimeStamp(long startTime) {
            for (SensorResult result : this.mSensors) {
                result.mTimeStamp -= startTime;
            }
        }

        void removeMinorSensors() {
            boolean keepFirstSensor = true;
            ListIterator iter = this.mSensors.listIterator();
            while (iter.hasNext()) {
                SensorResult result = (SensorResult)iter.next();
                if (!(result instanceof TimerResult)) continue;
                TimerResult tResult = (TimerResult)result;
                if (!((double)tResult.mElapseTime / (double)tResult.mHit < (double)Analyzer.sIgnoreThreshold)) continue;
                if (keepFirstSensor && result.mTimeStamp == 0L) {
                    keepFirstSensor = false;
                    continue;
                }
                iter.remove();
            }
        }

        void print(PrintStream out, int depth) {
            byte[] spaces = new byte[2 * (depth - 1)];
            for (int i = 0; i < spaces.length; ++i) {
                spaces[i] = 32;
            }
            String indent = new String(spaces);
            for (SensorResult result : this.mSensors) {
                result.print(out, false, indent);
            }
        }

        boolean match(SensorThread thread) {
            if (this.mSensors.size() != thread.mSensors.size()) {
                return false;
            }
            int size = this.mSensors.size();
            for (int i = 0; i < size; ++i) {
                SensorResult result1 = (SensorResult)this.mSensors.get(i);
                SensorResult result2 = (SensorResult)thread.mSensors.get(i);
                if (result1.mNameIndex == result2.mNameIndex) continue;
                return false;
            }
            return true;
        }

        void aggregate(SensorThread thread) {
            int size = this.mSensors.size();
            for (int i = 0; i < size; ++i) {
                SensorResult result1 = (SensorResult)this.mSensors.get(i);
                SensorResult result2 = (SensorResult)thread.mSensors.get(i);
                result1.aggregate(result2);
            }
        }
    }
}

