/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.beans.Beans;
import java.util.logging.Level;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.adf.share.perf.TimerProvider;
import oracle.adf.share.perf.TimerToken;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;

public class Timer
extends ADFPerfSensor {
    private ThreadLocal<TimerToken> mTokenHolder = null;
    private PhaseEvent mPEvent = null;
    private TimerProvider mProvider = null;
    @CodeSharingSafe(value="MutableStaticField")
    public static final Timer DUMMY_TIMER = new DummyTimer();

    private Timer(Level level, String sensorFullName, PhaseEvent pe) {
        super(level, sensorFullName);
        this.mPEvent = pe;
        if (pe != null) {
            this.mTokenHolder = new ThreadLocal<TimerToken>(){

                @Override
                protected TimerToken initialValue() {
                    return new TimerToken(false, 0L, true);
                }
            };
        }
    }

    protected Timer() {
    }

    public static Timer createTimer(Level level, String groupName, String name, String desc) {
        if (Beans.isDesignTime()) {
            return DUMMY_TIMER;
        }
        String nounType = LoggingUtils.getNounType(groupName);
        return Timer.createTimer(level, groupName, name, nounType, desc);
    }

    public static Timer createTimer(Level level, String groupName, String name, String desc, TimerProvider provider) {
        if (Beans.isDesignTime()) {
            return DUMMY_TIMER;
        }
        String nounType = LoggingUtils.getNounType(groupName);
        return Timer.createTimer(level, groupName, name, nounType, desc, provider);
    }

    public static Timer createTimer(Level level, String groupName, String name, String type, String desc) {
        if (Beans.isDesignTime()) {
            return DUMMY_TIMER;
        }
        name = LoggingUtils.standardizeSensorName(name);
        StringBuffer groupNameBuf = LoggingUtils.standardizeGroupName(groupName);
        groupNameBuf.append('/').append(name).append(" ").append("t");
        String fullName = groupNameBuf.toString();
        ADFPerfSensor timer = SensorTable.getSensor(fullName);
        if (timer != null && timer instanceof Timer) {
            return (Timer)timer;
        }
        PhaseEvent pet = null;
        if (sLogger.isLoggable(level) || LoggingUtils.isDMSLoggingEnabled(level)) {
            Noun parentNoun = Noun.get((String)groupName);
            if (parentNoun == null) {
                parentNoun = Noun.create((String)groupName);
            }
            if (type != null && parentNoun.getType() == "n/a") {
                parentNoun.setType(type);
            }
            pet = PhaseEvent.create((Noun)parentNoun, (String)name, (String)desc);
            pet.deriveMetric(511);
        }
        Timer tr = new Timer(level, fullName, pet);
        tr = (Timer)SensorTable.putSensor(fullName, tr);
        return tr;
    }

    public static Timer createTimer(Level level, String groupName, String name, String type, String desc, TimerProvider provider) {
        if (Beans.isDesignTime()) {
            return DUMMY_TIMER;
        }
        if (provider != null) {
            provider.createTimers(level, groupName, name, type, desc);
            if (!provider.isParentLoggable()) {
                type = null;
            }
        }
        Timer timer = Timer.createTimer(level, groupName, name, type, desc);
        timer.mProvider = provider;
        return timer;
    }

    public void start() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        TimerToken token = this.getTimerToken();
        if (!token.mStarted) {
            token.mDMSToken = this.mPEvent.start();
            token.mStarted = true;
        }
    }

    public TimerToken startWithToken() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return null;
        }
        return new TimerToken(true, this.mPEvent.start(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        try {
            TimerToken token = this.getTimerToken();
            if (token != null && token.mStarted) {
                long elapsedTime = this.mPEvent.stop2(token.mDMSToken) - token.mDMSToken;
                if (this.mEnablePerfLog) {
                    this.log(token.mDMSToken, Long.toString(elapsedTime), token.mEcid);
                }
                token.mStarted = false;
            }
        }
        finally {
            this.cleanupTimerToken();
        }
    }

    public void stopWithToken(TimerToken token) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (token.mStarted) {
            long elapsedTime = this.mPEvent.stop2(token.mDMSToken) - token.mDMSToken;
            if (this.mEnablePerfLog) {
                this.log(token.mDMSToken, Long.toString(elapsedTime), token.mEcid);
            }
            token.mStarted = false;
        }
    }

    public void stop(int returnValue) {
        this.stopComposite(null, returnValue, null);
    }

    public void stopWithToken(TimerToken token, int returnValue) {
        this.stopComposite(token, returnValue, null);
    }

    public void stop(Object returnValue) {
        this.stopComposite(null, 0, returnValue);
    }

    public void stopWithToken(TimerToken token, Object returnValue) {
        this.stopComposite(token, 0, returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopComposite(TimerToken token, int returnInt, Object returnObj) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (token == null) {
            token = this.getTimerToken();
        }
        try {
            if (token != null && token.mStarted) {
                Timer[] timers;
                long endTime = this.mPEvent.stop2(token.mDMSToken);
                long elapsedTime = endTime - token.mDMSToken;
                if (this.mProvider != null && (timers = returnObj != null ? this.mProvider.getTimers(returnObj) : this.mProvider.getTimers(returnInt)) != null) {
                    for (int i = 0; i < timers.length; ++i) {
                        PhaseEvent pe = timers[i].mPEvent;
                        if (pe == null) continue;
                        pe.start(token.mDMSToken);
                        pe.stop(token.mDMSToken, endTime);
                        if (!this.mEnablePerfLog) continue;
                        timers[i].log(token.mDMSToken, Long.toString(elapsedTime), token.mEcid);
                    }
                }
                if (this.mEnablePerfLog && (this.mProvider != null && this.mProvider.isParentLoggable() || this.mProvider == null)) {
                    this.log(token.mDMSToken, Long.toString(elapsedTime), token.mEcid);
                }
                token.mStarted = false;
            }
        }
        finally {
            this.cleanupTimerToken();
        }
    }

    public void cleanup() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        try {
            TimerToken token = this.getTimerToken();
            if (token != null && token.mStarted) {
                this.mPEvent.abort(token.mDMSToken);
                token.mStarted = false;
            }
        }
        finally {
            this.cleanupTimerToken();
        }
    }

    public void cleanupWithToken(TimerToken token) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (token.mStarted) {
            this.mPEvent.abort(token.mDMSToken);
            token.mStarted = false;
        }
    }

    private TimerToken getTimerToken() {
        return this.mTokenHolder.get();
    }

    private void cleanupTimerToken() {
        this.mTokenHolder.remove();
    }

    @Override
    public void reset() {
        if (this.mPEvent != null) {
            this.mPEvent.reset();
        }
    }

    private static class DummyTimer
    extends Timer {
        private static final String sName = "Dummy Timer";

        private DummyTimer() {
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void cleanupWithToken(TimerToken token) {
        }

        @Override
        public TimerToken startWithToken() {
            return null;
        }

        @Override
        public void stop(int returnValue) {
        }

        @Override
        public void stop(Object returnValue) {
        }

        @Override
        public void stopWithToken(TimerToken token) {
        }

        @Override
        public void stopWithToken(TimerToken token, int returnValue) {
        }

        @Override
        public void stopWithToken(TimerToken token, Object returnValue) {
        }

        public String toString() {
            return sName;
        }
    }
}

