/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.connection;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.pool.OracleDataSource;

public class ConnectionManager {
    private static ConnectionManager s_instance = null;
    private Connection m_conn = null;
    private Connection m_mainConn = null;
    private OracleDataSource _ods = null;
    private String m_userName;
    private String m_password;
    private String m_connectionString;

    private ConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionManager getInstance() {
        if (s_instance != null) return s_instance;
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (s_instance != null) return s_instance;
            s_instance = new ConnectionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public void setUserName(String string) {
        this.m_userName = string;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public void setConnectionString(String string) {
        this.m_connectionString = string;
    }

    public void setMainConnection(Connection connection) {
        this.m_mainConn = connection;
    }

    public Connection getMainConnection() {
        return this.m_mainConn;
    }

    public void setClonedConnection(Connection connection) {
        this.m_conn = connection;
    }

    public Connection getClonedConnection() throws SQLException {
        if (this.m_conn == null) {
            this.connect(this.m_userName, this.m_password, this.m_connectionString);
        }
        return this.m_conn;
    }

    public void connect(String string, String string2, String string3) throws SQLException {
        try {
            this._ods = new OracleDataSource();
            this._ods.setURL("jdbc:oracle:thin:@" + string3);
            this._ods.setUser(string);
            this._ods.setPassword(string2);
            this.m_conn = this._ods.getConnection();
            this.m_conn.setAutoCommit(false);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            throw new SQLException(unsatisfiedLinkError.getMessage());
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            throw sQLException;
        }
    }
}

