/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.internal;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import oracle.charts.internal.RoundGradientContext;

public class RoundGradientPaint
implements Paint {
    protected Point2D mPoint;
    protected Point2D mRadius;
    protected Color mPointColor;
    protected Color mBackgroundColor;

    public RoundGradientPaint(double x, double y, Color pointColor, double x2, double y2, Color backgroundColor) {
        this.mRadius = new Point2D.Double(x2, y2);
        if (this.mRadius.distance(0.0, 0.0) <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0");
        }
        this.mPoint = new Point2D.Double(x, y);
        this.mPointColor = pointColor;
        this.mBackgroundColor = backgroundColor;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userbounds, AffineTransform xform, RenderingHints hints) {
        Point2D transformedPoint = xform.transform(this.mPoint, null);
        Point2D transformedRadius = xform.deltaTransform(this.mRadius, null);
        return new RoundGradientContext(transformedPoint, this.mPointColor, transformedRadius, this.mBackgroundColor);
    }

    public int getTransparency() {
        int a2;
        int a1 = this.mPointColor.getAlpha();
        return (a1 & (a2 = this.mBackgroundColor.getAlpha())) == 255 ? 1 : 3;
    }
}

