/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Tuple;

public final class Tokenizer {
    private static final Pattern s_wsPattern = Pattern.compile("\\s");
    private static final Pattern s_puncPattern = Pattern.compile("\\p{Punct}");
    private static final Pattern s_underDollarHashPattern = Pattern.compile("[_$#]");
    private static final String EMPTY_STRING = "";
    private static final String NEWLINE = "\n";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String DOUBLE_SINGLE_QUOTE = "''";
    private static final String DOUBLE_DOUBLE_QUOTE = "\"\"";
    private Config m_config;
    private Token m_startMarker;
    private Token m_endMarker;
    private Token m_first;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tokenizer(Config config) {
        try (StringReader sr = null;){
            Reader reader;
            this.m_config = config;
            this.m_startMarker = this.createNewToken(Token.Type.END_MARKER, -1, null);
            this.m_endMarker = this.createNewToken(Token.Type.END_MARKER, -1, this.m_startMarker);
            this.m_first = null;
            if (this.m_config.m_source != null) {
                sr = new StringReader(this.m_config.m_source);
                reader = sr;
            } else {
                reader = this.m_config.m_reader;
            }
            if (reader == null) {
                return;
            }
            int codeTokenCount = 0;
            char[] buf = new char[1000];
            int sourceLength = reader.read(buf);
            if (sourceLength <= 0) {
                return;
            }
            StringBuilder source = new StringBuilder();
            source.append(buf, 0, sourceLength);
            Token.Type currentType = Token.Type.UNKNOWN;
            int currentPos = 0;
            boolean quit = false;
            Token currentToken = this.m_startMarker;
            while (currentPos < sourceLength && !quit) {
                int chars;
                String currOneCharString = source.substring(currentPos, currentPos + 1);
                String currTwoCharString = currentPos < sourceLength - 1 ? source.substring(currentPos, currentPos + 2) : EMPTY_STRING;
                String currSLCLengthString = currentPos < sourceLength - this.m_config.m_singleLineCommentStart.length() + 1 ? source.substring(currentPos, currentPos + this.m_config.m_singleLineCommentStart.length()) : EMPTY_STRING;
                switch (currentType) {
                    case UNKNOWN: {
                        boolean userTokenFound = false;
                        for (Tuple e : this.m_config.m_userTokens) {
                            String userToken = (String)e.getFirst();
                            Token.Type type = (Token.Type)((Object)e.getSecond());
                            if (currentPos >= sourceLength + 1 - userToken.length() || !source.substring(currentPos, currentPos + userToken.length()).equals(userToken)) continue;
                            currentToken = this.createNewToken(type, currentPos, currentToken);
                            this.setEnd(currentToken, (currentPos += userToken.length()) - 1);
                            userTokenFound = true;
                            break;
                        }
                        if (userTokenFound) break;
                        if (s_wsPattern.matcher(currOneCharString).matches()) {
                            currentType = Token.Type.WHITESPACE;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            this.setEnd(currentToken, ++currentPos - 1);
                        } else if (currTwoCharString.equals(this.m_config.m_multiLineCommentStart)) {
                            currentType = Token.Type.MULTI_LINE_COMMENT;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            ++currentPos;
                            ++currentPos;
                        } else if (currSLCLengthString.equals(this.m_config.m_singleLineCommentStart)) {
                            currentType = Token.Type.SINGLE_LINE_COMMENT;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            ++currentPos;
                            ++currentPos;
                        } else if (currOneCharString.equals(DOUBLE_QUOTE)) {
                            currentType = Token.Type.DOUBLE_QUOTED_STRING;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        } else if (currOneCharString.equals(SINGLE_QUOTE)) {
                            currentType = Token.Type.SINGLE_QUOTED_STRING;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        } else if (s_puncPattern.matcher(currOneCharString).matches()) {
                            currentType = Token.Type.PUNCTUATION;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        } else {
                            currentType = Token.Type.ALPHANUMERIC;
                            currentToken = this.createNewToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        }
                        if (currentToken.isCode() && this.m_config.m_maxTokens != null && ++codeTokenCount > this.m_config.m_maxTokens) {
                            quit = true;
                            break;
                        }
                        if (currentType != Token.Type.PUNCTUATION) break;
                        this.setEnd(currentToken, currentPos - 1);
                        currentType = Token.Type.UNKNOWN;
                        break;
                    }
                    case WHITESPACE: {
                        if (s_wsPattern.matcher(currOneCharString).matches()) {
                            this.setEnd(currentToken, ++currentPos - 1);
                            break;
                        }
                        this.setEnd(currentToken, currentPos - 1);
                        currentType = Token.Type.UNKNOWN;
                        break;
                    }
                    case MULTI_LINE_COMMENT: {
                        if (currentPos < source.length() - 2 && !currTwoCharString.equals(this.m_config.m_multiLineCommentEnd)) {
                            ++currentPos;
                            break;
                        }
                        this.setEnd(currentToken, currentPos + 1);
                        currentType = Token.Type.UNKNOWN;
                        ++currentPos;
                        ++currentPos;
                        break;
                    }
                    case SINGLE_LINE_COMMENT: {
                        if (!currOneCharString.equals(NEWLINE)) {
                            ++currentPos;
                            break;
                        }
                        this.setEnd(currentToken, currentPos);
                        currentType = Token.Type.UNKNOWN;
                        ++currentPos;
                        break;
                    }
                    case DOUBLE_QUOTED_STRING: {
                        if (!currOneCharString.equals(DOUBLE_QUOTE)) {
                            ++currentPos;
                            break;
                        }
                        if (currentPos < sourceLength - 1 && currTwoCharString.equals(DOUBLE_DOUBLE_QUOTE)) {
                            ++currentPos;
                            ++currentPos;
                            break;
                        }
                        this.setEnd(currentToken, currentPos);
                        currentType = Token.Type.UNKNOWN;
                        ++currentPos;
                        break;
                    }
                    case SINGLE_QUOTED_STRING: {
                        if (!currOneCharString.equals(SINGLE_QUOTE)) {
                            ++currentPos;
                            break;
                        }
                        if (currentPos < sourceLength - 1 && currTwoCharString.equals(DOUBLE_SINGLE_QUOTE)) {
                            ++currentPos;
                            ++currentPos;
                            break;
                        }
                        this.setEnd(currentToken, currentPos);
                        currentType = Token.Type.UNKNOWN;
                        ++currentPos;
                        break;
                    }
                    case ALPHANUMERIC: {
                        if (s_underDollarHashPattern.matcher(currOneCharString).matches()) {
                            ++currentPos;
                            break;
                        }
                        if (s_wsPattern.matcher(currOneCharString).matches()) {
                            this.setEnd(currentToken, currentPos - 1);
                            currentType = Token.Type.UNKNOWN;
                            break;
                        }
                        if (currentPos < sourceLength - 1 && currTwoCharString.equals(this.m_config.m_multiLineCommentStart)) {
                            this.setEnd(currentToken, currentPos - 1);
                            currentType = Token.Type.UNKNOWN;
                            break;
                        }
                        if (currSLCLengthString.equals(this.m_config.m_singleLineCommentStart)) {
                            this.setEnd(currentToken, currentPos - 1);
                            currentType = Token.Type.UNKNOWN;
                            break;
                        }
                        if (currOneCharString.equals(DOUBLE_QUOTE)) {
                            this.setEnd(currentToken, currentPos - 1);
                            currentType = Token.Type.UNKNOWN;
                            break;
                        }
                        if (currOneCharString.equals(SINGLE_QUOTE)) {
                            this.setEnd(currentToken, currentPos - 1);
                            currentType = Token.Type.UNKNOWN;
                            break;
                        }
                        if (s_puncPattern.matcher(currOneCharString).matches()) {
                            this.setEnd(currentToken, currentPos - 1);
                            currentType = Token.Type.UNKNOWN;
                            break;
                        }
                        ++currentPos;
                        break;
                    }
                }
                if (currentPos <= sourceLength - 10 || (chars = reader.read(buf)) <= 0) continue;
                source.append(buf, 0, chars);
                sourceLength += chars;
            }
            this.setEnd(currentToken, source.length() - 1);
            this.m_startMarker.setHeaderSourceImpl(source.toString());
            if (((Token)this.m_startMarker.getNextToken()).getType() != Token.Type.END_MARKER) {
                this.m_first = this.m_startMarker.getNextCodeToken();
            }
        }
    }

    public final Token getFirst() {
        return this.m_first;
    }

    public final Token getStartMarker() {
        return this.m_startMarker;
    }

    public final Token getEndMarker() {
        return this.m_endMarker;
    }

    private Token createNewToken(Token.Type type, int start, Token prev) {
        return this.m_config.m_factory.createToken(type, start, prev);
    }

    private void setEnd(Token tk, int end) {
        this.m_config.m_factory.setEnd(tk, end);
    }

    private static class DefaultTokenFactory
    implements TokenFactory {
        private DefaultTokenFactory() {
        }

        @Override
        public Token createToken(Token.Type type, int start, Token prev) {
            return new Token(type, start, prev);
        }

        @Override
        public void setEnd(Token tk, int end) {
            tk.setEnd(end);
        }
    }

    public static final class Config {
        private Reader m_reader;
        private String m_source;
        private TokenFactory m_factory = new DefaultTokenFactory();
        private List<Tuple<String, Token.Type>> m_userTokens = new ArrayList<Tuple<String, Token.Type>>();
        private String m_singleLineCommentStart = "--";
        private String m_multiLineCommentStart = "/*";
        private String m_multiLineCommentEnd = "*/";
        private Integer m_maxTokens = null;

        public void setSource(String source) {
            this.m_source = source;
        }

        public void setReader(Reader reader) {
            this.m_reader = reader;
        }

        public void setFactory(TokenFactory factory) {
            this.m_factory = factory;
        }

        public void setSingleLineCommentStart(String slcStart) {
            this.m_singleLineCommentStart = slcStart;
        }

        public void setMultiLineCommentStart(String mlcStart) {
            this.m_multiLineCommentStart = mlcStart;
        }

        public void setMultiLineCommentEnd(String mlcEnd) {
            this.m_multiLineCommentEnd = mlcEnd;
        }

        public void setMaxTokens(Integer maxTokens) {
            this.m_maxTokens = maxTokens;
        }

        public void addTokens(Token.Type type, Collection<String> list) {
            for (String val : list) {
                this.m_userTokens.add((Tuple<String, Token.Type>)new Tuple((Object)val, (Object)type));
            }
        }
    }

    public static interface TokenFactory {
        public Token createToken(Token.Type var1, int var2, Token var3);

        public void setEnd(Token var1, int var2);
    }
}

