/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenClause;
import oracle.javatools.db.token.TokenClauseInverter;
import oracle.javatools.db.token.TokenClauseOptions;
import oracle.javatools.db.token.TokenClauseParentheses;
import oracle.javatools.db.token.TokenClauseRepeater;
import oracle.javatools.db.token.TokenClauseSequence;
import oracle.javatools.db.token.TokenClauseSingleToken;
import oracle.javatools.db.token.Tokenizer;

public class TokenPattern<T extends Token> {
    private static final String ROOT_CLAUSE_NAME = " ";
    private final List<String> m_names = new ArrayList<String>();
    private TokenClause m_rootClause;
    private TokenClauseRepeater m_repeater;
    private int m_repeaterCount = 0;

    public TokenPattern(String expression) {
        Token startToken;
        if (expression == null || expression.trim().length() == 0) {
            throw new IllegalArgumentException("empty expression");
        }
        expression = expression.replaceAll("\\?\\.", "{?[.?]...}");
        expression = expression.replaceAll("\\(\\.\\.\\.\\)", "(--)");
        Tokenizer.Config config = this.getConfig(expression);
        Tokenizer tokenizer = new Tokenizer(config);
        Token tk = startToken = tokenizer.getFirst();
        ArrayList<String> stack = new ArrayList<String>();
        while (!tk.isEndMarker()) {
            String s = tk.getSource();
            Object prevCodeToken = tk.getPrevCodeToken();
            if (((Token)prevCodeToken).matches("<") && !this.isEscapedSingleCharToken((Token)prevCodeToken)) {
                if (this.m_names.contains(s)) {
                    throw new IllegalArgumentException("repeated name " + s);
                }
                this.m_names.add(s);
            }
            if (!this.isEscapedSingleCharToken(tk)) {
                if (s.equals("{") || s.equals("[") || s.equals("<")) {
                    stack.add(s);
                } else if (s.equals("|")) {
                    if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("{")) {
                        throw new IllegalArgumentException("| not within {}");
                    }
                } else {
                    if (s.equals("^") && !((Token)prevCodeToken).matches("{")) {
                        throw new IllegalArgumentException("^ not following {");
                    }
                    if (s.equals("}")) {
                        if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("{")) {
                            throw new IllegalArgumentException("{ } mismatch");
                        }
                        stack.remove(stack.size() - 1);
                    } else if (s.equals("]")) {
                        if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("[")) {
                            throw new IllegalArgumentException("[ ] mismatch");
                        }
                        stack.remove(stack.size() - 1);
                    } else if (s.equals(">")) {
                        if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("<")) {
                            throw new IllegalArgumentException("< > mismatch");
                        }
                        stack.remove(stack.size() - 1);
                    }
                }
            }
            tk = tk.getNextCodeToken();
        }
        if (stack.size() != 0) {
            throw new IllegalArgumentException("ran out of brackets");
        }
        this.m_rootClause = new TokenClauseSequence();
        this.build(this.m_rootClause, startToken);
    }

    private boolean isEscapedSingleCharToken(Token token) {
        Object prev;
        boolean retval = false;
        if (token != null && token.getType() != Token.Type.END_MARKER && token.getStart() == token.getEnd() && this.isEscapeChar((Token)(prev = token.getPrevToken()))) {
            retval = true;
        }
        return retval;
    }

    private boolean isEscapeChar(Token token) {
        return token != null & token.isPunctuation() && token.getStart() == token.getEnd() && token.getSource().equals(String.valueOf('\\'));
    }

    protected Tokenizer.Config getConfig(String expression) {
        Tokenizer.Config config = new Tokenizer.Config();
        config.setSource(expression);
        config.addTokens(Token.Type.USER_TOKEN, Arrays.asList("--", "..."));
        return config;
    }

    public String[] getNames() {
        return this.m_names.toArray(new String[this.m_names.size()]);
    }

    private Token build(TokenClause parent, Token startToken) {
        Token tk = startToken;
        while (tk.getType() != Token.Type.END_MARKER) {
            TokenClause sc;
            boolean isEscapedChar = this.isEscapedSingleCharToken(tk);
            if (!isEscapedChar && (tk.matches("}") || tk.matches(">") || tk.matches("]") || tk.matches("|"))) {
                return tk;
            }
            if (!isEscapedChar && (tk.matches("{") || tk.matches("["))) {
                TokenClauseSequence sc2;
                boolean invert = false;
                if (((Token)tk.getNextCodeToken()).matches("^")) {
                    invert = true;
                    tk = tk.getNextCodeToken();
                }
                sc = new TokenClauseOptions();
                while (!tk.matches("}") && !tk.matches("]")) {
                    sc2 = new TokenClauseSequence();
                    ((TokenClause)sc).addChildClause(sc2);
                    tk = this.build(sc2, (Token)tk.getNextCodeToken());
                }
                if (tk.matches("]")) {
                    sc2 = new TokenClauseSequence();
                    ((TokenClause)sc).addChildClause(sc2);
                    sc.setOptional(true);
                }
                if (invert) {
                    sc = new TokenClauseInverter(sc);
                }
                if (((Token)tk.getNextCodeToken()).matches("...")) {
                    this.m_repeater = new TokenClauseRepeater(sc);
                    ++this.m_repeaterCount;
                    sc = this.m_repeater;
                    tk = tk.getNextCodeToken();
                }
                parent.addChildClause(sc);
            } else if (!isEscapedChar && tk.matches("<")) {
                TokenClauseSequence sc2 = new TokenClauseSequence();
                parent.addChildClause(sc2);
                sc2.setKnownAs(((Token)tk.getNextCodeToken()).getSource());
                tk = this.build(sc2, (Token)tk.getNextCodeToken(2));
            } else if (tk.getType() == Token.Type.PUNCTUATION && ((Token)tk.getNextCodeToken()).matches("--") && ((Token)tk.getNextCodeToken(2)).getType() == Token.Type.PUNCTUATION) {
                Object end = tk.getNextCodeToken(2);
                if (this.isEscapeChar((Token)end)) {
                    end = ((Token)end).getNextCodeToken();
                }
                sc = new TokenClauseParentheses(tk.getSource(), ((Token)end).getSource());
                parent.addChildClause(sc);
                tk = end;
            } else if (!this.isEscapedSingleCharToken((Token)tk.getNextToken())) {
                parent.addChildClause(new TokenClauseSingleToken(tk));
            }
            tk = tk.getNextCodeToken();
        }
        return tk;
    }

    public PatternResult getResult(String source) {
        return this.getResult(source, true);
    }

    public PatternResult getResult(String source, boolean startsWith) {
        Tokenizer.Config config = new Tokenizer.Config();
        config.setSource(source);
        Tokenizer tokenizer = new Tokenizer(config);
        Token startTk = tokenizer.getFirst();
        return this.getResult((T)startTk, (T)startsWith);
    }

    public PatternResult getResult(T startTk) {
        return this.getResult(startTk, (T)true);
    }

    public PatternResult getResult(T startTk, boolean startsWith) {
        return this.getResult(startTk, null, startsWith);
    }

    public PatternResult getResult(T startTk, T endTk) {
        return this.getResult(startTk, endTk, true);
    }

    public PatternResult getResult(T startTk, T endTk, boolean startsWith) {
        PatternResult matchResult = null;
        TokenClause.ClauseResult clauseResult = null;
        T tk = startTk;
        Integer maxRepeats = null;
        while (!(tk == null || ((Token)tk).isEndMarker() || endTk != null && ((Token)endTk).getEnd() < ((Token)tk).getStart())) {
            matchResult = new PatternResult((Token)endTk);
            matchResult.setMaxRepeats(maxRepeats);
            clauseResult = this.m_rootClause.matches(matchResult, (Token)tk);
            if (clauseResult.isMatch()) {
                matchResult.recordResult(ROOT_CLAUSE_NAME, clauseResult);
                break;
            }
            if (this.m_repeaterCount == 1 && matchResult.getNumRepeats() != null && matchResult.getNumRepeats() > 1) {
                maxRepeats = matchResult.getNumRepeats() - 1;
                continue;
            }
            matchResult = null;
            maxRepeats = null;
            if (startsWith) break;
            tk = ((Token)tk).getNextCodeToken();
        }
        return matchResult;
    }

    public class PatternResult {
        private final Token m_endToken;
        private Token m_lastOKToken = null;
        private final Map<String, TokenClause.ClauseResult> m_namedResults = new HashMap<String, TokenClause.ClauseResult>();
        private Integer m_numRepeats;
        private Integer m_maxRepeats;

        void setNumRepeats(Integer m_numRepeats) {
            this.m_numRepeats = m_numRepeats;
        }

        Integer getNumRepeats() {
            return this.m_numRepeats;
        }

        void setMaxRepeats(Integer m_maxRepeats) {
            this.m_maxRepeats = m_maxRepeats;
        }

        Integer getMaxRepeats() {
            return this.m_maxRepeats;
        }

        PatternResult(Token endToken) {
            this.m_endToken = endToken;
        }

        void recordResult(String name, TokenClause.ClauseResult clauseResult) {
            this.m_namedResults.put(name, clauseResult);
        }

        public final String getNamedMatch(String name) {
            return this.getNamedMatch(name, true);
        }

        public final String getNamedMatch(String name, boolean format) {
            TokenClause.ClauseResult res = this.m_namedResults.get(name);
            if (res != null) {
                Token tk1 = res.getStartToken();
                Token tk2 = res.getEndToken();
                return tk1.getSource(format, tk2);
            }
            return null;
        }

        public final T getNamedMatchStartToken(String name) {
            TokenClause.ClauseResult res = this.m_namedResults.get(name);
            if (res != null) {
                return res.getStartToken();
            }
            return null;
        }

        public final T getNamedMatchEndToken(String name) {
            TokenClause.ClauseResult res = this.m_namedResults.get(name);
            if (res != null) {
                return res.getEndToken();
            }
            return null;
        }

        public T getStartToken() {
            return this.getNamedMatchStartToken(TokenPattern.ROOT_CLAUSE_NAME);
        }

        public T getEndToken() {
            return this.getNamedMatchEndToken(TokenPattern.ROOT_CLAUSE_NAME);
        }

        void setLastOKToken(Token lastOKToken) {
            if (lastOKToken != null && (this.m_lastOKToken == null || this.m_lastOKToken.getStart() < lastOKToken.getStart())) {
                this.m_lastOKToken = lastOKToken;
            }
        }

        public int getTokenCount() {
            Object tk = this.getStartToken();
            int i = 0;
            if (this.m_lastOKToken != null && tk != null) {
                i = 1;
                while (tk != this.m_lastOKToken) {
                    tk = ((Token)tk).getNextCodeToken();
                    ++i;
                }
            }
            return i;
        }

        boolean isWithinRange(Token token) {
            if (token == null) {
                return false;
            }
            if (token.getType() == Token.Type.END_MARKER) {
                return false;
            }
            return this.m_endToken == null || this.m_endToken.getStart() >= token.getStart();
        }
    }
}

