/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenClause;
import oracle.javatools.db.token.TokenClauseOptions;
import oracle.javatools.db.token.TokenPattern;

class TokenClauseRepeater
extends TokenClause {
    TokenClause m_clause;

    TokenClauseRepeater(TokenClause clause) {
        this.m_clause = clause;
    }

    @Override
    TokenClause.ClauseResult matches(TokenPattern.PatternResult patternResult, Token startToken) {
        TokenClause.ClauseResult childResult;
        TokenClause.ClauseResult result = new TokenClause.ClauseResult();
        int repeats = 0;
        patternResult.setNumRepeats(repeats);
        boolean match = false;
        Token localStartToken = startToken;
        Token endToken = null;
        while (this.isWithinRange(patternResult, localStartToken) && (childResult = this.m_clause.matches(patternResult, localStartToken)).isMatch()) {
            patternResult.setNumRepeats(++repeats);
            match = true;
            if (childResult.getEndToken() == null) break;
            endToken = childResult.getEndToken();
            localStartToken = endToken.getNextCodeToken();
            if (patternResult.getMaxRepeats() == null || !patternResult.getMaxRepeats().equals(repeats)) continue;
            break;
        }
        if (!match && !this.isWithinRange(patternResult, startToken) && this.m_clause instanceof TokenClauseOptions && ((TokenClauseOptions)this.m_clause).isOptional()) {
            match = true;
        }
        if (match) {
            result.setStartToken(startToken);
            result.setEndToken(endToken);
            result.setMatch(true);
        }
        this.recordResult(patternResult, result);
        return result;
    }

    @Override
    void addChildClause(TokenClause clause) {
        throw new RuntimeException("Cannot add children to a TokenClauseRepeater");
    }
}

